/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.controller;

import java.math.BigDecimal;
import java.text.DecimalFormatSymbols;
import java.util.HashMap;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.stage.Stage;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Bill;
import rs.petcom.master.dal.person.GiftCard;

public class GiftCardAmountDialogController
implements DialogController {
    ScreensController controller;
    BigDecimal amount;
    Bill bill;
    private GiftCard gCard;
    @FXML
    private BorderPane rootPane;
    @FXML
    private Label lblAmount;
    @FXML
    private Label lblBillValue;
    @FXML
    private Label lblDiffSum;
    @FXML
    private Label lblMessage;
    @FXML
    private Label lblGiftCardValue;
    @FXML
    private Label lblName;
    @FXML
    private GridPane gridPane;
    @FXML
    private Button btn0;
    @FXML
    private Button btnPoint;
    @FXML
    private Button btnDelete;
    @FXML
    private Button btn1;
    @FXML
    private Button btn2;
    @FXML
    private Button btn3;
    @FXML
    private Button btn4;
    @FXML
    private Button btn5;
    @FXML
    private Button btn6;
    @FXML
    private Button btn7;
    @FXML
    private Button btn8;
    @FXML
    private Button btn9;
    @FXML
    private Label infoText;
    HashMap<String, Object> parameter;
    int modalResult = ScreensController.MODAL_RESULT_CANCEL;

    @Override
    public void setParameter(HashMap<String, Object> parameter) {
        this.parameter = parameter;
        this.amount = ((GiftCard)parameter.get("giftCard")).getAmount();
        this.controller = (ScreensController)parameter.get("controller");
        this.gCard = (GiftCard)parameter.get("giftCard");
        this.bill = (Bill)parameter.get("giftCardBill");
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        this.fillLabels();
        this.lblBillValue.setText(String.valueOf(this.bill.getSumWithDiscout()));
        this.lblBillValue.setStyle("-fx-font-size: 18px; -fx-font-weight: bold;");
        this.lblGiftCardValue.setText("Stanje poklon kartice");
        this.lblGiftCardValue.setStyle("-fx-font-size: 20px; -fx-font-weight: bold;");
    }

    @Override
    public HashMap<String, Object> getParameter() {
        return this.parameter;
    }

    @Override
    public int getModalResult() {
        return this.modalResult;
    }

    @Override
    public void setModalResult(int modalResult) {
        this.modalResult = modalResult;
    }

    @FXML
    private void cancelAction(ActionEvent event) {
        this.modalResult = ScreensController.MODAL_RESULT_NO;
        ((Stage)this.rootPane.getScene().getWindow()).close();
    }

    @FXML
    private void addAction() {
        if (!this.infoText.getText().equals("") || this.infoText.getText() != null) {
            String iznos = "" + (this.amount.doubleValue() + Double.parseDouble(this.infoText.getText()));
            this.confirm(iznos);
            this.infoText.setText("");
            this.lblAmount.setText(iznos);
            this.amount = new BigDecimal(iznos);
            this.fillLabels();
        }
    }

    private void fillLabels() {
        this.lblDiffSum.setText(String.valueOf(this.amount.doubleValue() - this.bill.getSumWithDiscout() > 0.0 ? this.amount.doubleValue() - this.bill.getSumWithDiscout() : 0.0));
        this.lblDiffSum.setStyle("-fx-font-size: 18px; -fx-font-weight: bold;");
        if (this.bill.getSumWithDiscout() - this.amount.doubleValue() > 0.0) {
            this.lblMessage.setText("Potrebno je da doplatite iznos od: " + String.valueOf(this.bill.getSumWithDiscout() - this.amount.doubleValue()) + " dinara, kako biste podmirili iznos vaseg racuna.");
            this.lblMessage.setStyle("-fx-font-size: 18px; -fx-font-weight: bold;");
        }
        this.lblAmount.setText("" + this.amount);
        this.lblAmount.setStyle("-fx-font-size: 30px; -fx-font-weight: bold;");
        this.infoText.setStyle("-fx-font-size: 30px;");
        this.lblName.setStyle("-fx-font-size: 18px; -fx-font-weight: bold;");
        this.lblName.setText(this.gCard.getName());
    }

    public void confirm(String iznos) {
        GiftCard gCard = new GiftCard();
        gCard.setAmount(new BigDecimal(iznos));
        gCard.setGiftCardID(((GiftCard)this.parameter.get("giftCard")).getGiftCardID());
        gCard.updateAmount(this.controller);
    }

    @FXML
    private void showAction() {
        if (this.gridPane.isVisible()) {
            this.gridPane.setVisible(false);
        } else {
            this.gridPane.setVisible(true);
        }
    }

    @FXML
    private void useAction() {
        if (Double.parseDouble(this.lblAmount.getText()) > 0.0) {
            this.parameter.put("amountUsed", this.lblAmount.getText());
            this.modalResult = ScreensController.MODAL_RESULT_OK;
            ((Stage)this.rootPane.getScene().getWindow()).close();
        } else {
            this.controller.alert("Obavestenje", "Nedovoljan iznos na kartici koji zelite da iskoristite,\ndopunite karticu ili odustanite od kupiveni sa poklon karticom", this.rootPane.getScene().getWindow());
        }
    }

    @FXML
    private void numButtonClick(ActionEvent event) {
        if ((Button)event.getSource() == this.btn0) {
            this.infoText.setText(this.infoText.getText() + "0");
            this.gridPane.requestFocus();
        }
        if ((Button)event.getSource() == this.btn1) {
            this.infoText.setText(this.infoText.getText() + "1");
            this.gridPane.requestFocus();
        }
        if ((Button)event.getSource() == this.btn2) {
            this.infoText.setText(this.infoText.getText() + "2");
            this.gridPane.requestFocus();
        }
        if ((Button)event.getSource() == this.btn3) {
            this.infoText.setText(this.infoText.getText() + "3");
            this.gridPane.requestFocus();
        }
        if ((Button)event.getSource() == this.btn4) {
            this.infoText.setText(this.infoText.getText() + "4");
            this.gridPane.requestFocus();
        }
        if ((Button)event.getSource() == this.btn5) {
            this.infoText.setText(this.infoText.getText() + "5");
            this.gridPane.requestFocus();
        }
        if ((Button)event.getSource() == this.btn6) {
            this.infoText.setText(this.infoText.getText() + "6");
            this.gridPane.requestFocus();
        }
        if ((Button)event.getSource() == this.btn7) {
            this.infoText.setText(this.infoText.getText() + "7");
            this.gridPane.requestFocus();
        }
        if ((Button)event.getSource() == this.btn8) {
            this.infoText.setText(this.infoText.getText() + "8");
            this.gridPane.requestFocus();
        }
        if ((Button)event.getSource() == this.btn9) {
            this.infoText.setText(this.infoText.getText() + "9");
            this.gridPane.requestFocus();
        }
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        if ((Button)event.getSource() == this.btnPoint) {
            if (this.infoText.getText().equals("") || this.infoText.getText().equals("0")) {
                this.infoText.setText("0" + dfs.getDecimalSeparator());
            } else if (!this.infoText.getText().contains(dfs.getDecimalSeparator() + "")) {
                this.infoText.setText(this.infoText.getText() + dfs.getDecimalSeparator());
            }
            this.gridPane.requestFocus();
        }
        if ((Button)event.getSource() == this.btnDelete) {
            if (!this.infoText.getText().equals("")) {
                this.infoText.setText(this.infoText.getText().substring(0, this.infoText.getText().length() - 1));
            }
            this.gridPane.requestFocus();
        }
    }
}

