/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.PosPrint;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.SimpleDoc;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import rs.petcom.master.PosPrint.NarrowPosPrintOtpremnica;
import rs.petcom.master.PosPrint.NarrowPosPrintTest;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Printer;
import rs.petcom.master.dal.document.Document;

public class PosPrint {
    private ScreensController controller;
    private String content;
    private Printer printer;
    private DocFlavor flavor;
    private PrintRequestAttributeSet aset;
    private Document document;

    public PosPrint(ScreensController controller, Document document) {
        this.controller = controller;
        this.document = document;
        this.printer = (Printer)Printer.getAllActivePrinter(controller.getSettings().getConnection()).get(0);
        this.flavor = DocFlavor.BYTE_ARRAY.AUTOSENSE;
        this.aset = new HashPrintRequestAttributeSet();
    }

    public PosPrint() {
        this.flavor = DocFlavor.BYTE_ARRAY.AUTOSENSE;
        this.aset = new HashPrintRequestAttributeSet();
    }

    public void printNarrowGotBillToPos() {
        this.content = "Brojac racuna  3456/\u043f\u043f";
        try {
            for (int i = 0; i < 1; ++i) {
                this.print();
            }
        }
        catch (PrintException e) {
            e.printStackTrace();
        }
    }

    public void printNarrowOtpremnicaToPos() {
        int numOfCopies = Integer.parseInt(this.controller.getSettings().getActualByName("broj.kopija.otpremnica"));
        NarrowPosPrintOtpremnica narrOtpremnica = new NarrowPosPrintOtpremnica(this.controller, this.printer, this.document);
        this.content = narrOtpremnica.getContent();
        try {
            for (int i = 0; i < numOfCopies; ++i) {
                this.print();
            }
        }
        catch (PrintException e) {
            e.printStackTrace();
        }
    }

    public void printNarrowTestToPos() {
        NarrowPosPrintTest narrowTest = new NarrowPosPrintTest(this.printer);
        this.content = narrowTest.getContent();
        try {
            this.print();
        }
        catch (PrintException e) {
            e.printStackTrace();
        }
    }

    private byte[] contentToByte() {
        byte[] cut = new byte[]{27, 105};
        byte[] contentByte = null;
        byte[] test = new byte[500];
        int index = 0;
        for (int i = 0; i < 500; ++i) {
            test[index] = new Integer(i).byteValue();
            System.out.print(new Integer(i).byteValue());
            ++index;
        }
        try {
            String result = new String(this.content.getBytes("UTF-8"), Charset.forName("windows-1251"));
            System.out.println(result);
            contentByte = result.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        byte[] out = new byte[cut.length + contentByte.length];
        System.arraycopy(contentByte, 0, out, 0, contentByte.length);
        System.arraycopy(cut, 0, out, out.length - cut.length, cut.length);
        return out;
    }

    private PrintService getPrintServcie(String printerName) {
        PrintService[] pservices;
        for (PrintService p : pservices = PrintServiceLookup.lookupPrintServices(this.flavor, this.aset)) {
            if (!p.getName().toUpperCase().contains(printerName.toUpperCase())) continue;
            return p;
        }
        return null;
    }

    private void print() throws PrintException {
        byte[] byteContetn = this.contentToByte();
        SimpleDoc doc = new SimpleDoc(byteContetn, this.flavor, null);
        PrintService ps = this.getPrintServcie("BIX58");
        DocPrintJob pj = ps.createPrintJob();
        pj.print(doc, this.aset);
    }

    public static void main(String[] args) {
        PosPrint pp = new PosPrint();
        pp.printNarrowGotBillToPos();
    }
}

