/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.PosPrint;

import rs.petcom.master.PosPrint.ContentProporties;
import rs.petcom.master.dal.Printer;

public class NarrowPosPrintTest
extends ContentProporties {
    private String content;
    private int printerNumOfCharacters;

    public NarrowPosPrintTest(Printer printer) {
        this.printerNumOfCharacters = printer.getNumOfCharacters();
        this.content = this.posContent();
        this.content = this.clearFromEasternLatinChars(this.content);
    }

    public String getContent() {
        return this.content;
    }

    private String posContent() {
        StringBuilder content = new StringBuilder();
        content.append(this.makeHeader());
        content.append(this.makeBuyer());
        content.append(this.posPrintTitle());
        content.append(this.posPrintBody());
        content.append(this.posPrintSummary());
        content.append(this.posSignature());
        return content.toString();
    }

    private String makeHeader() {
        StringBuilder header = new StringBuilder();
        header.append(this.newRow());
        header.append(this.makeLineWithChar('=', this.printerNumOfCharacters));
        header.append(this.newRow());
        header.append(this.makeMultiRowContent("Stomatoloska Ordinacija Dentonio", this.printerNumOfCharacters));
        header.append(this.newRow());
        header.append(this.makeMultiRowContent("Kneza Milosa 93/1", this.printerNumOfCharacters));
        header.append(this.newRow());
        header.append(" PIB:");
        header.append("105917685");
        header.append(this.newRow());
        header.append(" MB:");
        header.append("64529919");
        header.append(this.newRow());
        header.append(this.makeLineWithChar('=', this.printerNumOfCharacters));
        header.append(this.newRow());
        return header.toString();
    }

    private String makeBuyer() {
        StringBuilder buyer = new StringBuilder();
        buyer.append(" Kupac:");
        buyer.append(this.newRow());
        buyer.append(this.makeMultiRowContent("petcom doo", this.printerNumOfCharacters));
        buyer.append(this.newRow());
        buyer.append(this.makeMultiRowContent("Maricka 22", this.printerNumOfCharacters));
        buyer.append(this.newRow());
        buyer.append(" PIB:");
        buyer.append("105917685");
        buyer.append(this.newRow());
        buyer.append(" MB:");
        buyer.append("6104885");
        buyer.append(this.newRow());
        return buyer.toString();
    }

    private String posPrintTitle() {
        String docTitile = "TestRacun 1/2021";
        StringBuilder title = new StringBuilder();
        title.append(this.makeLineWithChar('=', this.printerNumOfCharacters));
        title.append(this.newRow());
        title.append(this.contentInTheMiddle(docTitile, this.printerNumOfCharacters));
        title.append(this.newRow());
        title.append(this.makeLineWithChar('=', this.printerNumOfCharacters));
        title.append(this.newRow());
        return title.toString();
    }

    private String posPrintBody() {
        StringBuilder body = new StringBuilder();
        body.append(this.newRow());
        body.append(this.makeMultiRowContent("Stomatoloski pregled", this.printerNumOfCharacters));
        body.append(this.newRow());
        body.append(this.contentAtTheEnd("1.0 x 2000.0       2000.0", this.printerNumOfCharacters));
        body.append(this.newRow());
        body.append(this.makeMultiRowContent("Stomatoloski pregled sa izveztajem", this.printerNumOfCharacters));
        body.append(this.newRow());
        body.append(this.contentAtTheEnd(" 1.0 x 4000.0       4000.0", this.printerNumOfCharacters));
        body.append(this.newRow());
        body.append(this.makeMultiRowContent("Tretman laserom", this.printerNumOfCharacters));
        body.append(this.newRow());
        body.append(this.contentAtTheEnd("1.0 x 12000.0       12000.0", this.printerNumOfCharacters));
        body.append(this.newRow());
        body.append(this.makeMultiRowContent("Lokalna anestezija po vilici", this.printerNumOfCharacters));
        body.append(this.newRow());
        body.append(this.contentAtTheEnd("1.0 x 1500.0       1500.0", this.printerNumOfCharacters));
        body.append(this.newRow());
        body.append(this.makeMultiRowContent("Kompozitni ispun-jednopovrsinski sa anestezijom", this.printerNumOfCharacters));
        body.append(this.newRow());
        body.append(this.contentAtTheEnd("1.0 x 4000.0       4000.0", this.printerNumOfCharacters));
        body.append(this.newRow());
        body.append(this.makeMultiRowContent("Vitalna ekstirpacija", this.printerNumOfCharacters));
        body.append(this.newRow());
        body.append(this.contentAtTheEnd(" 1.0 x 3000.0       3000.0", this.printerNumOfCharacters));
        body.append(this.newRow());
        body.append(this.makeMultiRowContent("UMN i CZK", this.printerNumOfCharacters));
        body.append(this.newRow());
        body.append(this.contentAtTheEnd(" 1.0 x 4000.0       4000.0", this.printerNumOfCharacters));
        body.append(this.newRow());
        return body.toString();
    }

    private String posPrintSummary() {
        StringBuilder summary = new StringBuilder();
        summary.append(this.makeLineWithChar('-', this.printerNumOfCharacters));
        summary.append(this.newRow());
        summary.append(this.contentAtTheEnd("Ukupno:  30500.0", this.printerNumOfCharacters));
        summary.append(this.newRow());
        summary.append(this.makeLineWithChar('-', this.printerNumOfCharacters));
        summary.append(this.newRow());
        return summary.toString();
    }

    public String posSignature() {
        StringBuilder signature = new StringBuilder();
        signature.append(this.newRow());
        signature.append(" Robu izdao");
        signature.append(this.newRow());
        signature.append(this.contentInTheMiddle(this.makeLineWithChar('.', this.printerNumOfCharacters - 5), this.printerNumOfCharacters));
        signature.append(this.newRow());
        signature.append(" Robu primio:");
        signature.append(this.newRow());
        signature.append(this.contentInTheMiddle(this.makeLineWithChar('.', this.printerNumOfCharacters - 5), this.printerNumOfCharacters));
        signature.append(this.newRow());
        signature.append(" Broj LK:");
        signature.append(this.newRow());
        signature.append(this.contentInTheMiddle(this.makeLineWithChar('.', this.printerNumOfCharacters - 5), this.printerNumOfCharacters));
        signature.append(this.newRow());
        signature.append(this.makeLineWithChar('-', this.printerNumOfCharacters));
        signature.append(this.newRow());
        signature.append(this.makeMultiRowContent("Mesto i datum prometa dobara i usluga:", this.printerNumOfCharacters));
        signature.append(this.newRow());
        signature.append(" Beograd 27.09.2021. ");
        signature.append(this.newRow());
        signature.append(this.makeLineWithChar('-', this.printerNumOfCharacters));
        signature.append(this.newRow());
        signature.append(this.newRow());
        signature.append(this.newRow());
        signature.append(this.newRow());
        return signature.toString();
    }
}

