/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.PosPrint;

import java.sql.Connection;
import java.util.ArrayList;
import rs.petcom.master.PosPrint.ContentProporties;
import rs.petcom.master.PosPrint.NarrowPosPrintHeader;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Printer;
import rs.petcom.master.dal.document.Document;
import rs.petcom.master.dal.document.DocumentDetails;
import rs.petcom.master.dal.document.DocumentType;

public class NarrowPosPrintOtpremnica
extends ContentProporties {
    private Document document;
    private Connection connection;
    private NarrowPosPrintHeader posPrintHeader;
    private String content;
    private int printerNumOfCharacters;

    public NarrowPosPrintOtpremnica(ScreensController controller, Printer printer, Document document) {
        this.printerNumOfCharacters = printer.getNumOfCharacters();
        this.connection = controller.getSettings().getConnection();
        this.document = document;
        this.posPrintHeader = new NarrowPosPrintHeader(controller, printer, document);
        this.content = this.posContent();
        this.content = this.clearFromEasternLatinChars(this.content);
    }

    public String getContent() {
        return this.content;
    }

    private String posContent() {
        StringBuilder content = new StringBuilder();
        content.append(this.posPrintHeader.makeHeader());
        content.append(this.posPrintHeader.makeBuyer());
        content.append(this.posPrintTitle());
        content.append(this.posPrintBody());
        content.append(this.posPrintSummary());
        content.append(this.posPrintHeader.posSignature());
        return content.toString();
    }

    private String posPrintTitle() {
        String docTitile = DocumentType.getById(this.document.getDocumentTypeID(), this.connection).getName() + ":" + this.document.getNumber() + "/" + this.document.getYear();
        StringBuilder title = new StringBuilder();
        title.append(this.makeLineWithChar('=', this.printerNumOfCharacters));
        title.append(this.newRow());
        title.append(this.contentInTheMiddle(docTitile, this.printerNumOfCharacters));
        title.append(this.newRow());
        title.append(this.makeLineWithChar('=', this.printerNumOfCharacters));
        title.append(this.newRow());
        return title.toString();
    }

    public String posPrintBody() {
        ArrayList<DocumentDetails> details = DocumentDetails.getList(this.document.getDocumentID(), this.connection);
        String row = "";
        StringBuilder body = new StringBuilder();
        body.append(this.newRow());
        for (DocumentDetails detail : details) {
            row = detail.getQuantity() + " x " + detail.getPriceWithDiscount() + "       " + detail.getValue();
            body.append(this.makeMultiRowContent(detail.getProductName(), this.printerNumOfCharacters));
            body.append(this.newRow());
            body.append(this.contentAtTheEnd(row, this.printerNumOfCharacters));
            body.append(this.newRow());
        }
        return body.toString();
    }

    private String posPrintSummary() {
        StringBuilder summary = new StringBuilder();
        summary.append(this.makeLineWithChar('-', this.printerNumOfCharacters));
        summary.append(this.newRow());
        summary.append(this.contentAtTheEnd("Ukupno:  " + this.document.getSumWithDiscount(), this.printerNumOfCharacters));
        summary.append(this.newRow());
        summary.append(this.makeLineWithChar('-', this.printerNumOfCharacters));
        summary.append(this.newRow());
        return summary.toString();
    }
}

