/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.PosPrint;

import java.sql.Connection;
import java.util.ArrayList;
import rs.petcom.master.PosPrint.ContentProporties;
import rs.petcom.master.PosPrint.NarrowPosPrintHeader;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Printer;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.Vat;
import rs.petcom.master.dal.document.Document;
import rs.petcom.master.dal.document.DocumentDetails;
import rs.petcom.master.dal.document.DocumentType;

public class NarrowPosPrintGotBill
extends ContentProporties {
    private Document document;
    private ScreensController controller;
    private Connection connection;
    private NarrowPosPrintHeader posPrintHeader;
    private String content;
    private int printerNumOfCharacters;
    private double vat_Dj;
    private double vat_E;

    public NarrowPosPrintGotBill(ScreensController controller, Printer printer, Document document) {
        this.controller = controller;
        this.printerNumOfCharacters = printer.getNumOfCharacters();
        this.connection = controller.getSettings().getConnection();
        this.document = document;
        this.posPrintHeader = new NarrowPosPrintHeader(controller, printer, document);
        this.content = this.posContent();
        this.content = this.clearFromEasternLatinChars(this.content);
    }

    private String posContent() {
        StringBuilder content = new StringBuilder();
        content.append(this.posPrintHeader.makeHeader());
        content.append(this.posPrintHeader.makeBuyer());
        content.append(this.posPrintTitle());
        content.append(this.posPrintBody());
        content.append(this.posPrintSummary());
        content.append(this.posPrintHeader.posSignature());
        return content.toString();
    }

    public String getContent() {
        return this.content;
    }

    private String posPrintTitle() {
        String docTitile = DocumentType.getById(this.document.getDocumentTypeID(), this.connection).getName() + ":" + this.document.getNumber() + "/" + this.document.getYear();
        String BI = "BI:" + this.document.getFullNumber();
        StringBuilder title = new StringBuilder();
        title.append(this.makeLineWithChar('=', this.printerNumOfCharacters));
        title.append(this.newRow());
        title.append(this.contentInTheMiddle(docTitile, this.printerNumOfCharacters));
        title.append(this.newRow());
        title.append(this.contentInTheMiddle(BI, this.printerNumOfCharacters));
        title.append(this.newRow());
        title.append(this.makeLineWithChar('=', this.printerNumOfCharacters));
        title.append(this.newRow());
        return title.toString();
    }

    public String posPrintBody() {
        ArrayList<DocumentDetails> details = DocumentDetails.getList(this.document.getDocumentID(), this.connection);
        String row = "";
        StringBuilder body = new StringBuilder();
        body.append(this.newRow());
        for (DocumentDetails detail : details) {
            this.sumVat(detail.getVatID(), detail.getValue());
            row = detail.getQuantity() + " x " + detail.getPriceWithDiscount() + "       " + detail.getValue();
            body.append(this.makeMultiRowContent(detail.getProductName(), this.printerNumOfCharacters));
            body.append(this.newRow());
            body.append(this.contentAtTheEnd(row, this.printerNumOfCharacters));
            body.append(this.newRow());
        }
        return body.toString();
    }

    private String posPrintSummary() {
        StringBuilder summary = new StringBuilder();
        summary.append(this.makeLineWithChar('-', this.printerNumOfCharacters));
        summary.append(this.newRow());
        summary.append(this.contentAtTheEnd("Ukupno:  " + this.document.getSumWithDiscount(), this.printerNumOfCharacters));
        summary.append(this.newRow());
        summary.append(this.makeLineWithChar('-', this.printerNumOfCharacters));
        summary.append(this.newRow());
        if (this.isObjecyInVatSystem()) {
            summary.append(" Pdv osnovica: " + Settings.round(this.document.getSumWithDiscount() - this.vat_Dj - this.vat_E, 2));
            summary.append(this.newRow());
            if (this.vat_Dj > 0.0) {
                summary.append(" Pdv po 20%: " + Settings.round(this.vat_Dj, 2));
                summary.append(this.newRow());
            }
            if (this.vat_E > 0.0) {
                summary.append(" Pdv po 10%: " + Settings.round(this.vat_E, 2));
                summary.append(this.newRow());
            }
        } else {
            summary.append(" Objekat van PDV-a.");
            summary.append(this.newRow());
            summary.append(" Ukupan iznos PDV-a: 0.00");
            summary.append(this.newRow());
        }
        summary.append(this.makeLineWithChar('-', this.printerNumOfCharacters));
        summary.append(this.newRow());
        summary.append(this.makeMultiRowContent("Slovima:" + ScreensController.BrojUSlova(this.document.getSumWithDiscount()), this.printerNumOfCharacters));
        summary.append(this.newRow());
        summary.append(this.makeLineWithChar('-', this.printerNumOfCharacters));
        summary.append(this.newRow());
        return summary.toString();
    }

    private void sumVat(int vatId, double value) {
        Vat vat = Vat.getById(vatId, this.connection);
        switch (vat.getCode()) {
            case "GRUPA_DJ": {
                this.vat_Dj += Settings.round(value * vat.getValue3(), 2);
                break;
            }
            case "GRUPA_E": {
                this.vat_E += Settings.round(value * vat.getValue3(), 2);
                break;
            }
        }
    }

    private boolean isObjecyInVatSystem() {
        return this.controller.getObject().getObjectVatTypeID() == 1;
    }
}

