/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.PosPrint;

import com.github.anastaciocintra.escpos.EscPos;
import com.github.anastaciocintra.escpos.EscPosConst;
import com.github.anastaciocintra.escpos.Style;
import com.github.anastaciocintra.escpos.barcode.BarCodeWrapperInterface;
import com.github.anastaciocintra.escpos.barcode.QRCode;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.util.ArrayList;
import rs.petcom.enums.InvoiceType;
import rs.petcom.master.PosPrint.ContentProporties;
import rs.petcom.master.PosPrint.escpos.EscPosPrinterStandard;
import rs.petcom.master.PosPrint.escpos.IEscPosPrinter;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Printer;
import rs.petcom.master.dal.Unit;
import rs.petcom.master.dal.User;
import rs.petcom.master.dal.Vat;
import rs.petcom.master.dal.document.Document;
import rs.petcom.master.dal.document.DocumentDetails;
import rs.petcom.master.newFiscalization.invoice.InvoiceBody;
import rs.petcom.master.newFiscalization.invoice.InvoiceResponse;
import rs.petcom.master.newFiscalization.invoice.Payment;
import rs.petcom.master.newFiscalization.tax.TaxRate;
import rs.petcom.master.utility.FormaterUtil;
import rs.petcom.master.utility.NPrintUtil;

public class NarrowPosPrintFiscalRefund
extends ContentProporties {
    private Connection connection;
    private InvoiceBody body;
    private InvoiceResponse response;
    private Document document;
    private EscPos escPos;
    private int numOfCharacters;
    private Style style;
    IEscPosPrinter escPosPrinter;
    Document documentDatabase;

    public NarrowPosPrintFiscalRefund(InvoiceBody body, InvoiceResponse response, Document document, EscPos escPos, Printer printer, ScreensController controller) {
        this.body = body;
        this.response = response;
        this.document = document;
        this.escPos = escPos;
        this.connection = controller.getSettings().getConnection();
        this.numOfCharacters = printer.getNumOfCharacters();
        this.escPosPrinter = new EscPosPrinterStandard(escPos, printer.getServerName());
        this.style = new Style().setFontSize(Style.FontSize._1, Style.FontSize._2).setBold(true);
    }

    public void fiscalRefundContent(InvoiceType invoiceType, String stampa, Document document) throws UnsupportedEncodingException, IOException {
        this.documentDatabase = document;
        System.out.println("STAMPA JE " + stampa);
        if (!"true".equals(stampa) || this.escPosPrinter.getPrinterServerName().toUpperCase().contains("EPSON")) {
            this.header(invoiceType);
            this.fiscalBillItems(invoiceType);
            if (this.isRefundTypeCopy(invoiceType) || this.isRefundTypeTraining(invoiceType) || this.isRefundTypeProforma(invoiceType)) {
                this.notFiscal(invoiceType);
            }
            this.taxRates();
            this.footer();
            this.qrCode();
            this.endOfFiscalBill(invoiceType);
        } else {
            StringBuilder vrednost = this.header1(invoiceType);
            this.fiscalBillItems1(invoiceType, vrednost);
            if (this.isRefundTypeCopy(invoiceType) || this.isRefundTypeTraining(invoiceType) || this.isRefundTypeProforma(invoiceType)) {
                this.notFiscal1(invoiceType, vrednost);
            }
            this.taxRates1(vrednost);
            this.footer1(vrednost);
            String code1 = this.response.getVerificationUrl();
            String endBilll = this.textInTheMiddleWithSigns(" " + invoiceType.getFooter() + " ", '=', this.numOfCharacters);
            StringBuilder stringBuilder = new StringBuilder();
            StringBuilder footerPo = new StringBuilder();
            String signature = "Potpis kupca:";
            if (this.isRefundTypeCopy(invoiceType)) {
                footerPo.append(signature);
                footerPo.append(this.makeLineWithChar('_', this.numOfCharacters - signature.length()) + "\n\n");
            }
            footerPo.append(this.textInTheMiddleWithSigns(" " + invoiceType.getFooter() + " ", '=', this.numOfCharacters) + "\n");
            String endBillAndCode = stringBuilder.append(code1 + "\n").append(footerPo.toString()).toString();
            this.escPosPrinter.printImage(vrednost, endBillAndCode, this.numOfCharacters, this.escPos, this.response.getInvoiceNumber(), stringBuilder);
            this.endOfFiscalBill1(invoiceType);
        }
    }

    private void header(InvoiceType invoiceType) throws UnsupportedEncodingException, IOException {
        long userID = this.document.getSysUserAddID();
        User user = User.getUserByID(userID, this.connection);
        String referentDocumentDT = NPrintUtil.textDatefromISO8601(this.body.getReferentDocumentDT());
        this.escPosPrinter.printLineLatin(this.textInTheMiddleWithSigns(" " + invoiceType.getHeader() + " ", '=', this.numOfCharacters));
        this.escPosPrinter.printBlankLine();
        this.escPosPrinter.printLineLatin(this.contentInTheMiddle(this.response.getTin(), this.numOfCharacters));
        this.escPosPrinter.printLineAutoDetect(this.contentInTheMiddle(this.response.getBusinessName(), this.numOfCharacters));
        this.escPosPrinter.printLineAutoDetect(this.contentInTheMiddle(this.response.getLocationName(), this.numOfCharacters));
        this.escPosPrinter.printLineAutoDetect(this.contentInTheMiddle(this.response.getAddress(), this.numOfCharacters));
        this.escPosPrinter.printLineAutoDetect(this.contentInTheMiddle(this.response.getDistrict(), this.numOfCharacters));
        this.escPosPrinter.printLineLatin(this.makeLineWithChar('-', this.numOfCharacters));
        this.escPosPrinter.printLineLatin(this.textWithSpaceBetween("Kasir:", user.getUserName(), this.numOfCharacters));
        if (this.body.getBuyerId() != null) {
            this.escPosPrinter.printLineLatin(this.textWithSpaceBetween("Id kupca:", this.body.getBuyerId(), this.numOfCharacters));
        }
        this.escPosPrinter.printLineLatin(this.textWithSpaceBetween("Esir broj:", this.body.getInvoiceNumber(), this.numOfCharacters));
        this.escPosPrinter.printLineLatin(this.textWithSpaceBetween("Ref. broj:", this.body.getReferentDocumentNumber(), this.numOfCharacters));
        this.escPosPrinter.printLineLatin(this.textWithSpaceBetween("Ref. vreme:", referentDocumentDT, this.numOfCharacters));
        this.escPosPrinter.printBlankLine();
    }

    private double isLength(String name, int numOfCharacters) {
        double a = name.length();
        return a / (double)numOfCharacters;
    }

    private static void shareitString(StringBuilder stringBuilder, String locationName, double a, int numberOfCharachter) {
        int temp = 0;
        int tempnumberOfCharachter = numberOfCharachter;
        for (double i = 0.0; i < a; i += 1.0) {
            if (tempnumberOfCharachter > locationName.length()) {
                tempnumberOfCharachter = locationName.length();
            }
            String locationNameTemp = locationName.substring(temp, tempnumberOfCharachter);
            temp += numberOfCharachter;
            tempnumberOfCharachter += numberOfCharachter;
            stringBuilder.append(locationNameTemp);
            stringBuilder.append("\n");
        }
    }

    private StringBuilder header1(InvoiceType invoiceType) throws UnsupportedEncodingException, IOException {
        String businessName;
        double length;
        long userID = this.document.getSysUserAddID();
        this.escPos.pulsePin(EscPos.PinConnector.Pin_5, 100, 100);
        User user = User.getUserByID(userID, this.connection);
        StringBuilder sb = new StringBuilder();
        sb.append(this.textInTheMiddleWithSigns(" " + invoiceType.getHeader() + " ", '=', this.numOfCharacters) + "\n");
        if (this.response.getTin() != null) {
            sb.append(this.contentInTheMiddle(this.response.getTin(), this.numOfCharacters));
            sb.append("\n");
        }
        if ((length = this.isLength(businessName = this.contentInTheMiddle(this.response.getBusinessName(), this.numOfCharacters), this.numOfCharacters)) <= 2.0) {
            String businessNameTemp = (businessName.length() <= this.numOfCharacters - 1 ? businessName : businessName.substring(0, this.numOfCharacters - 1)) + "\n";
            businessNameTemp = businessNameTemp + (businessName.length() > this.numOfCharacters - 1 ? businessName.substring(this.numOfCharacters - 1, businessName.length()) + "\n" : "");
            sb.append(businessNameTemp);
        } else {
            NarrowPosPrintFiscalRefund.shareitString(sb, businessName, length, this.numOfCharacters);
        }
        String locationName = this.contentInTheMiddle(this.response.getLocationName(), this.numOfCharacters);
        length = this.isLength(locationName, this.numOfCharacters);
        if (length <= 2.0) {
            String locationNameTemp = (locationName.length() <= this.numOfCharacters - 1 ? locationName : locationName.substring(0, this.numOfCharacters - 1)) + "\n";
            locationNameTemp = locationNameTemp + (locationName.length() > this.numOfCharacters - 1 ? locationName.substring(this.numOfCharacters - 1, locationName.length()) + "\n" : "");
            sb.append(locationNameTemp);
        } else {
            NarrowPosPrintFiscalRefund.shareitString(sb, locationName, length, this.numOfCharacters);
        }
        String address = this.contentInTheMiddle(this.response.getAddress(), this.numOfCharacters);
        length = this.isLength(address, this.numOfCharacters);
        if (length <= 2.0) {
            String addressTemp = (address.length() <= this.numOfCharacters - 1 ? address : address.substring(0, this.numOfCharacters - 1)) + "\n";
            addressTemp = addressTemp + (address.length() > this.numOfCharacters - 1 ? address.substring(this.numOfCharacters - 1, address.length()) + "\n" : "");
            sb.append(addressTemp);
        } else {
            NarrowPosPrintFiscalRefund.shareitString(sb, address, length, this.numOfCharacters);
        }
        String district = this.contentInTheMiddle(this.response.getDistrict(), this.numOfCharacters);
        sb.append(district.length() <= this.numOfCharacters ? district : district.substring(0, this.numOfCharacters) + "\n").append(district.length() > this.numOfCharacters ? district.substring(this.numOfCharacters, district.length()) : "");
        sb.append("\n");
        sb.append(this.makeLineWithString("-", this.numOfCharacters));
        sb.append("\n");
        sb.append(this.textWithSpaceBetween("Kasir:", user.getUserName(), this.numOfCharacters));
        sb.append("\n");
        if (this.body.getBuyerId() != null) {
            sb.append(this.textWithSpaceBetween("Id kupca:", this.body.getBuyerId(), this.numOfCharacters));
            sb.append("\n");
        }
        if (this.body.getBuyerCostCenterId() != null) {
            sb.append(this.textWithSpaceBetween("Opciono polje kupca:", this.body.getBuyerCostCenterId(), this.numOfCharacters));
            sb.append("\n");
        }
        sb.append(this.textWithSpaceBetween("Esir broj:", this.body.getInvoiceNumber(), this.numOfCharacters) + "\n");
        if (this.body.getDateAndTimeOfIssue() != null) {
            sb.append(this.textWithSpaceBetween("Esir vreme:", this.body.getDateAndTimeOfIssue(), this.numOfCharacters));
            sb.append("\n");
        }
        if (this.body.getReferentDocumentDT() != null && !this.body.getReferentDocumentDT().isEmpty()) {
            String referentDocumentDT = NPrintUtil.textDatefromISO8601(this.body.getReferentDocumentDT());
            System.out.println("Referentno vreme ");
            String refbroj = this.textWithSpaceBetween("Ref. broj:", this.body.getReferentDocumentNumber(), this.numOfCharacters);
            String refBroj1 = (refbroj.length() <= this.numOfCharacters - 1 ? refbroj : refbroj.substring(0, this.numOfCharacters - 1)) + "\n";
            if (refbroj.length() > this.numOfCharacters - 1) {
                refBroj1 = refBroj1 + (refbroj.length() > this.numOfCharacters - 1 ? refbroj.substring(this.numOfCharacters - 1, refbroj.length()) + "\n" : "");
                sb.append(refBroj1 + "\n");
            } else {
                sb.append(refBroj1);
            }
            String refVreme = this.textWithSpaceBetween("Ref. vreme:", referentDocumentDT, this.numOfCharacters);
            String refVreme1 = (refVreme.length() <= this.numOfCharacters - 1 ? refVreme : refVreme.substring(0, this.numOfCharacters - 1)) + "\n";
            if (refVreme.length() > this.numOfCharacters - 1) {
                refVreme1 = refVreme1 + (refVreme.length() > this.numOfCharacters - 1 ? refVreme.substring(this.numOfCharacters - 1, refVreme.length()) + "\n" : "");
                sb.append(refVreme1 + "\n");
            } else {
                sb.append(refVreme1);
            }
        }
        return sb;
    }

    private void fiscalBillItems(InvoiceType invoiceType) throws UnsupportedEncodingException, IOException {
        this.insertFiscalItemsHeader(invoiceType);
        this.insertFiscalItems();
        this.insertFiscalItemsTotal();
    }

    private void fiscalBillItems1(InvoiceType invoiceType, StringBuilder stringBuilder) throws UnsupportedEncodingException, IOException {
        this.insertFiscalItemsHeader1(invoiceType, stringBuilder);
        this.insertFiscalItems1(stringBuilder);
        this.insertFiscalItemsTotal1(invoiceType, stringBuilder);
    }

    private void insertFiscalItemsHeader1(InvoiceType invoiceType, StringBuilder stringBuilder) throws UnsupportedEncodingException, IOException {
        stringBuilder.append(this.textInTheMiddleWithSigns(" " + invoiceType.getHeadline() + " ", '-', this.numOfCharacters));
        stringBuilder.append("\n");
        stringBuilder.append(" Artikli");
        stringBuilder.append("\n");
        stringBuilder.append(this.makeLineWithChar('=', this.numOfCharacters));
        stringBuilder.append("\n");
        stringBuilder.append(this.textWithSpaceBetween("Naziv   Cena", " Kol.     Ukupno", this.numOfCharacters));
        stringBuilder.append("\n");
    }

    private void insertFiscalItems1(StringBuilder stringBuilder) throws UnsupportedEncodingException, IOException {
        String vatCode = "";
        String productName = "";
        String unitName = "";
        String price = "";
        String quantity = "";
        String value = "";
        ArrayList<DocumentDetails> items = DocumentDetails.getList(this.document.getDocumentID(), this.connection);
        for (DocumentDetails item : items) {
            vatCode = Vat.getById(item.getVatID(), this.connection).getCode();
            productName = item.getBarcode() + "-" + item.getProductName();
            unitName = Unit.getUnitById(item.getUnitID(), this.connection).getCode();
            quantity = this.formatOnThree(item.getQuantity());
            price = this.formatOnTwo(item.getPriceWithDiscount());
            value = this.formatOnTwo(item.getValue() * -1.0);
            String productCombination = productName + "(" + vatCode + ")/" + unitName;
            String productNameTemp = (productCombination.length() <= this.numOfCharacters - 1 ? productCombination : productCombination.substring(0, this.numOfCharacters - 1)) + "\n";
            productNameTemp = productNameTemp + (productCombination.length() > this.numOfCharacters - 1 ? productCombination.substring(this.numOfCharacters - 1, productCombination.length()) + "\n" : "");
            stringBuilder.append(productNameTemp);
            if (this.documentDatabase != null && this.documentDatabase.getDocumentTypeID() == 20) {
                stringBuilder.append(this.textWithSpaceBetween(this.priceLine("", price), this.qunatitySumLine(quantity, String.valueOf(0.0), this.numOfCharacters), this.numOfCharacters) + "\n");
                continue;
            }
            stringBuilder.append(this.textWithSpaceBetween(this.priceLine("", price), this.qunatitySumLine(quantity, value, this.numOfCharacters), this.numOfCharacters) + "\n");
        }
    }

    private void insertFiscalItemsTotal1(InvoiceType invoiceType, StringBuilder stringBuilder) throws UnsupportedEncodingException, IOException {
        String total = this.formatOnTwo(this.response.getTotalAmount());
        stringBuilder.append(this.makeLineWithChar('-', this.numOfCharacters) + "\n");
        stringBuilder.append(this.textWithSpaceBetween("Ukupna refundacija:", total, this.numOfCharacters) + "\n");
        this.insertPayments1(stringBuilder);
    }

    private void insertPayments1(StringBuilder stringBuilder) throws UnsupportedEncodingException, IOException {
        Payment[] payments = this.body.getPayment();
        String methodName = "";
        String methodAmount = "";
        for (Payment payment : payments) {
            methodName = this.methodName(payment.getPaymentType());
            methodAmount = this.formatOnTwo(payment.getAmount());
            stringBuilder.append(this.textWithSpaceBetween(methodName, methodAmount, this.numOfCharacters) + "\n");
        }
    }

    private void insertCopyPayments1(StringBuilder stringBuilder) throws UnsupportedEncodingException, IOException {
        Payment[] payments = this.body.getPayment();
        String methodName = "";
        String methodAmount = "";
        for (Payment payment : payments) {
            methodName = this.methodName(payment.getPaymentType());
            methodAmount = this.formatOnTwo(payment.getAmount());
            stringBuilder.append(this.textWithSpaceBetween(methodName, methodAmount, this.numOfCharacters) + "\n");
        }
    }

    private void insertFiscalItemsHeader(InvoiceType invoiceType) throws UnsupportedEncodingException, IOException {
        this.escPosPrinter.printLineLatin(this.textInTheMiddleWithSigns(" " + invoiceType.getHeadline() + " ", '-', this.numOfCharacters));
        this.escPosPrinter.printLineLatin(" Artikli");
        this.escPosPrinter.printLineLatin(this.makeLineWithChar('=', this.numOfCharacters));
        this.escPosPrinter.printLineLatin(this.textWithSpaceBetween("Naziv   Cena", "Kol.       Ukupno", this.numOfCharacters));
        this.escPosPrinter.printBlankLine();
    }

    private void insertFiscalItems() throws UnsupportedEncodingException, IOException {
        String vatCode = "";
        String productName = "";
        String unitName = "";
        String price = "";
        String quantity = "";
        String value = "";
        ArrayList<DocumentDetails> items = DocumentDetails.getList(this.document.getDocumentID(), this.connection);
        for (DocumentDetails item : items) {
            vatCode = Vat.getById(item.getVatID(), this.connection).getCode();
            productName = item.getBarcode() + "-" + item.getProductName();
            unitName = Unit.getUnitById(item.getUnitID(), this.connection).getCode();
            quantity = this.formatOnThree(item.getQuantity());
            price = this.formatOnTwo(item.getPriceWithDiscount());
            value = this.formatOnTwo(item.getValue() * -1.0);
            if (this.escPosPrinter.canPrintCyrAndLatInOneLine()) {
                this.escPosPrinter.printLatin(productName + "(");
                if (FormaterUtil.isCyrillic(vatCode)) {
                    this.escPosPrinter.printCyrillic(vatCode);
                } else {
                    this.escPosPrinter.printLatin(vatCode);
                }
                this.escPosPrinter.printLineLatin(")/" + unitName);
            } else {
                if (FormaterUtil.isCyrillic(vatCode)) {
                    productName = FormaterUtil.stripSerbianLatin(productName);
                    unitName = FormaterUtil.stripSerbianLatin(unitName);
                }
                this.escPosPrinter.printLineAutoDetect(this.makeMultiRowContent(productName + "(" + vatCode + ")/" + unitName, this.numOfCharacters));
            }
            this.escPosPrinter.printLineLatin(this.textWithSpaceBetween(this.priceLine("", price), this.qunatitySumLine(quantity, value, this.numOfCharacters), this.numOfCharacters));
        }
    }

    private void insertFiscalItemsTotal() throws UnsupportedEncodingException, IOException {
        String total = this.formatOnTwo(this.response.getTotalAmount());
        this.escPosPrinter.printLineLatin(this.makeLineWithChar('-', this.numOfCharacters));
        this.escPosPrinter.printLineLatin(this.textWithSpaceBetween("Ukupna refundacija:", total, this.numOfCharacters));
        this.insertPayments();
    }

    private void insertPayments() throws UnsupportedEncodingException, IOException {
        Payment[] payments = this.body.getPayment();
        String methodName = "";
        String methodAmount = "";
        for (Payment payment : payments) {
            methodName = this.methodName(payment.getPaymentType());
            methodAmount = this.formatOnTwo(payment.getAmount());
            this.escPosPrinter.printLineLatin(this.textWithSpaceBetween(methodName, methodAmount, this.numOfCharacters));
        }
    }

    private void notFiscal(InvoiceType invoiceType) throws UnsupportedEncodingException, IOException {
        this.escPosPrinter.printLineLatin(this.makeLineWithChar('=', this.numOfCharacters));
        this.escPosPrinter.printLineLatinWithStyle(this.contentInTheMiddle(invoiceType.getHeader(), this.numOfCharacters), this.style);
    }

    private void notFiscal1(InvoiceType invoiceType, StringBuilder vrednost) throws UnsupportedEncodingException, IOException {
        vrednost.append(this.makeLineWithChar('=', this.numOfCharacters) + "\n");
        vrednost.append(this.contentInTheMiddle(invoiceType.getHeader(), this.numOfCharacters) + "\n");
    }

    private void taxRates() throws UnsupportedEncodingException, IOException {
        TaxRate[] rates;
        String rate = "";
        String rateAmount = "";
        double totalRateAmount = 0.0;
        this.escPosPrinter.printLineLatin(this.makeLineWithChar('=', this.numOfCharacters));
        this.escPosPrinter.printLineLatin(this.textWithSpaceBetween("Oznaka    Ime", "Stopa       Porez", this.numOfCharacters));
        for (TaxRate r : rates = this.response.getTaxItems()) {
            rate = this.formatOnTwo(r.getRate()) + "%";
            rateAmount = this.formatOnTwo(r.getAmount());
            totalRateAmount += r.getAmount();
            this.escPosPrinter.printLineAutoDetect(this.textWithSpaceBetween(this.taxMarkNameLine(r.getLabel(), r.getCategoryName()), this.taxRateVatLine(rate, rateAmount), this.numOfCharacters));
        }
        this.escPosPrinter.printLineLatin(this.makeLineWithChar('-', this.numOfCharacters));
        this.escPosPrinter.printLineLatin(this.textWithSpaceBetween("Ukupan iznos poreza:", this.formatOnTwo(totalRateAmount), this.numOfCharacters));
    }

    private void taxRates1(StringBuilder vrednost) throws UnsupportedEncodingException, IOException {
        TaxRate[] rates;
        String rate = "";
        String rateAmount = "";
        double totalRateAmount = 0.0;
        vrednost.append(this.makeLineWithChar('=', this.numOfCharacters) + "\n");
        if (this.numOfCharacters <= 30) {
            vrednost.append(this.textWithSpaceBetween("Oznaka   Ime", "Stopa    Porez", this.numOfCharacters) + "\n");
        } else {
            vrednost.append(this.textWithSpaceBetween("Oznaka    Ime", "Stopa       Porez", this.numOfCharacters) + "\n");
        }
        for (TaxRate r : rates = this.response.getTaxItems()) {
            rate = this.formatOnTwo(r.getRate()) + "%";
            rateAmount = this.formatOnTwo(r.getAmount());
            totalRateAmount += r.getAmount();
            String vr = this.textWithSpaceBetween(this.taxMarkNameLineImage(r.getLabel(), r.getCategoryName(), this.numOfCharacters), this.taxRateVatLineImage(rate, rateAmount, this.numOfCharacters), this.numOfCharacters);
            vrednost.append(vr + "\n");
        }
        vrednost.append(this.makeLineWithChar('-', this.numOfCharacters) + "\n");
        vrednost.append(this.textWithSpaceBetween("Ukupan iznos poreza:", this.formatOnTwo(totalRateAmount), this.numOfCharacters) + "\n");
    }

    private void footer() throws UnsupportedEncodingException, IOException {
        String pfrDate = NPrintUtil.textDatefromISO8601(this.response.getSdcDateTime());
        this.escPosPrinter.printLineLatin(this.makeLineWithChar('=', this.numOfCharacters));
        this.escPosPrinter.printLineLatin(this.textWithSpaceBetween("PFR vreme:", pfrDate, this.numOfCharacters));
        this.escPosPrinter.printLineLatin(this.textWithSpaceBetween("PFR broj ra\u010duna:", this.response.getInvoiceNumber(), this.numOfCharacters));
        String label = " Broja\u010d ra\u010duna:";
        if (this.escPosPrinter.canPrintCyrAndLatInOneLine()) {
            String value = this.response.getInvoiceCounter();
            this.escPosPrinter.printLatin(label);
            this.escPosPrinter.printLatin(this.spaces(this.numOfCharacters - (label.length() + value.length())));
            this.escPosPrinter.printLineCyrillic(value);
        } else if (FormaterUtil.isCyrillic(this.response.getInvoiceCounter())) {
            this.escPosPrinter.printLineCyrillic(this.textWithSpaceBetween(FormaterUtil.stripSerbianLatin(label), this.response.getInvoiceCounter(), this.numOfCharacters));
        } else {
            this.escPosPrinter.printLineLatin(this.textWithSpaceBetween(label, this.response.getInvoiceCounter(), this.numOfCharacters));
        }
        this.escPosPrinter.printLatin(this.makeLineWithChar('=', this.numOfCharacters));
    }

    private void footer1(StringBuilder stringBuilder) throws UnsupportedEncodingException, IOException {
        String prfNumber;
        String pfrDate = NPrintUtil.textDatefromISO8601(this.response.getSdcDateTime());
        stringBuilder.append(this.makeLineWithChar('=', this.numOfCharacters) + "\n");
        String prfvreme = this.textWithSpaceBetween("PFR vreme:", pfrDate, this.numOfCharacters);
        stringBuilder.append(prfvreme.length() <= this.numOfCharacters - 1 ? prfvreme : "PFR vreme:\n" + pfrDate);
        if (prfvreme.length() >= this.numOfCharacters - 1) {
            stringBuilder.append("\n");
        }
        stringBuilder.append((prfNumber = this.textWithSpaceBetween("PFR broj ra\u010duna:", this.response.getInvoiceNumber(), this.numOfCharacters)).length() <= this.numOfCharacters - 1 ? prfNumber : "PFR broj ra\u010duna:\n" + this.response.getInvoiceNumber());
        if (prfNumber.length() >= this.numOfCharacters - 1) {
            stringBuilder.append("\n");
        }
        String label = " Broja\u010d ra\u010duna:";
        stringBuilder.append(this.textWithSpaceBetween(label.trim(), this.response.getInvoiceCounter(), this.numOfCharacters) + "\n");
        stringBuilder.append(this.makeLineWithChar('=', this.numOfCharacters) + "\n\n");
    }

    private void qrCode() throws IllegalArgumentException, IOException {
        QRCode qrCode1 = new QRCode();
        qrCode1.setSize(3);
        qrCode1.setJustification(EscPosConst.Justification.Center);
        String code1 = this.response.getVerificationUrl();
        this.escPos.feed(1);
        this.escPos.write((BarCodeWrapperInterface)qrCode1, code1);
        this.escPos.feed(1);
    }

    private void endOfFiscalBill(InvoiceType invoiceType) throws UnsupportedEncodingException, IOException {
        String signature = "Potpis kupca:";
        this.escPosPrinter.printLatin(signature);
        this.escPosPrinter.printLineLatin(this.makeLineWithChar('_', this.numOfCharacters - signature.length()));
        this.escPosPrinter.printBlankLine();
        this.escPosPrinter.printLineLatin(this.textInTheMiddleWithSigns(" " + invoiceType.getFooter() + " ", '=', this.numOfCharacters));
        this.escPosPrinter.printBlankLines(5);
        this.escPos.cut(EscPos.CutMode.FULL);
        this.escPos.pulsePin(EscPos.PinConnector.Pin_5, 100, 100);
        this.escPos.close();
    }

    private void endOfFiscalBill1(InvoiceType invoiceType) throws UnsupportedEncodingException, IOException {
        this.escPosPrinter.printBlankLines(5);
        this.escPos.cut(EscPos.CutMode.FULL);
        this.escPos.pulsePin(EscPos.PinConnector.Pin_5, 100, 100);
        this.escPos.close();
    }

    private boolean isRefundTypeCopy(InvoiceType invoiceType) {
        return invoiceType == InvoiceType.REFUND_COPY;
    }

    private boolean isRefundTypeTraining(InvoiceType invoiceType) {
        return invoiceType == InvoiceType.REFUND_TRAINING;
    }

    private boolean isRefundTypeProforma(InvoiceType invoiceType) {
        return invoiceType == InvoiceType.REFUND_PROFORMA;
    }
}

