/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.PosPrint;

import com.github.anastaciocintra.escpos.EscPos;
import com.github.anastaciocintra.escpos.EscPosConst;
import com.github.anastaciocintra.escpos.Style;
import com.github.anastaciocintra.escpos.barcode.BarCodeWrapperInterface;
import com.github.anastaciocintra.escpos.barcode.QRCode;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Logger;
import rs.petcom.enums.InvoiceType;
import rs.petcom.master.PosPrint.ContentProporties;
import rs.petcom.master.PosPrint.escpos.EscPosPrinterStandard;
import rs.petcom.master.PosPrint.escpos.IEscPosPrinter;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Printer;
import rs.petcom.master.dal.Unit;
import rs.petcom.master.dal.User;
import rs.petcom.master.dal.Vat;
import rs.petcom.master.dal.document.Document;
import rs.petcom.master.dal.document.DocumentDetails;
import rs.petcom.master.dal.document.DocumentPayment;
import rs.petcom.master.dal.person.Person;
import rs.petcom.master.newFiscalization.invoice.InvoiceBody;
import rs.petcom.master.newFiscalization.invoice.InvoiceResponse;
import rs.petcom.master.newFiscalization.invoice.Item;
import rs.petcom.master.newFiscalization.invoice.Payment;
import rs.petcom.master.newFiscalization.tax.TaxRate;
import rs.petcom.master.utility.FormaterUtil;
import rs.petcom.master.utility.NPrintUtil;

public class NarrowPosPrintFiscalReceipt
extends ContentProporties {
    private Connection connection;
    private InvoiceBody body;
    private InvoiceResponse response;
    private Document document;
    private EscPos escPos;
    private int numOfCharacters;
    private Map<String, Double> payments;
    private Style style;
    IEscPosPrinter escPosPrinter;
    ScreensController controller;
    private StringBuilder avans;
    private String avanstin;
    private static final Logger LOGGER = Logger.getLogger("global");
    private String refNumber;

    public NarrowPosPrintFiscalReceipt(InvoiceBody body, InvoiceResponse response, Document document, ScreensController controller, Printer printer, EscPos escPos, Map<String, Double> payments) {
        this.controller = controller;
        this.body = body;
        this.response = response;
        this.document = document;
        this.escPos = escPos;
        this.payments = payments;
        this.avans = new StringBuilder();
        this.connection = controller.getSettings().getConnection();
        this.numOfCharacters = printer.getNumOfCharacters();
        this.escPosPrinter = new EscPosPrinterStandard(escPos, printer.getServerName());
        this.style = new Style().setFontSize(Style.FontSize._1, Style.FontSize._2).setBold(true);
    }

    public void fiscalBillContent(InvoiceType invoiceType, Person person) throws UnsupportedEncodingException, IOException {
        this.escPos.pulsePin(EscPos.PinConnector.Pin_2, 100, 100);
        if (!"true".equals(this.controller.getSettings().getStampa()) || this.escPosPrinter.getPrinterServerName().toUpperCase().contains("EPSON")) {
            this.header(invoiceType);
            this.fiscalBillItems(invoiceType);
            if (this.isInvoiceTypeCopy(invoiceType) || this.isInvoiceTypeTraining(invoiceType) || this.isInvoiceTypeProforma(invoiceType)) {
                this.notFiscal(invoiceType);
            }
            this.taxRates();
            this.footer();
            this.qrCode();
            this.endOfFiscalBill(invoiceType, person);
        } else {
            StringBuilder vrednost = this.header1(invoiceType);
            this.fiscalBillItems1(invoiceType, vrednost);
            if (this.isInvoiceTypeCopy(invoiceType) || this.isInvoiceTypeTraining(invoiceType) || this.isInvoiceTypeProforma(invoiceType)) {
                this.notFiscal1(invoiceType, vrednost);
            }
            this.taxRates1(vrednost);
            this.footer1(vrednost);
            String code1 = this.response.getVerificationUrl();
            String endBilll = this.textInTheMiddleWithSigns(" " + invoiceType.getFooter() + " ", '=', this.numOfCharacters);
            StringBuilder stringBuilder = new StringBuilder();
            if ("konacniracun".equals(this.avanstin)) {
                String refExternalNumber = Document.findByRefNumberExternal(this.refNumber, this.controller);
                this.avans.append("*Poslednji avansni ra\u010dun ").append("\n").append(refExternalNumber).append("\n").append(" " + LocalDate.now());
            }
            String footerCustomer = person != null ? this.footerCustomer(person) : "";
            stringBuilder.append(code1 + "\n").append(endBilll + "\n");
            if (person != null && this.controller.getCurrentBill().getPaymentMethod() != null && !"WireTransfer".equals(this.controller.getCurrentBill().getPaymentMethod().getCode()) && !"AVANS".equals(this.controller.getCurrentBill().getPaymentMethod().getCode())) {
                stringBuilder.append(footerCustomer);
            }
            String endBillAndCode = stringBuilder.toString();
            this.escPosPrinter.printImage(vrednost, endBillAndCode, this.numOfCharacters, this.escPos, this.response.getInvoiceNumber(), this.avans);
            this.endOfFiscalBill1(invoiceType, person);
        }
    }

    private String footerCustomer(Person person) {
        StringBuilder stringBuilder = new StringBuilder();
        int num = this.numOfCharacters - 5;
        stringBuilder.append("\n" + this.contentInTheMiddle("NEFISKALNA \u0160TAMPA", num) + "\n\n");
        stringBuilder.append("Podaci kupca:\n");
        stringBuilder.append(this.makeLineWithChar('=', num));
        stringBuilder.append("\n");
        stringBuilder.append(this.textWithSpaceBetween("Naziv:", person.getName(), num));
        stringBuilder.append("\n");
        stringBuilder.append(this.textWithSpaceBetween("Adresa:", person.getAddress(), num));
        stringBuilder.append("\n");
        stringBuilder.append(this.textWithSpaceBetween("PIB:", person.getPIB(), num));
        stringBuilder.append("\n");
        stringBuilder.append(this.textWithSpaceBetween("Mati\u010dni:", person.getMB(), num));
        stringBuilder.append("\n");
        stringBuilder.append(this.makeLineWithChar('=', num) + "\n");
        return stringBuilder.toString();
    }

    private void header(InvoiceType invoiceType) throws UnsupportedEncodingException, IOException {
        long userID = this.document.getSysUserAddID();
        User user = User.getUserByID(userID, this.connection);
        this.escPosPrinter.printLineLatin(this.textInTheMiddleWithSigns(" " + invoiceType.getHeader() + " ", '=', this.numOfCharacters));
        this.escPosPrinter.printBlankLine();
        this.escPosPrinter.printLineLatin(this.contentInTheMiddle(this.response.getTin(), this.numOfCharacters));
        this.escPosPrinter.printLineAutoDetect(this.contentInTheMiddle(this.response.getBusinessName(), this.numOfCharacters));
        this.escPosPrinter.printLineAutoDetect(this.contentInTheMiddle(this.response.getLocationName(), this.numOfCharacters));
        this.escPosPrinter.printLineAutoDetect(this.contentInTheMiddle(this.response.getAddress(), this.numOfCharacters));
        this.escPosPrinter.printLineAutoDetect(this.contentInTheMiddle(this.response.getDistrict(), this.numOfCharacters));
        this.escPosPrinter.printLineLatin(this.makeLineWithChar('-', this.numOfCharacters));
        this.escPosPrinter.printLineLatin(this.textWithSpaceBetween("Kasir:", user.getUserName(), this.numOfCharacters));
        if (this.body.getBuyerId() != null) {
            this.escPosPrinter.printLineLatin(this.textWithSpaceBetween("Id kupca:", this.body.getBuyerId(), this.numOfCharacters));
        }
        if (this.body.getBuyerCostCenterId() != null) {
            this.escPosPrinter.printLineLatin(this.textWithSpaceBetween("Opciono polje kupca:", this.body.getBuyerCostCenterId(), this.numOfCharacters));
        }
        this.escPosPrinter.printLineLatin(this.textWithSpaceBetween("Esir broj:", this.body.getInvoiceNumber(), this.numOfCharacters));
        if (this.isInvoiceTypeCopy(invoiceType)) {
            String referentDocumentDT = NPrintUtil.textDatefromSQL(this.body.getReferentDocumentDT());
            this.escPosPrinter.printLineLatin(this.textWithSpaceBetween("Ref. broj:", this.body.getReferentDocumentNumber(), this.numOfCharacters));
            this.escPosPrinter.printLineLatin(this.textWithSpaceBetween("Ref. vreme:", referentDocumentDT, this.numOfCharacters));
        }
        this.escPos.feed(1);
    }

    private StringBuilder header1(InvoiceType invoiceType) throws UnsupportedEncodingException, IOException {
        String businessName;
        double length;
        StringBuilder sb = new StringBuilder();
        long userID = this.document.getSysUserAddID();
        User user = User.getUserByID(userID, this.connection);
        sb.append(this.textInTheMiddleWithSigns(invoiceType.getHeader() + " ", '=', this.numOfCharacters));
        sb.append("\n");
        if (this.response.getTin() != null) {
            sb.append(this.contentInTheMiddle(this.response.getTin(), this.numOfCharacters));
            sb.append("\n");
        }
        if ((length = this.isLength(businessName = this.contentInTheMiddle(this.response.getBusinessName(), this.numOfCharacters), this.numOfCharacters)) <= 2.0) {
            String businessNameTemp = (businessName.length() <= this.numOfCharacters - 1 ? businessName : businessName.substring(0, this.numOfCharacters - 1)) + "\n";
            businessNameTemp = businessNameTemp + (businessName.length() > this.numOfCharacters - 1 ? businessName.substring(this.numOfCharacters - 1, businessName.length()) + "\n" : "");
            sb.append(businessNameTemp);
        } else {
            NarrowPosPrintFiscalReceipt.shareitString(sb, businessName, length, this.numOfCharacters);
        }
        String locationName = this.contentInTheMiddle(this.response.getLocationName(), this.numOfCharacters);
        length = this.isLength(locationName, this.numOfCharacters);
        if (length <= 2.0) {
            String locationNameTemp = (locationName.length() <= this.numOfCharacters - 1 ? locationName : locationName.substring(0, this.numOfCharacters - 1)) + "\n";
            locationNameTemp = locationNameTemp + (locationName.length() > this.numOfCharacters - 1 ? locationName.substring(this.numOfCharacters - 1, locationName.length()) + "\n" : "");
            sb.append(locationNameTemp);
        } else {
            NarrowPosPrintFiscalReceipt.shareitString(sb, locationName, length, this.numOfCharacters);
        }
        String address = this.contentInTheMiddle(this.response.getAddress(), this.numOfCharacters);
        length = this.isLength(address, this.numOfCharacters);
        if (length <= 2.0) {
            String addressTemp = (address.length() <= this.numOfCharacters - 1 ? address : address.substring(0, this.numOfCharacters - 1)) + "\n";
            addressTemp = addressTemp + (address.length() > this.numOfCharacters - 1 ? address.substring(this.numOfCharacters - 1, address.length()) + "\n" : "");
            sb.append(addressTemp);
        } else {
            NarrowPosPrintFiscalReceipt.shareitString(sb, address, length, this.numOfCharacters);
        }
        String district = this.contentInTheMiddle(this.response.getDistrict(), this.numOfCharacters);
        sb.append(district.length() <= this.numOfCharacters ? district : district.substring(0, this.numOfCharacters) + "\n").append(district.length() > this.numOfCharacters ? district.substring(this.numOfCharacters, district.length()) : "");
        sb.append("\n");
        sb.append(this.makeLineWithString("-", this.numOfCharacters));
        sb.append("\n");
        sb.append(this.textWithSpaceBetween("Kasir:", user.getUserName(), this.numOfCharacters));
        sb.append("\n");
        if (this.body.getBuyerId() != null) {
            sb.append(this.textWithSpaceBetween("Id kupca:", this.body.getBuyerId(), this.numOfCharacters));
            sb.append("\n");
        }
        if (this.body.getBuyerCostCenterId() != null) {
            sb.append(this.textWithSpaceBetween("Opciono polje kupca:", this.body.getBuyerCostCenterId(), this.numOfCharacters));
            sb.append("\n");
        }
        sb.append(this.textWithSpaceBetween("Esir broj:", this.body.getInvoiceNumber(), this.numOfCharacters) + "\n");
        if (this.body.getDateAndTimeOfIssue() != null) {
            sb.append(this.textWithSpaceBetween("Esir vreme:", this.body.getDateAndTimeOfIssue(), this.numOfCharacters));
            sb.append("\n");
        }
        if (this.controller.getSettings().getRefNumberTemp() != null && !this.controller.getSettings().getRefNumberTemp().isEmpty()) {
            System.out.println("refrereno vreme jeeeee");
            sb.append(this.textWithSpaceBetween("Ref. vreme:", Document.findByRefTime1(this.controller.getSettings().getRefNumberTemp(), this.controller), this.numOfCharacters));
            sb.append("\n");
            sb.append(this.textWithSpaceBetween("Ref. broj:", this.controller.getSettings().getRefNumberTemp(), this.numOfCharacters));
            sb.append("\n");
            this.controller.getSettings().setRefNumberTemp("");
        }
        if (this.isInvoiceTypeCopy(invoiceType)) {
            String referentDocumentDT = NPrintUtil.textDatefromSQL(this.body.getReferentDocumentDT());
            System.out.println("Referentno vreme ");
            String refbroj = this.textWithSpaceBetween("Ref. broj:", this.body.getReferentDocumentNumber(), this.numOfCharacters);
            String refBroj1 = (refbroj.length() <= this.numOfCharacters - 1 ? refbroj : refbroj.substring(0, this.numOfCharacters - 1)) + "\n";
            if (refbroj.length() > this.numOfCharacters - 1) {
                refBroj1 = refBroj1 + (refbroj.length() > this.numOfCharacters - 1 ? refbroj.substring(this.numOfCharacters - 1, refbroj.length()) + "\n" : "");
                sb.append(refBroj1 + "\n");
            } else {
                sb.append(refBroj1);
            }
            String refVreme = this.textWithSpaceBetween("Ref. vreme:", referentDocumentDT, this.numOfCharacters);
            String refVreme1 = (refVreme.length() <= this.numOfCharacters - 1 ? refVreme : refVreme.substring(0, this.numOfCharacters - 1)) + "\n";
            if (refVreme.length() > this.numOfCharacters - 1) {
                refVreme1 = refVreme1 + (refVreme.length() > this.numOfCharacters - 1 ? refVreme.substring(this.numOfCharacters - 1, refVreme.length()) + "\n" : "");
                sb.append(refVreme1 + "\n");
            } else {
                sb.append(refVreme1);
            }
        }
        return sb;
    }

    private double isLength(String name, int numOfCharacters) {
        double a = name.length();
        return a / (double)numOfCharacters;
    }

    private void fiscalBillItems1(InvoiceType invoiceType, StringBuilder stringBuilder) throws UnsupportedEncodingException, IOException {
        this.insertFiscalItemsHeader1(invoiceType, stringBuilder);
        this.insertFiscalItems1(stringBuilder, invoiceType);
        this.insertFiscalItemsTotal1(invoiceType, stringBuilder);
    }

    private void insertFiscalItemsHeader1(InvoiceType invoiceType, StringBuilder stringBuilder) throws UnsupportedEncodingException, IOException {
        stringBuilder.append(this.textInTheMiddleWithSigns(" " + invoiceType.getHeadline() + " ", '-', this.numOfCharacters));
        stringBuilder.append("\n");
        stringBuilder.append(this.contentInTheMiddle("Artikli", this.numOfCharacters));
        stringBuilder.append("\n");
        stringBuilder.append(this.makeLineWithChar('=', this.numOfCharacters));
        stringBuilder.append("\n");
        stringBuilder.append(this.textWithSpaceBetween("Naziv   Cena", " Kol.     Ukupno", this.numOfCharacters));
        stringBuilder.append("\n");
    }

    private void insertFiscalItems1(StringBuilder stringBuilder, InvoiceType invoiceType) throws UnsupportedEncodingException, IOException {
        String vatCode = "";
        String productName = "";
        String unitName = "";
        String price = "";
        String quantity = "";
        String value = "";
        String priceAvans = "";
        String productNameVans = "";
        if (this.avanstin != null && !this.avanstin.isEmpty() && !"konacniracun".equals(this.avanstin)) {
            ArrayList<DocumentDetails> items = DocumentDetails.getList(this.document.getDocumentID(), this.connection);
            for (DocumentDetails item : items) {
                productNameVans = item.getProductName();
                priceAvans = this.formatOnTwo(item.getPriceWithDiscount());
                if ("refundacija".equals(this.avanstin)) continue;
                this.avans.append(productNameVans).append(" ").append(priceAvans).append("\n");
            }
            for (Item item : this.body.getItems()) {
                vatCode = item.getLabels()[0];
                productName = "Avans";
                quantity = this.formatOnThree(item.getQuantity());
                price = this.formatOnTwo(item.getUnitPrice());
                value = this.formatOnTwo(item.getTotalAmount());
                String productCombination = " " + productName + "(" + vatCode + ")/";
                String productNameTemp = (productCombination.length() <= this.numOfCharacters - 1 ? productCombination : productCombination.substring(0, this.numOfCharacters - 1)) + "\n";
                productNameTemp = productNameTemp + (productCombination.length() > this.numOfCharacters - 1 ? productCombination.substring(this.numOfCharacters - 1, productCombination.length()) + "\n" : "");
                stringBuilder.append(productNameTemp);
                if ("refundacija".equals(this.avanstin)) {
                    stringBuilder.append(this.textWithSpaceBetween(this.priceLine("", price), this.qunatitySumLine(quantity, "-" + value, this.numOfCharacters), this.numOfCharacters));
                } else {
                    stringBuilder.append(this.textWithSpaceBetween(this.priceLine("", price), this.qunatitySumLine(quantity, value, this.numOfCharacters), this.numOfCharacters));
                }
                stringBuilder.append("\n");
            }
        } else {
            ArrayList<DocumentDetails> items = DocumentDetails.getList(this.document.getDocumentID(), this.connection);
            int i = 0;
            for (DocumentDetails item : items) {
                String text;
                vatCode = Vat.getById(item.getVatID(), this.connection).getCode();
                productName = item.getProductName();
                unitName = Unit.getUnitById(item.getUnitID(), this.connection).getCode();
                quantity = this.formatOnThree(item.getQuantity());
                price = this.formatOnTwo(item.getPriceWithDiscount());
                value = this.formatOnTwo(item.getValue());
                String productCombination = " " + productName + "(" + vatCode + ")/" + unitName;
                String productNameTemp = (productCombination.length() <= this.numOfCharacters - 1 ? productCombination : productCombination.substring(0, this.numOfCharacters - 1)) + "\n";
                productNameTemp = productNameTemp + (productCombination.length() > this.numOfCharacters - 1 ? productCombination.substring(this.numOfCharacters - 1, productCombination.length()) + "\n" : "");
                stringBuilder.append(productNameTemp);
                if (this.isInvoiceTypeProforma(invoiceType)) {
                    value = "0.0";
                }
                if ((text = this.textWithSpaceBetween(this.priceLine("", price), this.qunatitySumLine(quantity, value, this.numOfCharacters), this.numOfCharacters)).length() > this.numOfCharacters) {
                    String text1 = text.substring(0, this.numOfCharacters);
                    String text2 = text.substring(this.numOfCharacters, text.length());
                    text = text1 + "\n" + text2;
                }
                stringBuilder.append(text);
                if (items.size() == ++i) continue;
                stringBuilder.append("\n");
            }
        }
    }

    private void insertFiscalItemsTotal1(InvoiceType invoiceType, StringBuilder stringBuilder) throws UnsupportedEncodingException, IOException {
        if (this.avanstin != null && !this.avanstin.isEmpty() && !"konacniracun".equals(this.avanstin)) {
            String total = this.formatOnTwo(this.response.getTotalAmount());
            stringBuilder.append("\n" + this.makeLineWithChar('-', this.numOfCharacters) + "\n");
            stringBuilder.append(this.textWithSpaceBetween("Ukupan iznos:", total, this.numOfCharacters > 30 ? this.numOfCharacters - 10 : this.numOfCharacters - 3) + "\n");
            stringBuilder.append("\n" + this.makeLineWithChar('-', this.numOfCharacters) + "\n");
            if (invoiceType == InvoiceType.SALE_COPY) {
                this.insertCopyPayments1(stringBuilder);
            } else {
                this.insertPayments1(stringBuilder);
            }
        } else {
            String total = this.formatOnTwo(this.document.getSumWithDiscount());
            stringBuilder.append("\n" + this.makeLineWithChar('-', this.numOfCharacters) + "\n");
            stringBuilder.append(this.textWithSpaceBetween("Ukupan iznos:", total, this.numOfCharacters > 30 ? this.numOfCharacters - 10 : this.numOfCharacters - 3) + "\n");
            stringBuilder.append("\n" + this.makeLineWithChar('-', this.numOfCharacters) + "\n");
            if ("konacniracun".equals(this.avanstin)) {
                System.out.println("ref number je " + this.refNumber);
                double paid = Document.findByAvans(this.refNumber, this.controller);
                stringBuilder.append(this.textWithSpaceBetween("Pla\u0107eno avansom:", this.formatOnTwo(paid), this.numOfCharacters) + "\n");
                stringBuilder.append(this.textWithSpaceBetween("Pdv na avans:", this.formatOnTwo(DocumentPayment.findByLprf(this.refNumber, this.controller).getTax()), this.numOfCharacters) + "\n");
            }
            if (invoiceType == InvoiceType.SALE_COPY) {
                this.insertCopyPayments1(stringBuilder);
            } else {
                this.insertPayments1(stringBuilder);
            }
        }
    }

    private void insertFiscalItemsTotal(InvoiceType invoiceType) throws UnsupportedEncodingException, IOException {
        String total = this.formatOnTwo(this.document.getSumWithDiscount());
        this.escPosPrinter.printLineLatin(this.makeLineWithChar('-', this.numOfCharacters));
        this.escPosPrinter.printLineLatin(this.textWithSpaceBetween("Ukupan iznos:", total, this.numOfCharacters));
        if (invoiceType == InvoiceType.SALE_COPY) {
            this.insertCopyPayments();
        } else {
            this.insertPayments();
        }
    }

    private void insertPayments1(StringBuilder stringBuilder) throws UnsupportedEncodingException, IOException {
        if (this.avanstin != null && !this.avanstin.isEmpty() && !"konacniracun".equals(this.avanstin)) {
            String methodName = "";
            String methodAmount = "";
            double paid = 0.0;
            double moneyRefund = 0.0;
            for (Map.Entry<String, Double> set : this.payments.entrySet()) {
                methodName = this.methodName(set.getKey());
                methodAmount = this.formatOnTwo(set.getValue());
                stringBuilder.append(this.textWithSpaceBetween(methodName, methodAmount, this.numOfCharacters) + "\n");
                System.out.println("Payment vrednost je " + (paid += set.getValue().doubleValue()) + ",methodAmount" + methodAmount);
            }
            moneyRefund = paid - this.response.getTotalAmount();
            stringBuilder.append(this.textWithSpaceBetween("Povra\u0107aj:", this.formatOnTwo(moneyRefund), this.numOfCharacters) + "\n");
        } else {
            String methodName = "";
            String methodAmount = "";
            double paid = 0.0;
            double moneyRefund = 0.0;
            for (Map.Entry<String, Double> set : this.payments.entrySet()) {
                methodName = this.methodName(set.getKey());
                methodAmount = this.formatOnTwo(set.getValue());
                if ("konacniracun".equals(this.avanstin)) {
                    paid = Document.findByAvans(this.refNumber, this.controller);
                    methodAmount = String.valueOf(this.document.getSumWithDiscount() - paid);
                } else {
                    LOGGER.info("PAID je " + (paid += set.getValue().doubleValue()));
                }
                stringBuilder.append(this.textWithSpaceBetween(methodName, methodAmount, this.numOfCharacters) + "\n");
            }
            if ("konacniracun".equals(this.avanstin)) {
                moneyRefund = this.document.getSumWithDiscount() - paid - Double.valueOf(methodAmount);
                stringBuilder.append(this.textWithSpaceBetween("Preostalo za pla\u0107anje:", this.formatOnTwo(moneyRefund), this.numOfCharacters) + "\n");
            } else {
                moneyRefund = paid - this.document.getSumWithDiscount();
                LOGGER.info("moneyRefund je " + moneyRefund + ", getSumWithDiscount" + this.document.getSumWithDiscount());
                stringBuilder.append(this.textWithSpaceBetween("Povra\u0107aj:", this.formatOnTwo(moneyRefund), this.numOfCharacters) + "\n");
            }
        }
    }

    private void insertCopyPayments1(StringBuilder stringBuilder) throws UnsupportedEncodingException, IOException {
        Payment[] payments = this.body.getPayment();
        String methodName = "";
        String methodAmount = "";
        for (Payment payment : payments) {
            methodName = this.methodName(payment.getPaymentType());
            methodAmount = this.formatOnTwo(payment.getAmount());
            stringBuilder.append(this.textWithSpaceBetween(methodName, methodAmount, this.numOfCharacters) + "\n");
        }
    }

    private void taxRates1(StringBuilder stringBuilder) throws UnsupportedEncodingException, IOException {
        String rate = "";
        String rateAmount = "";
        double totalRateAmount = 0.0;
        stringBuilder.append(this.makeLineWithChar('=', this.numOfCharacters) + "\n");
        if (this.numOfCharacters <= 30) {
            stringBuilder.append(this.textWithSpaceBetween("Oznaka   Ime", "Stopa    Porez", this.numOfCharacters) + "\n");
        } else {
            stringBuilder.append(this.textWithSpaceBetween("Oznaka    Ime", "Stopa       Porez", this.numOfCharacters) + "\n");
        }
        TaxRate[] rates = this.response.getTaxItems();
        int i = 0;
        for (TaxRate r : rates) {
            rate = this.formatOnTwo(r.getRate()) + "%";
            rateAmount = this.formatOnTwo(r.getAmount());
            totalRateAmount += r.getAmount();
            String vr = this.textWithSpaceBetween(this.taxMarkNameLineImage(r.getLabel(), r.getCategoryName(), this.numOfCharacters), this.taxRateVatLineImage(rate, rateAmount, this.numOfCharacters), this.numOfCharacters);
            stringBuilder.append(vr);
            if (rates.length == ++i) continue;
            stringBuilder.append("\n");
        }
        System.out.println("sprema se da updatujem tax " + this.avanstin);
        if (this.avanstin != null && !this.avanstin.isEmpty() && !"konacniracun".equals(this.avanstin)) {
            System.out.println("treba da updatujem tax " + totalRateAmount);
            DocumentPayment.updateTax(this.document.getDocumentID(), totalRateAmount, this.controller);
        }
        stringBuilder.append("\n" + this.makeLineWithChar('-', this.numOfCharacters) + "\n");
        stringBuilder.append(this.textWithSpaceBetween("Ukupan iznos poreza:", this.formatOnTwo(totalRateAmount), this.numOfCharacters) + "\n");
    }

    private void footer1(StringBuilder stringBuilder) throws IOException {
        String prfNumber;
        String pfrDate = NPrintUtil.textDatefromISO8601(this.response.getSdcDateTime());
        stringBuilder.append(this.makeLineWithChar('=', this.numOfCharacters) + "\n");
        String prfvreme = this.textWithSpaceBetween("PFR vreme:", pfrDate, this.numOfCharacters);
        stringBuilder.append(prfvreme.length() <= this.numOfCharacters - 1 ? prfvreme : "PFR vreme:\n" + pfrDate);
        if (prfvreme.length() >= this.numOfCharacters - 1) {
            stringBuilder.append("\n");
        }
        stringBuilder.append((prfNumber = this.textWithSpaceBetween("PFR broj ra\u010duna:", this.response.getInvoiceNumber(), this.numOfCharacters)).length() <= this.numOfCharacters - 1 ? prfNumber : "PFR broj ra\u010duna:\n" + this.response.getInvoiceNumber());
        if (prfNumber.length() >= this.numOfCharacters - 1) {
            stringBuilder.append("\n");
        }
        String label = " Broja\u010d ra\u010duna:";
        stringBuilder.append(this.textWithSpaceBetween(label.trim(), this.response.getInvoiceCounter(), this.numOfCharacters) + "\n");
        stringBuilder.append(this.makeLineWithChar('=', this.numOfCharacters) + "\n\n");
    }

    private void endOfFiscalBill1(InvoiceType invoiceType, Person person) throws UnsupportedEncodingException, IOException {
        if (person != null) {
            // empty if block
        }
        this.escPosPrinter.printBlankLines(5);
        this.escPos.cut(EscPos.CutMode.FULL);
        this.escPos.close();
    }

    private void fiscalBillItems(InvoiceType invoiceType) throws UnsupportedEncodingException, IOException {
        this.insertFiscalItemsHeader(invoiceType);
        this.insertFiscalItems();
        this.insertFiscalItemsTotal(invoiceType);
    }

    private void insertFiscalItemsHeader(InvoiceType invoiceType) throws UnsupportedEncodingException, IOException {
        this.escPosPrinter.printLineLatin(this.textInTheMiddleWithSigns(" " + invoiceType.getHeadline() + " ", '-', this.numOfCharacters));
        this.escPosPrinter.printLineLatin(" Artikli");
        this.escPosPrinter.printLineLatin(this.makeLineWithChar('=', this.numOfCharacters));
        this.escPosPrinter.printLineLatin(this.textWithSpaceBetween("Naziv   Cena", "Kol.       Ukupno", this.numOfCharacters));
        this.escPos.feed(1);
    }

    private void insertFiscalItems() throws UnsupportedEncodingException, IOException {
        String vatCode = "";
        String productName = "";
        String unitName = "";
        String price = "";
        String quantity = "";
        String value = "";
        ArrayList<DocumentDetails> items = DocumentDetails.getList(this.document.getDocumentID(), this.connection);
        for (DocumentDetails item : items) {
            vatCode = Vat.getById(item.getVatID(), this.connection).getCode();
            productName = item.getBarcode() + "-" + item.getProductName();
            unitName = Unit.getUnitById(item.getUnitID(), this.connection).getCode();
            quantity = this.formatOnThree(item.getQuantity());
            price = this.formatOnTwo(item.getPriceWithDiscount());
            value = this.formatOnTwo(item.getValue());
            String left1 = productName + "(";
            String right1 = vatCode + ")/" + unitName;
            String prod = this.textWithSpaceBetween(productName + "(", vatCode + ")/" + unitName, this.numOfCharacters);
            System.out.println(prod);
            if (this.escPosPrinter.canPrintCyrAndLatInOneLine()) {
                this.escPosPrinter.printLatin(productName + "(");
                if (FormaterUtil.isCyrillic(vatCode)) {
                    this.escPosPrinter.printCyrillic(vatCode);
                } else {
                    this.escPosPrinter.printLatin(vatCode);
                }
                if ((left1 + right1).length() > this.numOfCharacters) {
                    this.escPosPrinter.printLineLatin("\n)/" + unitName);
                } else {
                    this.escPosPrinter.printLineLatin(")/" + unitName);
                }
            } else {
                if (FormaterUtil.isCyrillic(vatCode)) {
                    productName = FormaterUtil.stripSerbianLatin(productName);
                    unitName = FormaterUtil.stripSerbianLatin(unitName);
                }
                this.escPosPrinter.printLineAutoDetect(this.makeMultiRowContent(productName + "(" + vatCode + ")/" + unitName, this.numOfCharacters));
            }
            this.escPosPrinter.printLineLatin(this.textWithSpaceBetween(this.priceLine("", price), this.qunatitySumLine(quantity, value, this.numOfCharacters), this.numOfCharacters));
        }
    }

    private void insertPayments() throws UnsupportedEncodingException, IOException {
        String methodName = "";
        String methodAmount = "";
        double paid = 0.0;
        double moneyRefund = 0.0;
        for (Map.Entry<String, Double> set : this.payments.entrySet()) {
            methodName = this.methodName(set.getKey());
            methodAmount = this.formatOnTwo(set.getValue());
            paid += set.getValue().doubleValue();
            this.escPosPrinter.printLineLatin(this.textWithSpaceBetween(methodName, methodAmount, this.numOfCharacters));
        }
        moneyRefund = paid - this.document.getSumWithDiscount();
        this.escPosPrinter.printLineLatin(this.textWithSpaceBetween("Povra\u0107aj:", this.formatOnTwo(moneyRefund), this.numOfCharacters));
    }

    private void insertCopyPayments() throws UnsupportedEncodingException, IOException {
        Payment[] payments = this.body.getPayment();
        String methodName = "";
        String methodAmount = "";
        for (Payment payment : payments) {
            methodName = this.methodName(payment.getPaymentType());
            methodAmount = this.formatOnTwo(payment.getAmount());
            this.escPosPrinter.printLineLatin(this.textWithSpaceBetween(methodName, methodAmount, this.numOfCharacters));
        }
    }

    private void notFiscal(InvoiceType invoiceType) throws UnsupportedEncodingException, IOException {
        this.escPosPrinter.printLineLatin(this.makeLineWithChar('=', this.numOfCharacters));
        this.escPosPrinter.printLineLatinWithStyle(this.contentInTheMiddle(invoiceType.getFooter(), this.numOfCharacters), this.style);
    }

    private void notFiscal1(InvoiceType invoiceType, StringBuilder sb) throws UnsupportedEncodingException, IOException {
        String vrednost;
        sb.append(this.makeLineWithChar('=', this.numOfCharacters) + "\n");
        String string = vrednost = invoiceType.getFooter().length() < this.numOfCharacters ? invoiceType.getFooter() : invoiceType.getFooter().substring(0, this.numOfCharacters - 1);
        if (invoiceType.getFooter().length() > this.numOfCharacters) {
            vrednost = vrednost + "\n" + invoiceType.getFooter().substring(this.numOfCharacters - 1, invoiceType.getFooter().length());
        }
        sb.append(this.contentInTheMiddle(vrednost, this.numOfCharacters) + "\n");
    }

    private void taxRates() throws UnsupportedEncodingException, IOException {
        TaxRate[] rates;
        String rate = "";
        String rateAmount = "";
        double totalRateAmount = 0.0;
        this.escPosPrinter.printLineLatin(this.makeLineWithChar('=', this.numOfCharacters));
        this.escPosPrinter.printLineLatin(this.textWithSpaceBetween("Oznaka    Ime", "Stopa       Porez", this.numOfCharacters));
        for (TaxRate r : rates = this.response.getTaxItems()) {
            rate = this.formatOnTwo(r.getRate()) + "%";
            rateAmount = this.formatOnTwo(r.getAmount());
            totalRateAmount += r.getAmount();
            this.escPosPrinter.printLineAutoDetect(this.textWithSpaceBetween(this.taxMarkNameLine(r.getLabel(), r.getCategoryName()), this.taxRateVatLine(rate, rateAmount), this.numOfCharacters));
        }
        this.escPosPrinter.printLineLatin(this.makeLineWithChar('-', this.numOfCharacters));
        this.escPosPrinter.printLineLatin(this.textWithSpaceBetween("Ukupan iznos poreza:", this.formatOnTwo(totalRateAmount), this.numOfCharacters));
    }

    private void footer() throws IOException {
        String pfrDate = NPrintUtil.textDatefromISO8601(this.response.getSdcDateTime());
        this.escPosPrinter.printLineLatin(this.makeLineWithChar('=', this.numOfCharacters));
        String left1 = "PFR vreme:";
        String right1 = pfrDate;
        String a1 = this.textWithSpaceBetween(left1, right1, this.numOfCharacters);
        if ((left1 + right1).length() > this.numOfCharacters) {
            String d = left1 + "\n" + right1;
            this.escPosPrinter.printLineLatin(d);
        } else {
            this.escPosPrinter.printLineLatin(this.textWithSpaceBetween("PFR vreme:", pfrDate, this.numOfCharacters));
        }
        String left = "PFR broj ra\u010duna:";
        String right = this.response.getInvoiceNumber();
        String a = this.textWithSpaceBetween(left, right, this.numOfCharacters);
        System.out.println(a);
        if ((left + right).length() > this.numOfCharacters) {
            String d = left + "\n" + right;
            System.out.println(d);
            this.escPosPrinter.printLineLatin(d);
        } else {
            this.escPosPrinter.printLineLatin(this.textWithSpaceBetween("PFR broj ra\u010duna:", this.response.getInvoiceNumber(), this.numOfCharacters));
        }
        String label = " Broja\u010d ra\u010duna:";
        if (this.escPosPrinter.canPrintCyrAndLatInOneLine()) {
            String value = this.response.getInvoiceCounter();
            this.escPosPrinter.printLatin(label);
            this.escPosPrinter.printLatin(this.spaces(this.numOfCharacters - (label.length() + value.length())));
            this.escPosPrinter.printLineCyrillic(value);
        } else if (FormaterUtil.isCyrillic(this.response.getInvoiceCounter())) {
            this.escPosPrinter.printLineCyrillic(this.textWithSpaceBetween(FormaterUtil.stripSerbianLatin(label.trim()), this.response.getInvoiceCounter(), this.numOfCharacters));
        } else {
            this.escPosPrinter.printLineLatin(this.textWithSpaceBetween(label.trim(), this.response.getInvoiceCounter(), this.numOfCharacters));
        }
        this.escPosPrinter.printLatin(this.makeLineWithChar('=', this.numOfCharacters));
    }

    private void qrCode() throws IllegalArgumentException, IOException {
        QRCode qrCode1 = new QRCode();
        qrCode1.setSize(3);
        if (this.numOfCharacters < 40 && this.escPosPrinter.getPrinterServerName().toUpperCase().contains("EPSON")) {
            qrCode1.setJustification(EscPosConst.Justification.Left_Default);
        } else {
            qrCode1.setJustification(EscPosConst.Justification.Center);
        }
        String code1 = this.response.getVerificationUrl();
        this.escPos.feed(1);
        this.escPos.write((BarCodeWrapperInterface)qrCode1, code1);
        this.escPos.feed(1);
    }

    private void endOfFiscalBill(InvoiceType invoiceType, Person person) throws UnsupportedEncodingException, IOException {
        this.escPosPrinter.printLineLatin(this.textInTheMiddleWithSigns(" " + invoiceType.getFooter() + " ", '=', this.numOfCharacters));
        if (person != null) {
            this.personData(person);
        }
        this.escPosPrinter.printBlankLines(5);
        this.escPos.cut(EscPos.CutMode.FULL);
        this.escPos.close();
    }

    private void personData(Person person) throws IllegalArgumentException, IOException {
        this.escPosPrinter.printBlankLines(2);
        this.escPosPrinter.printLineLatinWithStyle(this.contentInTheMiddle("NEFISKALNA \u0160TAMPA", this.numOfCharacters), this.style);
        this.escPosPrinter.printBlankLines(2);
        this.escPosPrinter.printLineLatin("Podaci kupca:");
        this.escPosPrinter.printLineLatin(this.makeLineWithChar('=', this.numOfCharacters));
        this.escPosPrinter.printLineLatin(this.textWithSpaceBetween("Naziv:", person.getName(), this.numOfCharacters));
        this.escPosPrinter.printLineLatin(this.textWithSpaceBetween("Adresa:", person.getAddress(), this.numOfCharacters));
        this.escPosPrinter.printLineLatin(this.textWithSpaceBetween("PIB:", person.getPIB(), this.numOfCharacters));
        this.escPosPrinter.printLineLatin(this.textWithSpaceBetween("Mati\u010dni:", person.getMB(), this.numOfCharacters));
        this.escPosPrinter.printLineLatin(this.makeLineWithChar('=', this.numOfCharacters));
    }

    private boolean isInvoiceTypeCopy(InvoiceType invoiceType) {
        return invoiceType == InvoiceType.SALE_COPY;
    }

    private boolean isInvoiceTypeTraining(InvoiceType invoiceType) {
        return invoiceType == InvoiceType.SALE_TRAINING;
    }

    private boolean isInvoiceTypeProforma(InvoiceType invoiceType) {
        return invoiceType == InvoiceType.SALE_PROFORMA;
    }

    private static void shareitString(StringBuilder stringBuilder, String locationName, double a, int numberOfCharachter) {
        int temp = 0;
        int tempnumberOfCharachter = numberOfCharachter;
        for (double i = 0.0; i < a; i += 1.0) {
            if (tempnumberOfCharachter > locationName.length()) {
                tempnumberOfCharachter = locationName.length();
            }
            String locationNameTemp = locationName.substring(temp, tempnumberOfCharachter);
            temp += numberOfCharachter;
            tempnumberOfCharachter += numberOfCharachter;
            stringBuilder.append(locationNameTemp);
            stringBuilder.append("\n");
        }
    }

    public void setAvanstin(String avanstin) {
        this.avanstin = avanstin;
    }

    public void setRefNumber(String refNumber) {
        this.refNumber = refNumber;
    }
}

