/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.PosPrint;

import com.github.anastaciocintra.escpos.EscPos;
import com.github.anastaciocintra.output.PrinterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import javax.print.PrintService;
import rs.petcom.enums.InvoiceType;
import rs.petcom.master.PosPrint.NarrowPosPrintArticleSales;
import rs.petcom.master.PosPrint.NarrowPosPrintCurrentSales;
import rs.petcom.master.PosPrint.NarrowPosPrintFiscalReceipt;
import rs.petcom.master.PosPrint.NarrowPosPrintFiscalRefund;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Bill;
import rs.petcom.master.dal.Printer;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.WorkDay;
import rs.petcom.master.dal.document.Document;
import rs.petcom.master.dal.person.Person;
import rs.petcom.master.newFiscalization.invoice.InvoiceBody;
import rs.petcom.master.newFiscalization.invoice.InvoiceResponse;

public class ESCPosPrint {
    private ScreensController controller;
    private InvoiceResponse response;
    private InvoiceBody body;
    private Printer printer;
    private Document document;
    private Map<String, Double> payments;
    private WorkDay fromWd;
    private WorkDay toWd;
    private String avanstin;
    private String refNumber;

    public ESCPosPrint(InvoiceBody body, InvoiceResponse response, Document document, ScreensController controller, Map<String, Double> payments) {
        this.document = document;
        this.body = body;
        this.response = response;
        this.controller = controller;
        this.printer = (Printer)Printer.getAllActivePrinter(controller.getSettings().getConnection()).get(0);
        this.payments = payments;
    }

    public ESCPosPrint(InvoiceBody body, InvoiceResponse response, Document document, ScreensController controller) {
        this.document = document;
        this.body = body;
        this.response = response;
        this.controller = controller;
        this.printer = (Printer)Printer.getAllActivePrinter(controller.getSettings().getConnection()).get(0);
    }

    public ESCPosPrint(ScreensController controller) {
        this.controller = controller;
        this.printer = (Printer)Printer.getAllActivePrinter(controller.getSettings().getConnection()).get(0);
    }

    public ESCPosPrint(ScreensController controller, WorkDay fromWd, WorkDay toWd) {
        this.controller = controller;
        this.printer = (Printer)Printer.getAllActivePrinter(controller.getSettings().getConnection()).get(0);
        this.fromWd = fromWd;
        this.toWd = toWd;
    }

    public void printFiscalBill(InvoiceType invoiceType, Bill bill) {
        PrintService service = PrinterOutputStream.getPrintServiceByName((String)this.printer.getServerName());
        Person person = null;
        if (bill != null) {
            person = bill.getPerson();
        }
        try {
            PrinterOutputStream outputStream = new PrinterOutputStream(service);
            EscPos escPos = new EscPos((OutputStream)outputStream);
            NarrowPosPrintFiscalReceipt fiscalprint = new NarrowPosPrintFiscalReceipt(this.body, this.response, this.document, this.controller, this.printer, escPos, this.payments);
            fiscalprint.setAvanstin(this.avanstin);
            fiscalprint.setRefNumber(this.refNumber);
            fiscalprint.fiscalBillContent(invoiceType, person);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void printFiscalRefund(InvoiceType invoiceType, Document document) {
        PrintService service = PrinterOutputStream.getPrintServiceByName((String)this.printer.getServerName());
        try {
            PrinterOutputStream outputStream = new PrinterOutputStream(service);
            EscPos escPos = new EscPos((OutputStream)outputStream);
            escPos.setCharacterCodeTable(EscPos.CharacterCodeTable.CP852_Latin2);
            NarrowPosPrintFiscalRefund fiscalRefund = new NarrowPosPrintFiscalRefund(this.body, this.response, document, escPos, this.printer, this.controller);
            fiscalRefund.fiscalRefundContent(invoiceType, this.controller.getSettings().getStampa(), document);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void printCurrentSales(String type) {
        try {
            System.out.println("Stampa pozvana");
            boolean printA4 = Boolean.parseBoolean(this.controller.getSettings().getActualByName("print.A4"));
            boolean inoiceA4 = Boolean.parseBoolean(this.controller.getSettings().getActualByName("invoice.A4"));
            boolean profakturaA4 = Boolean.parseBoolean(this.controller.getSettings().getActualByName("profaktura.A4"));
            if (printA4 && inoiceA4 && profakturaA4) {
                NarrowPosPrintCurrentSales currentSales = new NarrowPosPrintCurrentSales(null, this.controller, this.printer, this.fromWd, this.toWd);
                this.controller.getSettings();
                currentSales.printContent(type, Settings.getPosCode(), this.controller.getSettings().getStampa());
            } else {
                PrintService service = PrinterOutputStream.getPrintServiceByName((String)this.printer.getServerName());
                PrinterOutputStream outputStream = new PrinterOutputStream(service);
                EscPos escPos = new EscPos((OutputStream)outputStream);
                escPos.setCharacterCodeTable(EscPos.CharacterCodeTable.CP852_Latin2);
                NarrowPosPrintCurrentSales currentSales = new NarrowPosPrintCurrentSales(escPos, this.controller, this.printer, this.fromWd, this.toWd);
                this.controller.getSettings();
                currentSales.printContent(type, Settings.getPosCode(), this.controller.getSettings().getStampa());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void printCurrentSalesWithArticles() {
        PrintService service = PrinterOutputStream.getPrintServiceByName((String)this.printer.getServerName());
        try {
            PrinterOutputStream outputStream = new PrinterOutputStream(service);
            EscPos escPos = new EscPos((OutputStream)outputStream);
            escPos.setCharacterCodeTable(EscPos.CharacterCodeTable.CP852_Latin2);
            NarrowPosPrintArticleSales articlesSales = new NarrowPosPrintArticleSales(escPos, this.controller, this.printer);
            articlesSales.printContent(this.controller.getSettings().getStampa());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setAvansTin(String avanstin) {
        this.avanstin = avanstin;
    }

    public void setRefNumber(String refNumber) {
        this.refNumber = refNumber;
    }
}

