/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.PosPrint;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import rs.petcom.master.PosPrint.BixolonPrintUtil;

public class CodePageConverterUtil {
    public static byte[] convertToLatin(String value) throws CharacterCodingException {
        return CodePageConverterUtil.convertToBytes(value, BixolonPrintUtil.CodePage.CP852_Latin2.charsetName);
    }

    public static byte[] convertToCyrillic(String value) throws CharacterCodingException {
        return CodePageConverterUtil.convertToBytes(value, BixolonPrintUtil.CodePage.WCP1251_Cyrillic.charsetName);
    }

    public static byte[] convertToBytes(String value, String charsetName) throws CharacterCodingException {
        CharsetEncoder encoder = Charset.forName(charsetName).newEncoder();
        CharsetEncoder encoderUtf8 = StandardCharsets.UTF_8.newEncoder();
        ByteBuffer conv1Bytes = encoderUtf8.encode(CharBuffer.wrap(value.toCharArray()));
        String utf8Str = new String(conv1Bytes.array(), StandardCharsets.UTF_8);
        ByteBuffer conv2Bytes = encoder.encode(CharBuffer.wrap(utf8Str.toCharArray()));
        return CodePageConverterUtil.copyOfRange(conv2Bytes.array(), 0, value.length());
    }

    public static byte[] copyOfRange(byte[] originalArray, int from, int to) {
        return Arrays.copyOfRange(originalArray, from, to);
    }
}

