/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.PosPrint;

import com.github.anastaciocintra.escpos.EscPos;
import com.github.anastaciocintra.escpos.Style;
import java.io.IOException;
import rs.petcom.master.PosPrint.CodePageConverterUtil;

public class BixolonPrintUtil {
    public static void printBlankLine(EscPos escPos) throws IOException {
        BixolonPrintUtil.printBlankLines(escPos, 1);
    }

    public static void printBlankLines(EscPos escPos, int lineCount) throws IOException {
        escPos.feed(lineCount);
    }

    public static void print(EscPos escPos, String value, CodePage codePage) throws IOException {
        BixolonPrintUtil.printWithStyle(escPos, value, codePage, null);
    }

    public static void printWithStyle(EscPos escPos, String value, CodePage codePage, Style style) throws IOException {
        if (style != null) {
            byte[] configBytes = style.getConfigBytes();
            escPos.write(configBytes, 0, configBytes.length);
        }
        escPos.setPrinterCharacterTable(codePage.value);
        escPos.write(CodePageConverterUtil.convertToBytes(value, codePage.charsetName), 0, value.length());
    }

    public static void printLatin(EscPos escPos, String value) throws IOException {
        BixolonPrintUtil.print(escPos, value, CodePage.CP852_Latin2);
    }

    public static void printCyrillic(EscPos escPos, String value) throws IOException {
        BixolonPrintUtil.print(escPos, value, CodePage.WCP1251_Cyrillic);
    }

    public static void printLine(EscPos escPos, String value, CodePage codePage) throws IOException {
        BixolonPrintUtil.print(escPos, value, codePage);
        escPos.writeLF("");
    }

    public static void printLineWithStyle(EscPos escPos, String value, CodePage codePage, Style style) throws IOException {
        BixolonPrintUtil.printWithStyle(escPos, value, codePage, style);
        escPos.writeLF("");
    }

    public static void printLineLatinWithStyle(EscPos escPos, String value, Style style) throws IOException {
        BixolonPrintUtil.printWithStyle(escPos, value, CodePage.CP852_Latin2, style);
        escPos.writeLF("");
    }

    public static void printLineLatin(EscPos escPos, String value) throws IOException {
        BixolonPrintUtil.printLine(escPos, value, CodePage.CP852_Latin2);
    }

    public static void printLineCyrillic(EscPos escPos, String value) throws IOException {
        BixolonPrintUtil.printLine(escPos, value, CodePage.WCP1251_Cyrillic);
    }

    public static enum CodePage {
        CP852_Latin2(18, "cp852"),
        WCP1251_Cyrillic(28, "cp1251");

        public int value;
        public String charsetName;

        private CodePage(int value) {
            this.value = value;
            this.charsetName = "cp852";
        }

        private CodePage(int value, String charsetName) {
            this.value = value;
            this.charsetName = charsetName;
        }
    }
}

