/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.jasper.jasperviewerfx;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.embed.swing.SwingFXUtils;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Accordion;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.Slider;
import javafx.scene.control.TitledPane;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import javafx.stage.FileChooser;
import javafx.stage.Popup;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.imageio.ImageIO;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperPrintManager;
import net.sf.jasperreports.engine.export.JRXlsExporterParameter;
import net.sf.jasperreports.engine.export.ooxml.JRDocxExporter;
import net.sf.jasperreports.engine.export.ooxml.JRXlsxExporter;
import rs.petcom.jasper.jasperviewerfx.JRViewerFxMode;
import rs.petcom.jasper.jasperviewerfx.TransactionResult;
import rs.petcom.jasper.jasperviewerfx.WarningToast;

public class JRViewerFxController
implements Initializable {
    private JRViewerFxMode printMode;
    private String reportFilename;
    private JRDataSource reportDataset;
    private Map reportParameters;
    private ChangeListener<Number> zoomListener;
    private JasperPrint jasperPrint;
    @FXML
    private ImageView imageView;
    @FXML
    ComboBox<Integer> pageList;
    @FXML
    Slider zoomLevel;
    @FXML
    private TitledPane resultPane;
    @FXML
    private Accordion resultAccordion;
    @FXML
    private Label resultDescription;
    @FXML
    protected Node view;
    private Stage parentStage;
    private Double zoomFactor;
    private double imageHeight;
    private double imageWidth;
    private List<Integer> pages;
    private Popup popup;
    private Label errorLabel;
    boolean showingToast;

    public void show() {
        if (this.reportParameters == null) {
            this.reportParameters = new HashMap();
        }
        if (this.printMode == null || this.printMode == JRViewerFxMode.REPORT_VIEW) {
            this.popup = new Popup();
            this.errorLabel = new Label("Error");
            this.errorLabel.setWrapText(true);
            this.errorLabel.setMaxHeight(200.0);
            this.errorLabel.setMinSize(100.0, 100.0);
            this.errorLabel.setMaxWidth(100.0);
            this.errorLabel.setAlignment(Pos.TOP_LEFT);
            this.errorLabel.getStyleClass().add((Object)"errorToastLabel");
            this.popup.getContent().add((Object)this.errorLabel);
            this.errorLabel.opacityProperty().bind((ObservableValue)this.popup.opacityProperty());
            this.zoomFactor = 1.0;
            this.zoomLevel.setValue(100.0);
            this.imageView.setX(0.0);
            this.imageView.setY(0.0);
            this.imageHeight = this.jasperPrint.getPageHeight();
            this.imageWidth = this.jasperPrint.getPageWidth();
            if (this.zoomListener != null) {
                this.zoomLevel.valueProperty().removeListener(this.zoomListener);
            }
            this.zoomListener = new ChangeListener<Number>(){

                public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                    JRViewerFxController.this.zoomFactor = newValue.doubleValue() / 100.0;
                    JRViewerFxController.this.imageView.setFitHeight(JRViewerFxController.this.imageHeight * JRViewerFxController.this.zoomFactor);
                    JRViewerFxController.this.imageView.setFitWidth(JRViewerFxController.this.imageWidth * JRViewerFxController.this.zoomFactor);
                }
            };
            this.zoomLevel.valueProperty().addListener(this.zoomListener);
            if (this.jasperPrint.getPages().size() > 0) {
                this.viewPage(0);
                this.pages = new ArrayList<Integer>();
                for (int i = 0; i < this.jasperPrint.getPages().size(); ++i) {
                    this.pages.add(i + 1);
                }
            }
            this.pageList.setItems(FXCollections.observableArrayList(this.pages));
            this.pageList.getSelectionModel().select(0);
        } else if (this.printMode == JRViewerFxMode.REPORT_PRINT) {
            this.print();
        }
    }

    @FXML
    public boolean save() {
        block14: {
            List selectedExtension;
            File file;
            block18: {
                block17: {
                    block16: {
                        block15: {
                            FileChooser fileChooser = new FileChooser();
                            fileChooser.setTitle("Save File");
                            fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("PDF Document", Arrays.asList("*.pdf", "*.PDF")));
                            fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("PNG image", Arrays.asList("*.png", "*.PNG")));
                            fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("DOCX Document", Arrays.asList("*.docx", "*.DOCX")));
                            fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("XLSX Document", Arrays.asList("*.xlsx", "*.XLSX")));
                            fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("HTML Document", Arrays.asList("*.html", "*.HTML")));
                            file = fileChooser.showSaveDialog((Window)this.parentStage);
                            if (fileChooser.getSelectedExtensionFilter() == null || fileChooser.getSelectedExtensionFilter().getExtensions() == null) break block14;
                            selectedExtension = fileChooser.getSelectedExtensionFilter().getExtensions();
                            if (!selectedExtension.contains("*.pdf")) break block15;
                            try {
                                JasperExportManager.exportReportToPdfFile((JasperPrint)this.jasperPrint, (String)file.getAbsolutePath());
                            }
                            catch (JRException e) {
                                e.printStackTrace();
                            }
                            break block14;
                        }
                        if (!selectedExtension.contains("*.png")) break block16;
                        for (int i = 0; i < this.jasperPrint.getPages().size(); ++i) {
                            String fileNumber = "0000" + Integer.toString(i + 1);
                            fileNumber = fileNumber.substring(fileNumber.length() - 4, fileNumber.length());
                            WritableImage image = this.getImage(i);
                            String[] fileTokens = file.getAbsolutePath().split("\\.");
                            String filename = "";
                            if (fileTokens.length > 0) {
                                for (int i2 = 0; i2 < fileTokens.length - 1; ++i2) {
                                    filename = filename + fileTokens[i2] + (i2 < fileTokens.length - 2 ? "." : "");
                                }
                                filename = filename + fileNumber + "." + fileTokens[fileTokens.length - 1];
                            } else {
                                filename = file.getAbsolutePath() + fileNumber;
                            }
                            File imageFile = new File(filename);
                            try {
                                ImageIO.write((RenderedImage)SwingFXUtils.fromFXImage((Image)image, null), "png", imageFile);
                                continue;
                            }
                            catch (IOException e) {
                                TransactionResult t = new TransactionResult();
                                t.setResultNumber(-1L);
                                t.setResult("Error Saving Report");
                                t.setResultDescription(e.getMessage());
                                this.setTransactionResult(t);
                                e.printStackTrace();
                            }
                        }
                        break block14;
                    }
                    if (!selectedExtension.contains("*.html")) break block17;
                    try {
                        JasperExportManager.exportReportToHtmlFile((JasperPrint)this.jasperPrint, (String)file.getAbsolutePath());
                    }
                    catch (JRException e) {
                        TransactionResult t = new TransactionResult();
                        t.setResultNumber(-1L);
                        t.setResult("Error Saving Report");
                        t.setResultDescription(e.getMessage());
                        this.setTransactionResult(t);
                        e.printStackTrace();
                    }
                    break block14;
                }
                if (!selectedExtension.contains("*.docx")) break block18;
                JRDocxExporter exporter = new JRDocxExporter();
                exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)this.jasperPrint);
                exporter.setParameter(JRExporterParameter.OUTPUT_FILE_NAME, (Object)file.getAbsolutePath());
                try {
                    exporter.exportReport();
                }
                catch (JRException e) {
                    TransactionResult t = new TransactionResult();
                    t.setResultNumber(-1L);
                    t.setResult("Error Saving Report");
                    t.setResultDescription(e.getMessage());
                    this.setTransactionResult(t);
                    e.printStackTrace();
                }
                break block14;
            }
            if (!selectedExtension.contains("*.xlsx")) break block14;
            JRXlsxExporter exporter = new JRXlsxExporter();
            exporter.setParameter(JRXlsExporterParameter.JASPER_PRINT, (Object)this.jasperPrint);
            exporter.setParameter(JRXlsExporterParameter.OUTPUT_FILE_NAME, (Object)file.getAbsolutePath());
            try {
                exporter.exportReport();
            }
            catch (JRException e) {
                TransactionResult t = new TransactionResult();
                t.setResultNumber(-1L);
                t.setResult("Error Saving Report");
                t.setResultDescription(e.getMessage());
                this.setTransactionResult(t);
                e.printStackTrace();
            }
        }
        return false;
    }

    private WritableImage getImage(int pageNumber) {
        BufferedImage image = null;
        try {
            image = (BufferedImage)JasperPrintManager.printPageToImage((JasperPrint)this.jasperPrint, (int)pageNumber, (float)2.0f);
        }
        catch (JRException e) {
            e.printStackTrace();
        }
        WritableImage fxImage = new WritableImage(this.jasperPrint.getPageWidth(), this.jasperPrint.getPageHeight());
        return SwingFXUtils.toFXImage((BufferedImage)image, (WritableImage)fxImage);
    }

    private void viewPage(int pageNumber) {
        this.imageView.setFitHeight(this.imageHeight * this.zoomFactor);
        this.imageView.setFitWidth(this.imageWidth * this.zoomFactor);
        this.imageView.setImage((Image)this.getImage(pageNumber));
    }

    public void clear() {
    }

    @FXML
    private void print() {
        try {
            JasperPrintManager.printReport((JasperPrint)this.jasperPrint, (boolean)true);
        }
        catch (JRException e) {
            e.printStackTrace();
        }
    }

    @FXML
    private void pageListSelected(ActionEvent event) {
        this.viewPage((Integer)this.pageList.getSelectionModel().getSelectedItem() - 1);
    }

    public void setTransactionResult(String result, String description, int resultNum) {
        TransactionResult t = new TransactionResult();
        t.setResult(result);
        t.setResultDescription(description);
        t.setResultNumber(resultNum);
        t.setTransactionTime(new Date());
        this.setTransactionResult(t);
    }

    public void setTransactionResult(TransactionResult t) {
        if (t != null) {
            if (t.getTransactionTime() == null) {
                this.resultPane.setText(t.getResult() + "  Time: " + new Date());
            } else {
                this.resultPane.setText(t.getResult() + "  Time: " + t.getTransactionTime());
            }
            this.resultDescription.setText(t.getResultDescription());
            this.resultPane.setVisible(true);
            this.resultAccordion.setVisible(true);
        } else {
            this.resultPane.setText("General Error Occurred  Time: " + new Date());
            this.resultDescription.setText("No data was returned.");
            this.resultPane.setVisible(true);
            this.resultAccordion.setVisible(true);
        }
        if (t.getResultNumber() != 0L && !this.showingToast) {
            this.showingToast = true;
            this.errorLabel.setText(t.getResult());
            this.popup.show((Window)this.parentStage);
            this.popup.setOpacity(1.0);
            WarningToast task = new WarningToast();
            task.progressProperty().addListener((ChangeListener)new ChangeListener<Number>(){

                public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                    JRViewerFxController.this.popup.setOpacity(newValue.doubleValue());
                    if (newValue.doubleValue() <= 0.01) {
                        JRViewerFxController.this.popup.hide();
                        JRViewerFxController.this.showingToast = false;
                    }
                }
            });
            this.popup.setX(this.view.getScene().getWindow().getX() + this.view.getScene().getWindow().getWidth() - 100.0);
            this.popup.setY(this.view.getScene().getWindow().getY());
            new Thread((Runnable)((Object)task)).start();
        }
    }

    public void clearTransactionResult() {
        this.resultPane.setText("");
        this.resultDescription.setText("");
        this.resultPane.setVisible(false);
        this.resultAccordion.setVisible(false);
    }

    public JRViewerFxMode getPrintMode() {
        return this.printMode;
    }

    public void setPrintMode(JRViewerFxMode printMode) {
        this.printMode = printMode;
    }

    public String getReportFilename() {
        return this.reportFilename;
    }

    public void setReportFilename(String reportFilename) {
        this.reportFilename = reportFilename;
    }

    public JRDataSource getReportDataset() {
        return this.reportDataset;
    }

    public void setReportDataset(JRDataSource reportDataset) {
        this.reportDataset = reportDataset;
    }

    public Map<Object, Object> getReportParameters() {
        return this.getReportParameters();
    }

    public void setReportParameters(Map<Object, Object> reportParameters) {
        this.reportParameters = reportParameters;
    }

    public Node getView() {
        return this.view;
    }

    public void setView(Node view) {
        this.view = view;
    }

    public void close() {
        this.parentStage.close();
    }

    public void initialize(URL location, ResourceBundle resources) {
    }

    public JasperPrint getJasperPrint() {
        return this.jasperPrint;
    }

    public void setJasperPrint(JasperPrint jasperPrint) {
        this.jasperPrint = jasperPrint;
    }
}

