/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.controller.trgovina;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.logging.Logger;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.stage.Stage;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Bill;
import rs.petcom.master.dal.Log;
import rs.petcom.master.dal.Round;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.User;

public class AuthorisationScreenControllerTrgovina
implements DialogController {
    private static final Logger LOGGER = Logger.getLogger("global");
    ScreensController controller;
    HashMap<String, Object> parameter;
    int modalResult = ScreensController.MODAL_RESULT_CANCEL;
    public static final int STORNO_ACTION = 1;
    public static final int PAYMENT_METHOD_ACTION = 2;
    public static final int REOPEN_WORKDAY = 3;
    public static final int PROGRAM_EXIT = 4;
    public static final int LOGOUT = 5;
    public static final int ZAKLJUCENJE_DANA = 6;
    public static final int ZAKLJUCENJE_DANA_SA_MINUSOM = 7;
    public static final int PAYMENT_METHOD_CHECH = 8;
    public static final int ZAKLJUCENJE_DANA_BEZ_FISKALA = 9;
    EventHandler<KeyEvent> eventHandler = new EventHandler<KeyEvent>(){

        public void handle(KeyEvent event) {
            switch (event.getCode()) {
                case ENTER: {
                    AuthorisationScreenControllerTrgovina.this.commitCode(null);
                    break;
                }
                case BACK_SPACE: 
                case DELETE: {
                    if (AuthorisationScreenControllerTrgovina.this.password.getText().length() > 0) {
                        AuthorisationScreenControllerTrgovina.this.password.setText(AuthorisationScreenControllerTrgovina.this.password.getText().substring(0, AuthorisationScreenControllerTrgovina.this.password.getText().length() - 1));
                    }
                }
                default: {
                    if (!event.getCode().isDigitKey()) break;
                    AuthorisationScreenControllerTrgovina.this.password.setText(AuthorisationScreenControllerTrgovina.this.password.getText() + event.getText());
                }
            }
        }
    };
    @FXML
    private BorderPane rootPane;
    @FXML
    private Label labelInfo;
    @FXML
    private GridPane numericPane;
    @FXML
    private PasswordField password;
    @FXML
    private Button button0;
    @FXML
    private Button button1;
    @FXML
    private Button button2;
    @FXML
    private Button button3;
    @FXML
    private Button button4;
    @FXML
    private Button button5;
    @FXML
    private Button button6;
    @FXML
    private Button button7;
    @FXML
    private Button button8;
    @FXML
    private Button button9;
    @FXML
    private Button buttonEnter;
    @FXML
    private Button buttonDelete;

    @Override
    public void setParameter(HashMap<String, Object> parameter) {
        this.parameter = parameter;
        this.controller = (ScreensController)parameter.get("controller");
        switch (this.controller.getAuthorizationRequest()) {
            case 1: {
                this.labelInfo.setText("Storniranje savke");
                break;
            }
        }
        this.password.setText("");
        this.rootPane.addEventFilter(KeyEvent.KEY_PRESSED, this.eventHandler);
    }

    @Override
    public HashMap<String, Object> getParameter() {
        return null;
    }

    @FXML
    private void handleButtonAction(ActionEvent event) {
        if (event.getSource() != this.buttonDelete) {
            this.password.setText(this.password.getText() + ((Button)event.getSource()).getText());
        } else {
            try {
                String code = this.password.getText().substring(0, this.password.getText().length() - 1);
                this.password.setText(code);
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    @FXML
    private void commitCode(ActionEvent event) {
        if (this.password.getText().length() > 0) {
            String string = this.password.getText();
            this.controller.getSettings();
            User user = User.getFromDb(string, Settings.getPosCode(), this.controller.getSettings().getConnection());
            switch (this.controller.getAuthorizationRequest()) {
                case 1: {
                    if (user != null && user.hasRole("storno")) {
                        this.storno(user.getUserID());
                    } else {
                        this.labelInfo.setText("Pogre\u0161na autorizacija");
                    }
                    this.password.setText("");
                    break;
                }
                case 2: {
                    if (user == null || !user.hasRole("manager")) break;
                    this.saveBill();
                    break;
                }
                case 8: {
                    if (user == null || !user.hasRole("manager")) break;
                    this.modalResult = ScreensController.MODAL_RESULT_OK;
                    this.rootPane.addEventFilter(KeyEvent.KEY_PRESSED, this.eventHandler);
                    ((Stage)this.rootPane.getScene().getWindow()).close();
                    break;
                }
                case 3: {
                    if (user == null || !user.hasRole("manager")) break;
                    this.modalResult = ScreensController.MODAL_RESULT_OK;
                    this.rootPane.addEventFilter(KeyEvent.KEY_PRESSED, this.eventHandler);
                    ((Stage)this.rootPane.getScene().getWindow()).close();
                    break;
                }
                case 5: {
                    if (user == null || !user.hasRole("manager")) break;
                    this.modalResult = ScreensController.MODAL_RESULT_OK;
                    this.rootPane.addEventFilter(KeyEvent.KEY_PRESSED, this.eventHandler);
                    ((Stage)this.rootPane.getScene().getWindow()).close();
                    break;
                }
                case 6: {
                    if (user == null || !user.hasRole("manager")) break;
                    this.parameter.put("user", user);
                    this.modalResult = ScreensController.MODAL_RESULT_OK;
                    this.rootPane.addEventFilter(KeyEvent.KEY_PRESSED, this.eventHandler);
                    ((Stage)this.rootPane.getScene().getWindow()).close();
                    break;
                }
                case 9: {
                    this.modalResult = ScreensController.MODAL_RESULT_NO;
                    while (this.modalResult != ScreensController.MODAL_RESULT_OK) {
                        if (user != null && user.hasRole("zatvaranje.dana")) {
                            this.parameter.put("user", user);
                            this.modalResult = ScreensController.MODAL_RESULT_OK;
                            this.rootPane.addEventFilter(KeyEvent.KEY_PRESSED, this.eventHandler);
                            ((Stage)this.rootPane.getScene().getWindow()).close();
                            continue;
                        }
                        this.controller.alert("Upozorenje", "Pogresna sifra", this.rootPane.getScene().getWindow());
                        this.password.setText("");
                        return;
                    }
                    break;
                }
                case 7: {
                    if (user != null && user.hasRole("minus")) {
                        this.parameter.put("user", user);
                        this.modalResult = ScreensController.MODAL_RESULT_OK;
                        this.rootPane.addEventFilter(KeyEvent.KEY_PRESSED, this.eventHandler);
                        ((Stage)this.rootPane.getScene().getWindow()).close();
                        break;
                    }
                    this.controller.alert("Nedostatak prava", "Nemate pravo da zatvorite dan sa minusom u lageru", this.rootPane.getScene().getWindow());
                    this.password.setText("");
                    break;
                }
            }
        }
    }

    @FXML
    private void cancelAction() {
        this.modalResult = ScreensController.MODAL_RESULT_CANCEL;
        this.rootPane.addEventFilter(KeyEvent.KEY_PRESSED, this.eventHandler);
        ((Stage)this.rootPane.getScene().getWindow()).close();
    }

    private void storno(long authId) {
        Double currentQuantity;
        if (this.controller.getAuthBill() == 0 && this.controller.getAuthRound() == 0 && this.controller.getAuthItem() == -1 && this.controller.getAuthAdditional() == -1 && this.controller.getAuthDesciptional() == -1) {
            Log.storno(this.controller.getUser().getUserID(), authId, this.controller.getPointOfSale().getPointOfSaleID(), this.controller.getBillList().get(this.controller.getActiveBill()).getLastRound(), this.controller.getSettings(), this.controller.getSettings().getConnection());
            this.controller.getBillList().get(this.controller.getActiveBill()).getRoundList().clear();
            this.controller.getBillList().get(this.controller.getActiveBill()).getRoundList().add(new Round());
            this.modalResult = ScreensController.MODAL_RESULT_OK;
            ((Stage)this.rootPane.getScene().getWindow()).close();
        }
        if (this.controller.getAuthBill() > -1 && this.controller.getAuthRound() > -1 && this.controller.getAuthItem() > -1 && this.controller.getAuthAdditional() == -1 && this.controller.getAuthDesciptional() == -1) {
            Log.storno(this.controller.getUser().getUserID(), authId, this.controller.getPointOfSale().getPointOfSaleID(), this.controller.getBillList().get(this.controller.getAuthBill()).getRoundList().get(this.controller.getAuthRound()).getItemList().get(this.controller.getAuthItem()), this.controller.getSettings(), this.controller.getSettings().getConnection());
            currentQuantity = this.controller.getBillList().get(this.controller.getAuthBill()).getRoundList().get(this.controller.getAuthRound()).getItemList().get(this.controller.getAuthItem()).getQuantity();
            if (this.controller.getAuthQuantity() != 0.0 && currentQuantity > this.controller.getAuthQuantity()) {
                this.controller.getBillList().get(this.controller.getAuthBill()).getRoundList().get(this.controller.getAuthRound()).getItemList().get(this.controller.getAuthItem()).setQuantity(currentQuantity - this.controller.getAuthQuantity());
            } else {
                this.controller.getBillList().get(this.controller.getAuthBill()).getRoundList().get(this.controller.getAuthRound()).getItemList().remove(this.controller.getAuthItem());
            }
            this.modalResult = ScreensController.MODAL_RESULT_OK;
            ((Stage)this.rootPane.getScene().getWindow()).close();
        }
        if (this.controller.getAuthBill() > -1 && this.controller.getAuthRound() > -1 && this.controller.getAuthItem() > -1 && this.controller.getAuthAdditional() == -1 && this.controller.getAuthDesciptional() > -1) {
            currentQuantity = this.controller.getBillList().get(this.controller.getAuthBill()).getRoundList().get(this.controller.getAuthRound()).getItemList().get(this.controller.getAuthItem()).getDescriptionalList().get(this.controller.getAuthDesciptional()).getQuantity();
            if (this.controller.getAuthQuantity() != 0.0 && currentQuantity > this.controller.getAuthQuantity()) {
                this.controller.getBillList().get(this.controller.getAuthBill()).getRoundList().get(this.controller.getAuthRound()).getItemList().get(this.controller.getAuthItem()).getDescriptionalList().get(this.controller.getAuthDesciptional()).setQuantity(currentQuantity - this.controller.getAuthQuantity());
            } else {
                this.controller.getBillList().get(this.controller.getAuthBill()).getRoundList().get(this.controller.getAuthRound()).getItemList().get(this.controller.getAuthItem()).getDescriptionalList().remove(this.controller.getAuthDesciptional());
            }
            this.modalResult = ScreensController.MODAL_RESULT_OK;
            ((Stage)this.rootPane.getScene().getWindow()).close();
        }
        if (this.controller.getAuthBill() > -1 && this.controller.getAuthRound() > -1 && this.controller.getAuthItem() > -1 && this.controller.getAuthAdditional() > -1 && this.controller.getAuthDesciptional() == -1) {
            currentQuantity = this.controller.getBillList().get(this.controller.getAuthBill()).getRoundList().get(this.controller.getAuthRound()).getItemList().get(this.controller.getAuthItem()).getAdditionalList().get(this.controller.getAuthAdditional()).getQuantity();
            if (this.controller.getAuthQuantity() != 0.0 && currentQuantity > this.controller.getAuthQuantity()) {
                this.controller.getBillList().get(this.controller.getAuthBill()).getRoundList().get(this.controller.getAuthRound()).getItemList().get(this.controller.getAuthItem()).getAdditionalList().get(this.controller.getAuthAdditional()).setQuantity(currentQuantity - this.controller.getAuthQuantity());
            } else {
                this.controller.getBillList().get(this.controller.getAuthBill()).getRoundList().get(this.controller.getAuthRound()).getItemList().get(this.controller.getAuthItem()).getAdditionalList().remove(this.controller.getAuthAdditional());
            }
            this.modalResult = ScreensController.MODAL_RESULT_OK;
            ((Stage)this.rootPane.getScene().getWindow()).close();
        }
    }

    private void saveBill() {
        try {
            Bill.writeBill(this.controller.getBillList().get(this.controller.getActiveBill()), this.controller.getPointOfSale(), false, "", this.controller.getBillList().get(this.controller.getActiveBill()).getDiscount(), this.controller);
            this.controller.getBillList().remove(this.controller.getActiveBill());
            this.controller.setActiveBill(-1);
            this.modalResult = ScreensController.MODAL_RESULT_OK;
            ((Stage)this.rootPane.getScene().getWindow()).close();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
        }
        catch (SQLException e) {
            LOGGER.severe(e.getMessage());
            Log.writeLog(this.controller.getUser(), "Error! PointOfSaleID = " + this.controller.getPointOfSale().getPointOfSaleID() + "\t" + e.getMessage(), this.controller.getSettings().getConnection());
            this.controller.alert("Gre\u0161ka pri upisivanju u bazu!", "\n\n Poruka o gre\u0161ci:\n\n" + e.getLocalizedMessage(), this.rootPane.getScene().getWindow());
        }
    }

    @Override
    public int getModalResult() {
        return this.modalResult;
    }

    @Override
    public void setModalResult(int modalResult) {
        this.modalResult = modalResult;
    }
}

