set @from=?,
    @to=?,
    @departments=?,
    @warehouse=?,
    @subGroups=?,
    @subGroupsSort=?,
    @excludedArtTypes=?,
    @onlyChanges=?,
    @white=?,
    @black=?,
    @lastPrice=?,
    @lastPriceWithBlack=?,
    @pgA=?,
    @pgG=?,
    @pgD=?,
    @pgDJ=?,
    @pgE=?,
    @pgZJ=?,
    @pgI=?,
    @pgJ=?,
    @pgK=?;

SELECT odpg AS 'kljuc',
       nazivartikla AS 'artikal',
       coalesce(barkod, "") as 'barkod',
       jm AS 'jm',
       ROUND(pocetno, 4) AS 'pocetno',
       ROUND(pocetno * nc * (1 + stopa), 2) AS 'pocetna vrednost',
       ROUND(ulaz, 4) AS 'ulaz',
       ROUND(ulaz * nc * (1 + stopa), 2) AS 'vrednost ulaza',
       ROUND(izlaz, 4) AS 'izlaz',
       ROUND(izlaz * nc * (1 + stopa), 2) AS 'vrednost izlaza',
       ROUND(pocetno + ulaz - izlaz, 4) AS 'zavrsno',
       ROUND((pocetno + ulaz - izlaz) * nc * (1 + stopa), 2) AS 'zavrsna vrednost',
       ROUND((pocetno + ulaz - izlaz) * nc, 2) AS 'zavrsna vrednost bez PDV-a',
       IF(pc LIKE '/', '/',ROUND((pocetno + ulaz - izlaz) * ((1 / mera) * pc), 2)) AS 'prodajna vrednost',
       ROUND(pocetno * nc, 2) AS 'pocetna vrednost bez PDV-a',
       ROUND(ulaz * nc, 2) AS 'vrednost ulaza bez PDV-a',
       ROUND(izlaz * nc, 2) AS 'vrednost izlaza bez PDV-a',
       IF(pc LIKE '/', '/',ROUND((pocetno + ulaz - izlaz) * ((1 / mera) * pc) / (1 + stopa), 2)) AS 'prodajna vrednost bez PDV-a',
       IF(@lastPrice, COALESCE((SELECT ts.komadBPDV from trebovanjestavka ts left join artikal a on a.id = ts.ARTIKAL_ID where a.name =SOURCE.nazivartikla  order by ts.id desc limit 1), 0), COALESCE(ROUND((select AVG(ts.komadBPDV) from trebovanjestavka ts join artikal a on a.id = ts.ARTIKAL_ID where a.name = SOURCE.nazivartikla),4), 0)) AS 'NabVrePoJedBezPdv',
       IF(@lastPrice, COALESCE((SELECT ts.komad from trebovanjestavka ts left join artikal a on a.id = ts.ARTIKAL_ID where a.name =SOURCE.nazivartikla  order by ts.id desc limit 1), 0), COALESCE(ROUND((select AVG(ts.komad) from trebovanjestavka ts join artikal a on a.id = ts.ARTIKAL_ID where a.name = SOURCE.nazivartikla),4), 0)) AS 'NabVrePoJed',
       coalesce((SELECT a.cena from artikal a where a.name = SOURCE.nazivartikla), 0.0) AS 'ProdVrePoJed',
       nc as 'nc',
       nc * (1 + stopa) as 'ncSpdv',
       stopa AS 'stopa'
FROM
  (SELECT CONCAT(o.id, '. ', o.naziv, if(@subGroupsSort, CONCAT('-', pg.naziv), '')) AS 'odpg',
          a.name AS 'nazivartikla',
          coalesce(a.barCode, "") as 'barkod',
          COALESCE(a.mera, 1) AS 'mera',
          a.jedinicaMere AS 'jm',
          ROUND(SUM(IF(ds.datum < @from, IF(@white, COALESCE((ds.beloUlaz - ds.beloIzlaz), 0), 0) + IF(@black, COALESCE((ds.crnoUlaz - ds.crnoIzlaz), 0), 0), 0)), 4) AS pocetno,
          ROUND(SUM(IF(ds.datum >= @from
                       AND ds.datum <= @to, IF(@white, COALESCE(ds.beloUlaz, 0), 0) + IF(@black, COALESCE(ds.crnoUlaz, 0), 0), 0)), 4) AS ulaz,
          ROUND(SUM(IF(ds.datum >= @from
                       AND ds.datum <= @to, IF(@white, COALESCE(ds.beloIzlaz, 0), 0) + IF(@black, COALESCE(ds.crnoIzlaz, 0), 0), 0)), 4) AS izlaz,
          
			 ROUND(
            COALESCE(
					 IF(
                    @lastPrice,
                    
						  IF(
                        NOT @warehouse,
                        (SELECT ts.komad / ((100 + ts.pdv) / 100)
                            FROM trebovanjestavka ts
                                LEFT JOIN trebovanje t ON ts.trebovanje_id = t.id
                            WHERE ts.artikal_id = a.id
                                AND IF(
                                    NOT @lastPriceWithBlack,
                                    t.crno = 0,
                                    TRUE)
                                and ts.komad > 0
                            ORDER BY ts.id DESC LIMIT 1),
                        (SELECT ps.komad
                            FROM prijemnicastavka ps
                                LEFT JOIN prijemnica p ON ps.prijemnica_id = p.id
                            WHERE ps.artikal_id = a.id
                                AND IF(
                                    NOT @lastPriceWithBlack,
                                    p.crno = 0,
                                    TRUE)
                            ORDER BY ps.id DESC LIMIT 1)),
                    IF(
                        NOT @warehouse,
                        
                        (SELECT avg(ts.komad / ((100 + ts.pdv) / 100))
                            FROM trebovanjestavka ts
                                LEFT JOIN trebovanje t ON ts.trebovanje_id = t.id
                            WHERE ts.artikal_id = a.id
                                AND IF(
                                    NOT @lastPriceWithBlack,
                                    t.crno = 0,
                                    TRUE)
										  and ts.komad > 0),
                            
                            
                        (SELECT avg(ps.komad)
                            FROM prijemnicastavka ps
                                LEFT JOIN prijemnica p ON ps.prijemnica_id = p.id
                            WHERE ps.artikal_id = a.id
                                AND IF(
                                    NOT @lastPriceWithBlack,
                                    p.crno = 0,
                                    TRUE)))),
                0),
            2) AS 'nc',
          IF(a.tip LIKE 'SIRO'
             OR a.tip LIKE 'POTR', '/', ROUND(COALESCE(a.cena, 0), 2)) AS 'pc',
          CASE a.poreskagrupa
              WHEN 0 THEN @pgA
              WHEN 1 THEN @pgG
              WHEN 2 THEN @pgD
              WHEN 3 THEN @pgDJ
              WHEN 4 THEN @pgE
              WHEN 5 THEN @pgZJ
              WHEN 6 THEN @pgI
              WHEN 7 THEN @pgJ
              WHEN 8 THEN @pgK
              ELSE 0
          END AS 'stopa',
          a.id AS 'aid'
   FROM dnevnostanje ds
   LEFT JOIN artikal a ON ds.artikalID = a.id
   LEFT JOIN odeljenje o ON ds.ODELJENJE_ID = o.id
   LEFT JOIN podgrupaartikala pg ON a.PODGRUPA_ID = pg.id
   WHERE ds.datum <= @to
     AND a.blokiran = 0
     AND FIND_IN_SET(a.tip, @excludedArtTypes) = 0
     AND FIND_IN_SET(ds.ODELJENJE_ID,  @departments) > 0
     AND FIND_IN_SET(pg.id,  @subGroups) > 0
   GROUP BY ds.artikalID,
            ds.ODELJENJE_ID
   ORDER BY o.id,
            if(@subGroupsSort, odpg, 1),
            nazivartikla) AS SOURCE
WHERE IF(@onlyChanges, ulaz <> 0
         OR izlaz <> 0, TRUE);