-- Dumping structure for procedure restoran.analiza_prodaje_po_satima

CREATE DEFINER=`root`@`localhost` PROCEDURE `analiza_prodaje_po_nedeljama`(IN `sp_datum1` VARCHAR(50),IN `sp_datum2` VARCHAR(50), IN `sp_nacin_placanja` VARCHAR(50), IN `sp_crno_placanje` VARCHAR(50))

BEGIN
SELECT DATE(r.datum) AS Datum, 

(SELECT DISTINCT SUM(sr1.cena * sr1.kolicina) 
FROM stavkaracuna sr1 
JOIN racun r ON r.id = sr1.RACUN_ID 
LEFT OUTER JOIN placanje p ON r.id = p.racun_id 
WHERE (find_in_set(p.nacin, sp_nacin_placanja)
OR find_in_set(r.crnoplacanje, sp_crno_placanje))
AND r.datum BETWEEN  sp_datum1 AND sp_datum2) AS 'Promet_Prvi', 

(SELECT COUNT(DISTINCT r.id) 
FROM stavkaracuna sr1 
JOIN racun r ON r.id = sr1.RACUN_ID 
LEFT OUTER JOIN placanje p ON r.id = p.racun_id 
WHERE (find_in_set(p.nacin, sp_nacin_placanja)
OR find_in_set(r.crnoplacanje, sp_crno_placanje))
AND r.datum BETWEEN  sp_datum1 AND sp_datum2) AS 'Broj racuna prvi'

FROM racun r
JOIN stavkaracuna sr ON sr.RACUN_ID = r.id
WHERE r.datum BETWEEN  sp_datum1 AND sp_datum2
GROUP BY DATE(r.datum)
ORDER BY r.datum;
END