/*
 * Decompiled with CFR 0.152.
 */
package swt.proba;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EnvTEst {
    public static void main(String[] args) {
        String path = System.getenv("PATH");
        System.out.println(path);
        String[] paths = path.split(";");
        Pattern patt = Pattern.compile(".*[Mm][Yy][Ss][Qq][Ll].*[\\\\\\/]bin");
        String p2 = null;
        for (String p : paths) {
            Matcher m = patt.matcher(p);
            System.out.println(p);
            boolean match = m.matches();
            System.out.println("match = " + match);
            if (!match) continue;
            p2 = p;
        }
        System.out.println("p2 = " + p2);
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        try {
            System.out.println("\"localhost:3306\".split(\":\") = " + Arrays.deepToString("localhost:3306".split(":")));
            File output = File.createTempFile("test", ".sql");
            Process p = pb.inheritIO().redirectOutput(output).command("mysqldump", "-hlocalhost", "-uroot", "-p928374", "-P3306", "restoran").start();
            int exitValue = p.waitFor();
            System.out.println("exitValue = " + exitValue);
            if (exitValue == 0) {
                output.renameTo(new File("C:\\Users\\Bojan\\Desktop\\test.sql"));
            } else {
                output.delete();
            }
            EnvTEst.backup(new MySQLBackupParams("localhost", "root", "928374", "restoran", "C:\\Users\\Bojan\\Desktop\\test2.sql"));
        }
        catch (IOException ex) {
            Logger.getLogger(EnvTEst.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(EnvTEst.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(EnvTEst.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (MySQLBackupException ex) {
            Logger.getLogger(EnvTEst.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void backup(MySQLBackupParams params) throws IllegalArgumentException, MySQLBackupException {
        if (params == null) {
            throw new IllegalArgumentException("MySQL backup params cannot be null");
        }
        LinkedList<String> cmd = new LinkedList<String>();
        cmd.add("mysqldump");
        if (params.getHost() != null && !params.getHost().isEmpty()) {
            String[] hostParts = params.getHost().split(":");
            if (hostParts.length > 1) {
                if (hostParts.length != 2) throw new IllegalArgumentException(MessageFormat.format("Host with value {0} is invalid because it contains more than one colon (:) character", params.getHost()));
                cmd.add("-h" + hostParts[0]);
                cmd.add("-P" + hostParts[1]);
            } else {
                cmd.add("-h" + hostParts[0]);
            }
        }
        if (params.getUsername() != null && !params.getUsername().isEmpty()) {
            cmd.add("-u" + params.getUsername());
            if (params.getPassword() != null && !params.getPassword().isEmpty()) {
                cmd.add("-p" + params.getPassword());
            }
        }
        if (params.getSchemaName() != null && !params.getSchemaName().isEmpty()) {
            cmd.add(params.getSchemaName());
        } else {
            cmd.add("restoran");
        }
        File output = params.getFilePath() != null && !params.getFilePath().isEmpty() ? new File(params.getFilePath()) : new File("C:\\Barmaster\\Backup\\restoran" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()) + ".sql");
        if (!(output.getParentFile() == null || output.getParentFile().exists() && output.getParentFile().isDirectory() || output.getParentFile().mkdirs())) {
            throw new MySQLBackupException(MessageFormat.format("Output file parent dir with path {0} doesn't exist and could not be created", output.getParentFile().getAbsolutePath()));
        }
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        try {
            File tempOutput = File.createTempFile("MSB", ".sql.tmp");
            Process backup = pb.redirectOutput(tempOutput).command(cmd).start();
            int exitValue = backup.waitFor();
            if (exitValue != 0) {
                tempOutput.delete();
                InputStream errorStream = backup.getErrorStream();
                BufferedReader r = new BufferedReader(new InputStreamReader(errorStream));
                String errorMessage = "";
                String temp = r.readLine();
                while (temp != null) {
                    errorMessage = errorMessage + temp;
                    temp = r.readLine();
                    if (temp == null) continue;
                    errorMessage = errorMessage + System.lineSeparator();
                }
                throw new MySQLBackupException(MessageFormat.format("MySQLDump process failed with exitValue = {0} and error message:\n{1}", exitValue, errorMessage));
            }
            tempOutput.renameTo(output);
            return;
        }
        catch (InterruptedException ex) {
            Logger.getLogger(EnvTEst.class.getName()).log(Level.SEVERE, null, ex);
            return;
        }
        catch (IOException ex) {
            throw new MySQLBackupException("MySQLDump process failed with IOException", ex);
        }
    }

    public static class MySQLBackupParams {
        private String host;
        private String username;
        private String password;
        private String schemaName;
        private String filePath;

        public MySQLBackupParams() {
        }

        public MySQLBackupParams(String host, String username, String password, String schemaName, String filePath) {
            this.host = host;
            this.username = username;
            this.password = password;
            this.schemaName = schemaName;
            this.filePath = filePath;
        }

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public String getSchemaName() {
            return this.schemaName;
        }

        public void setSchemaName(String schemaName) {
            this.schemaName = schemaName;
        }

        public String getFilePath() {
            return this.filePath;
        }

        public void setFilePath(String filePath) {
            this.filePath = filePath;
        }
    }

    public static class MySQLBackupException
    extends Exception {
        public MySQLBackupException(String message) {
            super(message);
        }

        public MySQLBackupException(String message, Throwable cause) {
            super(message, cause);
        }

        public MySQLBackupException(Throwable cause) {
            super(cause);
        }
    }
}

