/*
 * Decompiled with CFR 0.152.
 */
package swt.proba;

import com.dev63.restoran.Konstante;
import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class EncodingNames {
    public static final String RESULT = "C:/barmaster/font_encodings.pdf";
    public static final String[] FONT = new String[]{Konstante.getFontDir() + "arial.ttf"};

    public void createPdf(String filename) throws IOException, DocumentException {
        Document document = new Document(new Rectangle(350.0f, 842.0f));
        PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(filename));
        document.open();
        this.showEncodings(document, FONT[0]);
        document.close();
    }

    public void showEncodings(Document document, String font) throws DocumentException, IOException {
        BaseFont bf = BaseFont.createFont((String)font, (String)"Cp1252", (boolean)true);
        document.add((Element)new Paragraph("PostScript name: " + bf.getPostscriptFontName()));
        document.add((Element)new Paragraph("Available code pages:"));
        String[] encoding = bf.getCodePagesSupported();
        for (int i = 0; i < encoding.length; ++i) {
            document.add((Element)new Paragraph("encoding[" + i + "] = " + encoding[i]));
        }
        document.add((Element)Chunk.NEWLINE);
    }

    public void showEncodings(Document document, BaseFont font) throws DocumentException, IOException {
        BaseFont bf = font;
        document.add((Element)new Paragraph("PostScript name: " + bf.getPostscriptFontName()));
        document.add((Element)new Paragraph("Available code pages:"));
        String[] encoding = bf.getCodePagesSupported();
        for (int i = 0; i < encoding.length; ++i) {
            document.add((Element)new Paragraph("encoding[" + i + "] = " + encoding[i]));
        }
        document.add((Element)Chunk.NEWLINE);
    }

    public static void main(String[] args) throws IOException, DocumentException {
        new EncodingNames().createPdf(RESULT);
    }
}

