/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.utils;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LogUtils {
    private static final Logger logger = Logger.getLogger(LogUtils.class.getName());

    private static void logEnteringMethod(Logger log, Object ... params) {
        StackTraceElement el = Thread.currentThread().getStackTrace()[3];
        if (log == null) {
            log = Logger.getLogger(el.getClassName());
        }
        log.log(Level.INFO, "Entering {0}.{1} with {2}", new Object[]{el.getClassName(), el.getMethodName(), params.length == 0 ? "no arguments" : "arguments ".concat(Arrays.toString(params))});
    }

    public static void logEntering(Object ... params) {
        LogUtils.logEnteringMethod(null, params);
    }

    public static void logEntering(Logger log, Object ... params) {
        LogUtils.logEnteringMethod(log, params);
    }

    private static void logExitingMethod(Logger log, Object ... returnValue) {
        StackTraceElement el = Thread.currentThread().getStackTrace()[3];
        if (log == null) {
            log = Logger.getLogger(el.getClassName());
        }
        log.log(Level.INFO, "Exiting {0}.{1}. {2}", new Object[]{el.getClassName(), el.getMethodName(), returnValue.length == 0 ? "No return value" : "Returning ".concat(returnValue[0].toString())});
    }

    public static void logExiting() {
        LogUtils.logExitingMethod(null, new Object[0]);
    }

    public static void logExiting(Object returnValue) {
        LogUtils.logExitingMethod(null, returnValue);
    }

    public static void logExiting(Logger log) {
        LogUtils.logExitingMethod(log, new Object[0]);
    }

    public static void logExiting(Logger log, Object returnValue) {
        LogUtils.logExitingMethod(log, returnValue);
    }

    private static void logInternal(Level level, Throwable thrown, String message, Object ... arguments) {
        StackTraceElement stElement = Thread.currentThread().getStackTrace()[3];
        logger.logp(level, stElement.getClassName(), stElement.getMethodName(), MessageFormat.format(message, arguments), thrown);
    }

    private static void logInternal(Level level, String message, Object ... arguments) {
        StackTraceElement stElement = Thread.currentThread().getStackTrace()[3];
        logger.logp(level, stElement.getClassName(), stElement.getMethodName(), MessageFormat.format(message, arguments));
    }

    public static void severe(Throwable thrown, String message, Object ... arguments) {
        LogUtils.logInternal(Level.SEVERE, thrown, message, arguments);
    }

    public static void severe(String message, Object ... arguments) {
        LogUtils.logInternal(Level.SEVERE, message, arguments);
    }

    public static void warn(Throwable thrown, String message, Object ... arguments) {
        LogUtils.logInternal(Level.SEVERE, thrown, message, arguments);
    }

    public static void warn(String message, Object ... arguments) {
        LogUtils.logInternal(Level.SEVERE, message, arguments);
    }

    public static void info(Throwable thrown, String message, Object ... arguments) {
        LogUtils.logInternal(Level.SEVERE, thrown, message, arguments);
    }

    public static void info(String message, Object ... arguments) {
        LogUtils.logInternal(Level.SEVERE, message, arguments);
    }
}

