/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.taxes;

import com.dev63.fiscal.fp550.PoreskaGrupa;
import com.dev63.restoran.sistem.PoreskeStope;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;

public class TaxFunctions {
    private static final RoundingMode RM = RoundingMode.HALF_UP;
    private static final int SCALE = 8;
    private static final BigDecimal HUNDRED = BigDecimal.valueOf(100.0);

    public static BigDecimal getTGRatePercent(PoreskaGrupa pg) {
        return PoreskeStope.getPoreskaStopa(pg).getStopaBD();
    }

    public static BigDecimal getTGRatePercent(PoreskaGrupa pg, Date forDate) {
        return PoreskeStope.getPoreskaStopa(pg, forDate).getStopaBD();
    }

    public static BigDecimal toRate(BigDecimal percent) {
        return percent.divide(HUNDRED);
    }

    public static BigDecimal toRate(PoreskaGrupa pg) {
        return TaxFunctions.toRate(TaxFunctions.getTGRatePercent(pg));
    }

    public static BigDecimal toRate(PoreskaGrupa pg, Date forDate) {
        return TaxFunctions.toRate(TaxFunctions.getTGRatePercent(pg, forDate));
    }

    public static BigDecimal getNettoToBruttoQuantifier(BigDecimal tgRatePercent) {
        return BigDecimal.ONE.add(TaxFunctions.toRate(tgRatePercent));
    }

    public static BigDecimal getNettoToBruttoQuantifier(PoreskaGrupa pg) {
        return TaxFunctions.getNettoToBruttoQuantifier(TaxFunctions.getTGRatePercent(pg));
    }

    public static BigDecimal getNettoToBruttoQuantifier(PoreskaGrupa pg, Date forDate) {
        return TaxFunctions.getNettoToBruttoQuantifier(TaxFunctions.getTGRatePercent(pg, forDate));
    }

    public static BigDecimal getBruttoFromNetto(BigDecimal tgRatePercent, BigDecimal netto) {
        return netto.multiply(TaxFunctions.getNettoToBruttoQuantifier(tgRatePercent));
    }

    public static BigDecimal getBruttoFromNetto(PoreskaGrupa pg, BigDecimal netto) {
        return TaxFunctions.getBruttoFromNetto(TaxFunctions.getTGRatePercent(pg), netto);
    }

    public static BigDecimal getBruttoFromNetto(PoreskaGrupa pg, Date forDate, BigDecimal netto) {
        return TaxFunctions.getBruttoFromNetto(TaxFunctions.getTGRatePercent(pg, forDate), netto);
    }

    public static BigDecimal getTaxFromNetto(BigDecimal tgRatePercent, BigDecimal netto) {
        return netto.multiply(TaxFunctions.toRate(tgRatePercent));
    }

    public static BigDecimal getTaxFromNetto(PoreskaGrupa pg, BigDecimal netto) {
        return TaxFunctions.getTaxFromNetto(TaxFunctions.getTGRatePercent(pg), netto);
    }

    public static BigDecimal getTaxFromNetto(PoreskaGrupa pg, Date forDate, BigDecimal netto) {
        return TaxFunctions.getTaxFromNetto(TaxFunctions.getTGRatePercent(pg, forDate), netto);
    }

    public static BigDecimal getNettoFromBrutto(BigDecimal tgRatePercent, BigDecimal brutto) {
        return brutto.divide(TaxFunctions.getNettoToBruttoQuantifier(tgRatePercent), 8, RM);
    }

    public static BigDecimal getNettoFromBrutto(PoreskaGrupa pg, BigDecimal brutto) {
        return TaxFunctions.getNettoFromBrutto(TaxFunctions.getTGRatePercent(pg), brutto);
    }

    public static BigDecimal getNettoFromBrutto(PoreskaGrupa pg, Date forDate, BigDecimal brutto) {
        return TaxFunctions.getNettoFromBrutto(TaxFunctions.getTGRatePercent(pg, forDate), brutto);
    }

    public static BigDecimal getTaxFromBrutto(BigDecimal tgRatePercent, BigDecimal brutto) {
        return brutto.subtract(TaxFunctions.getNettoFromBrutto(tgRatePercent, brutto));
    }

    public static BigDecimal getTaxFromBrutto(PoreskaGrupa pg, BigDecimal brutto) {
        return TaxFunctions.getTaxFromBrutto(TaxFunctions.getTGRatePercent(pg), brutto);
    }

    public static BigDecimal getTaxFromBrutto(PoreskaGrupa pg, Date forDate, BigDecimal brutto) {
        return TaxFunctions.getTaxFromBrutto(TaxFunctions.getTGRatePercent(pg, forDate), brutto);
    }
}

