/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.tax;

import com.dev63.restoran.tax.TaxControlDefault;
import java.math.BigDecimal;
import java.math.RoundingMode;

public interface TaxControl {
    public static final BigDecimal HUNDRED = BigDecimal.valueOf(100.0);

    public BigDecimal nettoFromBrutto(BigDecimal var1, BigDecimal var2);

    public BigDecimal taxFromBrutto(BigDecimal var1, BigDecimal var2);

    public BigDecimal bruttoFromNetto(BigDecimal var1, BigDecimal var2);

    public BigDecimal taxFromNetto(BigDecimal var1, BigDecimal var2);

    default public BigDecimal nettoFromBruttoUsingPercentage(BigDecimal brutto, BigDecimal percentage) {
        return this.nettoFromBrutto(brutto, this.rateFromPercentage(percentage));
    }

    default public BigDecimal taxFromBruttoUsingPercentage(BigDecimal brutto, BigDecimal percentage) {
        return this.taxFromBrutto(brutto, this.rateFromPercentage(percentage));
    }

    default public BigDecimal bruttoFromNettoUsingPercentage(BigDecimal netto, BigDecimal percentage) {
        return this.bruttoFromNetto(netto, this.rateFromPercentage(percentage));
    }

    default public BigDecimal taxFromNettoUsingPercentage(BigDecimal netto, BigDecimal percentage) {
        return this.taxFromNetto(netto, this.rateFromPercentage(percentage));
    }

    default public BigDecimal rateFromPercentage(BigDecimal percentage) {
        return percentage.divide(HUNDRED, 2, RoundingMode.UNNECESSARY);
    }

    default public BigDecimal percentageFromRate(BigDecimal rate) {
        return rate.multiply(HUNDRED);
    }

    public static TaxControl instance() {
        return LazyInstanceHolder.VALUE;
    }

    public static class LazyInstanceHolder {
        private static final TaxControl VALUE = new TaxControlDefault();
    }
}

