/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.swt.resources;

import com.dev63.restoran.swt.resources.BrandingData;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class CountryCache {
    private static BrandingData brand = BrandingData.BARMASTER;
    private static HashMap<String, Image> imageMap;
    private static String ICON_ROOT_PATH;

    public static Image getImage(String fileName) {
        fileName = ICON_ROOT_PATH + fileName;
        Image image = imageMap.get(fileName);
        if (image == null || image.getDevice().isDisposed() || image.isDisposed()) {
            image = CountryCache.createImage(fileName);
            imageMap.put(fileName, image);
        }
        return image;
    }

    private static Image createImage(String fileName) {
        ClassLoader classLoader = CountryCache.class.getClassLoader();
        InputStream is = classLoader.getResourceAsStream(fileName);
        if (is == null && (is = classLoader.getResourceAsStream(fileName.substring(1))) == null && (is = classLoader.getResourceAsStream(fileName)) == null && (is = classLoader.getResourceAsStream(fileName.substring(1))) == null) {
            return null;
        }
        Image img = new Image((Device)Display.getCurrent(), is);
        try {
            is.close();
        }
        catch (IOException e) {
            e.printStackTrace(System.out);
        }
        return img;
    }

    public static void dispose() {
        for (Image i : imageMap.values()) {
            if (i == null || i.isDisposed()) continue;
            i.dispose();
        }
    }

    public static BrandingData getBrand() {
        return brand;
    }

    public static void setBrand(BrandingData aBrand) {
        brand = aBrand;
        ICON_ROOT_PATH = brand.getBrandingPath();
    }

    static {
        ICON_ROOT_PATH = brand.getBrandingPath();
        imageMap = new HashMap();
    }
}

