/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.swt.components;

import com.dev63.restoran.Konstante;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class TimeInput2
extends Composite
implements Listener {
    private final SimpleDateFormat format;
    private final Text field;
    private Calendar result;

    public TimeInput2(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        this.format = new SimpleDateFormat("HH:mm:ss");
        this.field = new Text((Composite)this, 2048);
        final Listener l = new Listener(){

            public void handleEvent(Event event) {
                InputDialog id = new InputDialog(TimeInput2.this.getShell(), 0);
                id.setInput(TimeInput2.this.result);
                TimeInput2.this.result = id.open();
                TimeInput2.this.updateFieldText();
            }
        };
        this.field.setEditable(false);
        this.field.addListener(3, l);
        this.field.addListener(1, new Listener(){

            public void handleEvent(Event event) {
                switch (event.keyCode) {
                    case 13: 
                    case 0x1000050: {
                        l.handleEvent(event);
                    }
                }
            }
        });
        this.result = Calendar.getInstance();
        this.updateFieldText();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.field.setEnabled(enabled);
    }

    private void updateFieldText() {
        if (this.result != null) {
            this.field.setText(this.format.format(this.result.getTime()));
        }
    }

    public void setDefault(Calendar cal) {
        this.result = cal;
        this.updateFieldText();
    }

    public void setDefault(Date date) {
        if (this.result == null) {
            this.result = Calendar.getInstance();
        }
        if (date != null) {
            this.result.setTime(date);
        }
        this.updateFieldText();
    }

    public Calendar getResult() {
        return this.result;
    }

    public int getHours() {
        return this.result.get(11);
    }

    public int getMinutes() {
        return this.result.get(12);
    }

    public int getSeconds() {
        return this.result.get(13);
    }

    public void handleEvent(Event event) {
        InputDialog id = new InputDialog(this.getShell(), 0);
        this.result = id.open();
    }

    private static class InputDialog
    extends Dialog {
        private Calendar input;

        public InputDialog(Shell parent, int style) {
            super(parent, style);
        }

        public Calendar open() {
            final Calendar ret = this.input != null ? this.input : Calendar.getInstance();
            Shell dialog = new Shell(this.getParent(), 67680);
            dialog.setLayout((Layout)new GridLayout(5, false));
            dialog.setText(String.format(Konstante.getBundle().getString("TEXT_IZABERITE_VREME"), new Object[0]));
            Font font = new Font((Device)dialog.getDisplay(), "Arial", 28, 0);
            GridData dataLeftRight = new GridData(4, 4, false, false);
            dataLeftRight.widthHint = 50;
            dataLeftRight.heightHint = 50;
            Button hPlus = new Button((Composite)dialog, 132);
            hPlus.setLayoutData((Object)dataLeftRight);
            Label l1 = new Label((Composite)dialog, 0);
            l1.setLayoutData((Object)new GridData(0x1000000, 4, false, false));
            Button mPlus = new Button((Composite)dialog, 132);
            mPlus.setLayoutData((Object)dataLeftRight);
            Label l2 = new Label((Composite)dialog, 0);
            l2.setLayoutData((Object)new GridData(0x1000000, 4, false, false));
            Button sPlus = new Button((Composite)dialog, 132);
            sPlus.setLayoutData((Object)dataLeftRight);
            DecimalFormat df = new DecimalFormat("00");
            final Combo hCombo = new Combo((Composite)dialog, 12);
            for (long i = 0L; i < 24L; ++i) {
                hCombo.add(df.format(i));
            }
            hCombo.select(ret.get(11));
            hCombo.setFont(font);
            hCombo.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    this.updateResult();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.updateResult();
                }

                private void updateResult() {
                    ret.set(11, hCombo.getSelectionIndex());
                }
            });
            Label l3 = new Label((Composite)dialog, 0);
            l3.setText(":");
            l3.setFont(font);
            l3.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
            final Combo mCombo = new Combo((Composite)dialog, 12);
            for (long i = 0L; i < 60L; ++i) {
                mCombo.add(df.format(i));
            }
            mCombo.select(ret.get(12));
            mCombo.setFont(font);
            mCombo.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    this.updateResult();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.updateResult();
                }

                private void updateResult() {
                    ret.set(12, mCombo.getSelectionIndex());
                }
            });
            Label l4 = new Label((Composite)dialog, 0);
            l4.setText(":");
            l4.setFont(font);
            l4.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
            final Combo sCombo = new Combo((Composite)dialog, 12);
            for (long i = 0L; i < 60L; ++i) {
                sCombo.add(df.format(i));
            }
            sCombo.select(ret.get(13));
            sCombo.setFont(font);
            sCombo.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    this.updateResult();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.updateResult();
                }

                private void updateResult() {
                    ret.set(13, sCombo.getSelectionIndex());
                }
            });
            Button hMinus = new Button((Composite)dialog, 1028);
            hMinus.setLayoutData((Object)dataLeftRight);
            Label l5 = new Label((Composite)dialog, 0);
            l5.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
            Button mMinus = new Button((Composite)dialog, 1028);
            mMinus.setLayoutData((Object)dataLeftRight);
            Label l6 = new Label((Composite)dialog, 0);
            l6.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
            Button sMinus = new Button((Composite)dialog, 1028);
            sMinus.setLayoutData((Object)dataLeftRight);
            hPlus.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    hCombo.select((hCombo.getSelectionIndex() + 1) % hCombo.getItemCount());
                    hCombo.notifyListeners(13, new Event());
                }
            });
            mPlus.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    mCombo.select((mCombo.getSelectionIndex() + 1) % mCombo.getItemCount());
                    mCombo.notifyListeners(13, new Event());
                }
            });
            sPlus.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    sCombo.select((sCombo.getSelectionIndex() + 1) % sCombo.getItemCount());
                    sCombo.notifyListeners(13, new Event());
                }
            });
            hMinus.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    hCombo.select((hCombo.getItemCount() + hCombo.getSelectionIndex() - 1) % hCombo.getItemCount());
                    hCombo.notifyListeners(13, new Event());
                }
            });
            mMinus.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    mCombo.select((mCombo.getItemCount() + mCombo.getSelectionIndex() - 1) % mCombo.getItemCount());
                    mCombo.notifyListeners(13, new Event());
                }
            });
            sMinus.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    sCombo.select((sCombo.getItemCount() + sCombo.getSelectionIndex() - 1) % sCombo.getItemCount());
                    sCombo.notifyListeners(13, new Event());
                }
            });
            dialog.pack();
            dialog.open();
            while (!dialog.isDisposed()) {
                if (dialog.getDisplay().readAndDispatch()) continue;
                dialog.getDisplay().sleep();
            }
            font.dispose();
            return ret;
        }

        public void setInput(Date date) {
            this.input = Calendar.getInstance();
            this.input.setTime(date);
        }

        public void setInput(Calendar cal) {
            this.input = cal;
        }
    }
}

