/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.swt.components;

import com.dev63.restoran.Dugmici;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.parts.DateInput2;
import com.dev63.restoran.parts.InputException;
import com.dev63.restoran.parts.IntInput2;
import com.dev63.restoran.sistem.CalendarAdapter;
import java.util.Date;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class SWTMessage {
    private static final ResourceBundle barmasterText = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale());
    public static final int MESSAGE_PLAIN = 0;
    public static final int MESSAGE_INFO = 1;
    public static final int MESSAGE_WARNING = 2;
    public static final int MESSAGE_ERROR = 4;
    public static final int MESSAGE_QUESTION = 8;
    public static final int RESPONSE_OK = 32;
    public static final int RESPONSE_CANCEL = 256;
    public static final int RESPONSE_YES = 64;
    public static final int RESPONSE_NO = 128;
    public static final int RESPONSE_ABORT = 512;
    public static final int RESPONSE_RETRY = 1024;
    public static final int RESPONSE_IGNORE = 2048;

    public static int showMessageDialog(Shell parent, String message, String title, int messageType) {
        boolean newDisp = false;
        boolean newParent = false;
        Display d = null;
        if (parent == null || parent.isDisposed()) {
            Shell shell = parent = Display.getCurrent() == null ? null : Display.getCurrent().getActiveShell();
        }
        if (parent == null || parent.isDisposed()) {
            d = Display.getCurrent();
            if (d == null) {
                d = new Display();
                newDisp = true;
            }
            parent = new Shell(d, 0);
            newParent = true;
        }
        int style = 32;
        switch (messageType) {
            case 1: {
                style |= 2;
                break;
            }
            case 2: {
                style |= 8;
                break;
            }
            case 4: {
                style |= 1;
            }
        }
        MessageBox mb = new MessageBox(parent, style);
        mb.setText(title);
        mb.setMessage(message);
        int retval = mb.open();
        if (newParent && parent != null && !parent.isDisposed()) {
            parent.dispose();
        }
        if (newDisp && d != null && !d.isDisposed()) {
            d.dispose();
        }
        return retval;
    }

    public static int showMessageDialog(Shell parent, String message) {
        String title = String.format(barmasterText.getString("TEXT_BARMASTER"), new Object[0]);
        return SWTMessage.showMessageDialog(parent, message, title, 0);
    }

    public static Date showDateInputDialog(Shell parent, String label, String title) {
        final Date[] result = new Date[1];
        final Shell s = new Shell(parent, 2144);
        s.setText(title);
        s.setLayout((Layout)new GridLayout(2, false));
        Label l = new Label((Composite)s, 131072);
        l.setText(label);
        l.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        final DateInput2 di2 = new DateInput2((Composite)s, label, new Date(), false, (RestoranServer)null);
        di2.getControl().addMouseListener((MouseListener)new CalendarAdapter(di2, s));
        GridData gd = new GridData(4, 4, true, false);
        gd.widthHint = 100;
        gd.heightHint = 30;
        di2.getControl().setLayoutData((Object)gd);
        GridData gdb = new GridData(4, 4, true, false);
        gdb.horizontalSpan = 2;
        gdb.widthHint = 120;
        gdb.heightHint = 50;
        Button bOk = Dugmici.getOkButton(s);
        bOk.setLayoutData((Object)gdb);
        bOk.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    result[0] = di2.getResult();
                }
                catch (InputException ex) {
                    Logger.getLogger(SWTMessage.class.getName()).log(Level.SEVERE, null, ex);
                    result[0] = null;
                }
                s.close();
            }
        });
        s.pack();
        Konstante.centerShellOnDisplay(s);
        s.open();
        while (!s.isDisposed()) {
            if (s.getDisplay().readAndDispatch()) continue;
            s.getDisplay().sleep();
        }
        return result[0];
    }

    public static Date[] showDateInputDialogPeriodicni(Shell parent, String labelOd, String labelDo, String title) {
        final Date[] result = new Date[2];
        final Shell s = new Shell(parent, 2144);
        s.setText(title);
        s.setLayout((Layout)new GridLayout(2, false));
        Label l = new Label((Composite)s, 131072);
        l.setText(labelOd);
        l.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        final DateInput2 di2Od = new DateInput2((Composite)s, labelOd, new Date(), false, (RestoranServer)null);
        di2Od.getControl().addMouseListener((MouseListener)new CalendarAdapter(di2Od, s));
        GridData gd = new GridData(4, 4, true, false);
        gd.widthHint = 100;
        gd.heightHint = 30;
        di2Od.getControl().setLayoutData((Object)gd);
        l = new Label((Composite)s, 131072);
        l.setText(labelDo);
        l.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        final DateInput2 di2Do = new DateInput2((Composite)s, labelDo, new Date(), false, (RestoranServer)null);
        di2Do.getControl().addMouseListener((MouseListener)new CalendarAdapter(di2Do, s));
        gd = new GridData(4, 4, true, false);
        gd.widthHint = 100;
        gd.heightHint = 30;
        di2Do.getControl().setLayoutData((Object)gd);
        GridData gdb = new GridData(4, 4, true, false);
        gdb.horizontalSpan = 2;
        gdb.widthHint = 120;
        gdb.heightHint = 50;
        Button bOk = Dugmici.getOkButton(s);
        bOk.setLayoutData((Object)gdb);
        bOk.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    result[0] = di2Od.getResult();
                    result[1] = di2Do.getResult();
                }
                catch (InputException ex) {
                    Logger.getLogger(SWTMessage.class.getName()).log(Level.SEVERE, null, ex);
                    result[0] = null;
                }
                s.close();
            }
        });
        s.pack();
        Konstante.centerShellOnDisplay(s);
        s.open();
        while (!s.isDisposed()) {
            if (s.getDisplay().readAndDispatch()) continue;
            s.getDisplay().sleep();
        }
        return result;
    }

    public static Integer showIntInputDialog(Shell parent, String label, String title) {
        final Integer[] result = new Integer[1];
        final Shell s = new Shell(parent, 2144);
        s.setText(title);
        s.setLayout((Layout)new GridLayout(2, false));
        Label l = new Label((Composite)s, 131072);
        l.setText(label);
        l.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        final IntInput2 di2 = new IntInput2((Composite)s, label, null, false);
        GridData gd = new GridData(4, 4, true, false);
        gd.widthHint = 100;
        gd.heightHint = 30;
        di2.getControl().setLayoutData((Object)gd);
        GridData gdb = new GridData(4, 4, true, false);
        gdb.horizontalSpan = 2;
        gdb.widthHint = 120;
        gdb.heightHint = 50;
        Button bOk = Dugmici.getOkButton(s);
        bOk.setLayoutData((Object)gdb);
        bOk.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    result[0] = di2.getResult();
                }
                catch (InputException ex) {
                    Logger.getLogger(SWTMessage.class.getName()).log(Level.SEVERE, null, ex);
                    result[0] = null;
                }
                s.close();
            }
        });
        s.pack();
        Konstante.centerShellOnDisplay(s);
        s.open();
        while (!s.isDisposed()) {
            if (s.getDisplay().readAndDispatch()) continue;
            s.getDisplay().sleep();
        }
        return result[0];
    }

    public static int showLocalizedMessageDialog(Shell parent, String message, String title, int messageType) {
        boolean newDisp = false;
        boolean newParent = false;
        Display d = null;
        if (parent == null || parent.isDisposed()) {
            Shell shell = parent = Display.getCurrent() == null ? null : Display.getCurrent().getActiveShell();
        }
        if (parent == null || parent.isDisposed()) {
            d = Display.getCurrent();
            if (d == null) {
                d = new Display();
                newDisp = true;
            }
            parent = new Shell(d, 0);
            newParent = true;
        }
        int type = 0;
        switch (messageType) {
            case 1: {
                type = 2;
                break;
            }
            case 2: {
                type = 4;
                break;
            }
            case 4: {
                type = 1;
            }
        }
        MessageDialog md = new MessageDialog(parent, title, null, message, type, new String[]{String.format(Konstante.getBundle().getString("TEXT_DA"), new Object[0]), String.format(Konstante.getBundle().getString("TEXT_NE"), new Object[0])}, 0);
        int retval = md.open();
        switch (retval) {
            case -1: {
                retval = 256;
                break;
            }
            case 0: {
                retval = 32;
                break;
            }
            default: {
                retval = 256;
            }
        }
        if (newParent && !parent.isDisposed()) {
            parent.dispose();
        }
        if (newDisp && d != null && !d.isDisposed()) {
            d.dispose();
        }
        return retval;
    }

    public static int showLocalizedYesNoCancelDialog(Shell parent, String message, String title) {
        boolean newDisp = false;
        boolean newParent = false;
        Display d = null;
        if (parent == null || parent.isDisposed()) {
            Shell shell = parent = Display.getCurrent() == null ? null : Display.getCurrent().getActiveShell();
        }
        if (parent == null || parent.isDisposed()) {
            d = Display.getCurrent();
            if (d == null) {
                d = new Display();
                newDisp = true;
            }
            parent = new Shell(d, 0);
            newParent = true;
        }
        int type = 0;
        type = 3;
        MessageDialog md = new MessageDialog(parent, title, null, message, type, new String[]{String.format(Konstante.getBundle().getString("TEXT_DA"), new Object[0]), String.format(Konstante.getBundle().getString("TEXT_NE"), new Object[0]), String.format(Konstante.getBundle().getString("TEXT_OTKAZI"), new Object[0])}, 0);
        int retval = md.open();
        switch (retval) {
            case -1: {
                retval = 256;
                break;
            }
            case 0: {
                retval = 64;
                break;
            }
            case 1: {
                retval = 128;
                break;
            }
            case 2: {
                retval = 256;
                break;
            }
            default: {
                retval = 256;
            }
        }
        if (newParent && !parent.isDisposed()) {
            parent.dispose();
        }
        if (newDisp && d != null && !d.isDisposed()) {
            d.dispose();
        }
        return retval;
    }

    public static int showLocalizedYesNoDialog(Shell parent, String message, String title) {
        boolean newDisp = false;
        boolean newParent = false;
        Display d = null;
        if (parent == null || parent.isDisposed()) {
            Shell shell = parent = Display.getCurrent() == null ? null : Display.getCurrent().getActiveShell();
        }
        if (parent == null || parent.isDisposed()) {
            d = Display.getCurrent();
            if (d == null) {
                d = new Display();
                newDisp = true;
            }
            parent = new Shell(d, 0);
            newParent = true;
        }
        int type = 0;
        type = 3;
        MessageDialog md = new MessageDialog(parent, title, null, message, type, new String[]{String.format(Konstante.getBundle().getString("TEXT_DA"), new Object[0]), String.format(Konstante.getBundle().getString("TEXT_NE"), new Object[0])}, 0);
        int retval = md.open();
        switch (retval) {
            case -1: {
                retval = 256;
                break;
            }
            case 0: {
                retval = 64;
                break;
            }
            default: {
                retval = 128;
            }
        }
        if (newParent && !parent.isDisposed()) {
            parent.dispose();
        }
        if (newDisp && d != null && !d.isDisposed()) {
            d.dispose();
        }
        return retval;
    }

    public static int showLocalizedMessageDialog(Shell parent, String message) {
        String title = String.format(barmasterText.getString("TEXT_BARMASTER"), new Object[0]);
        return SWTMessage.showLocalizedMessageDialog(parent, message, title, 0);
    }

    public static int showLocalizedInfoDialog(Shell parent, String message) {
        String title = String.format(Konstante.getBundle().getString("TEXT_INFO"), new Object[0]);
        return SWTMessage.showLocalizedMessageDialog(parent, message, title, 1);
    }

    public static int showLocalizedWarningDialog(Shell parent, String message) {
        String title = String.format(Konstante.getBundle().getString("TEXT_UPOZORENJE"), new Object[0]);
        return SWTMessage.showLocalizedMessageDialog(parent, message, title, 2);
    }

    public static int showLocalizedErrorDialog(Shell parent, String message) {
        String title = String.format(barmasterText.getString("TEXT_GRESKA"), new Object[0]);
        return SWTMessage.showLocalizedMessageDialog(parent, message, title, 4);
    }

    public static int showLocalizedYesNoDialog(Shell parent, String message) {
        String title = String.format(barmasterText.getString("TEXT_BARMASTER"), new Object[0]);
        return SWTMessage.showLocalizedYesNoDialog(parent, message, title);
    }

    public static int showLocalizedYesNoCancelDialog(Shell parent, String message) {
        String title = String.format(barmasterText.getString("TEXT_BARMASTER"), new Object[0]);
        return SWTMessage.showLocalizedYesNoCancelDialog(parent, message, title);
    }

    public static void main(String[] args) {
        System.out.println(SWTMessage.showLocalizedMessageDialog(null, "Proba", "Proba poruka", 1));
        System.out.println(SWTMessage.showLocalizedYesNoDialog(null, "Proba", "Proba poruka"));
        System.out.println(SWTMessage.showLocalizedYesNoDialog(null, "Proba", "Proba poruka"));
        System.out.println(SWTMessage.showLocalizedYesNoDialog(null, "Proba", "Proba poruka"));
        System.out.println(SWTMessage.showLocalizedYesNoCancelDialog(null, "Proba", "Proba poruka"));
        System.out.println(SWTMessage.showLocalizedYesNoCancelDialog(null, "Proba", "Proba poruka"));
        System.out.println(SWTMessage.showLocalizedYesNoCancelDialog(null, "Proba", "Proba poruka"));
        System.out.println(SWTMessage.showLocalizedYesNoCancelDialog(null, "Proba", "Proba poruka"));
        System.out.println(SWTMessage.showLocalizedMessageDialog(null, "Proba poruka"));
    }
}

