/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.swt.components;

import com.dev63.restoran.BMTerminalSettings;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.swt.resources.ImageCache;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class ImageButton
extends Canvas {
    private int mouse = 0;
    private Integer padding = null;
    private boolean hit = false;
    private boolean selection = false;
    private String text = "";
    private String textKey = "";
    private Image backgroundImage = null;
    private Image backgroundPattern = null;
    private Image image = null;
    private TextLayout tl = null;
    Map<SelectionListener, Listener> selectListenerMap = new HashMap<SelectionListener, Listener>();

    public ImageButton(final Composite parent, final int style) {
        super(parent, style);
        this.setBackgroundMode(2);
        if ((style & 2) > 0) {
            this.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    ImageButton.this.selection = !ImageButton.this.selection;
                }
            });
        }
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                int arc;
                ImageButton ib = (ImageButton)e.widget;
                int n = arc = ib.getBackgroundImage() == null ? BMTerminalSettings.getFOTheme().getButtonArc() : 3;
                if (ib.getBackgroundImage() != null) {
                    e.gc.drawImage(ib.getBackgroundImage(), 0, 0, ib.getBackgroundImage().getBounds().width, ib.getBackgroundImage().getBounds().height, 0, 0, ib.getBounds().width, ib.getBounds().height);
                } else {
                    ImageData btsData;
                    RGB bordCol = BMTerminalSettings.getFOTheme().getButtonBordColor();
                    Color bordColor = new Color((Device)ib.getDisplay(), bordCol);
                    Color prevColor = e.gc.getForeground();
                    ImageData imageData = btsData = ImageButton.this.backgroundPattern == null ? ImageCache.getImage("btStrip.png").getImageData() : ImageButton.this.backgroundPattern.getImageData();
                    if (btsData.width == 1) {
                        btsData = btsData.scaledTo(btsData.width, ib.getBounds().height);
                    }
                    Image btStrip = new Image((Device)ib.getDisplay(), btsData);
                    Pattern btPat = new Pattern((Device)ib.getDisplay(), btStrip);
                    e.gc.setBackgroundPattern(btPat);
                    e.gc.setForeground(bordColor);
                    e.gc.fillRoundRectangle(0, 0, ib.getBounds().width - 1, ib.getBounds().height - 1, arc, arc);
                    e.gc.drawRoundRectangle(0, 0, ib.getBounds().width - 1, ib.getBounds().height - 1, arc, arc);
                    e.gc.setBackgroundPattern(null);
                    e.gc.setForeground(prevColor);
                    btPat.dispose();
                    btStrip.dispose();
                    bordColor.dispose();
                }
                if (ImageButton.this.selection) {
                    e.gc.setBackground(e.display.getSystemColor(16));
                    e.gc.setAlpha(64);
                    e.gc.fillRoundRectangle(0, 0, ib.getBounds().width, ib.getBounds().height, arc, arc);
                    e.gc.setBackground(e.display.getSystemColor(1));
                    e.gc.setAlpha(255);
                }
                switch (ImageButton.this.mouse) {
                    case 0: 
                    case 1: {
                        this.drawFront(e, ib.getText(), ib.getImage());
                        break;
                    }
                    case 2: {
                        e.gc.setAlpha(128);
                        this.drawFront(e, ib.getText(), ib.getImage());
                        e.gc.setAlpha(255);
                    }
                }
                if (ib.isFocusControl()) {
                    e.gc.setLineStyle(3);
                    e.gc.setForeground(ib.getDisplay().getSystemColor(23));
                    e.gc.drawRoundRectangle(ImageButton.this.getPadding().intValue(), ImageButton.this.getPadding().intValue(), ib.getBounds().width - ImageButton.this.getPadding() * 2, ib.getBounds().height - ImageButton.this.getPadding() * 2, arc, arc);
                }
                if (!ib.getEnabled()) {
                    e.gc.setBackgroundPattern(null);
                    e.gc.setForeground(ib.getBackground());
                    e.gc.setAlpha(128);
                    e.gc.fillRoundRectangle(0, 0, ib.getBounds().width, ib.getBounds().height, arc, arc);
                }
            }

            private void drawFront(PaintEvent e, String s, Image frontImage) {
                Image fImg = frontImage == null || frontImage.isDisposed() ? null : frontImage;
                ImageButton ib = (ImageButton)e.widget;
                boolean arrow = false;
                if ((style & 4) > 0) {
                    if ((style & 0x80) > 0) {
                        fImg = ImageCache.getImage("strelaGore.png");
                    } else if ((style & 0x20000) > 0) {
                        fImg = ImageCache.getImage("strelaDesno.png");
                    } else if ((style & 0x400) > 0) {
                        fImg = ImageCache.getImage("strelaDole.png");
                    } else if ((style & 0x4000) > 0) {
                        fImg = ImageCache.getImage("strelaLevo.png");
                    }
                    ImageButton.this.text = "";
                    arrow = true;
                }
                int w = ib.getBounds().width - ImageButton.this.getPadding() * 2 - (fImg == null ? 0 : fImg.getBounds().width);
                int h = ib.getBounds().height - ImageButton.this.getPadding() * 2;
                e.gc.setForeground(ib.getForeground());
                e.gc.setFont(ib.getFont());
                if (ImageButton.this.textKey != null && Konstante.getBundle().containsKey(ImageButton.this.textKey)) {
                    ImageButton.this.text = Konstante.getBundle().getString(ImageButton.this.textKey);
                }
                if (ImageButton.this.text != null && ImageButton.this.text.length() > 0) {
                    ImageButton.this.tl = new TextLayout((Device)parent.getDisplay());
                    ImageButton.this.tl.setText(ImageButton.this.text);
                    ImageButton.this.tl.setAlignment(0x1000000);
                    TextStyle ts = new TextStyle(ib.getFont(), ib.getForeground(), null);
                    ImageButton.this.tl.setStyle(ts, 0, ImageButton.this.text.length());
                    ImageButton.this.tl.setWidth(w);
                    FontMetrics lfm = ImageButton.this.tl.getLineMetrics(0);
                    int lh = lfm.getHeight() * ImageButton.this.tl.getLineCount();
                    ImageButton.this.tl.draw(e.gc, ImageButton.this.getPadding() + (fImg == null ? 0 : fImg.getBounds().width), ImageButton.this.getPadding() + (h - (lh > h ? h : lh)) / 2);
                }
                if (fImg != null) {
                    boolean imgOnly = ImageButton.this.text.isEmpty();
                    if (arrow) {
                        int bw = ib.getBounds().width;
                        int bh = ib.getBounds().height;
                        int iw = fImg.getBounds().width;
                        int ih = fImg.getBounds().height;
                        float scale = (Float.valueOf(bw > bh ? (float)bh : (float)bw).floatValue() - (float)(ImageButton.this.getPadding() * 2)) / Float.valueOf(iw).floatValue();
                        int niw = Math.round(scale * (float)iw);
                        int nih = Math.round(scale * (float)ih);
                        e.gc.drawImage(fImg, 0, 0, iw, ih, (bw - niw) / 2, (bh - nih) / 2, niw, nih);
                    } else if (!imgOnly) {
                        e.gc.drawImage(fImg, ImageButton.this.getPadding().intValue(), ImageButton.this.getPadding() + (h - fImg.getBounds().height) / 2);
                    } else {
                        e.gc.drawImage(fImg, (ib.getBounds().width - fImg.getBounds().width) / 2, (ib.getBounds().height - fImg.getBounds().height) / 2);
                    }
                }
                if (ImageButton.this.tl != null && !ImageButton.this.tl.isDisposed()) {
                    ImageButton.this.tl.dispose();
                }
            }
        });
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                ImageButton.this.hit = true;
                ImageButton.this.mouse = 2;
                ImageButton.this.redraw();
            }

            public void mouseUp(MouseEvent e) {
                ImageButton.this.hit = false;
                ImageButton.this.mouse = 1;
                if (e.x < 0 || e.y < 0 || e.x > ImageButton.this.getBounds().width || e.y > ImageButton.this.getBounds().height) {
                    ImageButton.this.mouse = 0;
                }
                ImageButton.this.redraw();
                if (ImageButton.this.mouse == 1) {
                    Event event = new Event();
                    event.data = e.data;
                    event.detail = 13;
                    event.display = e.display;
                    event.doit = true;
                    event.height = 0;
                    event.item = e.widget;
                    event.stateMask = e.stateMask;
                    event.text = "";
                    event.time = e.time;
                    event.widget = e.widget;
                    event.width = 0;
                    event.x = e.x;
                    event.y = e.y;
                    ImageButton.this.notifyListeners(13, event);
                }
            }
        });
        this.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                switch (e.keyCode) {
                    case 13: 
                    case 32: 
                    case 0x1000050: {
                        Event event = new Event();
                        event.data = e.data;
                        event.detail = 13;
                        event.display = e.display;
                        event.doit = e.doit;
                        event.height = 0;
                        event.item = e.widget;
                        event.stateMask = e.stateMask;
                        event.text = "";
                        event.time = e.time;
                        event.widget = e.widget;
                        event.width = 0;
                        event.x = 0;
                        event.y = 0;
                        ImageButton.this.notifyListeners(13, event);
                        break;
                    }
                }
            }
        });
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                ImageButton.this.redraw();
            }

            public void focusLost(FocusEvent e) {
                ImageButton.this.redraw();
            }
        });
        this.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 16 || e.detail == 8) {
                    e.doit = true;
                }
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (ImageButton.this.tl != null && !ImageButton.this.tl.isDisposed()) {
                    ImageButton.this.tl.dispose();
                }
            }
        });
    }

    public void setBackgroundImage(Image image) {
        this.backgroundImage = image;
    }

    public void addSelectionListener(final SelectionListener listener) {
        Listener l = new Listener(){

            public void handleEvent(Event event) {
                listener.widgetSelected(new SelectionEvent(event));
            }
        };
        this.selectListenerMap.put(listener, l);
        this.addListener(13, l);
    }

    public void removeSelectionListener(SelectionListener listener) {
        if (this.selectListenerMap.containsKey(listener)) {
            this.removeListener(13, this.selectListenerMap.get(listener));
        }
    }

    public void removeAllSelectionListeners() {
        for (Listener listener : this.selectListenerMap.values()) {
            this.removeListener(13, listener);
        }
        this.selectListenerMap = new HashMap<SelectionListener, Listener>();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.redraw();
    }

    public Image getBackgroundImage() {
        return this.backgroundImage;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.textKey = null;
        this.text = text == null ? "" : text;
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public Integer getPadding() {
        if (this.padding == null) {
            return 4;
        }
        return this.padding;
    }

    public void addListener(int eventType, Listener listener) {
        super.addListener(eventType, listener);
    }

    public void setPadding(Integer padding) {
        this.padding = padding;
    }

    public boolean getSelection() {
        return this.selection;
    }

    public void setSelection(boolean selection) {
        this.selection = selection;
    }

    public Image getBackgroundPattern() {
        return this.backgroundPattern;
    }

    public void setBackgroundPattern(Image backgroundPattern) {
        this.backgroundPattern = backgroundPattern;
    }

    public String getTextKey() {
        return this.textKey;
    }

    public void setTextKey(String textKey) {
        if (textKey != null && Konstante.getBundle().containsKey(textKey)) {
            this.text = null;
        }
        this.textKey = textKey;
    }
}

