/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.stampa;

import Stampa.core.GridPrinter;
import Stampa.test.PrintHandler;
import Stampa.test.TableWrapper;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.SkidanjeNormativa;
import com.dev63.restoran.constants.StatLogic;
import com.dev63.restoran.model.Artikal;
import com.dev63.restoran.model.DnevnoStanje;
import com.dev63.restoran.model.Kartica;
import com.dev63.restoran.model.Odeljenje;
import com.dev63.restoran.model.Option;
import com.dev63.restoran.model.PodgrupaArtikala;
import com.dev63.restoran.model.StavkaRacuna;
import com.dev63.restoran.model.TipArtikla;
import com.dev63.restoran.sistem.IzracunajDnevniPromet;
import com.dev63.restoran.sistem.PomocniUpit;
import com.dev63.restoran.stampa.StampaIzvestajZalihe;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class UskaStanjeZaliha {
    private final ResourceBundle barmasterText = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale());
    private Restoran restoran;
    private RestoranServer server;
    Table table;
    Shell shell;
    Composite composite;
    List<Kartica> kartica2 = new ArrayList<Kartica>();
    List<PodgrupaArtikala> podgrupe = new ArrayList<PodgrupaArtikala>();
    boolean blic;
    boolean blic2;
    Date day1;
    Date day2;
    double ukupnoPoc = 0.0;
    double ukupnoUl = 0.0;
    double ukupnoPro = 0.0;
    double ukupno = 0.0;
    Odeljenje odeljenje;
    Odeljenje odeljenjeT;
    boolean finansijski;
    boolean isBelo;
    boolean isCrno;
    boolean isMedjuzbir;
    boolean isDanasnji;
    Map<Long, Artikal> artikli;
    List<Artikal> artikli2 = new ArrayList<Artikal>();
    Map<Long, Double> mapaPocetnoB;
    Map<Long, Double> mapaUlazB;
    Map<Long, Double> mapaIzlazB;
    Map<Long, Double> mapaPocetnoC;
    Map<Long, Double> mapaUlazC;
    Map<Long, Double> mapaIzlazC;
    List<DnevnoStanje> stanjaDanas = null;
    private Object podgrupaArtikala;
    private Map<String, List<String[]>> results = new HashMap<String, List<String[]>>();

    public UskaStanjeZaliha(Shell s, Restoran r, Odeljenje od, boolean finans, boolean bl, boolean bl2, boolean be, boolean cr, boolean mz) {
        this.shell = s;
        this.restoran = r;
        this.server = this.restoran.getServer();
        this.day1 = this.server.getPoslednjiPocetni();
        this.day2 = Konstante.getKrajnjiDatum(new Date(), this.server);
        this.finansijski = finans;
        this.isBelo = be;
        this.isCrno = cr;
        this.isMedjuzbir = mz;
        this.isDanasnji = !Konstante.getOnlyDate(this.day2).before(Konstante.getOnlyDate(new Date()));
        this.blic = bl;
        this.blic2 = bl2;
        this.shell.setEnabled(false);
        this.shell.setBackground(this.shell.getDisplay().getSystemColor(1));
        this.shell.setLayout((Layout)new GridLayout(2, false));
        this.shell.setText(String.format(this.barmasterText.getString("TEXT_IZVESTAJ_O_STANJU_ZALIHA_ZA_PERIOD"), new Object[0]) + ": " + StatLogic.getDateString(this.day1) + " -> " + StatLogic.getDateString(this.day2));
        this.odeljenje = od;
        this.blic = bl;
        this.table = new Table((Composite)this.shell, 66306);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 200;
        data.horizontalSpan = 2;
        this.table.setLayoutData((Object)data);
        if (this.isDanasnji) {
            ArrayList<Odeljenje> odeljenja = new ArrayList<Odeljenje>();
            odeljenja.add(this.odeljenje);
            IzracunajDnevniPromet dp = new IzracunajDnevniPromet(new Date(), odeljenja, this.server);
            this.stanjaDanas = dp.getDnevnaStanja();
            if (this.isMedjuzbir) {
                List<StavkaRacuna> stavke = this.server.readNenaplaceneStavkeRacuna();
                for (StavkaRacuna sr : stavke) {
                    Artikal a = sr.getArtikal();
                    if (od == null) {
                        for (Kartica k : SkidanjeNormativa.napraviKartice2(SkidanjeNormativa.razloziArtikal(a, sr.getKolicina(), this.server, Konstante.getDateIzvestaji(sr)), this.server, Konstante.getDateIzvestaji(sr))) {
                            this.kartica2.add(k);
                        }
                        continue;
                    }
                    for (Kartica k : SkidanjeNormativa.napraviKarticeOdeljenje2(SkidanjeNormativa.razloziArtikal(a, sr.getKolicina(), this.server, Konstante.getDateIzvestaji(sr)), this.server, this.odeljenje, Konstante.getDateIzvestaji(sr))) {
                        this.kartica2.add(k);
                    }
                }
            }
        }
        if (this.blic2) {
            this.makeHeadersBlicIzlaz();
            this.insertRowsBlicIzlaz(od);
        } else {
            this.makeHeaders();
            this.insertRows(od, false, bl2, finans, false, false, false, false, false);
        }
        Button printButton = new Button((Composite)this.shell, 8);
        printButton.setText(String.format(this.barmasterText.getString("TEXT_STAMPA"), new Object[0]));
        printButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                GridPrinter gp = new GridPrinter(new PrintHandler());
                gp.printTable(new TableWrapper(UskaStanjeZaliha.this.table), false, true, String.format(UskaStanjeZaliha.this.barmasterText.getString("TEXT_IZVESTAJ_O_STANJU_ZALIHA_ZA_PERIOD"), new Object[0]) + ": " + Konstante.getDate(UskaStanjeZaliha.this.day1) + "-->" + Konstante.getDate(UskaStanjeZaliha.this.day2), UskaStanjeZaliha.this.shell, UskaStanjeZaliha.this.server);
            }
        });
        GridPrinter gp = new GridPrinter(new PrintHandler());
        gp.printTable(new TableWrapper(this.table), false, true, String.format(this.barmasterText.getString("TEXT_IZVESTAJ_O_STANJU_ZALIHA_ZA_PERIOD"), new Object[0]) + ": " + Konstante.getDate(this.day1) + "-->" + Konstante.getDate(this.day2), this.shell, this.server);
        int items = this.table.getItemCount();
        String[][] ts = new String[items][4];
        for (int i = 0; i < items - 1; ++i) {
            ts[i][0] = this.table.getItem(i).getText(0);
            ts[i][1] = this.table.getItem(i).getText(1);
            ts[i][2] = this.table.getItem(i).getText(2);
            ts[i][3] = this.table.getItem(i).getText(6);
        }
        new StampaIzvestajZalihe(this.restoran, ts, String.format(this.barmasterText.getString("TEXT_IZVESTAJ_O_STANJU_ZALIHA"), new Object[0]).toUpperCase(), this.day1, this.day2);
    }

    private void insertRows(Odeljenje od, boolean samoSaPromenama, boolean blic, boolean finansijski, boolean po, boolean ul, boolean iz, boolean za, boolean poP) {
        block103: {
            int c;
            TableItem ti;
            HashMap<Double, Double> stopa_sumaProd;
            HashMap<Double, Double> stopa_sumaNab;
            double totalPVBPDV;
            double totalPV;
            double totalVPBPDV;
            double totalVP;
            double totalVUBPDV;
            double totalVU;
            double totalVIBPDV;
            double totalVI;
            double totalVZ;
            boolean BarCode;
            block101: {
                block102: {
                    ArrayList<Odeljenje> odeljenja;
                    BarCode = false;
                    if (od == null) {
                        odeljenja = null;
                    } else {
                        odeljenja = new ArrayList<Odeljenje>();
                        odeljenja.add(od);
                    }
                    if (this.podgrupaArtikala == null) {
                        this.podgrupe = this.server.readPodgrupeArtikala();
                    } else {
                        this.podgrupe = new ArrayList<PodgrupaArtikala>();
                        this.podgrupe.add((PodgrupaArtikala)this.podgrupaArtikala);
                    }
                    LinkedList<TipArtikla> exclTypes = new LinkedList<TipArtikla>();
                    exclTypes.add(TipArtikla.SLOZ);
                    exclTypes.add(TipArtikla.DODA);
                    exclTypes.add(TipArtikla.POTR);
                    boolean lastPrice = poP;
                    boolean lastPriceWithBlack = this.server.getSetting(Option.PO_POSLEDNJIM_CENAMA_KOMBINOVANO) != null && this.server.getSetting(Option.PO_POSLEDNJIM_CENAMA_KOMBINOVANO).booleanValue();
                    boolean onlyWithChanges = samoSaPromenama;
                    boolean magacin = od != null && (od.getMagacin() != null && od.getMagacin() != false || od.getId() == 1L);
                    this.results = BarCode ? this.server.getISZResults(this.day1, this.day2, exclTypes, odeljenja, this.podgrupe, this.isBelo, this.isCrno, lastPrice, lastPriceWithBlack, onlyWithChanges, magacin, true) : this.server.getISZResultsBB(this.day1, this.day2, exclTypes, odeljenja, this.podgrupe, this.isBelo, this.isCrno, lastPrice, lastPriceWithBlack, onlyWithChanges, magacin, true);
                    LinkedList<String> keys = new LinkedList<String>(this.results.keySet());
                    Collections.sort(keys);
                    String ukupnoL = String.format(Konstante.getBundle().getString("TEXT_UKUPNO"), new Object[0]);
                    String totalL = String.format(Konstante.getBundle().getString("TEXT_TOTAL"), new Object[0]);
                    Object text = null;
                    totalVZ = 0.0;
                    totalVI = 0.0;
                    totalVIBPDV = 0.0;
                    totalVU = 0.0;
                    totalVUBPDV = 0.0;
                    totalVP = 0.0;
                    totalVPBPDV = 0.0;
                    double totalVBPDV = 0.0;
                    totalPV = 0.0;
                    totalPVBPDV = 0.0;
                    double nabavno10 = 0.0;
                    double nabavno20 = 0.0;
                    double prodajno10 = 0.0;
                    double prodajno20 = 0.0;
                    stopa_sumaNab = new HashMap<Double, Double>();
                    stopa_sumaProd = new HashMap<Double, Double>();
                    for (String string : keys) {
                        int c2;
                        List<String[]> list = this.results.get(string);
                        ti = new TableItem(this.table, 0);
                        ti.setText(0, string);
                        double ukupnoVZ = 0.0;
                        double ukupnoVI = 0.0;
                        double ukupnoVIBPDV = 0.0;
                        double ukupnoVU = 0.0;
                        double ukupnoVUBPDV = 0.0;
                        double ukupnoVP = 0.0;
                        double ukupnoVPBPDV = 0.0;
                        double ukupnoVBPDV = 0.0;
                        double ukupnoPV = 0.0;
                        double ukupnoPVBPDV = 0.0;
                        double pocetno = 0.0;
                        double ulaz = 0.0;
                        double izlaz = 0.0;
                        double zavrsno = 0.0;
                        Object text1 = null;
                        for (String[] strings : list) {
                            int c3;
                            double sum;
                            pocetno = Double.parseDouble(BarCode ? strings[4] : strings[3]);
                            double VP = Double.parseDouble(BarCode ? strings[5] : strings[4]);
                            ulaz = Double.parseDouble(BarCode ? strings[6] : strings[5]);
                            double VU = Double.parseDouble(BarCode ? strings[7] : strings[6]);
                            izlaz = Double.parseDouble(BarCode ? strings[8] : strings[7]);
                            double VI = Double.parseDouble(BarCode ? strings[9] : strings[8]);
                            zavrsno = Double.parseDouble(BarCode ? strings[10] : strings[9]);
                            double VZ = Double.parseDouble(BarCode ? strings[11] : strings[10]);
                            double VBPDV = Double.parseDouble(BarCode ? strings[12] : strings[11]);
                            double PV = Double.parseDouble(BarCode ? ("/".equals(strings[13]) ? "0.0" : strings[13]) : ("/".equals(strings[12]) ? "0.0" : strings[12]));
                            double VPBPDV = Double.parseDouble(BarCode ? strings[14] : strings[13]);
                            double VUBPDV = Double.parseDouble(BarCode ? strings[15] : strings[14]);
                            double VIBPDV = Double.parseDouble(BarCode ? strings[16] : strings[15]);
                            double PVBPDV = Double.parseDouble(BarCode ? ("/".equals(strings[17]) ? "0.0" : strings[17]) : ("/".equals(strings[16]) ? "0.0" : strings[16]));
                            double nc = Double.parseDouble(BarCode ? strings[21] : strings[20]);
                            double ncSpdv = Double.parseDouble(BarCode ? strings[22] : strings[21]);
                            double stopa = Double.parseDouble(BarCode ? strings[23] : strings[22]);
                            if (!stopa_sumaNab.containsKey(stopa)) {
                                stopa_sumaNab.put(stopa, VZ);
                            } else {
                                sum = (Double)stopa_sumaNab.get(stopa);
                                stopa_sumaNab.put(stopa, sum += VZ);
                            }
                            if (!stopa_sumaProd.containsKey(stopa)) {
                                stopa_sumaProd.put(stopa, PV);
                            } else {
                                sum = (Double)stopa_sumaProd.get(stopa);
                                stopa_sumaProd.put(stopa, sum += PV);
                            }
                            ukupnoVZ += VZ;
                            ukupnoVI += VI;
                            ukupnoVIBPDV += VIBPDV;
                            ukupnoVU += VU;
                            ukupnoVUBPDV += VUBPDV;
                            ukupnoVP += VP;
                            ukupnoVPBPDV += VPBPDV;
                            ukupnoVBPDV += VBPDV;
                            ukupnoPV += PV;
                            ukupnoPVBPDV += PVBPDV;
                            if (blic) {
                                if (izlaz == 0.0) continue;
                                if (BarCode) {
                                    c3 = 4;
                                    ti = new TableItem(this.table, 0);
                                    ti.setText(0, strings[0]);
                                    ti.setText(1, strings[1]);
                                    ti.setText(2, strings[2]);
                                    ti.setText(3, strings[3].toUpperCase());
                                    if (!iz) continue;
                                    ti.setText(c3++, Konstante.getNumber4(izlaz));
                                    continue;
                                }
                                c3 = 3;
                                ti = new TableItem(this.table, 0);
                                ti.setText(0, strings[0]);
                                ti.setText(1, strings[1]);
                                ti.setText(2, strings[2].toUpperCase());
                                if (!iz) continue;
                                ti.setText(c3++, Konstante.getNumber4(izlaz));
                                continue;
                            }
                            if (BarCode) {
                                c3 = 4;
                                ti = new TableItem(this.table, 0);
                                ti.setText(0, strings[0]);
                                ti.setText(1, strings[1]);
                                ti.setText(2, strings[2]);
                                ti.setText(3, strings[3].toUpperCase());
                                if (po) {
                                    ti.setText(c3++, Konstante.getNumber4(pocetno));
                                }
                                if (po && finansijski) {
                                    ti.setText(c3++, Konstante.getNumber2(VP));
                                }
                                if (po && finansijski) {
                                    ti.setText(c3++, Konstante.getNumber2(pocetno * nc));
                                }
                                if (ul) {
                                    ti.setText(c3++, Konstante.getNumber4(ulaz));
                                }
                                if (ul && finansijski) {
                                    ti.setText(c3++, Konstante.getNumber2(VU));
                                }
                                if (ul && finansijski) {
                                    ti.setText(c3++, Konstante.getNumber2(VUBPDV));
                                }
                                if (iz) {
                                    ti.setText(c3++, Konstante.getNumber4(izlaz));
                                }
                                if (iz && finansijski) {
                                    ti.setText(c3++, Konstante.getNumber2(VI));
                                }
                                if (iz && finansijski) {
                                    ti.setText(c3++, Konstante.getNumber2(VIBPDV));
                                }
                                if (za) {
                                    ti.setText(c3++, Konstante.getNumber4(zavrsno));
                                }
                                if (za && finansijski) {
                                    ti.setText(c3++, Konstante.getNumber2(VZ));
                                }
                                if (za && finansijski) {
                                    ti.setText(c3++, Konstante.getNumber2(VBPDV));
                                }
                                ti.setText(c3++, Konstante.getNumber2(PV));
                                ti.setText(c3++, Konstante.getNumber2(PVBPDV));
                                ti.setText(c3++, Konstante.getNumber2(nc));
                                ti.setText(c3++, Konstante.getNumber2(ncSpdv));
                                if (!(zavrsno < 0.0)) continue;
                                ti.setForeground(this.shell.getDisplay().getSystemColor(4));
                                continue;
                            }
                            c3 = 3;
                            ti = new TableItem(this.table, 0);
                            ti.setText(0, strings[0]);
                            ti.setText(1, strings[1]);
                            ti.setText(2, strings[2].toUpperCase());
                            if (po) {
                                ti.setText(c3++, Konstante.getNumber4(pocetno));
                            }
                            if (po && finansijski) {
                                ti.setText(c3++, Konstante.getNumber2(VP));
                            }
                            if (po && finansijski) {
                                ti.setText(c3++, Konstante.getNumber2(pocetno * nc));
                            }
                            if (ul) {
                                ti.setText(c3++, Konstante.getNumber4(ulaz));
                            }
                            if (ul && finansijski) {
                                ti.setText(c3++, Konstante.getNumber2(VU));
                            }
                            if (ul && finansijski) {
                                ti.setText(c3++, Konstante.getNumber2(VUBPDV));
                            }
                            if (iz) {
                                ti.setText(c3++, Konstante.getNumber4(izlaz));
                            }
                            if (iz && finansijski) {
                                ti.setText(c3++, Konstante.getNumber2(VI));
                            }
                            if (iz && finansijski) {
                                ti.setText(c3++, Konstante.getNumber2(VIBPDV));
                            }
                            if (za) {
                                ti.setText(c3++, Konstante.getNumber4(zavrsno));
                            }
                            if (za && finansijski) {
                                ti.setText(c3++, Konstante.getNumber2(VZ));
                            }
                            ti.setText(c3++, Konstante.getNumber2(VBPDV));
                            ti.setText(c3++, Konstante.getNumber2(PV));
                            ti.setText(c3++, Konstante.getNumber2(PVBPDV));
                            ti.setText(c3++, Konstante.getNumber2(nc));
                            ti.setText(c3++, Konstante.getNumber2(ncSpdv));
                            if (!(zavrsno < 0.0)) continue;
                            ti.setForeground(this.shell.getDisplay().getSystemColor(4));
                        }
                        totalVZ += ukupnoVZ;
                        totalVI += ukupnoVI;
                        totalVIBPDV += ukupnoVIBPDV;
                        totalVU += ukupnoVU;
                        totalVUBPDV += ukupnoVUBPDV;
                        totalVP += ukupnoVP;
                        totalVPBPDV += ukupnoVPBPDV;
                        totalVBPDV += ukupnoVBPDV;
                        totalPV += ukupnoPV;
                        totalPVBPDV += ukupnoPVBPDV;
                        ti = new TableItem(this.table, 0);
                        ti.setText(0, "Ukupno: ");
                        if (blic) {
                            if (BarCode) {
                                c2 = 4;
                                if (iz) {
                                    ti.setText(c2++, Konstante.getNumber4(ukupnoVI));
                                }
                            } else {
                                c2 = 3;
                                ti = new TableItem(this.table, 0);
                                ti.setText(0, "");
                                ti.setText(1, "");
                                ti.setText(2, "");
                                if (iz) {
                                    ti.setText(c2++, Konstante.getNumber4(ukupnoVI));
                                }
                                if (zavrsno < 0.0) {
                                    ti.setForeground(this.shell.getDisplay().getSystemColor(4));
                                }
                            }
                        } else if (BarCode) {
                            c2 = 4;
                            if (po) {
                                ti.setText(c2++, "");
                            }
                            if (po && finansijski) {
                                ti.setText(c2++, Konstante.getNumber2(ukupnoVP));
                            }
                            if (po && finansijski) {
                                ti.setText(c2++, Konstante.getNumber2(ukupnoVPBPDV));
                            }
                            if (ul) {
                                ti.setText(c2++, "");
                            }
                            if (ul && finansijski) {
                                ti.setText(c2++, Konstante.getNumber2(ukupnoVU));
                            }
                            if (ul && finansijski) {
                                ti.setText(c2++, Konstante.getNumber2(ukupnoVUBPDV));
                            }
                            if (iz) {
                                ti.setText(c2++, "");
                            }
                            if (iz && finansijski) {
                                ti.setText(c2++, Konstante.getNumber2(ukupnoVI));
                            }
                            if (iz && finansijski) {
                                ti.setText(c2++, Konstante.getNumber2(ukupnoVIBPDV));
                            }
                            if (za) {
                                ti.setText(c2++, "");
                            }
                            if (za && finansijski) {
                                ti.setText(c2++, Konstante.getNumber2(ukupnoVZ));
                            }
                            if (za && finansijski) {
                                ti.setText(c2++, Konstante.getNumber2(ukupnoVZ / 1.2));
                            }
                            ti.setText(c2++, Konstante.getNumber2(ukupnoPV));
                            ti.setText(c2++, Konstante.getNumber2(ukupnoPVBPDV));
                            if (zavrsno < 0.0) {
                                ti.setForeground(this.shell.getDisplay().getSystemColor(4));
                            }
                        } else {
                            c2 = 3;
                            if (po) {
                                ti.setText(c2++, "");
                            }
                            if (po && finansijski) {
                                ti.setText(c2++, Konstante.getNumber2(ukupnoVP));
                            }
                            if (po && finansijski) {
                                ti.setText(c2++, Konstante.getNumber2(ukupnoVPBPDV));
                            }
                            if (ul) {
                                ti.setText(c2++, "");
                            }
                            if (ul && finansijski) {
                                ti.setText(c2++, Konstante.getNumber2(ukupnoVU));
                            }
                            if (ul && finansijski) {
                                ti.setText(c2++, Konstante.getNumber2(ukupnoVUBPDV));
                            }
                            if (iz) {
                                ti.setText(c2++, "");
                            }
                            if (iz && finansijski) {
                                ti.setText(c2++, Konstante.getNumber2(ukupnoVI));
                            }
                            if (iz && finansijski) {
                                ti.setText(c2++, Konstante.getNumber2(ukupnoVIBPDV));
                            }
                            if (za) {
                                ti.setText(c2++, "");
                            }
                            if (za && finansijski) {
                                ti.setText(c2++, Konstante.getNumber2(ukupnoVZ));
                            }
                            if (za && finansijski) {
                                ti.setText(c2++, Konstante.getNumber2(ukupnoVZ / 1.2));
                            }
                            ti.setText(c2++, Konstante.getNumber2(ukupnoPV));
                            ti.setText(c2++, Konstante.getNumber2(ukupnoPVBPDV));
                            if (zavrsno < 0.0) {
                                ti.setForeground(this.shell.getDisplay().getSystemColor(4));
                            }
                        }
                        ti = new TableItem(this.table, 0);
                        ti.setText("");
                    }
                    ti = new TableItem(this.table, 0);
                    ti.setText("TOTAL: ");
                    if (!blic) break block101;
                    if (!BarCode) break block102;
                    int c4 = 4;
                    if (iz) {
                        ti.setText(c4++, Konstante.getNumber4(totalVI));
                    }
                    break block103;
                }
                int c5 = 3;
                ti = new TableItem(this.table, 0);
                ti.setText(0, "");
                ti.setText(1, "");
                ti.setText(2, "");
                if (!iz) break block103;
                ti.setText(c5++, Konstante.getNumber4(totalVI));
                break block103;
            }
            if (BarCode) {
                c = 4;
                if (po) {
                    ti.setText(c++, "");
                }
                if (po && finansijski) {
                    ti.setText(c++, Konstante.getNumber2(totalVP));
                }
                if (po && finansijski) {
                    ti.setText(c++, Konstante.getNumber2(totalVPBPDV));
                }
                if (ul) {
                    ti.setText(c++, "");
                }
                if (ul && finansijski) {
                    ti.setText(c++, Konstante.getNumber2(totalVU));
                }
                if (ul && finansijski) {
                    ti.setText(c++, Konstante.getNumber2(totalVUBPDV));
                }
                if (iz) {
                    ti.setText(c++, "");
                }
                if (iz && finansijski) {
                    ti.setText(c++, Konstante.getNumber2(totalVI));
                }
                if (iz && finansijski) {
                    ti.setText(c++, Konstante.getNumber2(totalVIBPDV));
                }
                if (za) {
                    ti.setText(c++, "");
                }
                if (za && finansijski) {
                    ti.setText(c++, Konstante.getNumber2(totalVZ));
                }
                if (za && finansijski) {
                    ti.setText(c++, Konstante.getNumber2(totalVZ / 1.2));
                }
                ti.setText(c++, Konstante.getNumber2(totalPV));
                ti.setText(c++, Konstante.getNumber2(totalPVBPDV));
            } else {
                c = 3;
                if (po) {
                    ti.setText(c++, "");
                }
                if (po && finansijski) {
                    ti.setText(c++, Konstante.getNumber2(totalVP));
                }
                if (po && finansijski) {
                    ti.setText(c++, Konstante.getNumber2(totalVPBPDV));
                }
                if (ul) {
                    ti.setText(c++, "");
                }
                if (ul && finansijski) {
                    ti.setText(c++, Konstante.getNumber2(totalVU));
                }
                if (ul && finansijski) {
                    ti.setText(c++, Konstante.getNumber2(totalVUBPDV));
                }
                if (iz) {
                    ti.setText(c++, "");
                }
                if (iz && finansijski) {
                    ti.setText(c++, Konstante.getNumber2(totalVI));
                }
                if (iz && finansijski) {
                    ti.setText(c++, Konstante.getNumber2(totalVIBPDV));
                }
                if (za) {
                    ti.setText(c++, "");
                }
                if (za && finansijski) {
                    ti.setText(c++, Konstante.getNumber2(totalVZ));
                }
                if (za && finansijski) {
                    ti.setText(c++, Konstante.getNumber2(totalVZ / 1.2));
                }
                ti.setText(c++, Konstante.getNumber2(totalPV));
                ti.setText(c++, Konstante.getNumber2(totalPVBPDV));
            }
            ti = new TableItem(this.table, 0);
            ti.setText("");
            if (finansijski) {
                for (Double d : stopa_sumaNab.keySet()) {
                    ti = new TableItem(this.table, 0);
                    int c6 = BarCode ? 13 : 12;
                    ti.setText(c6++, "Stopa_" + d * 100.0 + "%");
                    ti.setText(c6++, Konstante.getNumber2((Double)stopa_sumaNab.get(d)));
                    for (Double d1 : stopa_sumaProd.keySet()) {
                        if (!d1.equals(d)) continue;
                        ti.setText(c6++, "Stopa_" + d * 100.0 + "%");
                        ti.setText(c6++, Konstante.getNumber2((Double)stopa_sumaProd.get(d1)));
                        System.out.println("samo (d) " + d);
                    }
                }
            }
        }
    }

    public double izracunajPocetno(Artikal a) {
        double pocetno = 0.0;
        if (this.isBelo && this.mapaPocetnoB.get(a.getId()) != null) {
            pocetno += this.mapaPocetnoB.get(a.getId()).doubleValue();
        }
        if (this.isCrno && this.mapaPocetnoC.get(a.getId()) != null) {
            pocetno += this.mapaPocetnoC.get(a.getId()).doubleValue();
        }
        return pocetno;
    }

    public double izracunajUlaz(Artikal a) {
        double ulaz = 0.0;
        if (this.isBelo) {
            if (this.mapaUlazB.get(a.getId()) != null) {
                ulaz += this.mapaUlazB.get(a.getId()).doubleValue();
            }
            if (this.getDS(a) != null) {
                ulaz += this.getDS(a).getBeloUlaz().doubleValue();
            }
        }
        if (this.isCrno) {
            if (this.mapaUlazC.get(a.getId()) != null) {
                ulaz += this.mapaUlazC.get(a.getId()).doubleValue();
            }
            if (this.getDS(a) != null) {
                ulaz += this.getDS(a).getCrnoUlaz().doubleValue();
            }
        }
        for (Kartica k : this.kartica2) {
            if (!k.getArtikal().equals(a) || !k.getOdeljenje().equals(this.odeljenjeT) || !(k.getKolicina() > 0.0)) continue;
            ulaz += k.getKolicina().doubleValue();
        }
        return ulaz;
    }

    public double izracunajIzlaz(Artikal a) {
        double izlaz = 0.0;
        if (this.isBelo) {
            if (this.mapaIzlazB.get(a.getId()) != null) {
                izlaz += this.mapaIzlazB.get(a.getId()).doubleValue();
            }
            if (this.getDS(a) != null) {
                izlaz += this.getDS(a).getBeloIzlaz().doubleValue();
            }
        }
        if (this.isCrno) {
            if (this.mapaIzlazC.get(a.getId()) != null) {
                izlaz += this.mapaIzlazC.get(a.getId()).doubleValue();
            }
            if (this.getDS(a) != null) {
                izlaz += this.getDS(a).getCrnoIzlaz().doubleValue();
            }
        }
        for (Kartica k : this.kartica2) {
            if (!k.getArtikal().equals(a) || !k.getOdeljenje().equals(this.odeljenjeT) || !(k.getKolicina() < 0.0)) continue;
            izlaz += -k.getKolicina().doubleValue();
        }
        return izlaz;
    }

    public void makeHeaders() {
        TableColumn tc0 = new TableColumn(this.table, 131072);
        tc0.setWidth(120);
        TableColumn tc1 = new TableColumn(this.table, 131072);
        tc1.setText("Artikal");
        tc1.setWidth(110);
        TableColumn tc2 = new TableColumn(this.table, 131072);
        tc2.setText("J.M.");
        tc2.setWidth(50);
        TableColumn tc9 = new TableColumn(this.table, 131072);
        tc9.setText("Pocetno");
        tc9.setWidth(90);
        TableColumn tc3 = new TableColumn(this.table, 131072);
        tc3.setText("Ulaz");
        tc3.setWidth(90);
        TableColumn tc4 = new TableColumn(this.table, 131072);
        tc4.setText("Izlaz");
        tc4.setWidth(90);
        TableColumn tc5 = new TableColumn(this.table, 131072);
        tc5.setText("Zavrsno");
        tc5.setWidth(90);
        TableColumn tc6 = new TableColumn(this.table, 131072);
        tc6.setText("Vrednost");
        tc6.setWidth(90);
        if (this.finansijski) {
            TableColumn tx = new TableColumn(this.table, 131072, 4);
            tx.setText("Vrednost");
            tx.setWidth(90);
            TableColumn tx1 = new TableColumn(this.table, 131072, 6);
            tx1.setText("Vrednost");
            tx1.setWidth(90);
            TableColumn tx2 = new TableColumn(this.table, 131072, 8);
            tx2.setText("Vrednost");
            tx2.setWidth(90);
        }
    }

    public void makeHeadersBlicIzlaz() {
        TableColumn tc0 = new TableColumn(this.table, 131072);
        tc0.setWidth(120);
        TableColumn tc1 = new TableColumn(this.table, 131072);
        tc1.setText("Artikal");
        tc1.setWidth(110);
        TableColumn tc2 = new TableColumn(this.table, 131072);
        tc2.setText("J.M.");
        tc2.setWidth(50);
        TableColumn tc4 = new TableColumn(this.table, 131072);
        tc4.setText("Izlaz");
        tc4.setWidth(90);
    }

    public void insertRows(Odeljenje od) {
        List<Odeljenje> odeljenja;
        if (od == null) {
            odeljenja = this.server.readOdeljenjeBezMag2();
        } else {
            odeljenja = new ArrayList<Odeljenje>();
            odeljenja.add(od);
        }
        Iterator<Odeljenje> iterator = odeljenja.iterator();
        while (iterator.hasNext()) {
            double vredPro;
            double vredUl;
            double vredPoc;
            double vrednost;
            double zavrsno;
            double pocetno;
            double ulaz;
            double izlaz;
            Odeljenje o;
            this.odeljenjeT = o = iterator.next();
            if (this.isBelo) {
                this.mapaPocetnoB = this.server.getDnevnoStanjeBelo(this.day1, o, PomocniUpit.artikliBezSlozenih(o));
                this.mapaIzlazB = this.server.getPeriodicnoStanjeBeloIzlaz(this.day1, this.day2, o, PomocniUpit.artikliBezSlozenih(o));
                this.mapaUlazB = this.server.getPeriodicnoStanjeBeloUlaz(this.day1, this.day2, o, PomocniUpit.artikliBezSlozenih(o));
            }
            if (this.isCrno) {
                this.mapaPocetnoC = this.server.getDnevnoStanjeCrno(this.day1, o, PomocniUpit.artikliBezSlozenih(o));
                this.mapaIzlazC = this.server.getPeriodicnoStanjeCrnoIzlaz(this.day1, this.day2, o, PomocniUpit.artikliBezSlozenih(o));
                this.mapaUlazC = this.server.getPeriodicnoStanjeCrnoUlaz(this.day1, this.day2, o, PomocniUpit.artikliBezSlozenih(o));
            }
            double ukupnoOdPo = 0.0;
            double ukupnoOdUl = 0.0;
            double ukupnoOdPr = 0.0;
            double ukupnoOdeljenje = 0.0;
            TableItem ti = new TableItem(this.table, 0);
            ti.setText(0, o.getNaziv());
            this.artikli = this.server.getArtikliBezSlozISirOdeljenje2(o.getId());
            this.artikli2.clear();
            for (Artikal a : this.artikli.values()) {
                this.artikli2.add(a);
            }
            this.sortiraj(this.artikli2);
            for (Artikal a : this.artikli2) {
                izlaz = this.izracunajIzlaz(a);
                ulaz = this.izracunajUlaz(a);
                if (this.blic && ulaz == 0.0 && izlaz == 0.0) continue;
                pocetno = this.izracunajPocetno(a);
                zavrsno = pocetno + ulaz - izlaz;
                vrednost = zavrsno * a.getTrenutnaNV();
                ukupnoOdeljenje += vrednost;
                vredPoc = pocetno * a.getTrenutnaNV();
                ukupnoOdPo += vredPoc;
                vredUl = ulaz * a.getTrenutnaNV();
                ukupnoOdUl += vredUl;
                vredPro = izlaz * a.getTrenutnaNV();
                ukupnoOdPr += vredPro;
                this.ukupno += vrednost;
                this.ukupnoPoc += vredPoc;
                this.ukupnoUl += vredUl;
                this.ukupnoPro += vredPro;
                ti = new TableItem(this.table, 0);
                if (this.finansijski) {
                    ti.setText(new String[]{"", a.getName(), a.getJedinicaMere(), Konstante.getNumber4(pocetno), Konstante.getNumber4(vredPoc), Konstante.getNumber4(ulaz), Konstante.getNumber4(vredUl), Konstante.getNumber4(izlaz), Konstante.getNumber4(vredPro), Konstante.getNumber4(zavrsno), Konstante.getNumber2(vrednost)});
                    continue;
                }
                ti.setText(new String[]{"", a.getName(), a.getJedinicaMere(), Konstante.getNumber4(pocetno), Konstante.getNumber4(ulaz), Konstante.getNumber4(izlaz), Konstante.getNumber4(zavrsno), Konstante.getNumber2(vrednost)});
            }
            ti = new TableItem(this.table, 0);
            if (this.finansijski) {
                ti.setText(3, "UKUPNO");
                ti.setText(4, Konstante.getNumber2(ukupnoOdPo));
                ti.setText(5, "UKUPNO");
                ti.setText(6, Konstante.getNumber2(ukupnoOdUl));
                ti.setText(7, "UKUPNO");
                ti.setText(8, Konstante.getNumber2(ukupnoOdPr));
                ti.setText(9, "UKUPNO");
                ti.setText(10, Konstante.getNumber2(ukupnoOdeljenje));
            } else {
                ti.setText(6, "UKUPNO");
                ti.setText(7, Konstante.getNumber2(ukupnoOdeljenje));
            }
            ti = new TableItem(this.table, 0);
            ukupnoOdeljenje = 0.0;
            ti = new TableItem(this.table, 0);
            ti = new TableItem(this.table, 0);
            ti.setText(0, "SIROVINE " + o.getNaziv());
            this.artikli = this.server.getArtikliSirovineOdeljenje2(o.getId());
            this.artikli2.clear();
            for (Artikal a : this.artikli.values()) {
                this.artikli2.add(a);
            }
            this.sortiraj(this.artikli2);
            for (Artikal a : this.artikli2) {
                izlaz = this.izracunajIzlaz(a);
                ulaz = this.izracunajUlaz(a);
                if (this.blic && ulaz == 0.0 && izlaz == 0.0) continue;
                pocetno = this.izracunajPocetno(a);
                zavrsno = pocetno + ulaz - izlaz;
                vrednost = zavrsno * a.getTrenutnaNV();
                ukupnoOdeljenje += vrednost;
                vredPoc = pocetno * a.getTrenutnaNV();
                ukupnoOdPo += vredPoc;
                vredUl = ulaz * a.getTrenutnaNV();
                ukupnoOdUl += vredUl;
                vredPro = izlaz * a.getTrenutnaNV();
                ukupnoOdPr += vredPro;
                this.ukupno += vrednost;
                this.ukupnoPoc += vredPoc;
                this.ukupnoUl += vredUl;
                this.ukupnoPro += vredPro;
                ti = new TableItem(this.table, 0);
                if (this.finansijski) {
                    ti.setText(new String[]{"", a.getName(), a.getJedinicaMere(), Konstante.getNumber4(pocetno), Konstante.getNumber4(vredPoc), Konstante.getNumber4(ulaz), Konstante.getNumber4(vredUl), Konstante.getNumber4(izlaz), Konstante.getNumber4(vredPro), Konstante.getNumber4(zavrsno), Konstante.getNumber2(vrednost)});
                    continue;
                }
                ti.setText(new String[]{"", a.getName(), a.getJedinicaMere(), Konstante.getNumber4(pocetno), Konstante.getNumber4(ulaz), Konstante.getNumber4(izlaz), Konstante.getNumber4(zavrsno), Konstante.getNumber2(vrednost)});
            }
            ti = new TableItem(this.table, 0);
            if (this.finansijski) {
                ti.setText(3, "UKUPNO");
                ti.setText(4, Konstante.getNumber2(ukupnoOdPo));
                ti.setText(5, "UKUPNO");
                ti.setText(6, Konstante.getNumber2(ukupnoOdUl));
                ti.setText(7, "UKUPNO");
                ti.setText(8, Konstante.getNumber2(ukupnoOdPr));
                ti.setText(9, "UKUPNO");
                ti.setText(10, Konstante.getNumber2(ukupnoOdeljenje));
            } else {
                ti.setText(6, "UKUPNO");
                ti.setText(7, Konstante.getNumber2(ukupnoOdeljenje));
            }
            ti = new TableItem(this.table, 0);
        }
        TableItem ti = new TableItem(this.table, 0);
        ti = new TableItem(this.table, 0);
        if (this.finansijski) {
            ti.setText(3, "Total");
            ti.setText(4, Konstante.getNumber2(this.ukupnoPoc));
            ti.setText(5, "Total");
            ti.setText(6, Konstante.getNumber2(this.ukupnoUl));
            ti.setText(7, "Total");
            ti.setText(8, Konstante.getNumber2(this.ukupnoPro));
            ti.setText(9, "Total");
            ti.setText(10, Konstante.getNumber2(this.ukupno));
        } else {
            ti.setText(0, "Ukupna vrednost zaliha");
            ti.setText(7, Konstante.getNumber2(this.ukupno));
        }
    }

    public void insertRowsBlicIzlaz(Odeljenje od) {
        List<Odeljenje> odeljenja;
        if (od == null) {
            odeljenja = this.server.readOdeljenjeBezMag2();
        } else {
            odeljenja = new ArrayList<Odeljenje>();
            odeljenja.add(od);
        }
        Iterator<Odeljenje> iterator = odeljenja.iterator();
        while (iterator.hasNext()) {
            double izlaz;
            Odeljenje o;
            this.odeljenjeT = o = iterator.next();
            if (this.isBelo) {
                this.mapaPocetnoB = this.server.getDnevnoStanjeBelo(this.day1, o, PomocniUpit.artikliBezSlozenih(o));
                this.mapaIzlazB = this.server.getPeriodicnoStanjeBeloIzlaz(this.day1, this.day2, o, PomocniUpit.artikliBezSlozenih(o));
                this.mapaUlazB = this.server.getPeriodicnoStanjeBeloUlaz(this.day1, this.day2, o, PomocniUpit.artikliBezSlozenih(o));
            }
            if (this.isCrno) {
                this.mapaPocetnoC = this.server.getDnevnoStanjeCrno(this.day1, o, PomocniUpit.artikliBezSlozenih(o));
                this.mapaIzlazC = this.server.getPeriodicnoStanjeCrnoIzlaz(this.day1, this.day2, o, PomocniUpit.artikliBezSlozenih(o));
                this.mapaUlazC = this.server.getPeriodicnoStanjeCrnoUlaz(this.day1, this.day2, o, PomocniUpit.artikliBezSlozenih(o));
            }
            TableItem ti = new TableItem(this.table, 0);
            ti.setText(0, o.getNaziv());
            this.artikli = this.server.getArtikliBezSlozISirOdeljenje2(o.getId());
            this.artikli2.clear();
            for (Artikal a : this.artikli.values()) {
                this.artikli2.add(a);
            }
            this.sortiraj(this.artikli2);
            for (Artikal a : this.artikli2) {
                izlaz = this.izracunajIzlaz(a);
                if (this.blic && izlaz == 0.0) continue;
                ti = new TableItem(this.table, 0);
                ti.setText(new String[]{"", a.getName(), a.getJedinicaMere(), Konstante.getNumber4(izlaz)});
            }
            ti = new TableItem(this.table, 0);
            ti = new TableItem(this.table, 0);
            ti.setText(0, "SIROVINE " + o.getNaziv());
            this.artikli = this.server.getArtikliSirovineOdeljenje2(o.getId());
            this.artikli2.clear();
            for (Artikal a : this.artikli.values()) {
                this.artikli2.add(a);
            }
            this.sortiraj(this.artikli2);
            for (Artikal a : this.artikli2) {
                izlaz = this.izracunajIzlaz(a);
                double ulaz = this.izracunajUlaz(a);
                if (this.blic && ulaz == 0.0 && izlaz == 0.0) continue;
                double pocetno = this.izracunajPocetno(a);
                double zavrsno = pocetno + ulaz - izlaz;
                double vrednost = zavrsno * a.getTrenutnaNV();
                this.ukupno += vrednost;
                ti = new TableItem(this.table, 0);
                ti.setText(new String[]{"", a.getName(), a.getJedinicaMere(), Konstante.getNumber4(izlaz)});
            }
        }
        TableItem ti = new TableItem(this.table, 0);
        ti = new TableItem(this.table, 0);
        if (this.finansijski) {
            ti.setText(3, "Total");
            ti.setText(4, Konstante.getNumber2(this.ukupnoPoc));
            ti.setText(5, "Total");
            ti.setText(6, Konstante.getNumber2(this.ukupnoUl));
            ti.setText(7, "Total");
            ti.setText(8, Konstante.getNumber2(this.ukupnoPro));
            ti.setText(9, "Total");
            ti.setText(10, Konstante.getNumber2(this.ukupno));
        } else {
            ti.setText(0, "Ukupna vrednost zaliha");
            ti.setText(7, Konstante.getNumber2(this.ukupno));
        }
    }

    public void sortiraj(List<Artikal> artikli) {
        Comparator<Artikal> SENIORITY_ORDER = null;
        SENIORITY_ORDER = new Comparator<Artikal>(){

            @Override
            public int compare(Artikal t1, Artikal t2) {
                return t1.getName().compareTo(t2.getName());
            }
        };
        Collections.sort(artikli, SENIORITY_ORDER);
    }

    DnevnoStanje getDS(Artikal a) {
        if (this.stanjaDanas == null) {
            return null;
        }
        for (DnevnoStanje ds : this.stanjaDanas) {
            if (!ds.getArtikalID().equals(a.getId())) continue;
            return ds;
        }
        return null;
    }
}

