/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.stampa;

import com.dev63.fiscal.fp550.PoreskaGrupa;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.constants.StatLogic;
import com.dev63.restoran.model.GrupaArtikala;
import com.dev63.restoran.model.NacinPlacanja;
import com.dev63.restoran.model.Placanje;
import com.dev63.restoran.model.Racun;
import com.dev63.restoran.model.Stampac;
import com.dev63.restoran.model.StavkaRacuna;
import com.dev63.restoran.stampa.NPrintUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class StampaZRepAustria {
    private RestoranServer server;
    private Date from;
    private Date to;
    private Stampac stampac;

    /*
     * WARNING - void declaration
     */
    public StampaZRepAustria(RestoranServer serverica, Date date1, Date date2) throws Exception {
        if (serverica == null) {
            throw new IllegalArgumentException("Argument serverica cannot be null");
        }
        if (date1 == null) {
            throw new IllegalArgumentException("Argument date1 cannot be null");
        }
        if (date2 == null) {
            throw new IllegalArgumentException("Argument date2 cannot be null");
        }
        if (date1.compareTo(new Date()) > 0) {
            throw new IllegalArgumentException("Argument date1 cannot be after current time");
        }
        if (date2.compareTo(new Date()) > 0) {
            throw new IllegalArgumentException("Argument date2 cannot be after current time");
        }
        if (date1.compareTo(date2) > 0) {
            throw new IllegalArgumentException("Argument date1 cannot be after date2");
        }
        this.server = serverica;
        this.from = Konstante.getPocetniDatum(date1, this.server);
        this.to = Konstante.getKrajnjiDatum(date2, this.server);
        this.stampac = this.server.readIzvestajiStampacObject();
        int stornoCount = this.server.getStornoCount(this.from, this.to, null);
        double stornoSum = this.server.getStornoSum(this.from, this.to, null);
        List<Racun> racuni = this.server.getRacuni(this.from, this.to, null);
        List<GrupaArtikala> grupe = this.server.readGrupeArtikala();
        HashMap<GrupaArtikala, Double> mapaKolPoGrupi = new HashMap<GrupaArtikala, Double>();
        HashMap<GrupaArtikala, Double> mapaIznosaPoGrupi = new HashMap<GrupaArtikala, Double>();
        HashMap<PoreskaGrupa, Double> mapaIznosaPoPG = new HashMap<PoreskaGrupa, Double>();
        HashMap<NacinPlacanja, Double> mapaIznosaPoPL = new HashMap<NacinPlacanja, Double>();
        HashMap<NacinPlacanja, Integer> mapaBRPoPL = new HashMap<NacinPlacanja, Integer>();
        Double total = 0.0;
        Integer br = 0;
        Double kolTotal = 0.0;
        for (Racun racun : racuni) {
            for (StavkaRacuna stavkaRacuna : racun.getStavke1()) {
                if (StatLogic.round(stavkaRacuna.getCena(), 2) == 0.0) continue;
                GrupaArtikala grupa = stavkaRacuna.getArtikal().getPodgrupa().getGrupa();
                PoreskaGrupa pg = stavkaRacuna.getArtikal().getPoreskaGrupa();
                if (!mapaKolPoGrupi.containsKey(grupa)) {
                    mapaKolPoGrupi.put(grupa, 0.0);
                }
                if (!mapaIznosaPoGrupi.containsKey(grupa)) {
                    mapaIznosaPoGrupi.put(grupa, 0.0);
                }
                if (!mapaIznosaPoPG.containsKey(pg)) {
                    mapaIznosaPoPG.put(pg, 0.0);
                }
                mapaKolPoGrupi.put(grupa, (Double)mapaKolPoGrupi.get(grupa) + stavkaRacuna.getKolicina());
                kolTotal = kolTotal + stavkaRacuna.getKolicina();
                mapaIznosaPoGrupi.put(grupa, (Double)mapaIznosaPoGrupi.get(grupa) + stavkaRacuna.getVrednostSaPopustom());
                mapaIznosaPoPG.put(pg, (Double)mapaIznosaPoPG.get(pg) + stavkaRacuna.getVrednostSaPopustom());
            }
            for (Placanje placanje : racun.getPlacanja()) {
                if (StatLogic.round(placanje.getIznos(), 2) == 0.0) continue;
                if (!mapaIznosaPoPL.containsKey((Object)placanje.getNacin())) {
                    mapaIznosaPoPL.put(placanje.getNacin(), 0.0);
                }
                if (!mapaBRPoPL.containsKey((Object)placanje.getNacin())) {
                    mapaBRPoPL.put(placanje.getNacin(), 0);
                }
                mapaIznosaPoPL.put(placanje.getNacin(), (Double)mapaIznosaPoPL.get((Object)placanje.getNacin()) + placanje.getIznos());
                mapaBRPoPL.put(placanje.getNacin(), (Integer)mapaBRPoPL.get((Object)placanje.getNacin()) + 1);
            }
            total = total + racun.total();
            Integer n = br;
            Integer n2 = br = Integer.valueOf(br + 1);
        }
        int bkur = this.stampac.getTip().getBrojKarakteraURedu();
        byte[] dblWOn = this.stampac.getTip().getEmulacija().getDblWdthOn();
        byte[] dblWOff = this.stampac.getTip().getEmulacija().getDblWdthOff();
        boolean bl = false;
        String content = "";
        String dat1 = new SimpleDateFormat("dd/MM/yy").format(date1);
        String dat2 = new SimpleDateFormat("dd/MM/yy").format(date2);
        content = content + NPrintUtils.centerSplitToEnds(bkur, dat1, dat2) + "\n";
        content = content + NPrintUtils.minusFill(bkur) + "\n";
        content = content + NPrintUtils.leftText(bkur, "Sparte/Gruppe") + "\n";
        content = content + NPrintUtils.spaceFill(bkur) + "\n";
        for (GrupaArtikala ga : grupe) {
            void var20_26;
            if (!mapaKolPoGrupi.containsKey(ga)) continue;
            ++var20_26;
            content = content + NPrintUtils.centerSplitToEnds(bkur, ga.getNaziv(), StatLogic.getNumber02NG((Double)mapaIznosaPoGrupi.get(ga))) + "\n";
        }
        content = content + NPrintUtils.centerSplitToEnds(bkur, "Gruppe1", StatLogic.getNumber02NG(total)) + "\n";
        content = content + NPrintUtils.minusFill(bkur) + "\n";
        content = content + NPrintUtils.centerSplitToEnds(bkur - 10, "*Sparte ges.", StatLogic.getNumber03NG(kolTotal) + " Q") + NPrintUtils.rightText(10, StatLogic.getNumber02NG(total)) + "\n";
        content = content + NPrintUtils.minusFill(bkur) + "\n";
        content = content + NPrintUtils.leftText(bkur, "Transaktion") + "\n";
        content = content + NPrintUtils.spaceFill(bkur) + "\n";
        content = content + NPrintUtils.centerSplitToEnds(bkur, new String(dblWOn) + "Brutto" + new String(dblWOff), StatLogic.getNumber02NG(total)) + "\n";
        content = content + NPrintUtils.minusFill(bkur) + "\n";
        double netoTotal = 0.0;
        for (PoreskaGrupa poreskaGrupa : PoreskaGrupa.values()) {
            if (!mapaIznosaPoPG.containsKey(poreskaGrupa)) continue;
            double iznos = (Double)mapaIznosaPoPG.get(poreskaGrupa);
            double procenat = Konstante.getPGStopaProcenatCeoBroj(poreskaGrupa);
            double neto = Konstante.getOsnovicaFromBruto(poreskaGrupa, iznos);
            double porez = Konstante.getPorezFromBruto(iznos, poreskaGrupa);
            netoTotal += neto;
            content = content + NPrintUtils.centerSplitToEnds(bkur, "Summe " + StatLogic.getNumber0(procenat) + "%", StatLogic.getNumber02NG(iznos)) + "\n";
            content = content + NPrintUtils.centerSplitToEnds(bkur, "MwSt " + StatLogic.getNumber0(procenat) + "%", StatLogic.getNumber02NG(porez)) + "\n";
        }
        content = content + NPrintUtils.centerSplitToEnds(bkur, new String(dblWOn) + "Netto" + new String(dblWOff), StatLogic.getNumber02NG(netoTotal)) + "\n";
        content = content + NPrintUtils.minusFill(bkur) + "\n";
        content = content + NPrintUtils.centerSplitToEnds(bkur - 9, "Storno", stornoCount + " Q") + NPrintUtils.rightText(9, StatLogic.getNumber02NG(stornoSum)) + "\n";
        content = content + NPrintUtils.minusFill(bkur) + "\n";
        content = content + NPrintUtils.centerSplitToEnds(bkur, "Gesamtbest.", StatLogic.getNumber02NG(total)) + "\n";
        content = content + NPrintUtils.centerSplitToEnds(bkur, "Gesamt bez.", StatLogic.getNumber02NG(total)) + "\n";
        content = content + NPrintUtils.centerSplitToEnds(bkur, "Durchschnitt", StatLogic.getNumber02NG(total / br.doubleValue())) + "\n";
        content = content + NPrintUtils.minusFill(bkur);
        for (NacinPlacanja nacinPlacanja : NacinPlacanja.values()) {
            if (!mapaBRPoPL.containsKey((Object)nacinPlacanja)) continue;
            content = content + NPrintUtils.centerSplitToEnds(bkur - 9, new String(dblWOn) + nacinPlacanja.getOpis() + new String(dblWOff), mapaBRPoPL.get((Object)nacinPlacanja) + " Q") + NPrintUtils.rightText(9, StatLogic.getNumber02NG((Double)mapaIznosaPoPL.get((Object)nacinPlacanja))) + "\n";
        }
        content = content + NPrintUtils.minusFill(bkur);
        System.out.println("content = " + content);
        NPrintUtils.printContent(content, this.stampac, 1);
    }
}

