/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.stampa;

import com.dev63.restoran.Konstante;
import com.dev63.restoran.constants.StatLogic;
import com.dev63.restoran.model.Stampac;
import com.dev63.restoran.model.Trebovanje;
import com.dev63.restoran.model.TrebovanjeStavka;
import com.dev63.restoran.stampa.NPrintUtils;

public class StampaTrebovanjaUska {
    private final Trebovanje trebovanje;
    private final Stampac stampac;
    private final int brojKopija;

    public StampaTrebovanjaUska(Trebovanje trebovanje, Stampac stampac, int brojKopija) throws IllegalArgumentException {
        this.trebovanje = trebovanje;
        if (this.trebovanje == null) {
            throw new IllegalArgumentException("Argument trebovanje cannot be null");
        }
        this.stampac = stampac;
        if (this.stampac == null) {
            throw new IllegalArgumentException("Argument trebovanje cannot be null");
        }
        this.brojKopija = brojKopija;
        this.print();
    }

    private void print() {
        int bkur = this.stampac.getTip().getBrojKarakteraURedu();
        String content = NPrintUtils.equalsFill(bkur) + "\n";
        String dokumentL = String.format(Konstante.getBundle().getString("TEXT_DOKUMENT"), new Object[0]);
        String dokument = this.trebovanje.getTip() != null ? this.trebovanje.getTip().getInterName() : String.format(Konstante.getBundle().getString("TEXT_BROJ_SKR"), new Object[0]) + ": " + this.trebovanje.getBrTrebovanja();
        content = content + NPrintUtils.centerText(bkur, (dokumentL.length() + 2 + dokument.length() > bkur ? "" : dokumentL + ": ") + dokument) + "\n";
        if (this.trebovanje.getTip() != null) {
            content = content + NPrintUtils.centerText(bkur, String.format(Konstante.getBundle().getString("TEXT_BROJ_SKR"), new Object[0]) + ": " + this.trebovanje.getBrTrebovanja()) + "\n";
        }
        content = content + NPrintUtils.centerSplitToEnds(bkur, String.format(Konstante.getBundle().getString("TEXT_DATUM"), new Object[0]), StatLogic.getDateString(this.trebovanje.getDatumTrebovanja())) + "\n";
        content = content + NPrintUtils.minusFill(bkur) + "\n";
        for (TrebovanjeStavka ts : this.trebovanje.getStavke()) {
            String kol = StatLogic.getNumber04NGF(ts.getKolicina());
            content = content + NPrintUtils.articleAmmountRightRow(bkur, ts.getArtikal().getName(), kol) + "\n";
        }
        content = content + NPrintUtils.equalsFill(bkur);
        NPrintUtils.printContent(content, this.stampac, this.brojKopija);
    }
}

