/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.stampa;

import com.dev63.fiscal.FiscalPrinter;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.model.Odeljenje;
import com.dev63.restoran.model.Stampac;
import com.dev63.restoran.model.TipStampaca;
import com.dev63.restoran.parts.XMLWriter;
import com.dev63.restoran.parts.XMLWriterHCP;
import com.dev63.restoran.stampa.StampaPorudzbine;
import com.dev63.restoran.stampa.StringAlign;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.SimpleDoc;
import javax.print.attribute.HashPrintRequestAttributeSet;
import org.apache.commons.lang.StringUtils;

public class StampaSifrarnikArtikala {
    File print;
    FileOutputStream fos = null;
    FileInputStream fis = null;
    String naziv;
    RestoranServer server;
    boolean odstampanazbirna = false;
    Stampac stampac;
    FiscalPrinter fiscal;

    public StampaSifrarnikArtikala(Restoran restoran, Map<Long, String> artikli, Odeljenje odeljenje) {
        this.server = restoran.getServer();
        this.fiscal = restoran.getFiscal();
        this.print = new File(System.getProperty("user.home"));
        this.print = new File(this.print, "restoran_print");
        if (!this.print.isDirectory()) {
            this.print.mkdir();
        }
        try {
            this.stampac = this.server.readIzvestajiStampacObject();
            if (this.server.getStampacTipByNaziv(this.stampac.getNaziv()).equalsIgnoreCase("HCPP2DS")) {
                String print = this.writeInString(restoran, artikli, odeljenje, 0);
                this.printFromString(this.stampac.getNaziv(), print);
            } else {
                if (this.server.getStampacTipByNaziv(this.stampac.getNaziv()).equalsIgnoreCase("EPSONTMT")) {
                    this.writeInFile(restoran, artikli, odeljenje, 4);
                } else if (this.server.getStampacTipByNaziv(this.stampac.getNaziv()).equalsIgnoreCase("EPP")) {
                    this.writeInFile(restoran, artikli, odeljenje, 8);
                } else {
                    this.writeInFile(restoran, artikli, odeljenje, 0);
                }
                this.printFromFile(this.naziv, this.stampac.getNaziv());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
        }
    }

    public String writeInString(Restoran restoran, Map<Long, String> artikli, Odeljenje odeljenje, int extraLinija) {
        String print = "";
        String od = odeljenje == null ? "Sva proizvodna mesta" : odeljenje.getNaziv();
        print = print + StringUtils.center((String)"Sifrarnik artikala", (int)32);
        print = print + StringUtils.center((String)od, (int)32);
        print = print + StringUtils.center((String)"", (int)32);
        print = print + StringUtils.center((String)"Artikal                    Sifra", (int)32);
        print = print + "--------------------------------";
        Set<Long> barkodovi = artikli.keySet();
        for (Long kljuc : barkodovi) {
            String barkod = kljuc.toString();
            String ime = artikli.get(kljuc);
            print = print + new StringAlign(32 - barkod.length() - 1, 108).format(ime);
            print = print + new StringAlign(1, 99).format(" ");
            print = print + new StringAlign(barkod.length(), 114).format(barkod);
        }
        print = print + "--------------------------------";
        for (int i = 0; i < extraLinija; ++i) {
            print = print + StringUtils.center((String)"", (int)32);
        }
        return print;
    }

    public void printFromString(String stampac, String print) {
        try {
            XMLWriterHCP.writeNonFiscal(print);
        }
        catch (Exception ex) {
            Logger.getLogger(StampaPorudzbine.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void writeInFile(Restoran restoran, Map<Long, String> artikli, Odeljenje odeljenje, int extraLinija) {
        try {
            this.fos = new FileOutputStream(this.print.getCanonicalPath() + "\\konobar.txt");
            PrintStream ps = new PrintStream(this.fos);
            String od = odeljenje == null ? "Sva proizvodna mesta" : odeljenje.getNaziv();
            ps.println(StringUtils.center((String)"Sifrarnik artikala", (int)34));
            ps.println(StringUtils.center((String)od, (int)34));
            ps.println();
            ps.println(StringUtils.center((String)"Artikal                      Sifra", (int)34));
            ps.println("----------------------------------");
            Set<Long> barkodovi = artikli.keySet();
            for (Long kljuc : barkodovi) {
                String barkod = kljuc.toString();
                String ime = artikli.get(kljuc);
                ps.println(new StringAlign(34 - barkod.length() - 1, 108).format(ime));
                ps.println(new StringAlign(1, 99).format(" "));
                ps.println(new StringAlign(barkod.length(), 114).format(barkod));
            }
            ps.println("----------------------------------");
            for (int i = 0; i < extraLinija; ++i) {
                ps.println();
            }
            this.fos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                this.fos.close();
            }
            catch (IOException ex) {
                Logger.getLogger(StampaSifrarnikArtikala.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void printFromFile(String putanja, String stampacN) {
        try {
            byte[] by;
            if (stampacN.equals(TipStampaca.FP550.toString())) {
                String strLine;
                this.fis = new FileInputStream(this.print.getCanonicalPath() + "\\konobar.txt");
                DataInputStream in = new DataInputStream(this.fis);
                BufferedReader br = new BufferedReader(new InputStreamReader(in));
                ArrayList<String> text = new ArrayList<String>();
                while ((strLine = br.readLine()) != null) {
                    text.add(strLine);
                }
                XMLWriter.writeNonFiscal(text);
                return;
            }
            DocFlavor flavor = DocFlavor.INPUT_STREAM.AUTOSENSE;
            HashPrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();
            PrintService[] pservices = PrintServiceLookup.lookupPrintServices(flavor, aset);
            DocPrintJob pj = null;
            DocPrintJob pj2 = null;
            for (PrintService printer : pservices) {
                if (!printer.getName().toUpperCase().contains(stampacN.toUpperCase())) continue;
                pj = printer.createPrintJob();
                pj2 = printer.createPrintJob();
            }
            this.fis = new FileInputStream(this.print.getCanonicalPath() + "\\konobar.txt");
            SimpleDoc doc = new SimpleDoc(this.fis, flavor, null);
            pj.print(doc, aset);
            this.fis.close();
            flavor = DocFlavor.BYTE_ARRAY.AUTOSENSE;
            switch (this.stampac.getTip()) {
                case STARTCP100: {
                    by = new byte[]{27, 100, 51};
                    break;
                }
                default: {
                    by = new byte[]{27, 105};
                }
            }
            SimpleDoc doc2 = new SimpleDoc(by, flavor, null);
            pj2.print(doc2, aset);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            try {
                this.fis.close();
            }
            catch (IOException ex1) {
                Logger.getLogger(StampaSifrarnikArtikala.class.getName()).log(Level.SEVERE, null, ex1);
            }
        }
    }
}

