/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.stampa;

import com.dev63.fiscal.fp550.PoreskaGrupa;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.constants.StatLogic;
import com.dev63.restoran.model.Artikal;
import com.dev63.restoran.model.CrnoPlacanje;
import com.dev63.restoran.model.JedMere;
import com.dev63.restoran.model.Konobar;
import com.dev63.restoran.model.NacinPlacanja;
import com.dev63.restoran.model.Placanje;
import com.dev63.restoran.model.Racun;
import com.dev63.restoran.model.Stampac;
import com.dev63.restoran.model.StavkaRacuna;
import com.dev63.restoran.model.TipStampaca;
import com.dev63.restoran.model.Tura;
import com.dev63.restoran.stampa.StringAlign;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.SimpleDoc;
import javax.print.attribute.HashPrintRequestAttributeSet;

public class StampaRacunaAustrija {
    Stampac stampac;
    int brojKopija = 1;
    String codePage;
    String nazivPoslovnice;
    String pibPrefix;
    String pib;
    String adresa;
    String mesto;
    String telefon;
    String header1;
    String header2;
    String header3;
    String header4;
    String footer1;
    String footer2;
    String footer3;
    String footer4;

    public StampaRacunaAustrija(Racun racun, Stampac stampac, String nazivPoslovnice, String pibPrefix, String pib, String adresa, String mesto, String telefon, String header1, String header2, String header3, String header4, String footer1, String footer2, String footer3, String footer4) {
        this.nazivPoslovnice = nazivPoslovnice;
        this.pibPrefix = pibPrefix;
        this.pib = pib;
        this.adresa = adresa;
        this.mesto = mesto;
        this.telefon = telefon;
        this.header1 = header1;
        this.header2 = header2;
        this.header3 = header3;
        this.header4 = header4;
        this.footer1 = footer1;
        this.footer2 = footer2;
        this.footer3 = footer3;
        this.footer4 = footer4;
        this.stampac = stampac;
        this.codePage = stampac.getKodnaStrana();
        this.writeInFile(racun, stampac.getTip().getBrojDodatnihLinija(), stampac.getTip().getBrojKarakteraURedu());
    }

    public void writeInFile(Racun racun, int extraLinija, int brojKarakteraURedu) {
        int i;
        Object por;
        PoreskaGrupa pg;
        char[] ela = new char[brojKarakteraURedu];
        char[] mla = new char[brojKarakteraURedu];
        Arrays.fill(ela, '=');
        Arrays.fill(mla, '-');
        String content = "";
        content = content + new String(ela) + "\n";
        content = content + new String(new byte[]{27, 33, 48});
        String[] title = this.nazivPoslovnice.split(" ");
        String red = "";
        boolean idx = false;
        content = content + new StringAlign(brojKarakteraURedu / 2, 99).format(this.nazivPoslovnice) + "\n";
        if (this.header1 != null) {
            content = content + new StringAlign(brojKarakteraURedu / 2, 99).format(this.header1) + "\n";
        }
        content = content + new String(new byte[]{27, 33, 0});
        content = content + "\n";
        content = content + new StringAlign(brojKarakteraURedu, 99).format((this.pibPrefix == null ? "" : this.pibPrefix) + this.pib) + "\n";
        content = content + new StringAlign(brojKarakteraURedu, 99).format((this.adresa == null ? "" : this.adresa) + (this.mesto == null ? "" : " " + this.mesto)) + "\n";
        content = content + new StringAlign(brojKarakteraURedu, 99).format(this.telefon == null ? "" : "Tel. " + this.telefon) + "\n";
        content = content + "\n";
        if (this.header2 != null) {
            content = content + new StringAlign(brojKarakteraURedu, 99).format(this.header2) + "\n";
        }
        if (this.header3 != null) {
            content = content + new StringAlign(brojKarakteraURedu, 99).format(this.header3) + "\n";
        }
        if (this.header4 != null) {
            content = content + new StringAlign(brojKarakteraURedu, 99).format(this.header4) + "\n";
        }
        content = content + "\n";
        content = content + new StringAlign(brojKarakteraURedu, 108).format("RECHNUNG") + "\n";
        content = content + "\n";
        content = content + new StringAlign(brojKarakteraURedu, 108).format(StatLogic.getDateString(racun.getDatum()) + " " + StatLogic.getTimeString(racun.getDatum())) + "\n";
        content = content + "\n";
        content = content + new StringAlign(brojKarakteraURedu, 108).format("Beleg-Nr " + racun.getBrojRacuna()) + "\n";
        content = content + "\n";
        content = content + new StringAlign(brojKarakteraURedu, 108).format("Tisch " + racun.getBrojStola()) + "\n";
        content = content + "\n";
        double razlika = 0.0;
        double total = 0.0;
        double zbir1 = 0.0;
        double zbir2 = 0.0;
        double zbir3 = 0.0;
        double zbir4 = 0.0;
        double zbir5 = 0.0;
        double zbir6 = 0.0;
        double zbir7 = 0.0;
        double zbir8 = 0.0;
        double zbir9 = 0.0;
        double pTotal = 0.0;
        content = content + new StringAlign(brojKarakteraURedu / 2, 108).format("Artikel") + new StringAlign(brojKarakteraURedu - brojKarakteraURedu / 2, 114).format("Preis") + "\n";
        content = content + new String(mla) + "\n";
        block15: for (StavkaRacuna sr : racun.getStavke()) {
            Artikal art = sr.getArtikal();
            double tmp = sr.getCena() - sr.getArtikal().getCena();
            content = content + new StringAlign(brojKarakteraURedu, 108).format(art.getName().toUpperCase()) + "\n";
            content = content + new StringAlign(brojKarakteraURedu - 12 - 12 - 2, 99).format(StatLogic.getNumber03F(sr.getKolicina()) + "x");
            content = content + new StringAlign(12, 114).format(StatLogic.getNumber02NG(sr.getCena()));
            content = content + new StringAlign(12, 114).format(StatLogic.getNumber02NG(sr.getVrednostSaPopustom()));
            content = content + new StringAlign(2, 114).format(StampaRacunaAustrija.getPGMark(art.getPoreskaGrupa())) + "\n";
            total += sr.getVrednostSaPopustom().doubleValue();
            switch (art.getPoreskaGrupa()) {
                case GRUPA_A: {
                    zbir1 += sr.getCena() * sr.getKolicina();
                    continue block15;
                }
                case GRUPA_G: {
                    zbir2 += sr.getCena() * sr.getKolicina();
                    continue block15;
                }
                case GRUPA_D: {
                    zbir3 += sr.getCena() * sr.getKolicina();
                    continue block15;
                }
                case GRUPA_DJ: {
                    zbir4 += sr.getCena() * sr.getKolicina();
                    continue block15;
                }
                case GRUPA_E: {
                    zbir5 += sr.getCena() * sr.getKolicina();
                    continue block15;
                }
                case GRUPA_ZJ: {
                    zbir6 += sr.getCena() * sr.getKolicina();
                    continue block15;
                }
                case GRUPA_I: {
                    zbir7 += sr.getCena() * sr.getKolicina();
                    continue block15;
                }
                case GRUPA_J: {
                    zbir8 += sr.getCena() * sr.getKolicina();
                    continue block15;
                }
                case GRUPA_K: {
                    zbir9 += sr.getCena() * sr.getKolicina();
                    continue block15;
                }
            }
            zbir1 += sr.getCena() * sr.getKolicina();
        }
        content = content + new String(mla) + "\n";
        content = content + new String(new byte[]{27, 33, 16});
        content = content + new StringAlign(10, 108).format("SUMME EUR:") + new StringAlign(brojKarakteraURedu - 10, 114).format(StatLogic.getNumber02NG(total)) + "\n";
        content = content + "\n";
        content = content + new String(new byte[]{27, 33, 0}) + "\n";
        LinkedList porezi = new LinkedList();
        if (zbir1 > 0.0) {
            pg = PoreskaGrupa.GRUPA_A;
            double porez = Konstante.getPorezFromBruto(zbir1, pg);
            por = "";
            por = (String)por + new StringAlign(5, 114).format(StatLogic.getNumber01NG(Konstante.getPGStopaProcenat(pg)) + "%");
            por = (String)por + " MwSt ";
            por = (String)por + "(" + StampaRacunaAustrija.getPGMark(pg) + ") ";
            if (((String)(por = (String)por + new StringAlign(6, 114).format(StatLogic.getNumber02NG(porez)))).length() > brojKarakteraURedu - 15) {
                por = new StringAlign(brojKarakteraURedu, 108).format((String)por) + "\n";
                por = (String)por + new StringAlign(brojKarakteraURedu - 8, 114).format("Netto ") + new StringAlign(8, 114).format(StatLogic.getNumber02NG(Konstante.getOsnovicaFromBruto(pg, zbir1)));
            } else {
                por = (String)por + new StringAlign(brojKarakteraURedu - ((String)por).length() - 8, 114).format("Netto ") + new StringAlign(8, 114).format(StatLogic.getNumber02NG(Konstante.getOsnovicaFromBruto(pg, zbir1)));
            }
            content = content + (String)por + "\n";
            pTotal += porez;
        }
        if (zbir2 > 0.0) {
            pg = PoreskaGrupa.GRUPA_G;
            double porez = Konstante.getPorezFromBruto(zbir2, pg);
            por = "";
            por = (String)por + new StringAlign(5, 114).format(StatLogic.getNumber01NG(Konstante.getPGStopaProcenat(pg)) + "%");
            por = (String)por + " MwSt ";
            por = (String)por + "(" + StampaRacunaAustrija.getPGMark(pg) + ") ";
            if (((String)(por = (String)por + new StringAlign(6, 114).format(StatLogic.getNumber02NG(porez)))).length() > brojKarakteraURedu - 15) {
                por = new StringAlign(brojKarakteraURedu, 108).format((String)por) + "\n";
                por = (String)por + new StringAlign(brojKarakteraURedu - 8, 114).format("Netto ") + new StringAlign(8, 114).format(StatLogic.getNumber02NG(Konstante.getOsnovicaFromBruto(pg, zbir2)));
            } else {
                por = (String)por + new StringAlign(brojKarakteraURedu - ((String)por).length() - 8, 114).format("Netto ") + new StringAlign(8, 114).format(StatLogic.getNumber02NG(Konstante.getOsnovicaFromBruto(pg, zbir2)));
            }
            content = content + (String)por + "\n";
            pTotal += porez;
        }
        if (zbir3 > 0.0) {
            pg = PoreskaGrupa.GRUPA_D;
            double porez = Konstante.getPorezFromBruto(zbir3, pg);
            por = "";
            por = (String)por + new StringAlign(5, 114).format(StatLogic.getNumber01NG(Konstante.getPGStopaProcenat(pg)) + "%");
            por = (String)por + " MwSt ";
            por = (String)por + "(" + StampaRacunaAustrija.getPGMark(pg) + ") ";
            if (((String)(por = (String)por + new StringAlign(6, 114).format(StatLogic.getNumber02NG(porez)))).length() > brojKarakteraURedu - 15) {
                por = new StringAlign(brojKarakteraURedu, 108).format((String)por) + "\n";
                por = (String)por + new StringAlign(brojKarakteraURedu - 8, 114).format("Netto ") + new StringAlign(8, 114).format(StatLogic.getNumber02NG(Konstante.getOsnovicaFromBruto(pg, zbir3)));
            } else {
                por = (String)por + new StringAlign(brojKarakteraURedu - ((String)por).length() - 8, 114).format("Netto ") + new StringAlign(8, 114).format(StatLogic.getNumber02NG(Konstante.getOsnovicaFromBruto(pg, zbir3)));
            }
            content = content + (String)por + "\n";
            pTotal += porez;
        }
        if (zbir4 > 0.0) {
            pg = PoreskaGrupa.GRUPA_DJ;
            double porez = Konstante.getPorezFromBruto(zbir4, pg);
            por = "";
            por = (String)por + new StringAlign(5, 114).format(StatLogic.getNumber01NG(Konstante.getPGStopaProcenat(pg)) + "%");
            por = (String)por + " MwSt ";
            por = (String)por + "(" + StampaRacunaAustrija.getPGMark(pg) + ") ";
            if (((String)(por = (String)por + new StringAlign(6, 114).format(StatLogic.getNumber02NG(porez)))).length() > brojKarakteraURedu - 15) {
                por = new StringAlign(brojKarakteraURedu, 108).format((String)por) + "\n";
                por = (String)por + new StringAlign(brojKarakteraURedu - 8, 114).format("Netto ") + new StringAlign(8, 114).format(StatLogic.getNumber02NG(Konstante.getOsnovicaFromBruto(pg, zbir4)));
            } else {
                por = (String)por + new StringAlign(brojKarakteraURedu - ((String)por).length() - 8, 114).format("Netto ") + new StringAlign(8, 114).format(StatLogic.getNumber02NG(Konstante.getOsnovicaFromBruto(pg, zbir4)));
            }
            content = content + (String)por + "\n";
            pTotal += porez;
        }
        if (zbir5 > 0.0) {
            pg = PoreskaGrupa.GRUPA_E;
            double porez = Konstante.getPorezFromBruto(zbir5, pg);
            por = "";
            por = (String)por + new StringAlign(5, 114).format(StatLogic.getNumber01NG(Konstante.getPGStopaProcenat(pg)) + "%");
            por = (String)por + " MwSt ";
            por = (String)por + "(" + StampaRacunaAustrija.getPGMark(pg) + ") ";
            if (((String)(por = (String)por + new StringAlign(6, 114).format(StatLogic.getNumber02NG(porez)))).length() > brojKarakteraURedu - 15) {
                por = new StringAlign(brojKarakteraURedu, 108).format((String)por) + "\n";
                por = (String)por + new StringAlign(brojKarakteraURedu - 8, 114).format("Netto ") + new StringAlign(8, 114).format(StatLogic.getNumber02NG(Konstante.getOsnovicaFromBruto(pg, zbir5)));
            } else {
                por = (String)por + new StringAlign(brojKarakteraURedu - ((String)por).length() - 8, 114).format("Netto ") + new StringAlign(8, 114).format(StatLogic.getNumber02NG(Konstante.getOsnovicaFromBruto(pg, zbir5)));
            }
            content = content + (String)por + "\n";
            pTotal += porez;
        }
        if (zbir6 > 0.0) {
            pg = PoreskaGrupa.GRUPA_ZJ;
            double porez = Konstante.getPorezFromBruto(zbir6, pg);
            por = "";
            por = (String)por + new StringAlign(5, 114).format(StatLogic.getNumber01NG(Konstante.getPGStopaProcenat(pg)) + "%");
            por = (String)por + " MwSt ";
            por = (String)por + "(" + StampaRacunaAustrija.getPGMark(pg) + ") ";
            if (((String)(por = (String)por + new StringAlign(6, 114).format(StatLogic.getNumber02NG(porez)))).length() > brojKarakteraURedu - 15) {
                por = new StringAlign(brojKarakteraURedu, 108).format((String)por) + "\n";
                por = (String)por + new StringAlign(brojKarakteraURedu - 8, 114).format("Netto ") + new StringAlign(8, 114).format(StatLogic.getNumber02NG(Konstante.getOsnovicaFromBruto(pg, zbir6)));
            } else {
                por = (String)por + new StringAlign(brojKarakteraURedu - ((String)por).length() - 8, 114).format("Netto ") + new StringAlign(8, 114).format(StatLogic.getNumber02NG(Konstante.getOsnovicaFromBruto(pg, zbir6)));
            }
            content = content + (String)por + "\n";
            pTotal += porez;
        }
        if (zbir7 > 0.0) {
            pg = PoreskaGrupa.GRUPA_I;
            double porez = Konstante.getPorezFromBruto(zbir7, pg);
            por = "";
            por = (String)por + new StringAlign(5, 114).format(StatLogic.getNumber01NG(Konstante.getPGStopaProcenat(pg)) + "%");
            por = (String)por + " MwSt ";
            por = (String)por + "(" + StampaRacunaAustrija.getPGMark(pg) + ") ";
            if (((String)(por = (String)por + new StringAlign(6, 114).format(StatLogic.getNumber02NG(porez)))).length() > brojKarakteraURedu - 15) {
                por = new StringAlign(brojKarakteraURedu, 108).format((String)por) + "\n";
                por = (String)por + new StringAlign(brojKarakteraURedu - 8, 114).format("Netto ") + new StringAlign(8, 114).format(StatLogic.getNumber02NG(Konstante.getOsnovicaFromBruto(pg, zbir7)));
            } else {
                por = (String)por + new StringAlign(brojKarakteraURedu - ((String)por).length() - 8, 114).format("Netto ") + new StringAlign(8, 114).format(StatLogic.getNumber02NG(Konstante.getOsnovicaFromBruto(pg, zbir7)));
            }
            content = content + (String)por + "\n";
            pTotal += porez;
        }
        if (zbir8 > 0.0) {
            pg = PoreskaGrupa.GRUPA_J;
            double porez = Konstante.getPorezFromBruto(zbir8, pg);
            por = "";
            por = (String)por + new StringAlign(5, 114).format(StatLogic.getNumber01NG(Konstante.getPGStopaProcenat(pg)) + "%");
            por = (String)por + " MwSt ";
            por = (String)por + "(" + StampaRacunaAustrija.getPGMark(pg) + ") ";
            if (((String)(por = (String)por + new StringAlign(6, 114).format(StatLogic.getNumber02NG(porez)))).length() > brojKarakteraURedu - 15) {
                por = new StringAlign(brojKarakteraURedu, 108).format((String)por) + "\n";
                por = (String)por + new StringAlign(brojKarakteraURedu - 8, 114).format("Netto ") + new StringAlign(8, 114).format(StatLogic.getNumber02NG(Konstante.getOsnovicaFromBruto(pg, zbir8)));
            } else {
                por = (String)por + new StringAlign(brojKarakteraURedu - ((String)por).length() - 8, 114).format("Netto ") + new StringAlign(8, 114).format(StatLogic.getNumber02NG(Konstante.getOsnovicaFromBruto(pg, zbir8)));
            }
            content = content + (String)por + "\n";
            pTotal += porez;
        }
        if (zbir9 > 0.0) {
            pg = PoreskaGrupa.GRUPA_K;
            double porez = Konstante.getPorezFromBruto(zbir9, pg);
            por = "";
            por = (String)por + new StringAlign(5, 114).format(StatLogic.getNumber01NG(Konstante.getPGStopaProcenat(pg)) + "%");
            por = (String)por + " MwSt ";
            por = (String)por + "(" + StampaRacunaAustrija.getPGMark(pg) + ") ";
            if (((String)(por = (String)por + new StringAlign(6, 114).format(StatLogic.getNumber02NG(porez)))).length() > brojKarakteraURedu - 15) {
                por = new StringAlign(brojKarakteraURedu, 108).format((String)por) + "\n";
                por = (String)por + new StringAlign(brojKarakteraURedu - 8, 114).format("Netto ") + new StringAlign(8, 114).format(StatLogic.getNumber02NG(Konstante.getOsnovicaFromBruto(pg, zbir9)));
            } else {
                por = (String)por + new StringAlign(brojKarakteraURedu - ((String)por).length() - 8, 114).format("Netto ") + new StringAlign(8, 114).format(StatLogic.getNumber02NG(Konstante.getOsnovicaFromBruto(pg, zbir9)));
            }
            content = content + (String)por + "\n";
            pTotal += porez;
        }
        double netto = 0.0;
        netto += Konstante.getOsnovicaFromBruto(PoreskaGrupa.GRUPA_A, zbir1);
        netto += Konstante.getOsnovicaFromBruto(PoreskaGrupa.GRUPA_G, zbir2);
        netto += Konstante.getOsnovicaFromBruto(PoreskaGrupa.GRUPA_D, zbir3);
        netto += Konstante.getOsnovicaFromBruto(PoreskaGrupa.GRUPA_DJ, zbir4);
        netto += Konstante.getOsnovicaFromBruto(PoreskaGrupa.GRUPA_E, zbir5);
        netto += Konstante.getOsnovicaFromBruto(PoreskaGrupa.GRUPA_ZJ, zbir6);
        netto += Konstante.getOsnovicaFromBruto(PoreskaGrupa.GRUPA_I, zbir7);
        netto += Konstante.getOsnovicaFromBruto(PoreskaGrupa.GRUPA_J, zbir8);
        netto += Konstante.getOsnovicaFromBruto(PoreskaGrupa.GRUPA_K, zbir9);
        String por2 = "";
        por2 = por2 + new StringAlign(5, 114).format("Summe");
        por2 = por2 + " MwSt ";
        por2 = por2 + "    ";
        if ((por2 = por2 + new StringAlign(6, 114).format(StatLogic.getNumber02NG(pTotal))).length() > brojKarakteraURedu - 15) {
            por2 = new StringAlign(brojKarakteraURedu, 108).format(por2) + "\n";
            por2 = por2 + new StringAlign(brojKarakteraURedu - 8, 114).format("Netto ") + new StringAlign(8, 114).format(StatLogic.getNumber02NG(netto));
        } else {
            por2 = por2 + new StringAlign(brojKarakteraURedu - por2.length() - 8, 114).format("Netto ") + new StringAlign(8, 114).format(StatLogic.getNumber02NG(netto));
        }
        content = content + por2 + "\n";
        content = content + "\n";
        for (Placanje placanje : racun.getPlacanja()) {
            content = content + new String(new byte[]{27, 33, 16});
            content = content + new StringAlign(brojKarakteraURedu / 2, 108).format(placanje.getNacin().getOpis() + ":") + new StringAlign(brojKarakteraURedu - brojKarakteraURedu / 2, 114).format(StatLogic.getNumber02NG(placanje.getIznos())) + "\n";
            content = content + new String(new byte[]{27, 33, 0}) + "\n";
        }
        content = content + new String(mla) + "\n";
        if (this.footer1 != null) {
            content = content + new StringAlign(brojKarakteraURedu, 99).format(this.footer1) + "\n";
        }
        if (this.footer2 != null) {
            content = content + new StringAlign(brojKarakteraURedu, 99).format(this.footer2) + "\n";
        }
        if (this.footer3 != null) {
            content = content + new StringAlign(brojKarakteraURedu, 99).format(this.footer3) + "\n";
        }
        if (this.footer4 != null) {
            content = content + new StringAlign(brojKarakteraURedu, 99).format(this.footer4) + "\n";
        }
        for (i = 0; i < extraLinija; ++i) {
            content = content + "\n";
        }
        System.out.println(content);
        for (i = 0; i < this.brojKopija; ++i) {
            try {
                byte[] out;
                Thread.sleep(500L);
                DocFlavor.INPUT_STREAM flavor = DocFlavor.INPUT_STREAM.AUTOSENSE;
                HashPrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();
                PrintService[] pservices = PrintServiceLookup.lookupPrintServices(flavor, aset);
                DocPrintJob pj = null;
                for (PrintService printer : pservices) {
                    if (!printer.getName().toUpperCase().contains(this.stampac.getNaziv().toUpperCase())) continue;
                    pj = printer.createPrintJob();
                }
                Charset cs = null;
                try {
                    cs = Charset.forName(this.codePage);
                }
                catch (Exception e) {
                    System.out.println("Nije prepoznat Charset za ime " + cs);
                }
                byte[] bb = cs == null ? StatLogic.clearFromEasternLatinChars(content).getBytes() : (cs.equals(Charset.forName("Cp852")) || cs.equals(Charset.forName("Cp1250")) || cs.equals(Charset.forName("Cp1252")) || cs.equals(Charset.forName("UTF8")) ? content.getBytes(this.codePage) : StatLogic.clearFromEasternLatinChars(content).getBytes(this.codePage));
                if (this.stampac.getTip() == TipStampaca.STARTCP100) {
                    out = new byte[bb.length + 3];
                    System.arraycopy(bb, 0, out, 0, bb.length);
                    out[out.length - 3] = 27;
                    out[out.length - 2] = 100;
                    out[out.length - 1] = 51;
                } else {
                    out = new byte[bb.length + 2];
                    System.arraycopy(bb, 0, out, 0, bb.length);
                    out[out.length - 2] = 27;
                    out[out.length - 1] = 105;
                }
                ByteArrayInputStream is = new ByteArrayInputStream(out);
                SimpleDoc doc = new SimpleDoc(is, flavor, null);
                pj.print(doc, aset);
                ((InputStream)is).close();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void main(String[] args) {
        CrnoPlacanje cp = new CrnoPlacanje();
        cp.setBrKopija(1);
        cp.setHeader1("METRO CASH & CARRY D.O.O.");
        cp.setHeader2("AUTOPUT ZA NOVI SAD 120");
        cp.setHeader3("BEOGRAD-ZEMUN");
        cp.setHeader4("PJ.IBARSKI PUT 20");
        cp.setHeader5("IBARSKI PUT 20");
        cp.setHeader6("BEOGRAD \u010cUKARICA");
        cp.setHeader7("PIB: 102864104");
        cp.setHeader8("EV.BR:RM 3905561");
        cp.setFooter1("I ZAPAMTI TUPAVKO");
        cp.setFooter2("OVO NIJE FISKALNI RA\u010cUN");
        cp.setRekapitulacijaPoreza(Boolean.TRUE);
        cp.setNaziv("Proba");
        cp.setPrikazEkran(false);
        Stampac s = new Stampac();
        s.setTip(TipStampaca.POSBANK80MM);
        s.setNaziv("SANK");
        cp.setStampac(s);
        Racun r = new Racun();
        r.setBrojStola(0);
        r.setCrnoPlacanje("Proba");
        r.setDatum(new Date());
        r.setBrojRacuna(96287);
        r.setFiskalniOdstampan(Boolean.FALSE);
        r.setPopust(0.0);
        r.setStorniran(false);
        r.setZatvoren(false);
        Konobar k = new Konobar();
        k.setPunoIme("\u0160alabajzer");
        k.setId(1L);
        k.setSkrIme(k.getPunoime());
        r.setKonobar(k);
        Tura t = new Tura();
        t.setBrojStola(0);
        t.setBrojTure(0);
        t.setRacun(r);
        String[] ss = new String[]{"\u0160", "\u0106", "\u010c", "\u0110", "\u017d", "\u0161", "\u0107", "\u010d", "\u0111", "\u017e"};
        LinkedList<StavkaRacuna> srl = new LinkedList<StavkaRacuna>();
        for (int i = 0; i < 10; ++i) {
            Artikal a = new Artikal();
            a.setName("artikal" + ss[i % ss.length] + " " + (i % 2 == 0 ? "na popustu " : "") + i);
            a.setId(Long.valueOf(i));
            a.setSkrNaziv(a.getName());
            a.setPoreskaGrupa(PoreskaGrupa.values()[i % 3 == 0 ? 0 : i % 3 + 2]);
            a.setJedinicaMere((new String[]{JedMere.KOM.name(), JedMere.KG.name(), JedMere.LIT.name(), JedMere.POR.name()})[i % 4]);
            a.setCena(150.0 * (double)(i % 5 + 1));
            a.setDozvoljenPopust(Boolean.TRUE);
            StavkaRacuna sr = new StavkaRacuna();
            sr.setArtikal(a);
            sr.setBrojStola(0);
            sr.setCena(a.getCena());
            sr.setKolicina(Double.valueOf(i % 3 + 1));
            sr.setNaziv(a.getName());
            sr.setRacun(r);
            sr.setTura(t);
            srl.add(sr);
        }
        t.setStavke(srl);
        r.setStavke1(srl);
        LinkedList<Tura> tl = new LinkedList<Tura>();
        tl.add(t);
        r.setTure(tl);
        Placanje p = new Placanje();
        p.setNacin(NacinPlacanja.GOTOVINA);
        p.setIznos(r.total());
        p.setVreme(r.getDatum());
        p.setRacun(r);
        LinkedList<Placanje> plist = new LinkedList<Placanje>();
        plist.add(p);
        r.setPlacanja(plist);
        LinkedList<String> list = new LinkedList<String>();
        list.add("METRO CASH & CARRY D.O.O.");
        list.add("AUTOPUT ZA NOVI SAD 120");
        list.add("BEOGRAD-ZEMUN");
        list.add("PJ.IBARSKI PUT 20");
        list.add("IBARSKI PUT 20");
        list.add("BEOGRAD \u010cUKARICA");
        String pib = "102864104";
        new StampaRacunaAustrija(r, s, "TOP GRILL", "ATU", "62445401", "Payergasse 13", "1160 WIEN", "0676/66 21 507", "NAJBOLJI ROSTILJ", "VELIKI POZDRAV", null, null, "PRIJATNO!!! DOVIDJENJA", null, null, null);
    }

    public static String getPGMark(PoreskaGrupa pg) {
        return new String(new char[]{Konstante.getPGOznaka(pg)});
    }
}

