/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.stampa;

import com.dev63.fiscal.FiscalPrinter;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.StavkeSumarno;
import com.dev63.restoran.constants.StatLogic;
import com.dev63.restoran.model.CrnoPlacanje;
import com.dev63.restoran.model.GrupaArtikala;
import com.dev63.restoran.model.Konobar;
import com.dev63.restoran.model.NacinPlacanja;
import com.dev63.restoran.model.Odeljenje;
import com.dev63.restoran.model.Option;
import com.dev63.restoran.model.PodgrupaArtikala;
import com.dev63.restoran.model.Setting;
import com.dev63.restoran.model.StalniGost;
import com.dev63.restoran.model.Stampac;
import com.dev63.restoran.model.StavkaRacuna;
import com.dev63.restoran.model.TipStampaca;
import com.dev63.restoran.parts.XMLWriter;
import com.dev63.restoran.parts.XMLWriterHCP;
import com.dev63.restoran.stampa.NPrintUtils;
import com.dev63.restoran.stampa.StampaPorudzbine;
import com.dev63.restoran.stampa.StringAlign;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.SimpleDoc;
import javax.print.attribute.HashPrintRequestAttributeSet;
import org.apache.commons.lang.StringUtils;

public class StampaPrometPoKonobaru {
    private static final ResourceBundle barmasterText = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale());
    File print;
    FileOutputStream fos = null;
    FileInputStream fis = null;
    String naziv;
    RestoranServer server;
    List<String> crnaPlacanja = new ArrayList<String>();
    boolean odstampanazbirna = false;
    Stampac stampac;
    FiscalPrinter fiscal;
    boolean trgovina = false;
    private StalniGost sg;
    private List<StavkaRacuna> stavkePoSG;

    public StampaPrometPoKonobaru(List<StavkaRacuna> stavkeKonacno, List<StavkaRacuna> stavkePoSG, Restoran restoran, List<PodgrupaArtikala> podgrupe, List<GrupaArtikala> grupe, Map<PodgrupaArtikala, Double> mapaPG, Map<GrupaArtikala, Double> mapaP, Map<NacinPlacanja, Double> nacinP, Map<String, Double> nacinPCrno, Map<String, Integer> brRacuna, boolean blic, Date day1, Date day2, boolean crno, boolean kombPlacanje, Odeljenje odeljenje, Konobar konobar, double medjuzbir, double stornoVred, int stornoKol) {
        this.stavkePoSG = stavkePoSG;
        this.server = restoran.getServer();
        this.fiscal = restoran.getFiscal();
        this.print = new File(System.getProperty("user.home"));
        this.print = new File(this.print, "restoran_print");
        Setting trg = this.server.getSetting(Option.TRGOVINA);
        this.trgovina = trg != null && trg.booleanValue();
        this.sg = this.server.getStalniGostBySifra(konobar.getSifra());
        int brojDodLinija = 0;
        try {
            brojDodLinija = this.server.getSetting(Option.PROMET_PO_KON_DOD_LINIJE).intValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (CrnoPlacanje cp : this.server.readCrnaPlacanja()) {
            this.crnaPlacanja.add(cp.getNaziv());
        }
        if (!this.print.isDirectory()) {
            this.print.mkdir();
        }
        try {
            this.stampac = this.server.readIzvestajiStampacObject();
            if (this.stampac != null) {
                if (this.stampac != null) {
                    String content = this.writeContent(stavkeKonacno, stavkePoSG, restoran, podgrupe, grupe, mapaPG, mapaP, nacinP, nacinPCrno, brRacuna, blic, day1, day2, crno, kombPlacanje, odeljenje, konobar, medjuzbir, stornoVred, stornoKol, this.stampac.getTip().getBrojKarakteraURedu(), brojDodLinija);
                    NPrintUtils.printContent(content, this.stampac, 1);
                    return;
                }
                if (this.server.getStampacTipByNaziv(this.stampac.getNaziv()).equalsIgnoreCase("HCPP2DS")) {
                    String print = this.writeInString(stavkeKonacno, stavkePoSG, restoran, podgrupe, grupe, mapaPG, mapaP, nacinP, nacinPCrno, brRacuna, blic, day1, day2, crno, kombPlacanje, odeljenje, konobar, medjuzbir, 0 + brojDodLinija);
                    System.out.println(print);
                    this.printFromString(this.stampac.getNaziv(), print);
                } else {
                    if (this.server.getStampacTipByNaziv(this.stampac.getNaziv()).equalsIgnoreCase("EPSONTMT")) {
                        this.writeInFile(stavkeKonacno, stavkePoSG, restoran, podgrupe, grupe, mapaPG, mapaP, nacinP, nacinPCrno, brRacuna, blic, day1, day2, crno, kombPlacanje, odeljenje, konobar, medjuzbir, stornoVred, stornoKol, 30, 4 + brojDodLinija);
                    } else if (this.server.getStampacTipByNaziv(this.stampac.getNaziv()).equalsIgnoreCase("POSBANK80MM")) {
                        this.writeInFile(stavkeKonacno, stavkePoSG, restoran, podgrupe, grupe, mapaPG, mapaP, nacinP, nacinPCrno, brRacuna, blic, day1, day2, crno, kombPlacanje, odeljenje, konobar, medjuzbir, stornoVred, stornoKol, 42, 4 + brojDodLinija);
                    } else if (this.server.getStampacTipByNaziv(this.stampac.getNaziv()).equalsIgnoreCase("EPP")) {
                        this.writeInFile(stavkeKonacno, stavkePoSG, restoran, podgrupe, grupe, mapaPG, mapaP, nacinP, nacinPCrno, brRacuna, blic, day1, day2, crno, kombPlacanje, odeljenje, konobar, medjuzbir, stornoVred, stornoKol, 32, 8 + brojDodLinija);
                    } else if (this.server.getStampacTipByNaziv(this.stampac.getNaziv()).equalsIgnoreCase("DATECS1000")) {
                        this.writeInFile(stavkeKonacno, stavkePoSG, restoran, podgrupe, grupe, mapaPG, mapaP, nacinP, nacinPCrno, brRacuna, blic, day1, day2, crno, kombPlacanje, odeljenje, konobar, medjuzbir, stornoVred, stornoKol, 32, 4 + brojDodLinija);
                    } else {
                        this.writeInFile(stavkeKonacno, stavkePoSG, restoran, podgrupe, grupe, mapaPG, mapaP, nacinP, nacinPCrno, brRacuna, blic, day1, day2, crno, kombPlacanje, odeljenje, konobar, medjuzbir, stornoVred, stornoKol, 32, 0 + brojDodLinija);
                    }
                    this.printFromFile(this.naziv);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
        }
    }

    public String writeInString(List<StavkaRacuna> stavkeKonacno, List<StavkaRacuna> stavkePoSG, Restoran restoran, List<PodgrupaArtikala> podgrupe, List<GrupaArtikala> grupe, Map<PodgrupaArtikala, Double> mapaPG, Map<GrupaArtikala, Double> mapaP, Map<NacinPlacanja, Double> nacinP, Map<String, Double> nacinPCrno, Map<String, Integer> brRacuni, boolean blic, Date day1, Date day2, boolean crno, boolean kombPlacanje, Odeljenje odeljenje, Konobar k, double medjuzbir, int extraLinija) {
        double servis = 0.0;
        double popust = 0.0;
        String print = "";
        String od = odeljenje == null ? String.format(barmasterText.getString("TEXT_SVA_PROIZVODNA_MESTA"), new Object[0]) : odeljenje.getNaziv();
        print = print + StringUtils.center((String)(Konstante.getDate(new Date()) + ""), (int)16);
        print = print + StringUtils.center((String)("" + Konstante.getfullTime(new Date())), (int)16);
        print = print + StringUtils.center((String)(!this.trgovina ? String.format(barmasterText.getString("TEXT_PROMET_PO_KONOBARU"), new Object[0]) : String.format(barmasterText.getString("TEXT_PROMET_PO_OPERATERU"), new Object[0])), (int)32);
        print = print + StringUtils.center((String)od, (int)32);
        print = print + StringUtils.center((String)"", (int)32);
        print = print + StringUtils.center((String)((!this.trgovina ? String.format(barmasterText.getString("TEXT_KONOBAR"), new Object[0]) : String.format(barmasterText.getString("TEXT_OPERATER"), new Object[0])) + ": " + k.getPunoime()), (int)32);
        if (!blic) {
            print = print + "Artikal    JM    Prodato        ";
            print = print + StringUtils.center((String)"Cena", (int)16);
            print = print + StringUtils.center((String)"Ukupno", (int)16);
            print = print + "--------------------------------";
        }
        for (PodgrupaArtikala pg : podgrupe) {
            if (!blic) {
                print = print + StringUtils.center((String)pg.getNaziv(), (int)32);
                print = print + "--------------------------------";
            }
            for (StavkaRacuna a : StavkeSumarno.getSumarnoF(stavkeKonacno)) {
                if (!a.getArtikal().getPodgrupa().equals(pg)) continue;
                double kol = a.getKolicina();
                double cena = a.getArtikal().getCena();
                double prodajnaCena = a.getCena();
                if (prodajnaCena > cena) {
                    servis += prodajnaCena - cena;
                } else {
                    popust += cena - prodajnaCena;
                }
                if (blic) continue;
                print = print + new StringAlign(22, 108).format(a.getArtikal().getName()) + new StringAlign(3, 108).format(a.getArtikal().getJedinicaMere()) + new StringAlign(7, 114).format(Konstante.getNumber02(kol));
                print = print + new StringAlign(16, 114).format(Konstante.getNumber2(cena)) + new StringAlign(16, 114).format(Konstante.getNumber2(kol * cena));
            }
            if (blic) continue;
            print = print + new StringAlign(32, 114).format("---------");
            print = print + new StringAlign(32, 114).format(Konstante.getNumber2(mapaPG.get(pg)));
            print = print + StringUtils.center((String)"", (int)32);
        }
        print = print + StringUtils.center((String)"", (int)32);
        print = print + "VRSTA" + new StringAlign(27, 114).format("PROD. VRED.");
        if (!blic) {
            for (PodgrupaArtikala pg : podgrupe) {
                print = print + pg.getNaziv() + new StringAlign(32 - pg.getNaziv().length(), 114).format(Konstante.getNumber2(mapaPG.get(pg)));
            }
            print = print + "--------------------------------";
            print = print + StringUtils.center((String)"Grupe", (int)32);
            print = print + "--------------------------------";
        }
        for (GrupaArtikala g : grupe) {
            print = print + g.getNaziv() + new StringAlign(32 - g.getNaziv().length(), 114).format(Konstante.getNumber2(mapaP.get(g)));
        }
        if (servis > 0.0 || popust > 0.0) {
            print = print + "\n";
            print = print + "--------------------------------";
            if (servis > 0.0) {
                print = print + new StringAlign(22, 108).format("SERVIS") + new StringAlign(10, 108).format(Konstante.getNumber2(servis));
            }
            if (popust > 0.0) {
                print = print + new StringAlign(22, 108).format("POPUST") + new StringAlign(10, 108).format(Konstante.getNumber2(popust));
            }
        }
        print = print + "--------------------------------";
        print = print + new StringAlign(27, 108).format("INSTRUMENTI") + new StringAlign(5, 108).format("NETO");
        print = print + new StringAlign(27, 108).format("PLACANJA") + new StringAlign(5, 108).format("IZNOS");
        print = print + "--------------------------------";
        double ukupno = 0.0;
        if (!kombPlacanje) {
            for (NacinPlacanja np : NacinPlacanja.values()) {
                if (!nacinP.containsKey((Object)np)) continue;
                String nacinPlacanja = "";
                nacinPlacanja = np.name().equalsIgnoreCase("GOTOVINA") ? "GOTOV." : (np.name().equalsIgnoreCase("KARTICA") ? "KART." : (np.name().equalsIgnoreCase("CEK") ? "CHECK" : "FAKTURA"));
                print = print + new StringAlign(22, 108).format(nacinPlacanja) + new StringAlign(10, 114).format(Konstante.getNumber2(nacinP.get((Object)np)));
                ukupno += nacinP.get((Object)np).doubleValue();
            }
            if (crno) {
                for (String cp : nacinPCrno.keySet()) {
                    print = print + new StringAlign(22, 108).format(cp) + new StringAlign(10, 114).format(Konstante.getNumber2(nacinPCrno.get(cp)));
                    ukupno += nacinPCrno.get(cp).doubleValue();
                }
            }
            print = print + "--------------------------------";
            print = print + "TOTAL" + new StringAlign(27, 114).format(Konstante.getNumber2(ukupno));
            print = print + "--------------------------------";
            print = print + "Nacin placanja" + new StringAlign(18, 114).format("Broj racuna");
            boolean ukupnoRacuna = false;
            for (NacinPlacanja np : NacinPlacanja.values()) {
                if (!brRacuni.containsKey(np.name())) continue;
                String nacinPlacanja = "";
                nacinPlacanja = np.name().equalsIgnoreCase("GOTOVINA") ? "GOTOV." : (np.name().equalsIgnoreCase("KARTICA") ? "KART." : (np.name().equalsIgnoreCase("CEK") ? "CHECK" : "FAKTURA"));
                print = print + nacinPlacanja + new StringAlign(32 - nacinPlacanja.length(), 114).format(Integer.toString(brRacuni.get(np.name())));
            }
            for (String cp : this.crnaPlacanja) {
                if (!brRacuni.containsKey(cp)) continue;
                String nacinPlacanja = cp;
                print = print + nacinPlacanja + new StringAlign(32 - nacinPlacanja.length(), 114).format(Integer.toString(brRacuni.get(cp)));
            }
        }
        for (int i = 0; i < extraLinija; ++i) {
            print = print + StringUtils.center((String)"", (int)32);
        }
        return print;
    }

    public void printFromString(String stampac, String print) {
        try {
            XMLWriterHCP.writeNonFiscal(print);
        }
        catch (Exception ex) {
            Logger.getLogger(StampaPorudzbine.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void writeInFile(List<StavkaRacuna> stavkeKonacno, List<StavkaRacuna> stavkeSG, Restoran restoran, List<PodgrupaArtikala> podgrupe, List<GrupaArtikala> grupe, Map<PodgrupaArtikala, Double> mapaPG, Map<GrupaArtikala, Double> mapaP, Map<NacinPlacanja, Double> nacinP, Map<String, Double> nacinPCrno, Map<String, Integer> brRacuni, boolean blic, Date day1, Date day2, boolean crno, boolean kombPlacanje, Odeljenje odeljenje, Konobar k, double medjuzbir, double stornoVred, int stornoKol, int karakteraURedu, int extraLinija) {
        try {
            char[] mla = new char[karakteraURedu];
            char[] ela = new char[karakteraURedu];
            char[] ula = new char[karakteraURedu];
            Arrays.fill(mla, '-');
            Arrays.fill(ela, '=');
            Arrays.fill(ula, '_');
            double servis = 0.0;
            double popust = 0.0;
            double ukupnoSG = 0.0;
            double ukupnoSGsaPoppustom = 0.0;
            for (StavkaRacuna sr : stavkeSG) {
                ukupnoSG += sr.getArtikal().getCena() * sr.getKolicina();
                ukupnoSGsaPoppustom += sr.getCena() * sr.getKolicina();
            }
            this.fos = new FileOutputStream(this.print.getCanonicalPath() + "\\konobar.txt");
            PrintStream ps = new PrintStream(this.fos);
            String od = odeljenje == null ? "Sva proizvodna mesta" : odeljenje.getNaziv();
            ps.println(new StringAlign(karakteraURedu / 2, 108).format(Konstante.getDate(new Date())) + new StringAlign(karakteraURedu - karakteraURedu / 2, 114).format(Konstante.getfullTime(new Date())));
            ps.println();
            ps.println(new StringAlign(karakteraURedu, 99).format("PROMET PO KONOBARU"));
            ps.println(new StringAlign(karakteraURedu, 99).format("Za period:"));
            ps.println(new StringAlign(karakteraURedu / 2, 114).format("Od: " + StatLogic.getDateString(day1)) + new StringAlign(karakteraURedu - karakteraURedu / 2, 108).format(" Do: " + StatLogic.getDateString(day2)));
            ps.println(new StringAlign(karakteraURedu, 99).format(od));
            ps.println(new StringAlign(karakteraURedu, 99).format("Konobar: " + k.getPunoime()));
            ps.println();
            if (!blic) {
                ps.println(ela);
                ps.println(new StringAlign(karakteraURedu - 3 - 7, 108).format("Artikal") + new StringAlign(3, 108).format("JM") + new StringAlign(7, 114).format("Prodato"));
                ps.println(new StringAlign(karakteraURedu / 2, 114).format("Cena") + new StringAlign(karakteraURedu - karakteraURedu / 2, 114).format("Ukupno"));
            }
            for (PodgrupaArtikala podgrupaArtikala : podgrupe) {
                if (!blic) {
                    ps.println(mla);
                    ps.println(new StringAlign(karakteraURedu, 99).format(podgrupaArtikala.getNaziv()));
                    ps.println(mla);
                }
                for (StavkaRacuna a : StavkeSumarno.getSumarnoF(stavkeKonacno)) {
                    if (!a.getArtikal().getPodgrupa().equals(podgrupaArtikala)) continue;
                    double kol = a.getKolicina();
                    double cena = a.getArtikal().getCena();
                    double prodajnaCena = a.getCena();
                    if (prodajnaCena > cena) {
                        servis += prodajnaCena - cena;
                    } else {
                        popust += cena - prodajnaCena;
                    }
                    if (blic) continue;
                    ps.println(new StringAlign(karakteraURedu - 3 - 7, 108).format(a.getArtikal().getName()) + new StringAlign(3, 108).format(a.getArtikal().getJedinicaMere()) + new StringAlign(7, 114).format(Konstante.getNumber02(kol)));
                    ps.println(new StringAlign(karakteraURedu / 2, 114).format(Konstante.getNumber2(cena)) + new StringAlign(karakteraURedu - karakteraURedu / 2, 114).format(Konstante.getNumber2(kol * cena)));
                }
                if (blic) continue;
                ps.println(new StringAlign(karakteraURedu, 114).format(new String(mla).substring(0, 10)));
                ps.println(new StringAlign(karakteraURedu, 114).format(Konstante.getNumber2(mapaPG.get(podgrupaArtikala))));
            }
            ps.println(mla);
            ps.println(new StringAlign(karakteraURedu - 10, 108).format("PODGRUPA") + new StringAlign(10, 114).format("PROD.VRED."));
            ps.println(mla);
            if (!blic) {
                for (PodgrupaArtikala podgrupaArtikala : podgrupe) {
                    String pgNaziv = podgrupaArtikala.getNaziv().length() > (karakteraURedu - 10 > 0 ? karakteraURedu - 10 : 0) ? podgrupaArtikala.getNaziv().substring(0, karakteraURedu - 10) : podgrupaArtikala.getNaziv();
                    ps.println(new StringAlign(karakteraURedu - 10, 108).format(pgNaziv) + new StringAlign(10, 99).format(Konstante.getNumber2(mapaPG.get(podgrupaArtikala))));
                }
                ps.println(ela);
                ps.println(new StringAlign(karakteraURedu, 99).format("Grupe"));
                ps.println(mla);
            }
            for (GrupaArtikala grupaArtikala : grupe) {
                ps.println(new StringAlign(karakteraURedu - 10, 108).format(grupaArtikala.getNaziv()) + new StringAlign(10, 99).format(Konstante.getNumber2(mapaP.get(grupaArtikala))));
            }
            ps.println(ela);
            ps.println(new StringAlign(karakteraURedu / 2, 99).format("Nacin placanja") + new StringAlign(karakteraURedu - karakteraURedu / 2, 114).format("Broj racuna"));
            ps.println(mla);
            int ukupnoRacuna = 0;
            for (NacinPlacanja np : NacinPlacanja.values()) {
                if (!brRacuni.containsKey(np.name())) continue;
                String nacinPlacanja = "";
                nacinPlacanja = np == NacinPlacanja.GOTOVINA ? "GOTOV." : (np == NacinPlacanja.KARTICA ? "KART." : (np == NacinPlacanja.CEK ? "CHECK" : "FAKTURA"));
                Integer brr = brRacuni.get(np.name());
                ps.println(new StringAlign(karakteraURedu - 4, 108).format(nacinPlacanja) + new StringAlign(4, 114).format(brr.toString()));
                ukupnoRacuna += brr.intValue();
            }
            for (String cp : this.crnaPlacanja) {
                if (!brRacuni.containsKey(cp)) continue;
                String nacinPlacanja = cp;
                Integer brr = brRacuni.get(cp);
                ps.println(new StringAlign(karakteraURedu - 4, 108).format(nacinPlacanja) + new StringAlign(4, 114).format(brr.toString()));
                ukupnoRacuna += brr.intValue();
            }
            ps.println(ela);
            ps.println(new StringAlign(karakteraURedu / 2, 108).format("INSTRUMENTI") + new StringAlign(karakteraURedu - karakteraURedu / 2, 114).format("NETO"));
            ps.println(new StringAlign(karakteraURedu / 2, 108).format("PLACANJA") + new StringAlign(karakteraURedu - karakteraURedu / 2, 114).format("IZNOS"));
            ps.println(mla);
            double d = 0.0;
            if (!kombPlacanje) {
                for (NacinPlacanja np : NacinPlacanja.values()) {
                    if (!nacinP.containsKey((Object)np)) continue;
                    String nacinPlacanja = "";
                    nacinPlacanja = np == NacinPlacanja.GOTOVINA ? "GOTOV." : (np == NacinPlacanja.KARTICA ? "KART." : (np == NacinPlacanja.CEK ? "CHECK" : "FAKTURA"));
                    ps.println(new StringAlign(karakteraURedu - 10, 108).format(nacinPlacanja) + new StringAlign(10, 114).format(Konstante.getNumber2(nacinP.get((Object)np))));
                    d += nacinP.get((Object)np).doubleValue();
                }
                if (crno) {
                    for (String cp : this.crnaPlacanja) {
                        if (!nacinPCrno.containsKey(cp)) continue;
                        ps.println(new StringAlign(karakteraURedu - 10, 108).format(cp) + new StringAlign(10, 114).format(Konstante.getNumber2(nacinPCrno.get(cp))));
                        d += nacinPCrno.get(cp).doubleValue();
                    }
                }
                if (servis > 0.0 || popust > 0.0) {
                    ps.println(mla);
                    if (servis > 0.0) {
                        ps.println(new StringAlign(karakteraURedu - 10, 108).format("SERVIS") + new StringAlign(10, 114).format(Konstante.getNumber2(servis)));
                    }
                    if (popust > 0.0) {
                        ps.println(new StringAlign(karakteraURedu - 10, 108).format("POPUST") + new StringAlign(10, 114).format(Konstante.getNumber2(popust)));
                    }
                }
                ps.println(ela);
                ps.println(new StringAlign(10, 108).format("TOTAL") + new StringAlign(karakteraURedu - 10, 114).format(Konstante.getNumber2(d)));
                ps.println(ela);
                if (stornoKol > 0) {
                    ps.println(new StringAlign(karakteraURedu / 2, 108).format("STORNO IZNOS") + new StringAlign(karakteraURedu - karakteraURedu / 2, 114).format(Konstante.getNumber2(stornoVred)));
                    ps.println(new StringAlign(karakteraURedu / 2, 108).format("STORNO BROJ") + new StringAlign(karakteraURedu - karakteraURedu / 2, 114).format("" + stornoKol));
                    ps.println(ela);
                }
            }
            if (this.sg != null && !stavkeSG.isEmpty()) {
                ps.println();
                ps.println(new StringAlign(karakteraURedu, 99).format("PROMET STALNOG GOSTA"));
                ps.println(new StringAlign(karakteraURedu, 99).format(this.sg.getNaziv()));
                ps.println(new StringAlign(karakteraURedu / 2, 108).format("Ukupno : ") + new StringAlign(karakteraURedu - karakteraURedu / 2, 114).format(StatLogic.getNumber02(ukupnoSG)));
                ps.println(new StringAlign(karakteraURedu / 2, 108).format("Popust sg : ") + new StringAlign(karakteraURedu - karakteraURedu / 2, 114).format(StatLogic.getNumber02(this.sg.getPopust()) + "%"));
                ps.println(new StringAlign(karakteraURedu / 2, 108).format("Ostvareni popust : ") + new StringAlign(karakteraURedu - karakteraURedu / 2, 114).format(StatLogic.getNumber02(ukupnoSG - ukupnoSGsaPoppustom)));
                ps.println();
            }
            for (int i = 0; i < extraLinija; ++i) {
                ps.println();
            }
            this.fos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                this.fos.close();
            }
            catch (IOException ex) {
                Logger.getLogger(StampaPrometPoKonobaru.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private String writeContent(List<StavkaRacuna> stavkeKonacno, List<StavkaRacuna> stavkeSG, Restoran restoran, List<PodgrupaArtikala> podgrupe, List<GrupaArtikala> grupe, Map<PodgrupaArtikala, Double> mapaPG, Map<GrupaArtikala, Double> mapaP, Map<NacinPlacanja, Double> nacinP, Map<String, Double> nacinPCrno, Map<String, Integer> brRacuni, boolean blic, Date day1, Date day2, boolean crno, boolean kombPlacanje, Odeljenje odeljenje, Konobar k, double medjuzbir, double stornoVred, int stornoKol, int karakteraURedu, int extraLinija) {
        ByteArrayOutputStream fos = new ByteArrayOutputStream();
        try {
            char[] mla = new char[karakteraURedu];
            char[] ela = new char[karakteraURedu];
            char[] ula = new char[karakteraURedu];
            Arrays.fill(mla, '-');
            Arrays.fill(ela, '=');
            Arrays.fill(ula, '_');
            double servis = 0.0;
            double popust = 0.0;
            double ukupnoSG = 0.0;
            double ukupnoSGsaPoppustom = 0.0;
            if (stavkeSG != null) {
                for (StavkaRacuna sr : stavkeSG) {
                    ukupnoSG += sr.getArtikal().getCena() * sr.getKolicina();
                    ukupnoSGsaPoppustom += sr.getCena() * sr.getKolicina();
                }
            }
            PrintStream ps = new PrintStream(fos);
            String od = odeljenje == null ? String.format(Konstante.getBundle().getString("TEXT_SVA_PROIZVODNA_MESTA"), new Object[0]) : odeljenje.getNaziv();
            ps.println(new StringAlign(karakteraURedu / 2, 108).format(Konstante.getDate(new Date())) + new StringAlign(karakteraURedu - karakteraURedu / 2, 114).format(Konstante.getfullTime(new Date())));
            ps.println(NPrintUtils.spaceFill(karakteraURedu));
            ps.println(new StringAlign(karakteraURedu, 99).format(String.format(Konstante.getBundle().getString("TEXT_PROMET_PO_KONOBARU"), new Object[0])));
            ps.println(new StringAlign(karakteraURedu, 99).format(String.format(Konstante.getBundle().getString("TEXT_ZA_PERIOD"), new Object[0]).toUpperCase() + ":"));
            ps.println(new StringAlign(karakteraURedu / 2, 114).format(String.format(Konstante.getBundle().getString("TEXT_OD"), new Object[0]).toUpperCase() + ": " + StatLogic.getDateString(day1)) + new StringAlign(karakteraURedu - karakteraURedu / 2, 108).format(" " + String.format(Konstante.getBundle().getString("TEXT_DO"), new Object[0]).toUpperCase() + ": " + StatLogic.getDateString(day2)));
            ps.println(new StringAlign(karakteraURedu, 99).format(od));
            ps.println(new StringAlign(karakteraURedu, 99).format(String.format(Konstante.getBundle().getString("TEXT_KONOBAR"), new Object[0]) + ": " + k.getPunoime()));
            ps.println(NPrintUtils.spaceFill(karakteraURedu));
            if (!blic) {
                ps.println(ela);
                ps.println(new StringAlign(karakteraURedu - 5 - 7, 108).format(String.format(Konstante.getBundle().getString("TEXT_ARTIKAL"), new Object[0])) + new StringAlign(5, 108).format(String.format(Konstante.getBundle().getString("TEXT_JEDINICA_MERE_SKR"), new Object[0])) + new StringAlign(7, 114).format(String.format(Konstante.getBundle().getString("TEXT_KOLICINA"), new Object[0])));
                ps.println(new StringAlign(karakteraURedu / 2, 114).format(String.format(Konstante.getBundle().getString("TEXT_CENA"), new Object[0])) + new StringAlign(karakteraURedu - karakteraURedu / 2, 114).format(String.format(Konstante.getBundle().getString("TEXT_UKUPNO"), new Object[0])));
            }
            for (PodgrupaArtikala podgrupaArtikala : podgrupe) {
                if (!blic) {
                    ps.println(mla);
                    ps.println(new StringAlign(karakteraURedu, 99).format(podgrupaArtikala.getNaziv()));
                    ps.println(mla);
                }
                for (StavkaRacuna a : StavkeSumarno.getSumarnoF(stavkeKonacno)) {
                    if (!a.getArtikal().getPodgrupa().equals(podgrupaArtikala)) continue;
                    double kol = a.getKolicina();
                    double cena = a.getArtikal().getCena();
                    double prodajnaCena = a.getCena();
                    if (prodajnaCena > cena) {
                        servis += (prodajnaCena - cena) * kol;
                    } else {
                        popust += (cena - prodajnaCena) * kol;
                    }
                    if (blic) continue;
                    ps.println(new StringAlign(karakteraURedu - 5 - 7, 108).format(a.getArtikal().getName()) + new StringAlign(5, 108).format(a.getArtikal().getJedinicaMere()) + new StringAlign(7, 114).format(Konstante.getNumber02(kol)));
                    ps.println(new StringAlign(karakteraURedu / 2, 114).format(Konstante.getNumber2(prodajnaCena)) + new StringAlign(karakteraURedu - karakteraURedu / 2, 114).format(Konstante.getNumber2(kol * prodajnaCena)));
                }
                if (blic) continue;
                ps.println(new StringAlign(karakteraURedu, 114).format(new String(mla).substring(0, 10)));
                ps.println(new StringAlign(karakteraURedu, 114).format(Konstante.getNumber2(mapaPG.get(podgrupaArtikala))));
            }
            ps.println(mla);
            ps.println(new StringAlign(karakteraURedu - 10, 108).format(String.format(Konstante.getBundle().getString("TEXT_PODGRUPA"), new Object[0]).toUpperCase()) + new StringAlign(10, 114).format(String.format(Konstante.getBundle().getString("TEXT_VREDNOST"), new Object[0]).toUpperCase()));
            ps.println(mla);
            if (!blic) {
                for (PodgrupaArtikala podgrupaArtikala : podgrupe) {
                    String pgNaziv = podgrupaArtikala.getNaziv().length() > (karakteraURedu - 10 > 0 ? karakteraURedu - 10 : 0) ? podgrupaArtikala.getNaziv().substring(0, karakteraURedu - 10) : podgrupaArtikala.getNaziv();
                    ps.println(new StringAlign(karakteraURedu - 10, 108).format(pgNaziv) + new StringAlign(10, 99).format(Konstante.getNumber2(mapaPG.get(podgrupaArtikala))));
                }
                ps.println(ela);
                ps.println(new StringAlign(karakteraURedu, 99).format(String.format(Konstante.getBundle().getString("TEXT_GRUPA"), new Object[0]).toUpperCase()));
                ps.println(mla);
            }
            for (GrupaArtikala grupaArtikala : grupe) {
                ps.println(new StringAlign(karakteraURedu - 10, 108).format(grupaArtikala.getNaziv()) + new StringAlign(10, 99).format(Konstante.getNumber2(mapaP.get(grupaArtikala))));
            }
            ps.println(ela);
            ps.println(new StringAlign(karakteraURedu / 2, 99).format(String.format(Konstante.getBundle().getString("TEXT_NACIN_PLACANJA"), new Object[0])) + new StringAlign(karakteraURedu - karakteraURedu / 2, 114).format(String.format(Konstante.getBundle().getString("TEXT_BROJ_RACUNA"), new Object[0])));
            ps.println(mla);
            int ukupnoRacuna = 0;
            for (NacinPlacanja np : NacinPlacanja.values()) {
                if (!brRacuni.containsKey(np.name())) continue;
                String nacinPlacanja = "";
                nacinPlacanja = np == NacinPlacanja.GOTOVINA ? "GOTOV." : (np == NacinPlacanja.KARTICA ? "KART." : (np == NacinPlacanja.CEK ? "CHECK" : "FAKTURA"));
                Integer brr = brRacuni.get(np.name());
                ps.println(new StringAlign(karakteraURedu - 4, 108).format(nacinPlacanja) + new StringAlign(4, 114).format(brr.toString()));
                ukupnoRacuna += brr.intValue();
            }
            for (String cp : this.crnaPlacanja) {
                if (!brRacuni.containsKey(cp)) continue;
                String nacinPlacanja = cp;
                Integer brr = brRacuni.get(cp);
                ps.println(new StringAlign(karakteraURedu - 4, 108).format(nacinPlacanja) + new StringAlign(4, 114).format(brr.toString()));
                ukupnoRacuna += brr.intValue();
            }
            ps.println(ela);
            ps.println(new StringAlign(karakteraURedu / 2, 108).format(String.format(Konstante.getBundle().getString("TEXT_INSTRUMENTI"), new Object[0])) + new StringAlign(karakteraURedu - karakteraURedu / 2, 114).format(String.format(Konstante.getBundle().getString("TEXT_NETO"), new Object[0])));
            ps.println(new StringAlign(karakteraURedu / 2, 108).format(String.format(Konstante.getBundle().getString("TEXT_PLACANJA"), new Object[0])) + new StringAlign(karakteraURedu - karakteraURedu / 2, 114).format(String.format(Konstante.getBundle().getString("TEXT_IZNOS"), new Object[0])));
            ps.println(mla);
            double d = 0.0;
            if (!kombPlacanje) {
                for (NacinPlacanja np : NacinPlacanja.values()) {
                    if (!nacinP.containsKey((Object)np)) continue;
                    String nacinPlacanja = "";
                    nacinPlacanja = np == NacinPlacanja.GOTOVINA ? "GOTOV." : (np == NacinPlacanja.KARTICA ? "KART." : (np == NacinPlacanja.CEK ? "CHECK" : "FAKTURA"));
                    ps.println(new StringAlign(karakteraURedu - 10, 108).format(nacinPlacanja) + new StringAlign(10, 114).format(Konstante.getNumber2(nacinP.get((Object)np))));
                    d += nacinP.get((Object)np).doubleValue();
                }
                if (crno) {
                    for (String cp : this.crnaPlacanja) {
                        if (!nacinPCrno.containsKey(cp)) continue;
                        ps.println(new StringAlign(karakteraURedu - 10, 108).format(cp) + new StringAlign(10, 114).format(Konstante.getNumber2(nacinPCrno.get(cp))));
                        d += nacinPCrno.get(cp).doubleValue();
                    }
                }
                if (servis > 0.0 || popust > 0.0) {
                    ps.println(mla);
                    if (servis > 0.0) {
                        ps.println(new StringAlign(karakteraURedu - 10, 108).format(String.format(Konstante.getBundle().getString("TEXT_SERVIS"), new Object[0]).toUpperCase()) + new StringAlign(10, 114).format(Konstante.getNumber2(servis)));
                    }
                    if (popust > 0.0) {
                        ps.println(new StringAlign(karakteraURedu - 10, 108).format(String.format(Konstante.getBundle().getString("TEXT_POPUST"), new Object[0]).toUpperCase()) + new StringAlign(10, 114).format(Konstante.getNumber2(popust)));
                    }
                }
                ps.println(ela);
                ps.println(new StringAlign(10, 108).format(String.format(Konstante.getBundle().getString("TEXT_TOTAL"), new Object[0])) + new StringAlign(karakteraURedu - 10, 114).format(Konstante.getNumber2(d)));
                ps.println(ela);
                if (stornoKol > 0) {
                    ps.println(new StringAlign(karakteraURedu / 2, 108).format(String.format(Konstante.getBundle().getString("TEXT_STORNO_IZNOS"), new Object[0])) + new StringAlign(karakteraURedu - karakteraURedu / 2, 114).format(Konstante.getNumber2(stornoVred)));
                    ps.println(new StringAlign(karakteraURedu / 2, 108).format(String.format(Konstante.getBundle().getString("TEXT_STORNO_BROJ"), new Object[0])) + new StringAlign(karakteraURedu - karakteraURedu / 2, 114).format("" + stornoKol));
                    ps.println(ela);
                }
            }
            if (this.sg != null && stavkeSG != null && !stavkeSG.isEmpty()) {
                ps.println();
                ps.println(new StringAlign(karakteraURedu, 99).format("PROMET STALNOG GOSTA"));
                ps.println(new StringAlign(karakteraURedu, 99).format(this.sg.getNaziv()));
                ps.println(new StringAlign(karakteraURedu / 2, 108).format("Ukupno : ") + new StringAlign(karakteraURedu - karakteraURedu / 2, 114).format(StatLogic.getNumber02(ukupnoSG)));
                ps.println(new StringAlign(karakteraURedu / 2, 108).format("Popust sg : ") + new StringAlign(karakteraURedu - karakteraURedu / 2, 114).format(StatLogic.getNumber02(this.sg.getPopust()) + "%"));
                ps.println(new StringAlign(karakteraURedu / 2, 108).format("Ostvareni popust : ") + new StringAlign(karakteraURedu - karakteraURedu / 2, 114).format(StatLogic.getNumber02(ukupnoSG - ukupnoSGsaPoppustom)));
                ps.println();
            }
            for (int i = 0; i < extraLinija; ++i) {
                ps.println();
            }
            String reta = fos.toString();
            fos.close();
            return reta;
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                fos.close();
            }
            catch (IOException ex) {
                Logger.getLogger(StampaPrometPoKonobaru.class.getName()).log(Level.SEVERE, null, ex);
            }
            return null;
        }
    }

    public void printFromFile(String putanja) {
        try {
            if (this.stampac.equals(TipStampaca.FP550.toString())) {
                String strLine;
                this.fis = new FileInputStream(this.print.getCanonicalPath() + "\\konobar.txt");
                DataInputStream in = new DataInputStream(this.fis);
                BufferedReader br = new BufferedReader(new InputStreamReader(in));
                ArrayList<String> text = new ArrayList<String>();
                while ((strLine = br.readLine()) != null) {
                    text.add(strLine);
                }
                XMLWriter.writeNonFiscal(text);
                return;
            }
            DocFlavor flavor = DocFlavor.INPUT_STREAM.AUTOSENSE;
            HashPrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();
            PrintService[] pservices = PrintServiceLookup.lookupPrintServices(flavor, aset);
            DocPrintJob pj = null;
            DocPrintJob pj2 = null;
            for (PrintService printer : pservices) {
                if (!printer.getName().toUpperCase().contains(this.stampac.getNaziv().toUpperCase())) continue;
                pj = printer.createPrintJob();
                pj2 = printer.createPrintJob();
            }
            this.fis = new FileInputStream(this.print.getCanonicalPath() + "\\konobar.txt");
            SimpleDoc doc = new SimpleDoc(this.fis, flavor, null);
            pj.print(doc, aset);
            this.fis.close();
            flavor = DocFlavor.BYTE_ARRAY.AUTOSENSE;
            byte[] by = this.stampac.getTip() == TipStampaca.STARTCP100 ? new byte[]{27, 100, 51} : new byte[]{27, 105};
            SimpleDoc doc2 = new SimpleDoc(by, flavor, null);
            pj2.print(doc2, aset);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            try {
                this.fis.close();
            }
            catch (IOException ex1) {
                Logger.getLogger(StampaPrometPoKonobaru.class.getName()).log(Level.SEVERE, null, ex1);
            }
        }
    }
}

