/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.stampa;

import com.dev63.restoran.Konstante;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.constants.StatLogic;
import com.dev63.restoran.izvestaji.PrometPoArtiklimaNovi;
import com.dev63.restoran.model.CrnoPlacanje;
import com.dev63.restoran.model.Kasa;
import com.dev63.restoran.model.NacinPlacanja;
import com.dev63.restoran.model.Odeljenje;
import com.dev63.restoran.model.PodgrupaArtikala;
import com.dev63.restoran.model.Stampac;
import com.dev63.restoran.stampa.NPrintUtils;
import java.util.Date;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StampaPrometPoArtiklimaNovi {
    private final ResourceBundle barmasterText = Konstante.getBundle();
    private Map<NacinPlacanja, Double> nacinP = new EnumMap<NacinPlacanja, Double>(NacinPlacanja.class);
    private Map<String, Long> racuniBR = new HashMap<String, Long>();
    private Map<NacinPlacanja, Double> servisP = new EnumMap<NacinPlacanja, Double>(NacinPlacanja.class);
    private Map<NacinPlacanja, Double> popustP = new EnumMap<NacinPlacanja, Double>(NacinPlacanja.class);
    private Map<NacinPlacanja, Double> netoP = new EnumMap<NacinPlacanja, Double>(NacinPlacanja.class);
    private Map<String, Double> nacinPCrno = new HashMap<String, Double>();
    private Map<String, Double> servisPCrno = new HashMap<String, Double>();
    private Map<String, Double> popustPCrno = new HashMap<String, Double>();
    private Map<String, Double> netoPCrno = new HashMap<String, Double>();
    double ukupno = 0.0;
    double neto = 0.0;
    double srvc = 0.0;
    double ppst = 0.0;
    private Integer quantWidth = 5;
    private Integer amountWidth = 8;
    boolean sifre;

    public StampaPrometPoArtiklimaNovi(List<Map<String, Object>> ppaArtData, List<Map<String, Object>> ppaFinanceData, List<CrnoPlacanje> blackPayments, Date from, Date to, Stampac printer, boolean sifre, RestoranServer server) throws Exception {
        this.sifre = sifre;
        try {
            String content = this.writeContent(ppaArtData, ppaFinanceData, blackPayments, from, to, printer.getTip().getBrojKarakteraURedu(), server);
            NPrintUtils.printContent(content, printer, 1);
        }
        catch (Exception ex) {
            Logger.getLogger(PrometPoArtiklimaNovi.class.getName()).log(Level.SEVERE, null, ex);
            throw ex;
        }
    }

    public StampaPrometPoArtiklimaNovi(RestoranServer server, boolean bltz, List<NacinPlacanja> belaPlacanja, List<CrnoPlacanje> cp, Date from, Date to, List<Odeljenje> odeljenja, List<Kasa> kase, List<PodgrupaArtikala> podgrupe, boolean buyingPrices, boolean subtotal) throws Exception {
        try {
            EnumSet<NacinPlacanja> bp = EnumSet.copyOf(belaPlacanja);
            List<Map<String, Object>> ppaArtData = null;
            List<Map<String, Object>> ppaFinanceData = null;
            if (!bltz) {
                ppaArtData = server.getNewRevenueByArticlesArticleData(bp, cp, from, to, odeljenja, kase, podgrupe, ppaArtData, false, false, subtotal);
            }
            ppaFinanceData = server.getNewRevenueByArticlesFinanceData(bp, cp, from, to, odeljenja, kase, podgrupe, ppaFinanceData, subtotal);
            Stampac stampac = server.readIzvestajiStampacObject();
            String content = this.writeContent(ppaArtData, ppaFinanceData, cp, from, to, stampac.getTip().getBrojKarakteraURedu(), server);
            NPrintUtils.printContent(content, stampac, 1);
        }
        catch (Exception ex) {
            Logger.getLogger(PrometPoArtiklimaNovi.class.getName()).log(Level.SEVERE, null, ex);
            throw ex;
        }
    }

    private void insertSubGroupTotalRow(StringBuilder contentBuilder, Double sgQuant, Double sgValue, int bkur) {
        contentBuilder.append(NPrintUtils.rightTextMinusPadding(bkur, " " + NPrintUtils.rightText(this.quantWidth + 2, StatLogic.getNumber02NG(sgQuant)) + NPrintUtils.rightText(this.amountWidth + 2, StatLogic.getNumber02(sgValue))));
        contentBuilder.append("\n");
    }

    private String writeContent(List<Map<String, Object>> ppaArtData, List<Map<String, Object>> ppaFinanceData, List<CrnoPlacanje> crnaPlacanja, Date from, Date to, int bkur, RestoranServer server) {
        StringBuilder contentBuilder = new StringBuilder();
        contentBuilder.append(NPrintUtils.centerSplitToCenter(bkur, StatLogic.getDateString(new Date()), StatLogic.getTimeString(new Date()))).append("\n");
        contentBuilder.append(NPrintUtils.centerText(bkur, String.format(this.barmasterText.getString("TEXT_PROMET_PO_ARTIKLIMA"), new Object[0]).toUpperCase())).append("\n");
        contentBuilder.append(NPrintUtils.centerText(bkur, String.format(this.barmasterText.getString("TEXT_OD"), new Object[0]) + " " + StatLogic.getDateTimeString(from != null ? from : server.getLastOpenZD().getZakljucenje()))).append("\n");
        contentBuilder.append(NPrintUtils.centerText(bkur, String.format(this.barmasterText.getString("TEXT_DO"), new Object[0]) + " " + StatLogic.getDateTimeString(to != null ? to : new Date()))).append("\n");
        contentBuilder.append(NPrintUtils.spaceFill(bkur)).append("\n");
        if (ppaArtData != null) {
            String lastPG = null;
            Double sgCount = 0.0;
            Double sgValue = 0.0;
            for (Map<String, Object> row : ppaArtData) {
                String subGroup = (String)row.get("podgrupa");
                if (lastPG != null && !subGroup.equals(lastPG)) {
                    this.insertSubGroupTotalRow(contentBuilder, sgCount, sgValue, bkur);
                    sgCount = 0.0;
                    sgValue = 0.0;
                }
                if (lastPG == null || !subGroup.equals(lastPG)) {
                    contentBuilder.append(NPrintUtils.centerTextEqualsPadding(bkur, subGroup));
                    contentBuilder.append("\n");
                    lastPG = subGroup;
                }
                String code = "";
                if (this.sifre) {
                    code = row.get("sifra") != null ? (String)row.get("sifra") : "";
                }
                String art = (String)row.get("artikal");
                Double quant = (Double)row.get("kolicina");
                Double prodajnacena = (Double)row.get("cena");
                Double value = (Double)row.get("vrednost");
                String jed = (String)row.get("jedinica");
                if (this.sifre && !code.equals("")) {
                    contentBuilder.append(NPrintUtils.leftText(bkur - this.quantWidth - this.amountWidth + 2, "(" + code + ")"));
                    contentBuilder.append("\n");
                }
                contentBuilder.append(NPrintUtils.leftText(bkur - this.quantWidth - this.amountWidth + 2, art));
                contentBuilder.append("\n");
                contentBuilder.append(" ");
                contentBuilder.append(NPrintUtils.rightText(this.quantWidth, jed));
                contentBuilder.append(" ");
                contentBuilder.append(NPrintUtils.rightText(this.quantWidth, StatLogic.getNumber02NG(quant)));
                contentBuilder.append(" ");
                contentBuilder.append(NPrintUtils.rightText(this.amountWidth, StatLogic.getNumber02NG(prodajnacena)));
                contentBuilder.append(" ");
                contentBuilder.append(NPrintUtils.rightText(this.amountWidth, StatLogic.getNumber02NG(value)));
                contentBuilder.append("\n");
                sgCount = sgCount + quant;
                sgValue = sgValue + value;
            }
            if (lastPG != null) {
                this.insertSubGroupTotalRow(contentBuilder, sgCount, sgValue, bkur);
                contentBuilder.append(NPrintUtils.equalsFill(bkur)).append("\n");
            }
        }
        String totalL = Konstante.getBundle().getString("TEXT_UKUPNO");
        String headerLeft = String.format(this.barmasterText.getString("TEXT_NACIN_PLACANJA"), new Object[0]);
        String headerRight = String.format(Konstante.getBundle().getString("TEXT_KOLICINA_RACUNA"), new Object[0]);
        Integer spaceLeft = (bkur - bkur % 2) / 2;
        Integer spaceRight = bkur - spaceLeft - 1;
        List<String> leftTitleRows = this.splitHeaderIntoRows(headerLeft, spaceLeft);
        List<String> rightTitleRows = this.splitHeaderIntoRows(headerRight, spaceRight);
        for (int i = 0; i < Math.max(leftTitleRows.size(), rightTitleRows.size()); ++i) {
            String l = i < leftTitleRows.size() ? leftTitleRows.get(i) : "";
            String r = i < rightTitleRows.size() ? rightTitleRows.get(i) : "";
            contentBuilder.append(NPrintUtils.leftText(spaceLeft, l)).append(" ").append(NPrintUtils.rightText(spaceRight, r)).append("\n");
        }
        contentBuilder.append(NPrintUtils.minusFill(bkur)).append("\n");
        String subtotalL = Konstante.getBundle().getString("TEXT_MEDJUZBIR");
        String combined = null;
        Double cNetto = 0.0;
        Double cDiscount = 0.0;
        Double cService = 0.0;
        Double cBrutto = 0.0;
        for (Map<String, Object> row : ppaFinanceData) {
            NacinPlacanja[] wpc = (NacinPlacanja[])row.get("brojbelihplacanja");
            String string = (String)row.get("beloplacanje");
            String blackP = (String)row.get("crnoplacanje");
            Double netto = (Double)row.get("neto");
            Double discount = (Double)row.get("popust");
            Double service = (Double)row.get("servis");
            Double brutto = (Double)row.get("bruto");
            Long count = (Long)row.get("brojracuna");
            if (wpc.longValue() == 0L) {
                if (blackP == null) {
                    blackP = subtotalL;
                } else {
                    this.racuniBR.put(blackP, count);
                }
                this.nacinPCrno.put(blackP, brutto);
                this.popustPCrno.put(blackP, discount);
                this.servisPCrno.put(blackP, service);
                this.netoPCrno.put(blackP, netto);
                continue;
            }
            if (wpc.longValue() == 1L) {
                NacinPlacanja npt = NacinPlacanja.valueOf(string);
                this.nacinP.put(npt, brutto);
                this.popustP.put(npt, discount);
                this.servisP.put(npt, service);
                this.netoP.put(npt, netto);
                this.racuniBR.put(npt.getOpis(), count);
                continue;
            }
            combined = Konstante.getBundle().getString("TEXT_KOMBINOVANO");
            cNetto = netto;
            cDiscount = discount;
            cService = service;
            cBrutto = brutto;
            this.racuniBR.put(combined, count);
        }
        int ukupnoRacuna = 0;
        HashMap<String, Long> mapa = new HashMap<String, Long>(this.racuniBR);
        for (NacinPlacanja np : NacinPlacanja.values()) {
            if (!mapa.containsKey(np.getOpis())) continue;
            contentBuilder.append(NPrintUtils.leftText(spaceLeft, np.getOpis())).append(" ");
            contentBuilder.append(NPrintUtils.rightText(spaceRight, ((Long)mapa.get(np.getOpis())).toString()));
            contentBuilder.append("\n");
            ukupnoRacuna = (int)((long)ukupnoRacuna + (Long)mapa.get(np.getOpis()));
            mapa.remove(np.getOpis());
        }
        for (CrnoPlacanje crnoPlacanje : crnaPlacanja) {
            String cpn = crnoPlacanje.getNaziv();
            if (!mapa.containsKey(cpn)) continue;
            contentBuilder.append(NPrintUtils.leftText(spaceLeft, cpn)).append(" ");
            contentBuilder.append(NPrintUtils.rightText(spaceRight, ((Long)mapa.get(cpn)).toString()));
            contentBuilder.append("\n");
            ukupnoRacuna = (int)((long)ukupnoRacuna + (Long)mapa.get(cpn));
            mapa.remove(cpn);
        }
        for (Map.Entry entry : mapa.entrySet()) {
            String naziv = (String)entry.getKey();
            Long brojRacuna = (Long)entry.getValue();
            contentBuilder.append(NPrintUtils.leftText(spaceLeft, naziv)).append(" ");
            contentBuilder.append(NPrintUtils.rightText(spaceRight, brojRacuna.toString()));
            contentBuilder.append("\n");
            ukupnoRacuna = (int)((long)ukupnoRacuna + brojRacuna);
            mapa.remove(naziv);
        }
        contentBuilder.append(NPrintUtils.leftText(spaceLeft, totalL)).append(" ");
        contentBuilder.append(NPrintUtils.rightText(spaceRight, Integer.toString(ukupnoRacuna)));
        contentBuilder.append("\n");
        contentBuilder.append(NPrintUtils.equalsFill(bkur)).append("\n");
        String headerLeftN = String.format(Konstante.getBundle().getString("TEXT_INSTRUMENTI_PLACANJA"), new Object[0]);
        String string = String.format(Konstante.getBundle().getString("TEXT_NETO_IZNOS"), new Object[0]);
        List<String> leftTitleRowsN = this.splitHeaderIntoRows(headerLeftN, spaceLeft);
        List<String> rightTitleRowsN = this.splitHeaderIntoRows(string, spaceRight);
        for (int i = 0; i < Math.max(leftTitleRowsN.size(), rightTitleRowsN.size()); ++i) {
            String l = i < leftTitleRowsN.size() ? leftTitleRowsN.get(i) : "";
            String r = i < rightTitleRowsN.size() ? rightTitleRowsN.get(i) : "";
            contentBuilder.append(NPrintUtils.leftText(spaceLeft, l)).append(" ").append(NPrintUtils.rightText(spaceRight, r)).append("\n");
        }
        contentBuilder.append(NPrintUtils.minusFill(bkur)).append("\n");
        for (NacinPlacanja np : NacinPlacanja.values()) {
            if (!this.nacinP.containsKey((Object)np)) continue;
            contentBuilder.append(NPrintUtils.leftText(bkur - 11, np.getOpis())).append(" ");
            contentBuilder.append(NPrintUtils.rightText(10, StatLogic.getNumber02NG(this.nacinP.get((Object)np)))).append("\n");
            this.ukupno += this.nacinP.get((Object)np).doubleValue();
            this.srvc += this.servisP.get((Object)np).doubleValue();
            this.ppst += this.popustP.get((Object)np).doubleValue();
            this.neto += this.netoP.get((Object)np).doubleValue();
        }
        for (CrnoPlacanje cpt : crnaPlacanja) {
            String cpn = cpt.getNaziv();
            if (!this.nacinPCrno.containsKey(cpn)) continue;
            contentBuilder.append(NPrintUtils.leftText(bkur - 11, cpn)).append(" ");
            contentBuilder.append(NPrintUtils.rightText(10, StatLogic.getNumber02NG(this.nacinPCrno.get(cpn)))).append("\n");
            this.ukupno += this.nacinPCrno.get(cpn).doubleValue();
            this.srvc += this.servisPCrno.get(cpn).doubleValue();
            this.ppst += this.popustPCrno.get(cpn).doubleValue();
            this.neto += this.netoPCrno.get(cpn).doubleValue();
        }
        if (combined != null) {
            contentBuilder.append(NPrintUtils.leftText(bkur - 11, combined)).append(" ");
            contentBuilder.append(NPrintUtils.rightText(10, StatLogic.getNumber02NG(cNetto))).append("\n");
            this.ukupno += cBrutto.doubleValue();
            this.srvc += cService.doubleValue();
            this.ppst += cDiscount.doubleValue();
            this.neto += cNetto.doubleValue();
        }
        if (this.nacinPCrno.containsKey(subtotalL)) {
            contentBuilder.append(NPrintUtils.leftText(bkur - 11, subtotalL)).append(" ");
            contentBuilder.append(NPrintUtils.rightText(10, StatLogic.getNumber02NG(this.netoPCrno.get(subtotalL)))).append("\n");
            this.ukupno += this.nacinPCrno.get(subtotalL).doubleValue();
            this.srvc += this.servisPCrno.get(subtotalL).doubleValue();
            this.ppst += this.popustPCrno.get(subtotalL).doubleValue();
            this.neto += this.netoPCrno.get(subtotalL).doubleValue();
        }
        contentBuilder.append(NPrintUtils.leftText(bkur - 11, totalL)).append(" ");
        contentBuilder.append(NPrintUtils.rightText(10, StatLogic.getNumber02NG(this.ukupno))).append("\n");
        if (this.srvc > 0.0 || this.ppst > 0.0) {
            contentBuilder.append(NPrintUtils.equalsFill(bkur)).append("\n");
        }
        if (this.ppst > 0.0) {
            contentBuilder.append(NPrintUtils.leftText(bkur - 11, String.format(Konstante.getBundle().getString("TEXT_POPUST"), new Object[0]))).append(" ");
            contentBuilder.append(NPrintUtils.rightText(10, StatLogic.getNumber02NG(this.ppst))).append("\n");
        }
        if (this.srvc > 0.0) {
            contentBuilder.append(NPrintUtils.leftText(bkur - 11, String.format(Konstante.getBundle().getString("TEXT_SERVIS"), new Object[0]))).append(" ");
            contentBuilder.append(NPrintUtils.rightText(10, StatLogic.getNumber02NG(this.srvc))).append("\n");
        }
        return contentBuilder.toString();
    }

    private List<String> splitHeaderIntoRows(String header, int lineLength) {
        LinkedList<String> rows = new LinkedList<String>();
        int idx = 0;
        for (String part : header.split("\\s+")) {
            while (idx < part.length()) {
                if (idx + lineLength >= part.length()) {
                    rows.add(part.substring(idx));
                    idx = part.length();
                    continue;
                }
                rows.add(part.substring(idx, idx + lineLength));
                idx += lineLength;
            }
            idx = 0;
        }
        return rows;
    }
}

