/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.stampa;

import com.dev63.restoran.Konstante;
import com.dev63.restoran.constants.StatLogic;
import com.dev63.restoran.model.Prijemnica;
import com.dev63.restoran.model.PrijemnicaStavka;
import com.dev63.restoran.model.Stampac;
import com.dev63.restoran.stampa.NPrintUtils;

public class StampaPrijemniceUska {
    private final Prijemnica prijemnica;
    private final Stampac stampac;
    private final int brojKopija;

    public StampaPrijemniceUska(Prijemnica prijemnica, Stampac stampac, int brojKopija) throws IllegalArgumentException {
        this.prijemnica = prijemnica;
        if (this.prijemnica == null) {
            throw new IllegalArgumentException("Argument prijemnica cannot be null");
        }
        this.stampac = stampac;
        if (this.stampac == null) {
            throw new IllegalArgumentException("Argument stampac cannot be null");
        }
        this.brojKopija = brojKopija;
        this.print();
    }

    private void print() {
        int bkur = this.stampac.getTip().getBrojKarakteraURedu();
        String content = NPrintUtils.equalsFill(bkur) + "\n";
        String dokumentL = String.format(Konstante.getBundle().getString("TEXT_DOKUMENT"), new Object[0]);
        String dokument = this.prijemnica.getTip() != null ? this.prijemnica.getTip().getInterName() : String.format(Konstante.getBundle().getString("TEXT_BROJ_SKR"), new Object[0]) + ": " + this.prijemnica.getBrPrijemnice();
        content = content + NPrintUtils.centerText(bkur, (dokumentL.length() + 2 + dokument.length() > bkur ? "" : dokumentL + ": ") + dokument) + "\n";
        if (this.prijemnica.getTip() != null) {
            content = content + NPrintUtils.centerText(bkur, String.format(Konstante.getBundle().getString("TEXT_BROJ_SKR"), new Object[0]) + ": " + this.prijemnica.getBrPrijemnice()) + "\n";
        }
        content = content + NPrintUtils.centerSplitToEnds(bkur, String.format(Konstante.getBundle().getString("TEXT_DATUM"), new Object[0]), StatLogic.getDateString(this.prijemnica.getDatumPrijemnice())) + "\n";
        content = content + NPrintUtils.minusFill(bkur) + "\n";
        for (PrijemnicaStavka ps : this.prijemnica.getStavke()) {
            String kol = StatLogic.getNumber04NGF(ps.getKolicina());
            content = content + NPrintUtils.articleAmmountRightRow(bkur, ps.getArtikal().getName(), kol) + "\n";
        }
        content = content + NPrintUtils.equalsFill(bkur) + "\n";
        NPrintUtils.printContent(content, this.stampac, this.brojKopija);
    }
}

