/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.stampa;

import com.dev63.restoran.BMTerminalSettings;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.StavkeSumarno;
import com.dev63.restoran.constants.StatLogic;
import com.dev63.restoran.model.Kasa;
import com.dev63.restoran.model.Odeljenje;
import com.dev63.restoran.model.OptionBO;
import com.dev63.restoran.model.Stampac;
import com.dev63.restoran.model.StavkaRacuna;
import com.dev63.restoran.model.Sto;
import com.dev63.restoran.model.StoNaziv;
import com.dev63.restoran.stampa.NPrintUtils;
import com.dev63.restoran.stampa.StringAlign;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;

public class StampaPorudzbine3 {
    private final ResourceBundle barmasterText = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale());
    RestoranServer server;
    boolean odstampanazbirna = false;
    boolean stampaBrPor;
    boolean hght = false;
    private Map<Odeljenje, List<StavkaRacuna>> mapa;
    private List<StavkaRacuna> stavke;
    private StoNaziv sn;
    private Sto astal;
    private List<Stampac> stampaci;
    private Kasa kasa;
    private Stampac stampac;
    private boolean fastfood;
    private String napomena;

    public StampaPorudzbine3(List<StavkaRacuna> st, boolean stampaBrPor, StoNaziv sn, Sto astal, List<Stampac> stampaci, Kasa kasa, String napomena) {
        this.mapa = StavkeSumarno.MakeHMapForOrderPrintForKasa(st, kasa);
        try {
            this.hght = BMTerminalSettings.getSetting(OptionBO.VISOKI_FONT_PORUDZBINE).booleanValue();
        }
        catch (Exception e) {
            this.hght = false;
        }
        this.kasa = kasa;
        this.sn = sn;
        this.astal = astal;
        this.stampaci = stampaci;
        this.stampaBrPor = stampaBrPor;
        this.napomena = napomena;
        this.fastfood = BMTerminalSettings.getSetting(OptionBO.FAST_FOOD).booleanValue();
        LinkedList<StavkaRacuna> stavkeZaStampu = new LinkedList<StavkaRacuna>();
        for (Stampac stmp : stampaci) {
            Odeljenje od = null;
            String content = null;
            boolean stampaj = true;
            for (StavkaRacuna stavka : st) {
                if (stavka.getArtikal().getStampaci() == null) {
                    return;
                }
                for (int i = 0; i < stavka.getArtikal().getStampaci().size(); ++i) {
                    if (!stavka.getArtikal().getStampaci().get(i).getBnaziv().equals(stmp.getBnaziv())) continue;
                    stavkeZaStampu.add(stavka);
                    od = stavka.getArtikal().getOdeljenje();
                }
            }
            if (stavkeZaStampu.isEmpty()) {
                stampaj = false;
            }
            if (!stampaj) continue;
            content = this.writeContent(stavkeZaStampu, od, stmp.getTip().getBrojDodatnihLinija(), stmp.getTip().getBrojKarakteraURedu());
            System.out.println("contentJ = " + content);
            NPrintUtils.printContent(content, stmp, stmp.getBrojKopijaPorudzbine());
            stavkeZaStampu.clear();
        }
    }

    private String writeContent(List<StavkaRacuna> stavke, Odeljenje o, int extraLinija, int brojKarakteraURedu) {
        int bkur = brojKarakteraURedu;
        String t1 = "";
        String t2 = "";
        String t3 = "";
        t1 = t1 + NPrintUtils.spaceFill(bkur) + "\n";
        t1 = t1 + NPrintUtils.centerSplitToCenter(bkur, StatLogic.getDateString(new Date()), StatLogic.getTimeString(new Date())) + "\n";
        if (this.kasa != null) {
            if (this.kasa.getProdajnoMesto() != null) {
                t1 = t1 + NPrintUtils.centerText(brojKarakteraURedu, String.format(Konstante.getBundle().getString("TEXT_PRODAJNO_MESTO"), new Object[0]) + ": " + this.kasa.getProdajnoMesto().getNaziv()) + "\n";
            }
            t2 = t2 + NPrintUtils.centerText(brojKarakteraURedu, String.format(Konstante.getBundle().getString("TEXT_KASA"), new Object[0]) + ": " + this.kasa.getOznaka()) + "\n";
        }
        t2 = t2 + NPrintUtils.spaceFill(bkur) + "\n";
        if (this.stampaBrPor) {
            t2 = t2 + NPrintUtils.centerText(bkur, String.format(this.barmasterText.getString("TEXT_PORUDZBINA_BR"), new Object[0]) + " " + stavke.get(0).getTura().getBrojTure()) + "\n";
        }
        String linija = this.sn == null ? String.format(this.barmasterText.getString("TEXT_STO"), new Object[0]) + ": " + this.astal.getBroj().toString() : this.sn.getNaziv();
        t2 = t2 + NPrintUtils.centerText(bkur, linija);
        t2 = t2 + NPrintUtils.spaceFill(bkur) + "\n";
        t2 = t2 + NPrintUtils.centerText(bkur, o != null ? o.getStampac().getBnaziv() : "") + "\n";
        t2 = t2 + NPrintUtils.spaceFill(bkur) + "\n";
        double vr = 0.0;
        for (StavkaRacuna sr : stavke) {
            boolean prices = o != null && o.getStampac().getStampaCene() != null && o.getStampac().getStampaCene() != false;
            t2 = t2 + this.printOrderItemLine(bkur, sr, prices);
            if (sr.getPodStavke() != null && !sr.getPodStavke().isEmpty()) {
                for (StavkaRacuna stavkaRacuna : sr.getPodStavke()) {
                    t2 = t2 + this.printOrderItemLine(bkur, stavkaRacuna, prices);
                    if (!prices) continue;
                    vr += stavkaRacuna.getVrednost().doubleValue();
                }
            }
            if (sr.getOpis() != null) {
                String[] opisi;
                for (String s : opisi = sr.getOpis().split(", ")) {
                    t2 = t2 + NPrintUtils.leftText(bkur, " ** " + s).concat("\n");
                }
            }
            if (!prices) continue;
            vr += sr.getVrednost().doubleValue();
        }
        if (this.napomena != null) {
            t2 = t2 + NPrintUtils.minusFill(bkur).concat("\n");
            for (String s : this.getParts(this.napomena, bkur)) {
                t2 = t2 + new StringAlign(brojKarakteraURedu, 108).format(s);
                t2 = t2 + "\n";
            }
            t2 = t2 + "\n";
            t2 = t2 + NPrintUtils.minusFill(bkur).concat("\n");
        }
        if (o == null) {
            t2 = t2 + NPrintUtils.spaceFill(bkur) + "\n";
            t2 = t2 + NPrintUtils.leftText(bkur - 12, String.format(this.barmasterText.getString("TEXT_UKUPNO"), new Object[0])) + NPrintUtils.rightText(12, StatLogic.getNumber02(vr)) + "\n";
        } else if (o.getStampac().getStampaCene() != null && o.getStampac().getStampaCene().booleanValue()) {
            t2 = t2 + NPrintUtils.leftText(bkur - 16, String.format(this.barmasterText.getString("TEXT_UKUPNO"), new Object[0])) + NPrintUtils.rightText(16, StatLogic.getNumber02(vr)) + "\n";
        }
        t3 = t3 + NPrintUtils.spaceFill(bkur) + "\n";
        Sto sto = this.astal;
        String kon = sto.getKonobar().getSkrIme() != null ? sto.getKonobar().getSkrIme() : sto.getKonobar().getPunoime();
        t3 = t3 + NPrintUtils.centerText(bkur, this.fastfood ? String.format(this.barmasterText.getString("TEXT_OPERATER"), new Object[0]) + ": " + kon : String.format(this.barmasterText.getString("TEXT_KONOBAR"), new Object[0]) + ": " + kon);
        t3 = t3 + NPrintUtils.spaceFill(bkur) + "\n";
        if (o != null) {
            for (int i = 0; i < o.getStampac().getBlankoLinija(); ++i) {
                t3 = t3 + NPrintUtils.spaceFill(bkur) + "\n";
            }
        }
        byte[] h = t1.getBytes(Charset.forName("UTF8"));
        byte[] b = t2.getBytes(Charset.forName("UTF8"));
        byte[] byArray = t3.getBytes(Charset.forName("UTF8"));
        byte[] dblH = this.hght ? o.getStampac().getTip().getEmulacija().getDblHghtBldOn() : new byte[]{};
        byte[] offH = this.hght ? o.getStampac().getTip().getEmulacija().getDblHghtBldOff() : new byte[]{};
        byte[] out = new byte[h.length + b.length + byArray.length + dblH.length + offH.length];
        int pointer = 0;
        System.arraycopy(h, 0, out, pointer, h.length);
        pointer += h.length;
        if (this.hght) {
            System.arraycopy(dblH, 0, out, pointer, dblH.length);
            pointer += dblH.length;
        }
        System.arraycopy(b, 0, out, pointer, b.length);
        pointer += b.length;
        if (this.hght) {
            System.arraycopy(offH, 0, out, pointer, offH.length);
            pointer += offH.length;
        }
        System.arraycopy(byArray, 0, out, pointer, byArray.length);
        String content = new String(out, Charset.forName("UTF8"));
        return content;
    }

    private List<String> getParts(String string, int partitionSize) {
        ArrayList<String> parts = new ArrayList<String>();
        int len = string.length();
        for (int i = 0; i < len; i += partitionSize) {
            parts.add(string.substring(i, Math.min(len, i + partitionSize)));
        }
        return parts;
    }

    private String printOrderItemLine(int bkur, StavkaRacuna sr, boolean prices) {
        StringBuilder t2 = new StringBuilder();
        StavkaRacuna parent = sr.getGlavnaStavka();
        String prefix = parent != null ? "--" : "";
        BigDecimal parentKol = parent != null ? BigDecimal.valueOf(parent.getKolicina()) : BigDecimal.ONE;
        BigDecimal kol = BigDecimal.valueOf(sr.getKolicina());
        kol = kol.divide(parentKol, 3, RoundingMode.HALF_UP);
        String kolicina = "";
        if (parentKol.compareTo(BigDecimal.ONE) != 0) {
            kolicina = kolicina.concat("(").concat(StatLogic.getNumber03NGF(parentKol)).concat("x)");
        }
        kolicina = kolicina.concat(StatLogic.getNumber03NGF(kol).concat("x "));
        int[] colLen = new int[prices ? 4 : 2];
        int i = 0;
        if (prices) {
            colLen[i++] = bkur - prefix.length();
            colLen[i++] = bkur - 16;
            colLen[i++] = 7;
            colLen[i++] = 9;
            i = 0;
            t2.append(prefix);
            t2.append(NPrintUtils.leftText(colLen[i++], sr.getArtikal().getSkrNaziv()));
            t2.append("\n");
            t2.append(NPrintUtils.rightText(colLen[i++], kolicina));
            t2.append(NPrintUtils.rightText(colLen[i++], StatLogic.getNumber02NG(sr.getCena() != null ? sr.getCena() : sr.getArtikal().getCena())));
            t2.append(NPrintUtils.rightText(colLen[i++], StatLogic.getNumber02NG(sr.getVrednost())));
            t2.append("\n");
        } else {
            colLen[i++] = kolicina.length();
            colLen[i++] = bkur - prefix.length() - kolicina.length();
            i = 0;
            t2.append(prefix);
            t2.append(NPrintUtils.leftText(colLen[i++], kolicina));
            if (sr.getArtikal().getSkrNaziv().length() > bkur - prefix.length() - kolicina.length()) {
                String[] s = sr.getArtikal().getSkrNaziv().trim().split("\\s+");
                String gore = "";
                for (int a = 0; a < s.length - 1; ++a) {
                    gore = gore + " " + s[a];
                }
                String dole = s[s.length - 1];
                t2.append(NPrintUtils.leftText(colLen[i++], gore.trim()) + "\n");
                i = 0;
                t2.append(NPrintUtils.leftText(colLen[i++], ""));
                t2.append(NPrintUtils.leftText(colLen[i++], dole));
            } else {
                t2.append(NPrintUtils.leftText(colLen[i++], sr.getArtikal().getSkrNaziv()));
            }
            t2.append("\n");
        }
        return t2.toString();
    }
}

