/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.stampa;

import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.model.Artikal;
import com.dev63.restoran.model.CrnoPlacanje;
import com.dev63.restoran.model.Placanje;
import com.dev63.restoran.model.Racun;
import com.dev63.restoran.model.Stampac;
import com.dev63.restoran.model.StavkaRacuna;
import com.dev63.restoran.model.TipStampaca;
import com.dev63.restoran.stampa.StringAlign;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.SimpleDoc;
import javax.print.attribute.HashPrintRequestAttributeSet;
import org.apache.commons.lang.StringUtils;

public class StampaKopijeRacuna1 {
    RestoranServer server;
    Stampac stampac;
    CrnoPlacanje cp;
    int brojKopija = 1;

    public StampaKopijeRacuna1(Racun racun, Restoran restoran) {
        this.server = restoran.getServer();
        this.cp = this.server.getCrnoNaziv(racun.getCrnoPlacanje());
        this.brojKopija = this.cp.getBrKopija();
        if (this.cp.getStampac() == null) {
            return;
        }
        this.stampac = this.cp.getStampac();
        if (this.stampac.getTip() == TipStampaca.EPSONTMT) {
            this.writeInFile(racun, 8);
        } else if (this.stampac.getTip() == TipStampaca.EPSONTMT80) {
            this.writeInFile(racun, 8);
        } else if (this.stampac.getTip() == TipStampaca.POSBANK80MM) {
            this.writeInFile80MM(racun, 4);
        } else if (this.stampac.getTip() == TipStampaca.EPP) {
            this.writeInFile(racun, 8);
        } else {
            this.writeInFile(racun, 0);
        }
    }

    public void writeInFile(Racun racun, int extraLinija) {
        int i;
        System.out.println("OVDE STAMPA 58MM");
        String content = "";
        if (this.cp != null) {
            if (this.cp.getHeader1() != null) {
                content = content + StringUtils.center((String)this.cp.getHeader1(), (int)34) + "\n";
            }
            if (this.cp.getHeader2() != null) {
                content = content + StringUtils.center((String)this.cp.getHeader2(), (int)34) + "\n";
            }
            if (this.cp.getHeader3() != null) {
                content = content + StringUtils.center((String)this.cp.getHeader3(), (int)34) + "\n";
            }
        }
        content = content + "---------------------------------\n";
        if (racun.getFiskalniOdstampan().booleanValue() && racun.getCrnoPlacanje() != null) {
            content = content + StringUtils.center((String)"KOPIJA RACUNA", (int)34) + "\n";
            content = content + "---------------------------------\n";
        }
        content = content + new StringAlign(15, 108).format(Konstante.getDate(racun.getDatum())) + new StringAlign(15, 114).format(Konstante.getTime(racun.getDatum())) + "\n";
        if (racun.getBrojStola() != 0) {
            content = content + StringUtils.center((String)("Sto : " + Konstante.getNazivStola(racun.getBrojStola(), this.server)), (int)34) + "\n";
        }
        content = content + "---------------------------------\n";
        content = content + "artikal    kol.   cena    ukupno\n";
        content = content + "---------------------------------\n";
        double razlika = 0.0;
        for (StavkaRacuna sr : racun.getStavke()) {
            Artikal art = sr.getArtikal();
            double tmp = sr.getCena() - this.server.getArtikal(art.getId()).getCena();
            content = content + new StringAlign(30, 108).format(art.getName()) + "\n";
            content = content + new StringAlign(10, 114).format(Konstante.getNumber1(sr.getKolicina())) + new StringAlign(10, 114).format(Konstante.getNumber2(sr.getCena())) + new StringAlign(10, 114).format(Konstante.getNumber2(sr.getVrednost())) + "\n";
        }
        content = content + "---------------------------------\n";
        content = content + "UKUPNO" + new StringAlign(25, 114).format(Konstante.getNumber2(racun.totalBezPopusta())) + "\n";
        double popust = racun.getPopust();
        double popustI = racun.totalBezPopusta() * popust / 100.0;
        content = content + "POPUST" + new StringAlign(10, 114).format(Konstante.getNumber02(popust) + "%") + new StringAlign(15, 114).format(Konstante.getNumber2(popustI)) + "\n";
        content = content + "               _________________\n";
        content = content + "TOTAL" + new StringAlign(26, 114).format(Konstante.getNumber2(racun.totalBezPopusta() - popustI)) + "\n";
        if (racun.getCrnoPlacanje() == null) {
            content = content + "---------------------------------\n";
            for (Placanje p : racun.getPlacanja()) {
                content = content + p.getNacin().name() + ":   " + Konstante.getNumber2(racun.total()) + "\n";
            }
        }
        content = content + "\n";
        if (racun.getStalniGost() != null && !racun.getStalniGost().getNaziv().isEmpty()) {
            content = content + "Korisnik:" + new StringAlign(22, 114).format(racun.getStalniGost().getNaziv()) + "\n";
        }
        content = content + "\n";
        String kon = racun.getKonobar().getSkrIme() != null ? racun.getKonobar().getSkrIme() : racun.getKonobar().getPunoime();
        content = content + StringUtils.center((String)("Konobar: " + kon), (int)34) + "\n";
        if (this.cp != null) {
            if (this.cp.getFooter1() != null) {
                content = content + StringUtils.center((String)this.cp.getFooter1(), (int)34) + "\n";
            }
            if (this.cp.getFooter2() != null) {
                content = content + StringUtils.center((String)this.cp.getFooter2(), (int)34) + "\n";
            }
            if (this.cp.getFooter3() != null) {
                content = content + StringUtils.center((String)this.cp.getFooter3(), (int)34) + "\n";
            }
        }
        for (i = 0; i < extraLinija; ++i) {
            content = content + "\n";
        }
        for (i = 0; i < this.brojKopija; ++i) {
            try {
                byte[] out;
                Thread.sleep(500L);
                DocFlavor.INPUT_STREAM flavor = DocFlavor.INPUT_STREAM.AUTOSENSE;
                HashPrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();
                PrintService[] pservices = PrintServiceLookup.lookupPrintServices(flavor, aset);
                DocPrintJob pj = null;
                for (PrintService printer : pservices) {
                    if (!printer.getName().toUpperCase().contains(this.stampac.getNaziv().toUpperCase())) continue;
                    pj = printer.createPrintJob();
                }
                byte[] bb = content.getBytes();
                if (this.stampac.getTip() == TipStampaca.STARTCP100) {
                    out = new byte[bb.length + 3];
                    System.arraycopy(bb, 0, out, 0, bb.length);
                    out[out.length - 3] = 27;
                    out[out.length - 2] = 100;
                    out[out.length - 1] = 51;
                } else {
                    out = new byte[bb.length + 2];
                    System.arraycopy(bb, 0, out, 0, bb.length);
                    out[out.length - 2] = 27;
                    out[out.length - 1] = 105;
                }
                ByteArrayInputStream is = new ByteArrayInputStream(out);
                SimpleDoc doc = new SimpleDoc(is, flavor, null);
                pj.print(doc, aset);
                ((InputStream)is).close();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void writeInFile80MM(Racun racun, int extraLinija) {
        int i;
        String content = "";
        if (this.cp != null) {
            if (this.cp.getHeader1() != null) {
                content = content + StringUtils.center((String)this.cp.getHeader1(), (int)42) + "\n";
            }
            if (this.cp.getHeader2() != null) {
                content = content + StringUtils.center((String)this.cp.getHeader2(), (int)42) + "\n";
            }
            if (this.cp.getHeader3() != null) {
                content = content + StringUtils.center((String)this.cp.getHeader3(), (int)42) + "\n";
            }
        }
        content = content + "------------------------------------------\n";
        if (racun.getFiskalniOdstampan().booleanValue() && racun.getCrnoPlacanje() != null) {
            content = content + StringUtils.center((String)"KOPIJA RACUNA", (int)42) + "\n";
            content = content + "------------------------------------------\n";
        }
        content = content + new StringAlign(22, 108).format(Konstante.getDate(racun.getDatum())) + new StringAlign(20, 114).format(Konstante.getTime(racun.getDatum())) + "\n";
        if (racun.getBrojStola() != 0) {
            content = content + StringUtils.center((String)("Sto : " + Konstante.getNazivStola(racun.getBrojStola(), this.server)), (int)42) + "\n";
        }
        content = content + "------------------------------------------\n";
        content = content + new StringAlign(12, 108).format("artikal") + new StringAlign(13, 114).format("kolicina") + new StringAlign(7, 114).format("cena") + new StringAlign(10, 114).format("ukupno") + "\n";
        content = content + "------------------------------------------\n";
        double razlika = 0.0;
        for (StavkaRacuna sr : racun.getStavke()) {
            Artikal art = sr.getArtikal();
            double tmp = sr.getCena() - this.server.getArtikal(art.getId()).getCena();
            content = content + new StringAlign(42, 108).format(art.getName()) + "\n";
            content = content + new StringAlign(22, 114).format(Konstante.getNumber1(sr.getKolicina()) + "x") + new StringAlign(10, 114).format(Konstante.getNumber2(sr.getCena())) + new StringAlign(10, 114).format(Konstante.getNumber2(sr.getVrednost())) + "\n";
        }
        content = content + "------------------------------------------\n";
        content = content + "UKUPNO" + new StringAlign(36, 114).format(Konstante.getNumber2(racun.totalBezPopusta())) + "\n";
        double popust = racun.getPopust();
        double popustI = racun.totalBezPopusta() * popust / 100.0;
        content = content + "POPUST" + new StringAlign(10, 114).format(Konstante.getNumber02(popust) + "%") + new StringAlign(26, 114).format(Konstante.getNumber2(popustI)) + "\n";
        content = content + new StringAlign(42, 114).format("_____________") + "\n";
        content = content + "TOTAL" + new StringAlign(37, 114).format(Konstante.getNumber2(racun.totalBezPopusta() - popustI)) + "\n";
        if (racun.getCrnoPlacanje() == null) {
            content = content + "------------------------------------------\n";
            for (Placanje p : racun.getPlacanja()) {
                content = content + p.getNacin().name() + ":   " + Konstante.getNumber2(racun.total()) + "\n";
            }
        }
        content = content + "\n";
        if (racun.getStalniGost() != null && !racun.getStalniGost().getNaziv().isEmpty()) {
            content = content + "Korisnik:" + new StringAlign(33, 114).format(racun.getStalniGost().getNaziv()) + "\n";
        }
        content = content + "\n";
        String kon = racun.getKonobar().getSkrIme() != null ? racun.getKonobar().getSkrIme() : racun.getKonobar().getPunoime();
        content = content + StringUtils.center((String)("Konobar: " + kon), (int)42) + "\n";
        if (this.cp != null) {
            if (this.cp.getFooter1() != null) {
                content = content + StringUtils.center((String)this.cp.getFooter1(), (int)42) + "\n";
            }
            if (this.cp.getFooter2() != null) {
                content = content + StringUtils.center((String)this.cp.getFooter2(), (int)42) + "\n";
            }
            if (this.cp.getFooter3() != null) {
                content = content + StringUtils.center((String)this.cp.getFooter3(), (int)42) + "\n";
            }
        }
        for (i = 0; i < extraLinija; ++i) {
            content = content + "\n";
        }
        for (i = 0; i < this.brojKopija; ++i) {
            try {
                byte[] out;
                Thread.sleep(500L);
                DocFlavor.INPUT_STREAM flavor = DocFlavor.INPUT_STREAM.AUTOSENSE;
                HashPrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();
                PrintService[] pservices = PrintServiceLookup.lookupPrintServices(flavor, aset);
                DocPrintJob pj = null;
                for (PrintService printer : pservices) {
                    if (!printer.getName().toUpperCase().contains(this.stampac.getNaziv().toUpperCase())) continue;
                    pj = printer.createPrintJob();
                }
                byte[] bb = content.getBytes();
                if (this.stampac.getTip() == TipStampaca.STARTCP100) {
                    out = new byte[bb.length + 3];
                    System.arraycopy(bb, 0, out, 0, bb.length);
                    out[out.length - 3] = 27;
                    out[out.length - 2] = 100;
                    out[out.length - 1] = 51;
                } else {
                    out = new byte[bb.length + 2];
                    System.arraycopy(bb, 0, out, 0, bb.length);
                    out[out.length - 2] = 27;
                    out[out.length - 1] = 105;
                }
                ByteArrayInputStream is = new ByteArrayInputStream(out);
                SimpleDoc doc = new SimpleDoc(is, flavor, null);
                pj.print(doc, aset);
                ((InputStream)is).close();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

