/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.stampa;

import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.model.CrnoPlacanje;
import com.dev63.restoran.model.Placanje;
import com.dev63.restoran.model.Racun;
import com.dev63.restoran.model.Stampac;
import com.dev63.restoran.model.StavkaRacuna;
import com.dev63.restoran.model.TipStampaca;
import com.dev63.restoran.stampa.StampaPorudzbine;
import com.dev63.restoran.stampa.StringAlign;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.SimpleDoc;
import javax.print.attribute.HashPrintRequestAttributeSet;
import org.apache.commons.lang.StringUtils;

public class StampaKopijeRacuna {
    File print;
    FileOutputStream fos = null;
    FileInputStream fis = null;
    RestoranServer server;
    Stampac stampac;
    int brojKopija = 1;

    public StampaKopijeRacuna(Racun racun, Restoran restoran) {
        this.server = restoran.getServer();
        CrnoPlacanje cp = this.server.getCrnoNaziv(racun.getCrnoPlacanje());
        if (cp.getStampac() == null) {
            return;
        }
        this.stampac = cp.getStampac();
        try {
            this.print = new File(System.getProperty("user.home"));
            this.print = new File(this.print, "restoran_print");
            if (!this.print.isDirectory()) {
                this.print.mkdir();
            }
            if (this.stampac.getTip() == TipStampaca.EPSONTMT) {
                this.writeInFile(racun, 4);
            } else if (this.stampac.getTip() == TipStampaca.EPSONTMT80) {
                this.writeInFile(racun, 4);
            } else if (this.stampac.getTip() == TipStampaca.EPP) {
                this.writeInFile(racun, 8);
            } else {
                this.writeInFile(racun, 0);
            }
            for (int i = 0; i < this.brojKopija; ++i) {
                this.printFromFile(this.stampac);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void writeInFile(Racun racun, int extraLinija) {
        try {
            CrnoPlacanje cp = null;
            if (racun.getCrnoPlacanje() != null) {
                cp = this.server.getCrnoNaziv(racun.getCrnoPlacanje());
                this.brojKopija = cp.getBrKopija();
            }
            this.fos = new FileOutputStream(this.print.getCanonicalPath() + "\\proba.txt");
            PrintStream ps = new PrintStream(this.fos);
            if (cp != null) {
                if (cp.getHeader1() != null) {
                    ps.println(StringUtils.center((String)cp.getHeader1(), (int)34));
                }
                if (cp.getHeader2() != null) {
                    ps.println(StringUtils.center((String)cp.getHeader2(), (int)34));
                }
                if (cp.getHeader3() != null) {
                    ps.println(StringUtils.center((String)cp.getHeader3(), (int)34));
                }
            }
            ps.println("---------------------------------");
            if (racun.getFiskalniOdstampan().booleanValue() && racun.getCrnoPlacanje() != null) {
                ps.println(StringUtils.center((String)"KOPIJA RACUNA", (int)34));
                ps.println("---------------------------------");
            }
            ps.println(new StringAlign(15, 108).format(Konstante.getDate(racun.getDatum())) + new StringAlign(15, 114).format(Konstante.getTime(racun.getDatum())));
            if (racun.getBrojStola() != 0) {
                ps.println(StringUtils.center((String)("Sto : " + Konstante.getNazivStola(racun.getBrojStola(), this.server)), (int)34));
            }
            ps.println("---------------------------------");
            ps.println("artikal    kol.   cena    ukupno");
            ps.println("---------------------------------");
            for (StavkaRacuna sr : racun.getStavke()) {
                ps.println(new StringAlign(30, 108).format(sr.getArtikal().getName()));
                ps.println(new StringAlign(10, 114).format(Konstante.getNumber1(sr.getKolicina())) + new StringAlign(10, 114).format(Konstante.getNumber2(sr.getCena())) + new StringAlign(10, 114).format(Konstante.getNumber2(sr.getVrednost())));
            }
            ps.println("---------------------------------");
            ps.println("UKUPNO" + new StringAlign(25, 114).format(Konstante.getNumber2(racun.totalBezPopusta())));
            double popust = racun.getPopust();
            double popustI = racun.totalBezPopusta() * popust / 100.0;
            ps.println("POPUST" + new StringAlign(10, 114).format(Konstante.getNumber02(popust) + "%") + new StringAlign(15, 114).format(Konstante.getNumber2(popustI)));
            ps.println("               _________________");
            ps.println("SVEGA" + new StringAlign(26, 114).format(Konstante.getNumber2(racun.totalBezPopusta() - popustI)));
            if (racun.getCrnoPlacanje() == null) {
                ps.println("---------------------------------");
                for (Placanje p : racun.getPlacanja()) {
                    ps.println(p.getNacin().name() + ":   " + Konstante.getNumber2(racun.total()));
                }
            }
            ps.println();
            if (racun.getStalniGost() != null && !racun.getStalniGost().getNaziv().isEmpty()) {
                ps.println("Korisnik:" + new StringAlign(22, 114).format(racun.getStalniGost().getNaziv()));
            }
            ps.println();
            String kon = racun.getKonobar().getSkrIme() != null ? racun.getKonobar().getSkrIme() : racun.getKonobar().getPunoime();
            ps.println(StringUtils.center((String)("Konobar: " + kon), (int)34));
            if (cp != null) {
                if (cp.getFooter1() != null) {
                    ps.println(StringUtils.center((String)cp.getFooter1(), (int)34));
                }
                if (cp.getFooter2() != null) {
                    ps.println(StringUtils.center((String)cp.getFooter2(), (int)34));
                }
                if (cp.getFooter3() != null) {
                    ps.println(StringUtils.center((String)cp.getFooter3(), (int)34));
                }
            }
            for (int i = 0; i < extraLinija; ++i) {
                ps.println();
            }
            this.fos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                this.fos.close();
            }
            catch (IOException ex) {
                Logger.getLogger(StampaPorudzbine.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void printFromFile(Stampac stampac) {
        if (stampac.getTip() == TipStampaca.FP550 || stampac.getTip() == TipStampaca.HCPP2DS || stampac.getTip() == TipStampaca.HCPBEST) {
            return;
        }
        try {
            byte[] by;
            DocFlavor flavor = DocFlavor.INPUT_STREAM.AUTOSENSE;
            HashPrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();
            PrintService[] pservices = PrintServiceLookup.lookupPrintServices(flavor, aset);
            DocPrintJob pj = null;
            DocPrintJob pj2 = null;
            for (PrintService printer : pservices) {
                if (!printer.getName().toUpperCase().contains(stampac.getNaziv().toUpperCase())) continue;
                pj = printer.createPrintJob();
                pj2 = printer.createPrintJob();
            }
            this.fis = new FileInputStream(this.print.getCanonicalPath() + "\\proba.txt");
            SimpleDoc doc = new SimpleDoc(this.fis, flavor, null);
            pj.print(doc, aset);
            this.fis.close();
            flavor = DocFlavor.BYTE_ARRAY.AUTOSENSE;
            switch (stampac.getTip()) {
                case STARTCP100: {
                    by = new byte[]{27, 100, 51};
                    break;
                }
                default: {
                    by = new byte[]{27, 105};
                }
            }
            SimpleDoc doc2 = new SimpleDoc(by, flavor, null);
            pj2.print(doc2, aset);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            try {
                this.fis.close();
            }
            catch (IOException ex1) {
                Logger.getLogger(StampaPorudzbine.class.getName()).log(Level.SEVERE, null, ex1);
            }
        }
    }
}

