/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.stampa;

import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.model.Artikal;
import com.dev63.restoran.model.Kartica;
import com.dev63.restoran.model.Odeljenje;
import com.dev63.restoran.model.Stampac;
import com.dev63.restoran.sistem.PreostalaKolicina;
import com.dev63.restoran.stampa.StringAlign;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.SimpleDoc;
import javax.print.attribute.HashPrintRequestAttributeSet;
import org.apache.commons.lang.StringUtils;

public class StampaIzvestajZalihe {
    File print;
    FileOutputStream fos = null;
    FileInputStream fis = null;
    RestoranServer server;
    boolean odstampanazbirna = false;
    Stampac stampac;

    public StampaIzvestajZalihe(Restoran restoran, boolean blic, Date day1, Date day2, Odeljenje odeljenje, List<Kartica> kartica1, List<Kartica> kartica2) {
        this.server = restoran.getServer();
        this.print = new File(System.getProperty("user.home"));
        this.print = new File(this.print, "restoran_print");
        if (!this.print.isDirectory()) {
            this.print.mkdir();
        }
        try {
            this.stampac = this.server.readIzvestajiStampacObject();
            this.writeInFile(odeljenje, blic, kartica1, kartica2);
            this.printFromFile();
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
        }
    }

    public StampaIzvestajZalihe(Restoran restoran, String[][] uskiString, String title, Date day1, Date day2) {
        this.server = restoran.getServer();
        this.print = new File(System.getProperty("user.home"));
        this.print = new File(this.print, "restoran_print");
        if (!this.print.isDirectory()) {
            this.print.mkdir();
        }
        try {
            this.stampac = this.server.readIzvestajiStampacObject();
            this.writeInFile(uskiString, title, day1, day2);
            this.printFromFile();
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
        }
    }

    private void writeInFile(String[][] uski, String title, Date day1, Date day2) {
        try {
            this.fos = new FileOutputStream(this.print.getCanonicalPath() + "\\artikli.txt");
            PrintStream ps = new PrintStream(this.fos);
            ps.println(Konstante.getDate(new Date()) + "\t" + Konstante.getfullTime(new Date()));
            ps.println(StringUtils.center((String)title, (int)32));
            if (day1 != null && day2 != null) {
                ps.println(StringUtils.center((String)("od " + Konstante.getDate(day1) + " do " + Konstante.getDate(day2)), (int)32));
            }
            ps.println("");
            if (day1 != null && day2 != null) {
                ps.println("Artikal         J.M.    Stanje");
            } else {
                ps.println("Artikal         J.M.    Stanje");
                ps.println("------------------------------");
            }
            for (int i = 0; i < uski.length; ++i) {
                if (uski[i][0] != null && uski[i][0].length() > 2) {
                    ps.println("------------------------------");
                    ps.println(StringUtils.center((String)uski[i][0], (int)32));
                    ps.println("------------------------------");
                    continue;
                }
                String s1 = uski[i][1] != null ? uski[i][1] : "";
                String s2 = uski[i][2] != null ? uski[i][2] : "";
                String s3 = uski[i][3] != null ? uski[i][3] : "";
                ps.println(new StringAlign(19, 108).format(s1) + new StringAlign(5, 108).format(s2) + new StringAlign(6, 114).format(s3));
            }
            ps.println("");
            ps.println("");
            ps.println("");
            ps.println("");
            this.fos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                this.fos.close();
            }
            catch (IOException ex) {
                Logger.getLogger(StampaIzvestajZalihe.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void writeInFile(Odeljenje od, boolean blic, List<Kartica> kartica1, List<Kartica> kartica2) {
        double ukupno = 0.0;
        try {
            double vrednost;
            double zavrsno;
            double pocetno;
            double ulaz;
            double izlaz;
            List<Artikal> artikli;
            double ukupnoOdeljenje;
            List<Odeljenje> odeljenja;
            this.fos = new FileOutputStream(this.print.getCanonicalPath() + "\\artikli.txt");
            PrintStream ps = new PrintStream(this.fos);
            String ode = od == null ? "Sva proizvodna mesta" : od.getNaziv();
            ps.println(Konstante.getDate(new Date()) + "\t" + Konstante.getfullTime(new Date()));
            ps.println(StringUtils.center((String)"IZVESTAJ O STANJU ZALIHA", (int)32));
            ps.println(StringUtils.center((String)ode, (int)32));
            ps.println("Artikal          JM      Vrednost");
            ps.println("Pocetno  Ulaz   Prodato   Zavrsno");
            ps.println("---------------------------------");
            if (od == null) {
                odeljenja = this.server.readOdeljenjeBezMag();
            } else {
                odeljenja = new ArrayList<Odeljenje>();
                odeljenja.add(od);
            }
            for (Odeljenje o : odeljenja) {
                ukupnoOdeljenje = 0.0;
                ps.println(StringUtils.center((String)o.getNaziv(), (int)34));
                ps.println("---------------------------------");
                artikli = PreostalaKolicina.getArtikliBezSlozenihISirovina(o, this.server);
                this.sortiraj(artikli);
                for (Artikal a : artikli) {
                    izlaz = this.izracunajIzlaz(a, kartica2);
                    ulaz = this.izracunajUlaz(a, kartica2);
                    if (blic && ulaz == 0.0 && izlaz == 0.0) continue;
                    pocetno = this.izracunajPocetno(a, o, kartica1);
                    zavrsno = pocetno + ulaz - izlaz;
                    vrednost = zavrsno * a.getTrenutnaNV();
                    ukupnoOdeljenje += vrednost;
                    ukupno += vrednost;
                    ps.println(new StringAlign(19, 108).format(a.getName()) + new StringAlign(5, 108).format(a.getJedinicaMere()) + new StringAlign(8, 114).format(Konstante.getNumber2(vrednost)));
                    ps.println(new StringAlign(8, 108).format(Konstante.getNumber4(pocetno)) + new StringAlign(8, 108).format(Konstante.getNumber4(ulaz)) + new StringAlign(8, 108).format(Konstante.getNumber4(izlaz)) + new StringAlign(8, 114).format(Konstante.getNumber4(zavrsno)));
                }
                ps.println();
            }
            for (Odeljenje o : odeljenja) {
                ukupnoOdeljenje = 0.0;
                ps.println(StringUtils.center((String)("SIROVINE " + o.getNaziv()), (int)32));
                ps.println("------------------------------");
                artikli = PreostalaKolicina.getSirovine(o, this.server);
                this.sortiraj(artikli);
                for (Artikal a : artikli) {
                    izlaz = this.izracunajIzlaz(a, o, kartica2);
                    ulaz = this.izracunajUlaz(a, o, kartica2);
                    if (blic && ulaz == 0.0 && izlaz == 0.0) continue;
                    pocetno = this.izracunajPocetno(a, o, kartica2);
                    zavrsno = pocetno + ulaz - izlaz;
                    vrednost = zavrsno * a.getTrenutnaNV();
                    ukupnoOdeljenje += vrednost;
                    ukupno += vrednost;
                    ps.println(new StringAlign(19, 108).format(a.getName()) + new StringAlign(5, 108).format(a.getJedinicaMere()) + new StringAlign(8, 114).format(Konstante.getNumber2(vrednost)));
                    ps.println(new StringAlign(8, 108).format(Konstante.getNumber4(pocetno)) + new StringAlign(8, 108).format(Konstante.getNumber4(ulaz)) + new StringAlign(8, 108).format(Konstante.getNumber4(izlaz)) + new StringAlign(8, 114).format(Konstante.getNumber4(zavrsno)));
                }
            }
            ps.println("---------------------------------");
            ps.println("Nabavna vrednost" + new StringAlign(16, 114).format(Konstante.getNumber2(ukupno)));
            ps.println("---------------------------------");
            this.fos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                this.fos.close();
            }
            catch (IOException ex) {
                Logger.getLogger(StampaIzvestajZalihe.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void printFromFile() {
        if (this.stampac == null) {
            return;
        }
        try {
            byte[] by;
            DocFlavor flavor = DocFlavor.INPUT_STREAM.AUTOSENSE;
            HashPrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();
            PrintService[] pservices = PrintServiceLookup.lookupPrintServices(flavor, aset);
            DocPrintJob pj = null;
            DocPrintJob pj2 = null;
            for (PrintService printer : pservices) {
                if (!printer.getName().toUpperCase().contains(this.stampac.getNaziv().toUpperCase())) continue;
                pj = printer.createPrintJob();
                pj2 = printer.createPrintJob();
            }
            this.fis = new FileInputStream(this.print.getCanonicalPath() + "\\artikli.txt");
            SimpleDoc doc = new SimpleDoc(this.fis, flavor, null);
            pj.print(doc, aset);
            this.fis.close();
            flavor = DocFlavor.BYTE_ARRAY.AUTOSENSE;
            switch (this.stampac.getTip()) {
                case STARTCP100: {
                    by = new byte[]{27, 100, 51};
                    break;
                }
                default: {
                    by = new byte[]{27, 105};
                }
            }
            SimpleDoc doc2 = new SimpleDoc(by, flavor, null);
            pj2.print(doc2, aset);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            try {
                this.fis.close();
            }
            catch (IOException ex1) {
                Logger.getLogger(StampaIzvestajZalihe.class.getName()).log(Level.SEVERE, null, ex1);
            }
        }
    }

    public double izracunajUlaz(Artikal a, List<Kartica> kartica2) {
        double ulaz = 0.0;
        for (Kartica k : kartica2) {
            if (!k.getArtikal().equals(a) || !(k.getKolicina() > 0.0)) continue;
            ulaz += k.getKolicina().doubleValue();
        }
        return ulaz;
    }

    public double izracunajIzlaz(Artikal a, List<Kartica> kartica2) {
        double izlaz = 0.0;
        for (Kartica k : kartica2) {
            if (!k.getArtikal().equals(a) || !(k.getKolicina() < 0.0)) continue;
            izlaz += -k.getKolicina().doubleValue();
        }
        return izlaz;
    }

    public double izracunajPocetno(Artikal a, Odeljenje o, List<Kartica> kartica1) {
        double pocetno = 0.0;
        for (Kartica k : kartica1) {
            if (!k.getArtikal().equals(a) || !k.getOdeljenje().equals(o)) continue;
            pocetno += k.getKolicina().doubleValue();
        }
        return pocetno;
    }

    public double izracunajUlaz(Artikal a, Odeljenje o, List<Kartica> kartica2) {
        double ulaz = 0.0;
        for (Kartica k : kartica2) {
            if (!k.getArtikal().equals(a) || !k.getOdeljenje().equals(o) || !(k.getKolicina() > 0.0)) continue;
            ulaz += k.getKolicina().doubleValue();
        }
        return ulaz;
    }

    public double izracunajIzlaz(Artikal a, Odeljenje o, List<Kartica> kartica2) {
        double izlaz = 0.0;
        for (Kartica k : kartica2) {
            if (!k.getArtikal().equals(a) || !k.getOdeljenje().equals(o) || !(k.getKolicina() < 0.0)) continue;
            izlaz += -k.getKolicina().doubleValue();
        }
        return izlaz;
    }

    public void sortiraj(List<Artikal> artikli) {
        Comparator<Artikal> SENIORITY_ORDER = null;
        SENIORITY_ORDER = new Comparator<Artikal>(){

            @Override
            public int compare(Artikal t1, Artikal t2) {
                return t1.getName().compareTo(t2.getName());
            }
        };
        Collections.sort(artikli, SENIORITY_ORDER);
    }
}

