/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.stampa;

import com.dev63.fiscal.fp550.PoreskaGrupa;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.constants.StatLogic;
import com.dev63.restoran.model.Artikal;
import com.dev63.restoran.model.CrnoPlacanje;
import com.dev63.restoran.model.JedMere;
import com.dev63.restoran.model.Komitent;
import com.dev63.restoran.model.Konobar;
import com.dev63.restoran.model.NacinPlacanja;
import com.dev63.restoran.model.Option;
import com.dev63.restoran.model.Placanje;
import com.dev63.restoran.model.Racun;
import com.dev63.restoran.model.StalniGost;
import com.dev63.restoran.model.Stampac;
import com.dev63.restoran.model.StavkaRacuna;
import com.dev63.restoran.model.TipStampaca;
import com.dev63.restoran.model.Tura;
import com.dev63.restoran.parts.XMLWriter;
import com.dev63.restoran.parts.XMLWriterHCP;
import com.dev63.restoran.stampa.NPrintUtils;
import com.dev63.restoran.stampa.StringAlign;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StampaGotovinskogUska {
    private static final ResourceBundle barmasterText = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale());
    static RestoranServer server;
    Stampac stampac;
    int brojKopija = 1;
    String codePage;
    String naziv;
    String adresa;
    String mesto;
    String pib;
    String brojBI;
    String maticniBroj;

    public StampaGotovinskogUska(Racun racun, String naziv, String adresa, String mesto, String pib, Stampac stampac, String brojBI, String maticniBroj, RestoranServer server) {
        this.naziv = naziv;
        this.adresa = adresa;
        this.mesto = mesto;
        this.pib = pib;
        this.brojBI = brojBI;
        StampaGotovinskogUska.server = server;
        this.maticniBroj = maticniBroj;
        if (stampac != null) {
            this.stampac = stampac;
            this.codePage = stampac.getKodnaStrana();
            String content = this.writeInString(racun, stampac.getTip().getBrojDodatnihLinija(), stampac.getTip().getBrojKarakteraURedu());
            if (TipStampaca.RMINEFISKAL == stampac.getTip()) {
                XMLWriter.printUskiGotovinskiRMI(content);
            } else {
                NPrintUtils.printContent(content, stampac, this.brojKopija);
            }
            return;
        }
    }

    public void printFromString(String print) {
        if (this.stampac.getTip() == TipStampaca.HCPP2DS) {
            try {
                XMLWriterHCP.writeNonFiscal(print);
            }
            catch (Exception ex) {
                Logger.getLogger(StampaGotovinskogUska.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else if (this.stampac.getTip() == TipStampaca.RMINEFISKAL) {
            try {
                String out = print;
                out = StatLogic.clearFromEasternLatinChars(out);
                LinkedList<String> printList = new LinkedList<String>();
                while (out.length() > 32) {
                    printList.add(out.substring(0, 32));
                    out = out.substring(32);
                }
                XMLWriter.writeNonFiscal(printList);
            }
            catch (Exception ex) {
                Logger.getLogger(StampaGotovinskogUska.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private String writeInString(Racun r, int extraLinija, int brojKarakteraURedu) {
        int stopa;
        String print = "";
        char[] nla = new char[brojKarakteraURedu];
        char[] mla = new char[brojKarakteraURedu];
        char[] ela = new char[brojKarakteraURedu];
        char[] ula = new char[brojKarakteraURedu];
        char[] dot = new char[brojKarakteraURedu];
        Arrays.fill(nla, ' ');
        Arrays.fill(ela, '=');
        Arrays.fill(mla, '-');
        Arrays.fill(ula, '_');
        Arrays.fill(dot, '.');
        print = print + new String(ula) + "\n";
        print = print + new String(mla) + "\n";
        String pibL = barmasterText.getString("TEXT_PIB") + ": ";
        print = print + this.prilagodiRed(this.naziv, brojKarakteraURedu) + "\n";
        print = print + this.prilagodiRed(this.adresa, brojKarakteraURedu) + "\n";
        print = print + new StringAlign(brojKarakteraURedu, 108).format(this.mesto == null ? "" : this.mesto) + "\n";
        print = print + new StringAlign(brojKarakteraURedu, 108).format(pibL + (this.pib == null ? "" : this.pib)) + "\n";
        print = print + new StringAlign(brojKarakteraURedu, 108).format("Mati\u010dni broj: " + (this.maticniBroj == null ? "" : this.maticniBroj)) + "\n";
        print = print + new String(mla) + "\n";
        Komitent k = r.getKomitent();
        if (k == null) {
            print = print + new String(nla) + "\n";
            print = print + new StringAlign(brojKarakteraURedu, 108).format(String.format(barmasterText.getString("TEXT_KUPAC") + ":", new Object[0])) + "\n";
            print = print + new String(dot) + "\n";
            print = print + new String(nla) + "\n";
            print = print + new StringAlign(brojKarakteraURedu, 108).format("Adresa:") + "\n";
            print = print + new String(dot) + "\n";
            print = print + new String(nla) + "\n";
            print = print + new StringAlign(brojKarakteraURedu, 108).format("Mesto:") + "\n";
            print = print + new String(dot) + "\n";
            print = print + new String(nla) + "\n";
            print = print + new StringAlign(brojKarakteraURedu, 108).format("PIB:") + "\n";
            print = print + new String(dot) + "\n";
            print = print + new String(nla) + "\n";
            print = print + new StringAlign(brojKarakteraURedu, 108).format("Mati\u010dni broj:") + "\n";
            print = print + new String(dot) + "\n";
        } else {
            print = print + new StringAlign(brojKarakteraURedu, 108).format(String.format(barmasterText.getString("TEXT_KUPAC") + ":", new Object[0])) + "\n";
            print = print + this.prilagodiRed(k.getNaziv(), brojKarakteraURedu) + "\n";
            print = print + this.prilagodiRed(k.getAdresa(), brojKarakteraURedu) + "\n";
            print = print + new StringAlign(brojKarakteraURedu, 108).format(k == null ? new String(ula).substring(4) : (k.getMesto().length() > brojKarakteraURedu ? k.getMesto().substring(0, brojKarakteraURedu) : k.getMesto())) + "\n";
            print = print + new StringAlign(brojKarakteraURedu, 108).format(pibL + (k == null ? new String(ula).substring(pibL.length() + 4) : (k.getPib().length() > brojKarakteraURedu ? k.getPib().substring(0, brojKarakteraURedu) : k.getPib()))) + "\n";
            print = print + new StringAlign(brojKarakteraURedu, 108).format("Mati\u010dni broj: " + (k.getMb() == null ? "" : k.getMb())) + "\n";
        }
        print = print + new String(nla) + "\n";
        print = print + new String(mla) + "\n";
        print = print + new StringAlign(brojKarakteraURedu, 99).format(String.format(barmasterText.getString("TEXT_RACUN_BR"), new Object[0]) + ": " + r.getId()) + "\n";
        print = print + new StringAlign(brojKarakteraURedu, 99).format("BI:" + this.brojBI) + "\n";
        print = print + new String(mla) + "\n";
        double aZbir = 0.0;
        double eZbir = 0.0;
        double dZbir = 0.0;
        double gZbir = 0.0;
        double djZbir = 0.0;
        double zjZbir = 0.0;
        double iZbir = 0.0;
        double jZbir = 0.0;
        double kZbir = 0.0;
        double pTotal = 0.0;
        block13: for (StavkaRacuna sr : r.getStavke()) {
            Artikal art = sr.getArtikal();
            print = print + new StringAlign(brojKarakteraURedu, 108).format(art.getName()) + "\n";
            print = print + new StringAlign(brojKarakteraURedu - 10 - 10, 114).format(Konstante.getNumber1(sr.getKolicina()) + "x");
            print = print + new StringAlign(10, 114).format(Konstante.getNumber2(sr.getCena()));
            print = print + new StringAlign(10, 114).format(Konstante.getNumber2(sr.getVrednost())) + "\n";
            switch (art.getPoreskaGrupa()) {
                case GRUPA_A: {
                    aZbir += sr.getCena() * sr.getKolicina();
                    continue block13;
                }
                case GRUPA_D: {
                    dZbir += sr.getCena() * sr.getKolicina();
                    continue block13;
                }
                case GRUPA_G: {
                    gZbir += sr.getCena() * sr.getKolicina();
                    continue block13;
                }
                case GRUPA_E: {
                    eZbir += sr.getCena() * sr.getKolicina();
                    continue block13;
                }
                case GRUPA_DJ: {
                    djZbir += sr.getCena() * sr.getKolicina();
                    continue block13;
                }
                case GRUPA_ZJ: {
                    zjZbir += sr.getCena() * sr.getKolicina();
                    continue block13;
                }
                case GRUPA_I: {
                    iZbir += sr.getCena() * sr.getKolicina();
                    continue block13;
                }
                case GRUPA_J: {
                    jZbir += sr.getCena() * sr.getKolicina();
                    continue block13;
                }
                case GRUPA_K: {
                    kZbir += sr.getCena() * sr.getKolicina();
                    continue block13;
                }
            }
            aZbir += sr.getCena() * sr.getKolicina();
        }
        double porezA = Konstante.round(Konstante.getPorezFromBruto(aZbir, PoreskaGrupa.GRUPA_A), 2);
        double porezE = Konstante.round(Konstante.getPorezFromBruto(eZbir, PoreskaGrupa.GRUPA_E), 2);
        double porezD = Konstante.round(Konstante.getPorezFromBruto(dZbir, PoreskaGrupa.GRUPA_D), 2);
        double porezG = Konstante.round(Konstante.getPorezFromBruto(gZbir, PoreskaGrupa.GRUPA_G), 2);
        double porezDJ = Konstante.round(Konstante.getPorezFromBruto(djZbir, PoreskaGrupa.GRUPA_DJ), 2);
        double porezZJ = Konstante.round(Konstante.getPorezFromBruto(zjZbir, PoreskaGrupa.GRUPA_ZJ), 2);
        double porezI = Konstante.round(Konstante.getPorezFromBruto(eZbir, PoreskaGrupa.GRUPA_I), 2);
        double porezJ = Konstante.round(Konstante.getPorezFromBruto(eZbir, PoreskaGrupa.GRUPA_J), 2);
        double porezK = Konstante.round(Konstante.getPorezFromBruto(eZbir, PoreskaGrupa.GRUPA_K), 2);
        double osnovica = r.total() - porezA - porezE - porezD - porezG - porezDJ - porezZJ - porezI - porezJ - porezK;
        print = print + new String(mla) + "\n";
        print = print + new StringAlign(brojKarakteraURedu, 114).format("Ukupno:" + Konstante.getNumber2(r.total())) + "\n";
        print = print + new String(mla) + "\n";
        print = print + new StringAlign(brojKarakteraURedu, 108).format("Osnovica: " + osnovica) + "\n";
        if (aZbir > 0.0) {
            stopa = Konstante.getPGStopaProcenatCeoBroj(PoreskaGrupa.GRUPA_A);
            print = print + new StringAlign(brojKarakteraURedu, 108).format("Porez po " + stopa + "%: " + porezA) + "\n";
        }
        if (gZbir > 0.0) {
            stopa = Konstante.getPGStopaProcenatCeoBroj(PoreskaGrupa.GRUPA_G);
            print = print + new StringAlign(brojKarakteraURedu, 108).format("Porez po " + stopa + "%: " + porezG) + "\n";
        }
        if (dZbir > 0.0) {
            stopa = Konstante.getPGStopaProcenatCeoBroj(PoreskaGrupa.GRUPA_D);
            print = print + new StringAlign(brojKarakteraURedu, 108).format("Porez po " + stopa + "%: " + porezD) + "\n";
        }
        if (eZbir > 0.0) {
            stopa = Konstante.getPGStopaProcenatCeoBroj(PoreskaGrupa.GRUPA_E);
            print = print + new StringAlign(brojKarakteraURedu, 108).format("Porez po " + stopa + "%: " + porezE) + "\n";
        }
        if (djZbir > 0.0) {
            stopa = Konstante.getPGStopaProcenatCeoBroj(PoreskaGrupa.GRUPA_DJ);
            print = print + new StringAlign(brojKarakteraURedu, 108).format("Porez po " + stopa + "%: " + porezDJ) + "\n";
        }
        if (zjZbir > 0.0) {
            stopa = Konstante.getPGStopaProcenatCeoBroj(PoreskaGrupa.GRUPA_ZJ);
            print = print + new StringAlign(brojKarakteraURedu, 108).format("Porez po " + stopa + "%: " + porezZJ) + "\n";
        }
        if (iZbir > 0.0) {
            stopa = Konstante.getPGStopaProcenatCeoBroj(PoreskaGrupa.GRUPA_I);
            print = print + new StringAlign(brojKarakteraURedu, 108).format("Porez po " + stopa + "%: " + porezI) + "\n";
        }
        if (jZbir > 0.0) {
            stopa = Konstante.getPGStopaProcenatCeoBroj(PoreskaGrupa.GRUPA_J);
            print = print + new StringAlign(brojKarakteraURedu, 108).format("Porez po " + stopa + "%: " + porezJ) + "\n";
        }
        if (kZbir > 0.0) {
            stopa = Konstante.getPGStopaProcenatCeoBroj(PoreskaGrupa.GRUPA_K);
            print = print + new StringAlign(brojKarakteraURedu, 108).format("Porez po " + stopa + "%: " + porezK) + "\n";
        }
        print = print + new String(mla) + "\n";
        print = print + new StringAlign(brojKarakteraURedu, 108).format(barmasterText.getString("TEXT_OPERATER") + ": " + r.getKonobar().getSkrIme()) + "\n";
        print = print + new String(mla) + "\n";
        print = print + new String(nla) + "\n";
        print = print + new StringAlign(brojKarakteraURedu, 108).format("Racun izdao:") + "\n";
        print = print + new String(dot) + "\n";
        print = print + new String(nla) + "\n";
        print = print + new StringAlign(brojKarakteraURedu, 108).format("Potpis kupca:") + "\n";
        print = print + new String(dot) + "\n";
        print = print + new String(nla) + "\n";
        print = print + new StringAlign(brojKarakteraURedu, 108).format("Broj li\u010dne karte:") + "\n";
        print = print + new String(dot) + "\n";
        print = print + new String(nla) + "\n";
        print = print + new String(mla) + "\n";
        print = print + new StringAlign(brojKarakteraURedu, 108).format(barmasterText.getString("TEXT_DATUM_PROMETA") + ": " + StatLogic.getDateString(r.getDatum())) + "\n";
        print = print + new String(mla) + "\n";
        print = print + new String(ula) + "\n";
        try {
            String foot1 = server.getSetting(Option.RACUN_FOOTER_1).stringValue();
            String foot2 = server.getSetting(Option.RACUN_FOOTER_2).stringValue();
            String foot3 = server.getSetting(Option.RACUN_FOOTER_3).stringValue();
            String foot4 = server.getSetting(Option.RACUN_FOOTER_4).stringValue();
            if (!foot1.equals("")) {
                print = print + new StringAlign(brojKarakteraURedu, 108).format(foot1);
            }
            if (!foot2.equals("")) {
                print = print + new StringAlign(brojKarakteraURedu, 108).format(foot2);
            }
            if (!foot3.equals("")) {
                print = print + new StringAlign(brojKarakteraURedu, 108).format(foot3);
            }
            if (!foot4.equals("")) {
                print = print + new StringAlign(brojKarakteraURedu, 108).format(foot4);
            }
            if (!(foot1.equals("") && foot2.equals("") && foot3.equals("") && foot4.equals(""))) {
                print = print + new String(ula);
                print = print + new String(mla);
            }
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        return print;
    }

    public static void main(String[] args) {
        CrnoPlacanje cp = new CrnoPlacanje();
        cp.setBrKopija(1);
        cp.setHeader1("METRO CASH & CARRY D.O.O.");
        cp.setHeader2("AUTOPUT ZA NOVI SAD 120");
        cp.setHeader3("BEOGRAD-ZEMUN");
        cp.setHeader4("PJ.IBARSKI PUT 20");
        cp.setHeader5("IBARSKI PUT 20");
        cp.setHeader6("BEOGRAD \u010cUKARICA");
        cp.setHeader7("PIB: 102864104");
        cp.setFooter1("I ZAPAMTI TUPAVKO");
        cp.setFooter2("OVO NIJE FISKALNI RA\u010cUN");
        cp.setRekapitulacijaPoreza(Boolean.TRUE);
        cp.setNaziv("Proba");
        cp.setPrikazEkran(false);
        Stampac s = new Stampac();
        s.setTip(TipStampaca.HCPP2DS);
        s.setNaziv("SANK1");
        cp.setStampac(s);
        Racun r = new Racun();
        r.setId(123456L);
        r.setBrojStola(0);
        r.setCrnoPlacanje("Proba");
        r.setDatum(new Date());
        r.setFiskalniOdstampan(Boolean.FALSE);
        r.setPopust(0.0);
        r.setStorniran(false);
        r.setZatvoren(false);
        StalniGost sg = new StalniGost();
        sg.setNaziv("MIKS Keops");
        sg.setAdersa("Glavna BB");
        sg.setMesto("11000 Beograd");
        sg.setPib("123456789");
        r.setStalniGost(sg);
        Placanje p = new Placanje();
        p.setIznos(15500.0);
        p.setNacin(NacinPlacanja.GOTOVINA);
        r.setPlacanja(new LinkedList<Placanje>());
        r.getPlacanja().add(p);
        Konobar k = new Konobar();
        k.setPunoIme("\u0160alabajzer");
        k.setId(1L);
        k.setSkrIme(k.getPunoime());
        r.setKonobar(k);
        Tura t = new Tura();
        t.setBrojStola(0);
        t.setBrojTure(0);
        t.setRacun(r);
        String[] ss = new String[]{"\u0160", "\u0106", "\u010c", "\u0110", "\u017d", "\u0161", "\u0107", "\u010d", "\u0111", "\u017e"};
        LinkedList<StavkaRacuna> srl = new LinkedList<StavkaRacuna>();
        for (int i = 0; i < 10; ++i) {
            Artikal a = new Artikal();
            a.setName("artikal" + ss[i % ss.length] + " " + (i % 2 == 0 ? "na popustu " : "") + i);
            a.setId(Long.valueOf(i));
            a.setSkrNaziv(a.getName());
            a.setPoreskaGrupa(PoreskaGrupa.values()[i % 3 == 0 ? 0 : i % 3 + 2]);
            a.setJedinicaMere((new String[]{JedMere.KOM.name(), JedMere.KG.name(), JedMere.LIT.name(), JedMere.POR.name()})[i % 4]);
            a.setCena(150.0 * (double)(i % 5 + 1));
            a.setDozvoljenPopust(Boolean.TRUE);
            StavkaRacuna sr = new StavkaRacuna();
            sr.setArtikal(a);
            sr.setBrojStola(0);
            sr.setCena(a.getCena());
            sr.setKolicina(Double.valueOf(i % 3 + 1));
            sr.setNaziv(a.getName());
            sr.setRacun(r);
            sr.setTura(t);
            srl.add(sr);
        }
        t.setStavke(srl);
        r.setStavke1(srl);
        LinkedList<Tura> tl = new LinkedList<Tura>();
        tl.add(t);
        r.setTure(tl);
        LinkedList<String> list = new LinkedList<String>();
        list.add("METRO CASH & CARRY D.O.O.");
        list.add("AUTOPUT ZA NOVI SAD 120");
        list.add("BEOGRAD-ZEMUN");
        list.add("PJ.IBARSKI PUT 20");
        list.add("IBARSKI PUT 20");
        list.add("BEOGRAD \u010cUKARICA");
        String pib = "102864104";
        new StampaGotovinskogUska(r, "Mauzer Legalitet k.a.o.", "Brzi put za P.M.", "Kingdom of Far Far Away", "10110101010", s, "123456", "", server);
    }

    public static String getPGMark(PoreskaGrupa pg) {
        return new String(new char[]{Konstante.getPGOznaka(pg)});
    }

    private String prilagodiRed(String red, int brojKarakteraUredu) {
        StringBuilder sb = new StringBuilder();
        while (red.length() > brojKarakteraUredu) {
            String redZaUpis = red.substring(0, brojKarakteraUredu);
            sb.append(redZaUpis);
            sb.append("\n");
            red = red.substring(brojKarakteraUredu);
        }
        sb.append(red);
        return sb.toString();
    }
}

