/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.stampa;

import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.model.Artikal;
import com.dev63.restoran.model.ArtikalText;
import com.dev63.restoran.model.Stampac;
import com.dev63.restoran.model.StoNaziv;
import com.dev63.restoran.stampa.NPrintUtils;
import com.dev63.restoran.stampa.StringAlign;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.persistence.NoResultException;

public class StampaDodatnogTexta {
    private Stampac stampac;
    private int brojKopija = 1;
    private StoNaziv sn;
    List<Artikal> items;
    RestoranServer server;

    public StampaDodatnogTexta(List<Artikal> items, Stampac stampac, int brojKopija, RestoranServer server) {
        this.items = items;
        this.stampac = stampac;
        this.brojKopija = brojKopija;
        this.server = server;
        this.writeInFile(items, brojKopija, stampac.getTip().getBrojDodatnihLinija(), stampac.getTip().getBrojKarakteraURedu(), server);
    }

    public void writeInFile(List<Artikal> items, int brojKopija, int extraLinija, int brojKarakteraURedu, RestoranServer server) {
        Date datum = new Date();
        char[] ela = new char[brojKarakteraURedu];
        char[] mla = new char[brojKarakteraURedu];
        char[] ula = new char[brojKarakteraURedu];
        Arrays.fill(ela, '=');
        Arrays.fill(mla, '-');
        Arrays.fill(ula, '_');
        String content = "";
        content = content + new String(ela);
        content = content + "\n";
        for (Artikal a : items) {
            ArtikalText at = null;
            try {
                at = server.getArtikalText(a);
            }
            catch (NoResultException ex) {
                System.out.println("Ne postoji zapis u ArtikalText za artikal " + a);
            }
            String string = at.getText();
            if (at != null && at.getStampaj().booleanValue()) {
                content = content + new StringAlign(brojKarakteraURedu, 108).format("- " + a.getName());
                content = content + "\n";
                for (String s : this.getParts(string, brojKarakteraURedu)) {
                    content = content + new StringAlign(brojKarakteraURedu, 108).format(s);
                }
                content = content + "\n";
            }
            content = content + "\n";
        }
        content = content + new String(ela);
        content = content + "\n";
        NPrintUtils.printContent(content, this.stampac, brojKopija);
    }

    private List<String> getParts(String string, int partitionSize) {
        ArrayList<String> parts = new ArrayList<String>();
        int len = string.length();
        for (int i = 0; i < len; i += partitionSize) {
            parts.add(string.substring(i, Math.min(len, i + partitionSize)));
        }
        return parts;
    }
}

