/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.stampa;

import com.dev63.restoran.constants.StatLogic;
import com.dev63.restoran.model.Stampac;
import com.dev63.restoran.model.TipStampaca;
import com.dev63.restoran.parts.XMLWriter;
import com.dev63.restoran.parts.XMLWriterHCP;
import com.dev63.restoran.stampa.StringAlign;
import com.dev63.restoran.stampa.StringAlignEqualsPadding;
import com.dev63.restoran.stampa.StringAlignMinusPadding;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.SimpleDoc;
import javax.print.attribute.HashPrintRequestAttributeSet;

public class NPrintUtils {
    public static String centerSplitToMiddle(int maxChars, String left, String right) {
        if (left == null) {
            left = "";
        }
        if (right == null) {
            right = "";
        }
        String ret = "";
        ret = ret + new StringAlign(maxChars / 2, 114).format(left);
        ret = ret + new StringAlign(maxChars - maxChars / 2, 108).format(right);
        return ret;
    }

    public static String centerSplitToCenter(int maxChars, String left, String right) {
        if (left == null) {
            left = "";
        }
        if (right == null) {
            right = "";
        }
        String ret = "";
        ret = ret + new StringAlign(maxChars / 2, 99).format(left);
        ret = ret + new StringAlign(maxChars - maxChars / 2, 99).format(right);
        return ret;
    }

    public static String centerSplitToEnds(int maxChars, String left, String right) {
        if (left == null) {
            left = "";
        }
        if (right == null) {
            right = "";
        }
        String ret = "";
        ret = ret + new StringAlign(maxChars / 2, 108).format(left);
        ret = ret + new StringAlign(maxChars - maxChars / 2, 114).format(right);
        return ret;
    }

    public static String labelValueSplitToEnds(int maxChars, String label, String value) {
        if (label == null) {
            label = "";
        }
        if (value == null) {
            value = "";
        }
        String ret = "";
        if (label.length() + value.length() > maxChars) {
            ret = ret + new StringAlign(maxChars, 108).format(label) + "\n";
            ret = ret + new StringAlign(maxChars, 114).format(value);
        } else {
            ret = ret + new StringAlign(label.length() > maxChars ? maxChars : label.length(), 108).format(label);
            ret = ret + new StringAlign(label.length() > maxChars ? 0 : maxChars - label.length(), 114).format(value);
        }
        return ret;
    }

    public static String centerText(int maxChars, String text) {
        if (text == null) {
            text = "";
        }
        String ret = "";
        ret = ret + new StringAlign(maxChars, 99).format(text);
        return ret;
    }

    public static String centerTextMinusPadding(int maxChars, String text) {
        if (text == null) {
            text = "";
        }
        String ret = "";
        ret = ret + new StringAlignMinusPadding(maxChars, 99).format(text);
        return ret;
    }

    public static String centerTextEqualsPadding(int maxChars, String text) {
        if (text == null) {
            text = "";
        }
        String ret = "";
        ret = ret + new StringAlignEqualsPadding(maxChars, 99).format(text);
        return ret;
    }

    public static String leftText(int maxChars, String text) {
        if (text == null) {
            text = "";
        }
        String ret = "";
        ret = ret + new StringAlign(maxChars, 108).format(text);
        return ret;
    }

    public static String leftTextMinusPadding(int maxChars, String text) {
        if (text == null) {
            text = "";
        }
        String ret = "";
        ret = ret + new StringAlignMinusPadding(maxChars, 108).format(text);
        return ret;
    }

    public static String leftTextEqualsPadding(int maxChars, String text) {
        if (text == null) {
            text = "";
        }
        String ret = "";
        ret = ret + new StringAlignEqualsPadding(maxChars, 108).format(text);
        return ret;
    }

    public static String rightText(int maxChars, String text) {
        if (text == null) {
            text = "";
        }
        String ret = "";
        ret = ret + new StringAlign(maxChars, 114).format(text);
        return ret;
    }

    public static String rightTextMinusPadding(int maxChars, String text) {
        if (text == null) {
            text = "";
        }
        String ret = "";
        ret = ret + new StringAlignMinusPadding(maxChars, 114).format(text);
        return ret;
    }

    public static String rightTextEqualsPadding(int maxChars, String text) {
        if (text == null) {
            text = "";
        }
        String ret = "";
        ret = ret + new StringAlignEqualsPadding(maxChars, 114).format(text);
        return ret;
    }

    public static String articleAmmountRightRow(int maxChars, String article, String ammount) {
        String ret = "";
        if ((article + " " + ammount).length() > maxChars) {
            ret = ret + NPrintUtils.leftText(maxChars, article) + "\n";
            ret = ret + NPrintUtils.rightText(maxChars, ammount);
        } else {
            ret = ret + NPrintUtils.leftText(maxChars - ammount.length(), article) + ammount;
        }
        return ret;
    }

    public static List<String> stringToList(String in, int lineChars) {
        LinkedList<String> list = new LinkedList<String>();
        String temp = in;
        while (temp.length() > lineChars) {
            list.add(temp.substring(0, lineChars));
            temp = temp.substring(lineChars);
        }
        list.add(temp);
        return list;
    }

    public static String charFill(int lineChars, char fillChar) {
        if (lineChars < 0) {
            return "";
        }
        char[] nla = new char[lineChars];
        Arrays.fill(nla, fillChar);
        return new String(nla);
    }

    public static String spaceFill(int line) {
        return NPrintUtils.charFill(line, ' ');
    }

    public static String minusFill(int line) {
        return NPrintUtils.charFill(line, '-');
    }

    public static String equalsFill(int line) {
        return NPrintUtils.charFill(line, '=');
    }

    public static String underFill(int line) {
        return NPrintUtils.charFill(line, '_');
    }

    /*
     * WARNING - void declaration
     */
    public static void printContent(String content, Stampac printer, int copies) {
        block23: {
            if (printer == null || content == null || copies == 0) {
                System.out.println("printer/content/copies je null");
                return;
            }
            try {
                void var21_32;
                byte[] bb;
                int i;
                char[] nla;
                String[] ss;
                int bkur = printer.getTip().getBrojKarakteraURedu();
                int bdl = printer.getTip().getBrojDodatnihLinija();
                String cTemp = StatLogic.clearFromEasternLatinChars(StatLogic.replaceCyrillicWithEasternLatinChars(content));
                for (String string : ss = cTemp.split("\\r?\\n")) {
                    int idx = 0;
                    while (idx < string.length()) {
                        System.out.print(string.charAt(idx));
                        if (++idx % bkur != 0) continue;
                        System.out.print('\n');
                    }
                    System.out.print('\n');
                }
                if (printer.getTip() == TipStampaca.FP550 || printer.getTip() == TipStampaca.RMINEFISKAL) {
                    nla = new char[bdl * bkur];
                    Arrays.fill(nla, ' ');
                    content = content + new String(nla);
                    content = content.replace("\n", "");
                    content = content.replace("\r", "");
                    content = StatLogic.clearFromEasternLatinChars(content);
                    System.out.println("printer: " + (Object)((Object)printer.getTip()) + ", " + bkur);
                    for (i = 0; i < copies; ++i) {
                        XMLWriter.writeNonFiscal(NPrintUtils.stringToList(content, bkur));
                    }
                    break block23;
                }
                if (printer.getTip() == TipStampaca.HCPP2DS) {
                    nla = new char[bdl * bkur];
                    Arrays.fill(nla, ' ');
                    content = content.replaceAll("\\r?\\n", "");
                    content = content + new String(nla);
                    for (i = 0; i < copies; ++i) {
                        XMLWriterHCP.writeNonFiscal(content);
                    }
                    break block23;
                }
                nla = new char[bdl];
                Arrays.fill(nla, '\n');
                content = content + new String(nla);
                DocFlavor.INPUT_STREAM flavor = DocFlavor.INPUT_STREAM.AUTOSENSE;
                HashPrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();
                PrintService[] pservices = PrintServiceLookup.lookupPrintServices(flavor, aset);
                DocPrintJob pj = null;
                System.out.println("content = " + content);
                byte[] cpa = new byte[]{};
                String codePage = printer.getKodnaStrana();
                Charset cs = null;
                try {
                    cs = Charset.forName(codePage);
                }
                catch (Exception e) {
                    System.out.println("Nije prepoznat Charset za ime " + cs);
                }
                if (cs == null) {
                    bb = StatLogic.clearFromEasternLatinChars(StatLogic.replaceCyrillicWithEasternLatinChars(content)).getBytes(Charset.forName("cp437"));
                } else {
                    System.out.println("cs = " + cs);
                    bb = cs.equals(Charset.forName("Cp855")) || cs.equals(Charset.forName("Cp1251")) || cs.equals(Charset.forName("UTF8")) ? content.getBytes(cs) : (cs.equals(Charset.forName("Cp852")) || cs.equals(Charset.forName("Cp1250")) || cs.equals(Charset.forName("Cp1252")) ? StatLogic.replaceCyrillicWithEasternLatinChars(content).getBytes(cs) : StatLogic.clearFromEasternLatinChars(StatLogic.replaceCyrillicWithEasternLatinChars(content)).getBytes(cs));
                    try {
                        cpa = printer.getTip().getCodePageCommandForCharset(cs);
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.out);
                    }
                }
                byte[] cut = printer.getTip().getEmulacija().getPartialCut();
                for (byte by : cpa) {
                    System.out.printf("b = %02X", by);
                }
                byte[] out = new byte[bb.length + cut.length + cpa.length];
                System.arraycopy(cpa, 0, out, 0, cpa.length);
                System.arraycopy(bb, 0, out, cpa.length, bb.length);
                System.arraycopy(cut, 0, out, bb.length + cpa.length, cut.length);
                PrintService ps = null;
                PrintService[] printServiceArray = pservices;
                int n = printServiceArray.length;
                boolean bl = false;
                while (var21_32 < n) {
                    PrintService p = printServiceArray[var21_32];
                    if (p.getName().toUpperCase().contains(printer.getNaziv().toUpperCase())) {
                        ps = p;
                    }
                    ++var21_32;
                }
                if (ps != null) {
                    for (int i2 = 0; i2 < copies; ++i2) {
                        String result = new String(out);
                        System.out.println(result);
                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(out);
                        SimpleDoc doc = new SimpleDoc(byteArrayInputStream, flavor, null);
                        pj = ps.createPrintJob();
                        pj.print(doc, aset);
                        ((InputStream)byteArrayInputStream).close();
                        try {
                            Thread.sleep(500L);
                            continue;
                        }
                        catch (InterruptedException ex) {
                            Logger.getLogger(NPrintUtils.class.getName()).log(Level.WARNING, ex.getMessage(), ex);
                        }
                    }
                } else {
                    Logger.getLogger(NPrintUtils.class.getName()).warning("Definisani printer nije pronadjen");
                }
            }
            catch (Exception ex) {
                Logger.getLogger(NPrintUtils.class.getName()).log(Level.WARNING, "Greska prilikom uske stampe", ex);
            }
        }
    }
}

