/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.sistem.zdpregled;

import com.dev63.restoran.Konstante;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.SWTModels;
import com.dev63.restoran.Util;
import com.dev63.restoran.model.ZD;
import com.dev63.restoran.parts.DateInput2;
import com.dev63.restoran.parts.InputException;
import com.dev63.restoran.sistem.RekonstrukcijaPoUtroscima;
import com.dev63.restoran.sistem.zdpregled.ZdPregledServer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class PregledZd
extends SWTModels {
    private RestoranServer server;
    private ZdPregledServer zdServer;
    private Display display;
    private Shell zdShell;
    private String[] koloneZd = new String[]{"Id", "Datum", "Po\u010detak", "Zaklju\u010denje", "Zd broj"};
    private String[] koloneKonflikt = new String[]{"Datum", "Konflikt"};
    private int[] sirinaZdKolona = new int[]{50, 120, 120, 180, 90};
    private int[] sirinaKonfliktKolona = new int[]{100, 500};
    private Date datum;
    private Table zdTable;
    private Table konfliktTable;
    private String red;
    private Text idTx;
    private Text zdbrojTx;
    private DateInput2 izmenaDatum;
    private Combo pocetak;
    private Label emptyLabel;
    private DateInput2 dateInput2;
    private DateTime timeZakljucenje;
    private DateTime dateZakljucenje;
    private ZD zd;

    public PregledZd(RestoranServer server, Shell shell) {
        this.server = server;
        this.red = "";
        this.datum = Util.bom();
        this.zdServer = new ZdPregledServer(server, this.datum);
        this.display = shell.getDisplay();
        this.zdShell = super.makeShell(0, 0, this.display, "Pregled ZD", 2);
        this.makeInput();
        this.zdServer.popuniZdRedove(this.zdTable);
        this.zdServer.popuniKonfliktRedove(this.konfliktTable);
        this.zdShell.open();
    }

    private void makeInput() {
        String[] poslednjiZd = this.zdServer.getLastZd();
        Composite composite = this.makeComposite((Composite)this.zdShell, 2, 0, 0, 0, 0);
        this.dateInput2 = this.makeDateInput(composite, this.zdShell, this.datum);
        Button showTable = this.makeButton(composite, "Prika\u017ei");
        this.dodajListener(showTable);
        this.emptyLabel = this.makeLabel((Composite)this.zdShell, "", 0, 20, null, 1, 1);
        Group zdGroup = this.makeGroup((Composite)this.zdShell, 600, 0, 1, 2, "Pregled ZD", 1, 10, 10, 10, 10);
        Group konfliktGroup = this.makeGroup((Composite)this.zdShell, 0, 0, 1, 1, "Konflikti", 1, 10, 10, 10, 10);
        Group podesavanjaGroup = this.makeGroup((Composite)this.zdShell, 0, 0, 1, 1, "Podesavanja", 6, 10, 10, 10, 10);
        this.zdTable = this.makeTable((Composite)zdGroup, this.koloneZd, this.sirinaZdKolona, 1, 2);
        this.dodajListener(this.zdTable);
        this.konfliktTable = this.makeTable((Composite)konfliktGroup, this.koloneKonflikt, this.sirinaKonfliktKolona, 1, 1);
        for (int i = 0; i < this.koloneZd.length; ++i) {
            this.makeLabel((Composite)podesavanjaGroup, this.koloneZd[i], this.sirinaZdKolona[i], 20, null, 0, 0);
        }
        this.emptyLabel = this.makeLabel((Composite)podesavanjaGroup, "", 0, 20, null, 1, 1);
        this.idTx = this.makeTextField((Composite)podesavanjaGroup, poslednjiZd[0], 30, 20, false, 0, 0);
        Date datum = Konstante.getDatefromString("yyyy-MM-dd", poslednjiZd[1]);
        this.izmenaDatum = this.makeDateInput((Composite)podesavanjaGroup, this.zdShell, datum);
        this.pocetak = this.makeComboString((Composite)podesavanjaGroup, this.getPocetakComboList());
        Composite zakljucenje = this.makeComposite((Composite)podesavanjaGroup, 2, 2, 0, 0, 0);
        this.dateZakljucenje = this.makeDate(zakljucenje, poslednjiZd[3].split(" ")[0], "-");
        this.timeZakljucenje = this.makeTime(zakljucenje, poslednjiZd[3].split(" ")[1], ":");
        this.zdbrojTx = this.makeTextField((Composite)podesavanjaGroup, poslednjiZd[4], 50, 20, true, 0, 0);
        Composite dugmici = this.makeComposite((Composite)podesavanjaGroup, 3, 2, 0, 0, 0);
        Button izmeniZD = this.makeButton(dugmici, "Izmeni ZD");
        this.dodajListener(izmeniZD);
        Button obrisiZD = this.makeButton(dugmici, "Obri\u0161i ZD");
        this.dodajListener(obrisiZD);
        Button dodajZD = this.makeButton(dugmici, "Dodaj ZD");
        this.dodajListener(dodajZD);
        Button potvrdi = this.makeButton((Composite)podesavanjaGroup, "Potvrdi");
        this.dodajListener(potvrdi);
    }

    private void dodajListener(final Table table) {
        table.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TableItem selection = (TableItem)event.item;
                for (int i = 0; i < table.getColumnCount(); ++i) {
                    if (i == table.getColumnCount() - 1) {
                        PregledZd.this.red = PregledZd.this.red + selection.getText(i);
                        continue;
                    }
                    PregledZd.this.red = PregledZd.this.red + selection.getText(i) + ";";
                }
                PregledZd.this.zdServer.popuniRedtext(PregledZd.this.red, PregledZd.this.idTx, PregledZd.this.izmenaDatum, PregledZd.this.pocetak, PregledZd.this.dateZakljucenje, PregledZd.this.timeZakljucenje, PregledZd.this.zdbrojTx);
                PregledZd.this.red = "";
            }
        });
    }

    private void dodajListener(final Button button) {
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                try {
                    PregledZd.this.zd = PregledZd.this.zdServer.makeZd(PregledZd.this.idTx, PregledZd.this.izmenaDatum, PregledZd.this.pocetak, PregledZd.this.dateZakljucenje, PregledZd.this.timeZakljucenje, PregledZd.this.zdbrojTx);
                    long id = Long.parseLong(PregledZd.this.idTx.getText());
                    if (button.getText().contains("Prika\u017ei")) {
                        PregledZd.this.zdServer.refresh(PregledZd.this.dateInput2.getResult(), PregledZd.this.zdTable, PregledZd.this.konfliktTable);
                    } else if (button.getText().contains("Obri\u0161i")) {
                        PregledZd.this.zdServer.deleteZD(id);
                        PregledZd.this.zdServer.refresh(PregledZd.this.dateInput2.getResult(), PregledZd.this.zdTable, PregledZd.this.konfliktTable);
                    } else if (button.getText().contains("Dodaj")) {
                        PregledZd.this.zdServer.insertZD(PregledZd.this.zd);
                        PregledZd.this.zdServer.refresh(PregledZd.this.dateInput2.getResult(), PregledZd.this.zdTable, PregledZd.this.konfliktTable);
                    } else if (button.getText().contains("Izmeni")) {
                        PregledZd.this.zdServer.updateZD(PregledZd.this.zd);
                        PregledZd.this.zdServer.refresh(PregledZd.this.dateInput2.getResult(), PregledZd.this.zdTable, PregledZd.this.konfliktTable);
                    } else {
                        new RekonstrukcijaPoUtroscima(PregledZd.this.zdShell, PregledZd.this.dateInput2.getResult(), PregledZd.this.server, true);
                        PregledZd.this.zdShell.close();
                    }
                }
                catch (InputException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private List<String> getPocetakComboList() {
        ArrayList<String> lista = new ArrayList<String>();
        lista.add("0");
        lista.add("1");
        return lista;
    }
}

