/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.sistem.fpProtocols.metalink;

import com.dev63.restoran.BMTerminalSettings;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.model.OptionBO;
import com.dev63.restoran.model.Placanje;
import com.dev63.restoran.model.Racun;
import com.dev63.restoran.model.Setting;
import com.dev63.restoran.model.StavkaRacuna;
import com.dev63.restoran.sistem.fpProtocols.metalink.model.BMMLCashier;
import com.dev63.restoran.sistem.fpProtocols.metalink.model.BMMLItem;
import com.dev63.restoran.sistem.fpProtocols.metalink.model.BMMLPayment;
import com.dev63.restoran.swt.components.SWTMessage;
import java.io.File;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import rs.petcom.metalink.transform.model.MLBill;
import rs.petcom.metalink.transform.model.MLBillStorno;
import rs.petcom.metalink.transform.model.MLCashier;
import rs.petcom.metalink.transform.model.MLItem;
import rs.petcom.metalink.transform.model.MLPayment;
import rs.petcom.metalink.transform.model.MLPeriodReport;
import rs.petcom.metalink.transform.model.MLPutInDeposit;
import rs.petcom.metalink.transform.model.MLXReport;
import rs.petcom.metalink.transform.model.MLZReport;

public class MetaLinkProtocol {
    private static final String BILL_PREFIX = "ABC_";
    private static final String STORNO_PREFIX = "REK_";
    private static final String COMMAND_PREFIX = "CMD_";
    private static final String FILE_SUFFIX = ".xml";
    private static final String TO_FP_FOLDER = "/TO_FP";
    private static volatile MetaLinkProtocol instance;
    private static final Object syncOK;
    private String flPath = null;
    private final SimpleDateFormat shortDate;
    private final DecimalFormat price;
    private final DecimalFormat ammount;
    private int counter = 10000;

    public int getBrojac() {
        if (this.counter == 100000) {
            this.counter = 10000;
        }
        return ++this.counter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MetaLinkProtocol getInstance() throws ClassNotFoundException {
        if (instance == null) {
            Object object = syncOK;
            synchronized (object) {
                if (instance == null) {
                    instance = new MetaLinkProtocol();
                }
            }
        }
        return instance;
    }

    private MetaLinkProtocol() throws ClassNotFoundException {
        this.checkCon();
        this.price = new DecimalFormat("###0.00");
        this.ammount = new DecimalFormat("###0.000");
        this.price.setGroupingUsed(false);
        this.ammount.setGroupingUsed(false);
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        dfs.setMonetaryDecimalSeparator('.');
        this.price.setDecimalFormatSymbols(dfs);
        this.ammount.setDecimalFormatSymbols(dfs);
        this.price.setRoundingMode(RoundingMode.HALF_UP);
        this.ammount.setRoundingMode(RoundingMode.HALF_UP);
        this.shortDate = new SimpleDateFormat("ddMMyy");
    }

    private boolean checkCon() throws ClassNotFoundException {
        String path = BMTerminalSettings.getSetting(OptionBO.FPLINK_FOLDER).stringValue();
        File fold = new File(path);
        if (!fold.exists() || !fold.isDirectory()) {
            SWTMessage.showLocalizedWarningDialog(null, String.format(Konstante.getBundle().getString("PORUKA_PUTANJA_KOJA_POKAZUJE_NA_FLINK_FOLDER_NIJE_VALIDNA"), path));
            this.flPath = null;
            return false;
        }
        this.flPath = path;
        return true;
    }

    public void stampaPresekaStanja() throws ClassNotFoundException {
        if (this.checkCon()) {
            MLXReport cmd = new MLXReport();
            try {
                File f = File.createTempFile("BMMLCMD-", FILE_SUFFIX);
                cmd.marshalToFile(f);
                f.renameTo(new File(this.flPath + TO_FP_FOLDER, COMMAND_PREFIX + this.getBrojac() + FILE_SUFFIX));
            }
            catch (Exception ee) {
                Logger.getLogger(MetaLinkProtocol.class.getName()).log(Level.SEVERE, ee.getMessage(), ee);
                SWTMessage.showLocalizedErrorDialog(null, String.format(Konstante.getBundle().getString("PORUKA_RACUN_NIJE_ODSTAMPAN"), new Object[0]));
            }
        }
    }

    public void stampaDnevnogIzvestaja() throws ClassNotFoundException {
        if (this.checkCon()) {
            MLZReport cmd = new MLZReport();
            try {
                File f = File.createTempFile("BMMLCMD-", FILE_SUFFIX);
                cmd.marshalToFile(f);
                f.renameTo(new File(this.flPath + TO_FP_FOLDER, COMMAND_PREFIX + this.getBrojac() + FILE_SUFFIX));
            }
            catch (Exception ee) {
                Logger.getLogger(MetaLinkProtocol.class.getName()).log(Level.SEVERE, ee.getMessage(), ee);
                SWTMessage.showLocalizedErrorDialog(null, String.format(Konstante.getBundle().getString("PORUKA_RACUN_NIJE_ODSTAMPAN"), new Object[0]));
            }
        }
    }

    public void stampajPeriodicni(Date odd, Date dod) throws ClassNotFoundException {
        if (this.checkCon()) {
            MLPeriodReport cmd = new MLPeriodReport(odd, dod);
            try {
                File f = File.createTempFile("BMMLCMD-", FILE_SUFFIX);
                cmd.marshalToFile(f);
                f.renameTo(new File(this.flPath + TO_FP_FOLDER, COMMAND_PREFIX + this.getBrojac() + FILE_SUFFIX));
            }
            catch (Exception ee) {
                Logger.getLogger(MetaLinkProtocol.class.getName()).log(Level.SEVERE, ee.getMessage(), ee);
                SWTMessage.showLocalizedErrorDialog(null, String.format(Konstante.getBundle().getString("PORUKA_RACUN_NIJE_ODSTAMPAN"), new Object[0]));
            }
        }
    }

    public int prodajaArtikala(Racun r) {
        int i;
        int brFrac = 0;
        MLBill bill = new MLBill();
        for (i = 0; i < r.getStavke().size(); ++i) {
            boolean isRacunNull;
            StavkaRacuna sr = r.getStavke().get(i);
            boolean bl = isRacunNull = sr.getRacun() == null;
            if (isRacunNull) {
                sr.setRacun(r);
            }
            if (r.getStavke().get(i).getCena().compareTo(0.1) < 0) {
                if (!isRacunNull) continue;
                sr.setRacun(null);
                continue;
            }
            BMMLItem item = new BMMLItem(sr);
            bill.addItem((MLItem)item);
            if (!isRacunNull) continue;
            sr.setRacun(null);
        }
        for (i = 0; i < r.getPlacanja().size(); ++i) {
            Placanje p = r.getPlacanja().get(i);
            bill.addPayment((MLPayment)new BMMLPayment(p));
        }
        try {
            Setting s = BMTerminalSettings.getSetting(OptionBO.FPLINK_OPERATERI);
            if (s != null && s.booleanValue() && r.getKonobar() != null && r.getKonobar().getSkrIme() != null) {
                bill.setCashier((MLCashier)new BMMLCashier(r.getKonobar()));
            }
            File f = File.createTempFile("BMML-", FILE_SUFFIX);
            bill.marshalToFile(f);
            f.renameTo(new File(this.flPath + TO_FP_FOLDER, BILL_PREFIX + this.getBrojac() + FILE_SUFFIX));
        }
        catch (Exception ee) {
            Logger.getLogger(MetaLinkProtocol.class.getName()).log(Level.SEVERE, ee.getMessage(), ee);
            SWTMessage.showLocalizedErrorDialog(null, String.format(Konstante.getBundle().getString("PORUKA_RACUN_NIJE_ODSTAMPAN"), new Object[0]));
        }
        return brFrac;
    }

    public void uplataDepozita(double iznos) throws ClassNotFoundException {
        if (this.checkCon()) {
            MLPutInDeposit putInDeposit = new MLPutInDeposit(iznos);
            try {
                File f = File.createTempFile("BMMLCMD-", FILE_SUFFIX);
                putInDeposit.marshalToFile(f);
                f.renameTo(new File(this.flPath + TO_FP_FOLDER, COMMAND_PREFIX + this.getBrojac() + FILE_SUFFIX));
            }
            catch (Exception ee) {
                Logger.getLogger(MetaLinkProtocol.class.getName()).log(Level.SEVERE, ee.getMessage(), ee);
                SWTMessage.showLocalizedErrorDialog(null, String.format(Konstante.getBundle().getString("PORUKA_RACUN_NIJE_ODSTAMPAN"), new Object[0]));
            }
        }
    }

    public void stornoRacuna(int brojIsecka, Racun r) {
        boolean brFrac = false;
        MLBillStorno billStorno = new MLBillStorno();
        billStorno.setBillNumber(Integer.toString(brojIsecka));
        for (int i = 0; i < r.getStavke().size(); ++i) {
            boolean isRacunNull;
            StavkaRacuna sr = r.getStavke().get(i);
            boolean bl = isRacunNull = sr.getRacun() == null;
            if (isRacunNull) {
                sr.setRacun(r);
            }
            if (r.getStavke().get(i).getCena().compareTo(0.1) < 0) {
                if (!isRacunNull) continue;
                sr.setRacun(null);
                continue;
            }
            BMMLItem item = new BMMLItem(sr);
            billStorno.addItem((MLItem)item);
            if (!isRacunNull) continue;
            sr.setRacun(null);
        }
        try {
            File f = File.createTempFile("BMMLREK-", FILE_SUFFIX);
            billStorno.marshalToFile(f);
            f.renameTo(new File(this.flPath + TO_FP_FOLDER, STORNO_PREFIX + this.getBrojac() + FILE_SUFFIX));
        }
        catch (Exception ee) {
            Logger.getLogger(MetaLinkProtocol.class.getName()).log(Level.SEVERE, ee.getMessage(), ee);
            SWTMessage.showLocalizedErrorDialog(null, String.format(Konstante.getBundle().getString("PORUKA_RACUN_NIJE_ODSTAMPAN"), new Object[0]));
        }
    }

    static {
        syncOK = new Object();
    }
}

