/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.sistem.fpProtocols;

import com.dev63.fiscal.fp550.PoreskaGrupa;
import com.dev63.restoran.BMTerminalSettings;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.model.NacinPlacanja;
import com.dev63.restoran.model.OptionBO;
import com.dev63.restoran.model.Racun;
import com.dev63.restoran.model.Setting;
import com.dev63.restoran.model.StavkaRacuna;
import com.dev63.restoran.swt.components.SWTMessage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.math.RoundingMode;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FLinkProtocol {
    private static volatile FLinkProtocol instance;
    private static final Object syncOK;
    private String flPath = null;
    private final SimpleDateFormat shortDate;
    private final DecimalFormat price;
    private final DecimalFormat ammount;
    private int counter = 10000;

    public int getBrojac() {
        if (this.counter == 100000) {
            this.counter = 10000;
        }
        return ++this.counter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FLinkProtocol getInstance() {
        if (instance == null) {
            Object object = syncOK;
            synchronized (object) {
                if (instance == null) {
                    instance = new FLinkProtocol();
                }
            }
        }
        return instance;
    }

    private FLinkProtocol() {
        this.checkCon();
        this.price = new DecimalFormat("###0.00;-###0.00");
        this.ammount = new DecimalFormat("###0.000;-###0.000");
        this.price.setGroupingUsed(false);
        this.ammount.setGroupingUsed(false);
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        dfs.setMonetaryDecimalSeparator('.');
        this.price.setDecimalFormatSymbols(dfs);
        this.ammount.setDecimalFormatSymbols(dfs);
        this.price.setRoundingMode(RoundingMode.HALF_UP);
        this.ammount.setRoundingMode(RoundingMode.HALF_UP);
        this.shortDate = new SimpleDateFormat("ddMMyy");
    }

    private boolean checkCon() {
        String path = BMTerminalSettings.getSetting(OptionBO.FPLINK_FOLDER).stringValue();
        File fold = new File(path);
        if (!fold.exists() || !fold.isDirectory()) {
            SWTMessage.showLocalizedWarningDialog(null, String.format(Konstante.getBundle().getString("PORUKA_PUTANJA_KOJA_POKAZUJE_NA_FLINK_FOLDER_NIJE_VALIDNA"), path));
            this.flPath = null;
            return false;
        }
        this.flPath = path;
        return true;
    }

    public void stampaPresekaStanja() {
        if (this.checkCon()) {
            this.posaljiKomandu("X", "");
        }
    }

    public void stampaDnevnogIzvestaja() {
        if (this.checkCon() && !"E".equals(this.posaljiKomandu("Z", ""))) {
            try {
                Thread.sleep(4000L);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FLinkProtocol.class.getName()).log(Level.SEVERE, null, ex);
            }
            this.posaljiKomandu("O", "");
        }
    }

    public void stampajPeriodicni(Date odd, Date dod) {
        if (this.checkCon()) {
            String oddo = this.shortDate.format(odd) + ";" + this.shortDate.format(dod);
            this.posaljiKomandu("R", oddo);
        }
    }

    private String posaljiKomandu(String komanda, String param) {
        String pathkom = this.flPath;
        String fPath = null;
        String pathpriv = System.getProperty("user.dir");
        try {
            String sadrzaj;
            if ("Z".equals(komanda)) {
                sadrzaj = "Z,0,______,_,__;";
                fPath = "Z.inp";
            } else if ("O".equals(komanda)) {
                sadrzaj = "O,0,______,_,__;ALL";
                fPath = "O.inp";
            } else if ("X".equals(komanda)) {
                sadrzaj = "X,0,______,_,__;";
                fPath = "X.inp";
            } else if ("R".equals(komanda)) {
                sadrzaj = "R,0,______,_,__;5;" + param;
                fPath = "RI.inp";
            } else {
                sadrzaj = param;
            }
            if (sadrzaj.length() > 0) {
                if (fPath == null) {
                    fPath = "FL" + this.getBrojac();
                }
                File f = new File(pathpriv, fPath);
                FileOutputStream fos = new FileOutputStream(f);
                OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, Charset.isSupported("cp1250") ? Charset.forName("cp1250") : Charset.defaultCharset());
                osw.write(sadrzaj);
                osw.flush();
                osw.close();
                fos.close();
                f.renameTo(new File(pathkom, fPath));
                return "";
            }
            return "";
        }
        catch (Exception ee) {
            Logger.getLogger(FLinkProtocol.class.getName()).log(Level.SEVERE, ee.getMessage(), ee);
            return "E";
        }
    }

    public int prodajaArtikala(Racun r) {
        int i;
        String sadrzaj = "";
        int brFrac = 0;
        for (i = 0; i < r.getStavke().size(); ++i) {
            boolean isRacunNull;
            StavkaRacuna sr = r.getStavke().get(i);
            boolean bl = isRacunNull = sr.getRacun() == null;
            if (isRacunNull) {
                sr.setRacun(r);
            }
            if (r.getStavke().get(i).getCena().compareTo(0.1) < 0) {
                if (!isRacunNull) continue;
                sr.setRacun(null);
                continue;
            }
            sadrzaj = sadrzaj + "S,0,______,_,__;" + sr.getArtikal().getName() + ";" + this.price.format(sr.getCena()) + ";" + this.ammount.format(r.getStavke().get(i).getKolicina()) + ";0;1;" + this.poreskaGrupa(r.getStavke().get(i).getArtikal().getPoreskaGrupa()) + ";0;" + r.getStavke().get(i).getArtikal().getId() + ";" + this.price.format(0.0) + ";;0;\r\n";
            if (!isRacunNull) continue;
            sr.setRacun(null);
        }
        if (r.getPlacanja().isEmpty()) {
            sadrzaj = sadrzaj + "T,0,______,_,__;\r\n";
        } else {
            for (i = 0; i < r.getPlacanja().size(); ++i) {
                sadrzaj = sadrzaj + "T,0,______,_,__;" + this.nacinPlacanja(r.getPlacanja().get(i).getNacin()) + ";" + this.price.format(r.getPlacanja().get(i).getIznos()) + ";;;;\r\n";
            }
        }
        if (sadrzaj.length() > 0) {
            try {
                String pathkom = r.getId() + ".inp";
                String pathpriv = System.getProperty("user.dir");
                Setting s = BMTerminalSettings.getSetting(OptionBO.FPLINK_OPERATERI);
                if (s != null && s.booleanValue() && r.getKonobar() != null && r.getKonobar().getSkrIme() != null) {
                    sadrzaj = "L,1,______,_,__;SetOperator;1;" + r.getKonobar().getSkrIme() + ";1111;1111;\r\nK,0,______,_,__;;1;1111;;;;;;\r\n" + sadrzaj;
                }
                File f = new File(pathpriv, pathkom);
                FileOutputStream fos = new FileOutputStream(f);
                OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, Charset.isSupported("cp1250") ? Charset.forName("cp1250") : Charset.defaultCharset());
                osw.write(sadrzaj);
                osw.flush();
                osw.close();
                fos.close();
                f.renameTo(new File(this.flPath, pathkom));
            }
            catch (Exception ee) {
                Logger.getLogger(FLinkProtocol.class.getName()).log(Level.SEVERE, ee.getMessage(), ee);
                SWTMessage.showLocalizedErrorDialog(null, String.format(Konstante.getBundle().getString("PORUKA_RACUN_NIJE_ODSTAMPAN"), new Object[0]));
            }
        }
        return brFrac;
    }

    public void uplataDepozita(double iznos) {
        if (this.checkCon()) {
            String param = "I,0,________,_,__;0;" + this.price.format(iznos) + ";;;;";
            this.posaljiKomandu("I", param);
        }
    }

    private int poreskaGrupa(PoreskaGrupa pg) {
        switch (pg) {
            case GRUPA_A: {
                return 1;
            }
            case GRUPA_G: {
                return 2;
            }
            case GRUPA_D: {
                return 3;
            }
            case GRUPA_DJ: {
                return 4;
            }
            case GRUPA_E: {
                return 5;
            }
        }
        return 5;
    }

    private int nacinPlacanja(NacinPlacanja np) {
        switch (np) {
            case GOTOVINA: {
                return 0;
            }
            case KARTICA: {
                return 1;
            }
            case CEK: {
                return 2;
            }
            case FAKTURA: {
                return 3;
            }
        }
        return 0;
    }

    public void stornoRacuna(int brojIsecka, Racun r) {
        String sadrzaj = "";
        boolean brFrac = false;
        for (int i = 0; i < r.getStavke().size(); ++i) {
            boolean isRacunNull;
            StavkaRacuna sr = r.getStavke().get(i);
            boolean bl = isRacunNull = sr.getRacun() == null;
            if (isRacunNull) {
                sr.setRacun(r);
            }
            if (r.getStavke().get(i).getCena().compareTo(0.1) < 0) {
                if (!isRacunNull) continue;
                sr.setRacun(null);
                continue;
            }
            sadrzaj = sadrzaj + "S,0,______,_,__;" + sr.getNaziv() + ";" + this.price.format(sr.getCena()) + ";" + this.ammount.format(r.getStavke().get(i).getKolicina()) + ";0;1;" + this.poreskaGrupa(r.getStavke().get(i).getArtikal().getPoreskaGrupa()) + ";0;" + r.getStavke().get(i).getArtikal().getId() + ";" + this.price.format(0.0) + ";;0;\r\n";
            if (!isRacunNull) continue;
            sr.setRacun(null);
        }
        if (sadrzaj.length() > 0) {
            try {
                sadrzaj = sadrzaj + "T,0,______,_,__;\r\n";
                String pathkom = "S" + r.getId() + ".inp";
                String pathpriv = System.getProperty("user.dir");
                sadrzaj = "K,0,______,_,__;" + brojIsecka + ";;;;;;;;\r\n" + sadrzaj;
                File f = new File(pathpriv, pathkom);
                FileOutputStream fos = new FileOutputStream(f);
                OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, Charset.isSupported("cp1250") ? Charset.forName("cp1250") : Charset.defaultCharset());
                osw.write(sadrzaj);
                osw.flush();
                osw.close();
                fos.close();
                f.renameTo(new File(this.flPath, pathkom));
            }
            catch (Exception ee) {
                Logger.getLogger(FLinkProtocol.class.getName()).log(Level.SEVERE, ee.getMessage(), ee);
                SWTMessage.showLocalizedErrorDialog(null, String.format(Konstante.getBundle().getString("PORUKA_RACUN_NIJE_ODSTAMPAN"), new Object[0]));
            }
        }
    }

    static {
        syncOK = new Object();
    }
}

