/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.sistem;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class XLSExporter {
    public static void exportTable(Table t, Shell s) throws IOException {
        HSSFSheet sheet1;
        String text = "";
        File folder = new File("C:/barmaster/Export");
        if (!folder.exists()) {
            folder.mkdirs();
        } else if (!folder.isDirectory()) {
            folder.delete();
            folder.mkdirs();
        }
        FileDialog fd = new FileDialog(s, 8192);
        fd.setText("Izaberite putanju za pamcenje fajla");
        fd.setFilterExtensions(new String[]{".xls"});
        fd.setOverwrite(true);
        fd.setFilterPath(folder.getCanonicalPath());
        fd.setFileName(s.getText().replaceAll("\\W|_", "") + "---" + new SimpleDateFormat("yyyy-MM-dd").format(new Date()) + ".xls");
        String filename = fd.open();
        if (filename == null) {
            return;
        }
        File f = new File(filename);
        if (f.exists()) {
            System.out.println(f.delete());
        }
        f.createNewFile();
        FileOutputStream fos = new FileOutputStream(f);
        HSSFWorkbook xls = new HSSFWorkbook();
        try {
            sheet1 = xls.createSheet(s.getText());
        }
        catch (IllegalArgumentException e) {
            sheet1 = xls.createSheet("ZaSadaBezDobrogNaslova");
        }
        HSSFRow header = sheet1.createRow(0);
        HSSFCellStyle hStyle = xls.createCellStyle();
        hStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        hStyle.setBorderBottom(BorderStyle.NONE);
        hStyle.setBorderRight(BorderStyle.NONE);
        hStyle.setBorderLeft(BorderStyle.NONE);
        hStyle.setBorderTop(BorderStyle.NONE);
        hStyle.setWrapText(true);
        for (int i = 0; i < t.getColumns().length; ++i) {
            TableColumn tc = t.getColumns()[i];
            HSSFCell hCell = header.createCell(i);
            hCell.setCellValue(tc.getText());
            hCell.setCellStyle(hStyle);
        }
        sheet1.createFreezePane(t.getColumnCount(), 1);
        sheet1.setRepeatingRows(CellRangeAddress.valueOf((String)"1:1"));
        HSSFCellStyle data = xls.createCellStyle();
        data.setBorderBottom(BorderStyle.NONE);
        data.setBorderRight(BorderStyle.NONE);
        data.setBorderLeft(BorderStyle.NONE);
        data.setBorderTop(BorderStyle.NONE);
        for (int i = 1; i <= t.getItems().length; ++i) {
            HSSFRow row = sheet1.createRow(i);
            TableItem ti = t.getItems()[i - 1];
            for (int j = 0; j < t.getColumns().length; ++j) {
                HSSFCell cell = row.createCell(j);
                text = ti.getText(j).replace(",", ".");
                Double d = null;
                try {
                    d = Double.parseDouble(text);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (d != null) {
                    cell.setCellValue(d.doubleValue());
                } else {
                    cell.setCellValue(ti.getText(j));
                }
                cell.setCellStyle(data);
            }
        }
        xls.write((OutputStream)fos);
        fos.close();
    }
}

