/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.sistem;

import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.restoran.Dugmici;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.Utrosci;
import com.dev63.restoran.model.Artikal;
import com.dev63.restoran.model.DnevnoStanje;
import com.dev63.restoran.model.NacinPlacanja;
import com.dev63.restoran.model.Normativ;
import com.dev63.restoran.model.Odeljenje;
import com.dev63.restoran.model.Option;
import com.dev63.restoran.model.Placanje;
import com.dev63.restoran.model.Racun;
import com.dev63.restoran.model.StalniGost;
import com.dev63.restoran.model.StavkaRacuna;
import com.dev63.restoran.model.TipArtikla;
import com.dev63.restoran.model.Tura;
import com.dev63.restoran.model.ZD;
import com.dev63.restoran.parts.DateInput2;
import com.dev63.restoran.parts.DoubleInput2;
import com.dev63.restoran.parts.InputException;
import com.dev63.restoran.sistem.CalendarAdapter;
import com.dev63.restoran.sistem.FakturaRacun;
import com.dev63.restoran.sistem.IzracunajDnevniPromet;
import com.dev63.restoran.sistem.IzracunajDnevniPromet2;
import com.dev63.restoran.sistem.PomocniUpit;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class VPfaktura {
    RestoranServer server;
    SWTContainer parent;
    DateInput2 datum;
    final Table table;
    Button plus;
    Button minus;
    Odeljenje odeljenje;
    List<StavkaRacuna> stavke = new ArrayList<StavkaRacuna>();
    Shell shell;
    Text pretraga;
    Combo artikal;
    DoubleInput2 cenaKomad;
    Button crno;
    Restoran restoran;
    List<Artikal> artikli2 = new ArrayList<Artikal>();
    Map<Long, Double> mapaPocetnoB;
    Map<Long, Double> mapaUlazB;
    Map<Long, Double> mapaIzlazB;
    Map<Long, Double> mapaPocetnoC;
    Map<Long, Double> mapaUlazC;
    Map<Long, Double> mapaIzlazC;
    boolean sifre;
    List<DnevnoStanje> stanjaDanas = null;
    double totalNab;
    double totalProd;
    TableItem total;
    private List<StalniGost> stalni;
    private Combo comboSG;
    boolean inspektor = false;
    boolean crn = false;

    public VPfaktura(SWTContainer owner, Restoran r, Odeljenje o, final boolean inspektor) {
        this.restoran = r;
        this.server = this.restoran.getServer();
        this.parent = owner;
        this.shell = this.parent.getControl().getShell();
        this.odeljenje = o;
        this.inspektor = inspektor;
        this.stalni = this.server.readStalniGostiKupci();
        try {
            this.sifre = this.restoran.getServer().getSetting(Option.STAMPA_SIFARA_DOKUMENTI).booleanValue();
        }
        catch (Exception e) {
            this.sifre = false;
        }
        Composite shell2 = new Composite((Composite)this.shell, 2048);
        SWTContainer parent2 = new SWTContainer(shell2);
        Label dat = new Label(shell2, 0);
        dat.setText("Datum unosa:");
        dat.setBackground(this.shell.getDisplay().getSystemColor(22));
        this.datum = new DateInput2(parent2, "Datum unosa", new Date(this.server.getLastDateZD().getTime()), false, this.server);
        this.datum.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.datum, this.shell));
        this.datum.setEnabled(true);
        Label cr = null;
        if (inspektor) {
            cr = new Label(shell2, 0);
            cr.setText("Unos dodatnih:");
            cr.setBackground(this.shell.getDisplay().getSystemColor(22));
            this.crno = new Button(shell2, 32);
        }
        Label labelSG = new Label(shell2, 0);
        labelSG.setText("Kupac: ");
        labelSG.setBackground(shell2.getDisplay().getSystemColor(22));
        this.comboSG = new Combo(shell2, 12);
        this.comboSG.add("Odaberite kupca");
        for (StalniGost stg : this.stalni) {
            this.comboSG.add(stg.getNaziv());
        }
        this.comboSG.select(0);
        Label opisL = new Label(shell2, 0);
        opisL.setText("Opis:");
        opisL.setBackground(this.shell.getDisplay().getSystemColor(22));
        final Text opis = new Text(shell2, 2560);
        Label separator1 = new Label(shell2, 258);
        this.table = new Table(shell2, 68356);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        TableColumn nazivArtikla = new TableColumn(this.table, 0x1000000);
        nazivArtikla.setText("Naziv artikla");
        nazivArtikla.setWidth(150);
        TableColumn kolicina = new TableColumn(this.table, 0x1000000);
        kolicina.setText("Kolicina");
        kolicina.setWidth(65);
        TableColumn jmere = new TableColumn(this.table, 0x1000000);
        jmere.setText("J.M");
        jmere.setWidth(65);
        TableColumn nabavnaCena = new TableColumn(this.table, 0x1000000);
        nabavnaCena.setText("Nab. vrednost");
        nabavnaCena.setWidth(90);
        TableColumn prodajnaCena = new TableColumn(this.table, 0x1000000);
        prodajnaCena.setText("Prod. vrednost");
        prodajnaCena.setWidth(90);
        this.total = new TableItem(this.table, 0);
        this.total.setText(new String[]{"", "", "TOTAL:", "" + this.totalNab, "" + this.totalProd});
        this.plus = Dugmici.getPlusButton(shell2);
        this.plus.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                VPfaktura.this.unosStavke(VPfaktura.this.shell, VPfaktura.this.table);
            }
        });
        this.minus = Dugmici.getMinusButton(shell2);
        this.minus.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                int i = VPfaktura.this.table.getSelectionIndex();
                if (i >= 0 && i != VPfaktura.this.stavke.size()) {
                    VPfaktura.this.totalNab -= Double.parseDouble(VPfaktura.this.table.getItem(i).getText(3));
                    VPfaktura.this.totalProd -= Double.parseDouble(VPfaktura.this.table.getItem(i).getText(4));
                    VPfaktura.this.table.remove(i);
                    VPfaktura.this.stavke.remove(i);
                    VPfaktura.this.total.setText(new String[]{"", "", "TOTAL:", "" + VPfaktura.this.totalNab, "" + VPfaktura.this.totalProd});
                }
            }
        });
        Label separator2 = new Label(shell2, 258);
        Button cancelButt = Dugmici.getCancelButton(shell2);
        cancelButt.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                VPfaktura.this.parent.getControl().getShell().close();
            }
        });
        Button okButt = Dugmici.getOkButton(shell2);
        okButt.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (VPfaktura.this.server.getKonobarMeniPromet() == null) {
                    Konstante.getPoruka3(VPfaktura.this.shell, "Morate imati izabranog konobara!!!");
                    return;
                }
                if (VPfaktura.this.comboSG.getSelectionIndex() == 0) {
                    Konstante.getPoruka3(VPfaktura.this.shell, "Niste odabrali kupca !");
                    return;
                }
                StalniGost sg = (StalniGost)VPfaktura.this.stalni.get(VPfaktura.this.comboSG.getSelectionIndex() - 1);
                if (VPfaktura.this.stavke.size() < 1) {
                    Konstante.getPoruka3(VPfaktura.this.shell, "Morate uneti podatke za bar jedan artikal !");
                    return;
                }
                double iznos = 0.0;
                if (inspektor) {
                    VPfaktura.this.crn = VPfaktura.this.crno.getSelection();
                }
                try {
                    Calendar dc = Calendar.getInstance();
                    dc.setTime(VPfaktura.this.datum.getResult());
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(new Date());
                    cal.set(5, dc.get(5));
                    cal.set(2, dc.get(2));
                    cal.set(1, dc.get(1));
                    Tura t = new Tura();
                    t.setBrojStola(0);
                    t.setBrojTure(VPfaktura.this.server.sledeciBrojTure());
                    t.setDatum(cal.getTime());
                    t.setPripremljena(false);
                    t.setStavke(VPfaktura.this.stavke);
                    ArrayList<Tura> ture = new ArrayList<Tura>();
                    ture.add(t);
                    for (StavkaRacuna os : VPfaktura.this.stavke) {
                        os.setTura(t);
                        iznos += os.getCena() * os.getKolicina();
                    }
                    Placanje p = new Placanje();
                    p.setNacin(NacinPlacanja.FAKTURA);
                    p.setVreme(cal.getTime());
                    p.setIznos(iznos);
                    ZD zd = VPfaktura.this.server.getZDbyDatum(cal.getTime());
                    long zdBroj = zd.getZdBroj();
                    ArrayList<Placanje> pList = new ArrayList<Placanje>();
                    pList.add(p);
                    Racun r = new Racun();
                    r.setBrojFakture(Integer.parseInt(VPfaktura.this.server.getSetting(Option.SLEDECI_BROJ_VP_FAKTURE).getActual()));
                    r.setStalniGost(sg);
                    r.setZatvoren(true);
                    r.setNapomena(opis.getText());
                    r.setBrojStola(0);
                    r.setBrojGostiju("1");
                    r.setBrojRacuna(VPfaktura.this.server.nextFiscalBillNumber());
                    r.setDatum(cal.getTime());
                    r.setFiskalniOdstampan(false);
                    r.setKonobar(VPfaktura.this.server.getKonobarMeniPromet());
                    r.setPlacanja(pList);
                    r.setTure(ture);
                    r.setZdBroj(zdBroj);
                    try {
                        VPfaktura.this.server.makeRacunAndTura(r);
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                    r = (Racun)VPfaktura.this.server.getBase().find(Racun.class, (Object)r.getId());
                    Utrosci.upisDnevnogUtroska(r, VPfaktura.this.server);
                    int brojKopija = VPfaktura.this.server.getSetting(Option.BROJ_KOPIJA_FAKTURE).intValue();
                    new FakturaRacun(VPfaktura.this.shell.getDisplay(), VPfaktura.this.restoran, r, VPfaktura.this.restoran.getStope(), brojKopija, "", false, null, true);
                    VPfaktura.this.server.insertVpFakturaNaslov();
                    VPfaktura.this.server.incrementSledeciBrojVPFakture();
                    VPfaktura.this.izmenaPrometa(VPfaktura.this.datum.getResult());
                }
                catch (InputException ie) {
                    ie.printStackTrace();
                }
                VPfaktura.this.parent.getControl().getShell().close();
            }
        });
        GridLayout layout = new GridLayout(1, false);
        this.shell.setLayout((Layout)layout);
        this.shell.setMaximized(true);
        layout = new GridLayout(3, false);
        shell2.setLayout((Layout)layout);
        GridData data = new GridData();
        data.widthHint = 150;
        data.horizontalAlignment = 16384;
        data.horizontalSpan = 3;
        data = new GridData();
        data.widthHint = 150;
        data.horizontalAlignment = 16384;
        data.horizontalSpan = 2;
        dat.setLayoutData((Object)data);
        if (inspektor) {
            cr.setLayoutData((Object)data);
        }
        labelSG.setLayoutData((Object)data);
        opisL.setLayoutData((Object)data);
        data = new GridData();
        data.widthHint = 150;
        data.horizontalAlignment = 16384;
        this.datum.getControl().setLayoutData((Object)data);
        if (inspektor) {
            this.crno.setLayoutData((Object)data);
        }
        data = new GridData();
        data.horizontalSpan = 3;
        data = new GridData(768);
        data.horizontalSpan = 3;
        separator1.setLayoutData((Object)data);
        separator2.setLayoutData((Object)data);
        data = new GridData(768);
        data.horizontalSpan = 3;
        data.heightHint = 250;
        data = new GridData(768);
        data.horizontalSpan = 3;
        this.comboSG.setLayoutData((Object)data);
        data = new GridData(768);
        data.horizontalSpan = 3;
        data.heightHint = 60;
        opis.setLayoutData((Object)data);
        data = new GridData();
        data.widthHint = 450;
        data.heightHint = 400;
        data.horizontalAlignment = 16384;
        this.table.setLayoutData((Object)data);
    }

    private void izmenaPrometa(Date d) {
        this.server.deleteDnevnoStanje(d);
        IzracunajDnevniPromet dp = new IzracunajDnevniPromet(d, null, this.restoran.getServer());
        dp.createDnevnaStanja();
        this.server.addDnevnaStanja(dp.getDnevnaStanja());
    }

    public void unosStavke(Shell shell, final Table table) {
        final Shell shell2 = new Shell(shell.getDisplay(), 67680);
        shell2.setBackground(shell.getDisplay().getSystemColor(22));
        Monitor primary = shell2.getDisplay().getPrimaryMonitor();
        Rectangle bounds = primary.getBounds();
        Rectangle rect = shell2.getBounds();
        int x = bounds.x + rect.width / 2;
        int y = bounds.y + rect.height / 2;
        shell2.setLocation(x, y);
        final SortedMap<String, Long> artikli3 = this.server.getArtikliVPfaktura(this.odeljenje.getId());
        final SWTContainer parent2 = new SWTContainer((Composite)shell2);
        Label p = new Label((Composite)shell2, 0);
        p.setText("Pretraga:");
        p.setBackground(shell.getDisplay().getSystemColor(22));
        this.pretraga = new Text((Composite)shell2, 0);
        this.pretraga.addListener(2, new Listener(){

            public void handleEvent(Event e) {
                switch (e.keyCode) {
                    case 13: 
                    case 0x1000050: {
                        String str = VPfaktura.this.pretraga.getText();
                        if (str.length() > 0) {
                            VPfaktura.this.artikal.removeAll();
                        }
                        SortedMap<Object, Object> sMapa = new TreeMap();
                        if (str == null || str.length() <= 0) {
                            return;
                        }
                        sMapa = VPfaktura.this.server.getArtikliByNameOrBarcode(VPfaktura.this.odeljenje.getId(), str);
                        if (sMapa.isEmpty()) {
                            Konstante.getPoruka3(shell2, "Nije pronadjen artikal po pretrazi");
                            for (String string : artikli3.keySet()) {
                                VPfaktura.this.artikal.add(string);
                            }
                            VPfaktura.this.artikal.select(0);
                            break;
                        }
                        for (String string : sMapa.keySet()) {
                            VPfaktura.this.artikal.add(string);
                        }
                        VPfaktura.this.artikal.select(0);
                    }
                }
            }
        });
        Label a = new Label((Composite)shell2, 0);
        a.setText("Artikal:");
        a.setBackground(shell2.getDisplay().getSystemColor(22));
        this.artikal = new Combo((Composite)shell2, 2572);
        for (String s : artikli3.keySet()) {
            this.artikal.add(s);
        }
        this.artikal.select(0);
        Label k = new Label((Composite)shell2, 0);
        k.setText("Kolicina :");
        k.setBackground(shell2.getDisplay().getSystemColor(22));
        final DoubleInput2 kolicina = new DoubleInput2(parent2, "Kolicina", false);
        Label c = new Label((Composite)shell2, 0);
        c.setText("Cena :");
        c.setBackground(shell2.getDisplay().getSystemColor(22));
        final DoubleInput2 cena = new DoubleInput2(parent2, "Cena", false);
        this.artikal.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int i = VPfaktura.this.artikal.getSelectionIndex();
                Artikal art = null;
                if (i > -1) {
                    art = VPfaktura.this.server.getArtikal(VPfaktura.this.artikal.getItem(i));
                    cena.setResult(art.getCena());
                }
            }
        });
        Button cancelButt = Dugmici.getCancelButton(shell2);
        cancelButt.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                parent2.getControl().getShell().close();
            }
        });
        Button okButt = Dugmici.getOkButton(shell2);
        okButt.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                try {
                    int i = VPfaktura.this.artikal.getSelectionIndex();
                    Artikal art = null;
                    if (i > -1) {
                        art = VPfaktura.this.server.getArtikal(VPfaktura.this.artikal.getItem(i));
                    }
                    if (art == null) {
                        Konstante.getPoruka3(shell2, "Nije izabran artikal");
                        return;
                    }
                    StavkaRacuna st = new StavkaRacuna();
                    st.setArtikal(art);
                    st.setBrojStola(0);
                    st.setCena(cena.getResult());
                    st.setKolicina(kolicina.getResult());
                    st.setNaziv(art.getName());
                    VPfaktura.this.stavke.add(st);
                    TableItem item = new TableItem(table, 0, VPfaktura.this.stavke.size() - 1);
                    if (art.getTip() == TipArtikla.SIRO || art.getTip() == TipArtikla.POLU) {
                        art.setTrenutnaNV(VPfaktura.this.izracunajNabVrednost(art));
                        item.setText(new String[]{art.getName(), Konstante.getNumber14(kolicina.getResult()), art.getJedinicaMere(), "" + cena.getResult() * kolicina.getResult(), "0.0"});
                        VPfaktura.this.totalNab += art.getTrenutnaNV() * art.getMera() * kolicina.getResult();
                        VPfaktura.this.totalProd += 0.0;
                    } else {
                        art = (Artikal)VPfaktura.this.server.getBase().find(Artikal.class, (Object)art.getId());
                        item.setText(new String[]{art.getName(), Konstante.getNumber14(kolicina.getResult()), art.getJedinicaMere(), Konstante.getNumber4(art.getTrenutnaNV() * kolicina.getResult() * art.getMera()), "" + cena.getResult() * kolicina.getResult()});
                        VPfaktura.this.totalNab += art.getTrenutnaNV() * kolicina.getResult() * art.getMera();
                        VPfaktura.this.totalProd += cena.getResult() * kolicina.getResult();
                    }
                    shell2.close();
                }
                catch (InputException ex) {
                    Konstante.getPoruka(shell2, ex.getMessage());
                }
                VPfaktura.this.total.setText(new String[]{"", "", "TOTAL:", Konstante.getNumber4(VPfaktura.this.totalNab), "" + VPfaktura.this.totalProd});
            }
        });
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.verticalSpacing = 10;
        layout.horizontalSpacing = 10;
        shell2.setLayout((Layout)layout);
        GridData data = new GridData();
        data.widthHint = 200;
        data.horizontalAlignment = 131072;
        this.artikal.setLayoutData((Object)data);
        data = new GridData();
        data.widthHint = 150;
        data.heightHint = 30;
        data.horizontalAlignment = 16384;
        a.setLayoutData((Object)data);
        k.setLayoutData((Object)data);
        c.setLayoutData((Object)data);
        this.pretraga.setLayoutData((Object)data);
        kolicina.getControl().setLayoutData((Object)data);
        cena.getControl().setLayoutData((Object)data);
        data = new GridData();
        data.widthHint = 150;
        data.horizontalAlignment = 131072;
        shell2.pack();
        shell2.open();
    }

    public void izracunajBelo(Date day1, Date day2) {
        IzracunajDnevniPromet2 dp = new IzracunajDnevniPromet2(this.restoran, new Date(), true, false, this.odeljenje);
        this.stanjaDanas = dp.getDnevnaStanja();
        this.mapaPocetnoB = this.server.getDnevnoStanjeBelo(day1, this.odeljenje, PomocniUpit.artikliBezSlozenih(this.odeljenje));
        this.mapaIzlazB = this.server.getPeriodicnoStanjeBeloIzlaz(day1, day2, this.odeljenje, PomocniUpit.artikliBezSlozenih(this.odeljenje));
        this.mapaUlazB = this.server.getPeriodicnoStanjeBeloUlaz(day1, day2, this.odeljenje, PomocniUpit.artikliBezSlozenih(this.odeljenje));
    }

    public void izracunajCrno(Date day1, Date day2) {
        IzracunajDnevniPromet2 dp = new IzracunajDnevniPromet2(this.restoran, new Date(), false, true, this.odeljenje);
        this.stanjaDanas = dp.getDnevnaStanja();
        this.mapaPocetnoC = this.server.getDnevnoStanjeCrno(day1, this.odeljenje, PomocniUpit.artikliBezSlozenih(this.odeljenje));
        this.mapaIzlazC = this.server.getPeriodicnoStanjeCrnoIzlaz(day1, day2, this.odeljenje, PomocniUpit.artikliBezSlozenih(this.odeljenje));
        this.mapaUlazC = this.server.getPeriodicnoStanjeCrnoUlaz(day1, day2, this.odeljenje, PomocniUpit.artikliBezSlozenih(this.odeljenje));
    }

    public double izracunajPocetno(Artikal a, boolean belo) {
        double pocetno = 0.0;
        if (belo && this.mapaPocetnoB.get(a.getId()) != null) {
            pocetno += this.mapaPocetnoB.get(a.getId()).doubleValue();
        }
        if (!belo && this.mapaPocetnoC.get(a.getId()) != null) {
            pocetno += this.mapaPocetnoC.get(a.getId()).doubleValue();
        }
        return pocetno;
    }

    public double izracunajUlaz(Artikal a, boolean belo) {
        double ulaz = 0.0;
        if (belo) {
            if (this.mapaUlazB.get(a.getId()) != null) {
                ulaz += this.mapaUlazB.get(a.getId()).doubleValue();
            }
            if (this.getDS(a) != null) {
                ulaz += this.getDS(a).getBeloUlaz().doubleValue();
            }
        }
        if (!belo) {
            if (this.mapaUlazC.get(a.getId()) != null) {
                ulaz += this.mapaUlazC.get(a.getId()).doubleValue();
            }
            if (this.getDS(a) != null) {
                ulaz += this.getDS(a).getCrnoUlaz().doubleValue();
            }
        }
        return ulaz;
    }

    public double izracunajIzlaz(Artikal a, boolean belo) {
        double izlaz = 0.0;
        if (belo) {
            if (this.mapaIzlazB.get(a.getId()) != null) {
                izlaz += this.mapaIzlazB.get(a.getId()).doubleValue();
            }
            if (this.getDS(a) != null) {
                izlaz += this.getDS(a).getBeloIzlaz().doubleValue();
            }
        }
        if (!belo) {
            if (this.mapaIzlazC.get(a.getId()) != null) {
                izlaz += this.mapaIzlazC.get(a.getId()).doubleValue();
            }
            if (this.getDS(a) != null) {
                izlaz += this.getDS(a).getCrnoIzlaz().doubleValue();
            }
        }
        return izlaz;
    }

    public void sortiraj(List<Artikal> artikli) {
        Comparator<Artikal> SENIORITY_ORDER = null;
        SENIORITY_ORDER = new Comparator<Artikal>(){

            @Override
            public int compare(Artikal t1, Artikal t2) {
                return t1.getName().compareTo(t2.getName());
            }
        };
        Collections.sort(artikli, SENIORITY_ORDER);
    }

    public double izracunajNabVrednost(Artikal input) {
        double nv = 0.0;
        try {
            for (Normativ n : this.server.getNormativiByLastNormativiArtikal(input.getId())) {
                nv += n.getSastojak().getTrenutnaNV() * n.getKolicina();
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return nv;
    }

    DnevnoStanje getDS(Artikal a) {
        if (this.stanjaDanas == null) {
            return null;
        }
        for (DnevnoStanje ds : this.stanjaDanas) {
            if (!ds.getArtikalID().equals(a.getId())) continue;
            return ds;
        }
        return null;
    }
}

