/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.sistem;

import com.dev63.fiscal.FiscalException;
import com.dev63.fiscal.fp550.SerialIOException;
import com.dev63.hotel.swt.swing2swt.components.SWTComponent;
import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.hotel.swt.swing2swt.components.SWTOptionPane;
import com.dev63.restoran.Dugmici;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.NabavneCene;
import com.dev63.restoran.PopisProvera;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.SWTContainerClass;
import com.dev63.restoran.StavkeSumarno;
import com.dev63.restoran.comparators.PrijemnicaStavkaRedniBrojComparator;
import com.dev63.restoran.constants.StatLogic;
import com.dev63.restoran.izvestaji.stampa.ReportPrintBuilder;
import com.dev63.restoran.izvestaji.stampa.StampaKalkulacijeNPC2;
import com.dev63.restoran.model.Artikal;
import com.dev63.restoran.model.BObject;
import com.dev63.restoran.model.GrupaArtikala;
import com.dev63.restoran.model.HacapMagacini;
import com.dev63.restoran.model.Normativ;
import com.dev63.restoran.model.Odeljenje;
import com.dev63.restoran.model.Option;
import com.dev63.restoran.model.PodgrupaArtikala;
import com.dev63.restoran.model.Prijemnica;
import com.dev63.restoran.model.PrijemnicaStavka;
import com.dev63.restoran.model.Setting;
import com.dev63.restoran.model.StalniGost;
import com.dev63.restoran.model.TipPrijemnice;
import com.dev63.restoran.model.TipTrebovanja;
import com.dev63.restoran.parts.DateInput2;
import com.dev63.restoran.parts.DoubleInput2;
import com.dev63.restoran.parts.InputException;
import com.dev63.restoran.parts.ObjectWrapper;
import com.dev63.restoran.parts.TextInput2;
import com.dev63.restoran.sistem.ArtikalDialog;
import com.dev63.restoran.sistem.CalendarAdapter;
import com.dev63.restoran.sistem.Dobavljaci;
import com.dev63.restoran.sistem.PoreskeStope;
import com.dev63.restoran.stampa.StampaKalkulacijeBA;
import com.dev63.restoran.stampa.StampaKalkulacijeNPC;
import com.dev63.restoran.stampa.StampaPrijemniceUska;
import com.dev63.restoran.swt.resources.FontCache;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.nebula.paperclips.core.Print;
import org.eclipse.nebula.paperclips.core.PrintJob;
import org.eclipse.nebula.paperclips.core.page.PagePrint;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class UpravljanjePrijemnicom {
    String fontName = "Arial";
    private final ResourceBundle barmasterText = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale());
    private RestoranServer server;
    private Restoran restoran;
    private Prijemnica input;
    private TipPrijemnice type;
    private Shell shell;
    private List<StalniGost> dobavljaci;
    private Combo dobavljac;
    private DateInput2 datum;
    private DateInput2 datum2;
    private DateInput2 valutaPlacanja;
    Button crno;
    private Table stavkeTable;
    private TableViewer stavkeTV;
    private Button plus;
    private Button minus;
    private Odeljenje magacin;
    private String brojPrijemnice;
    private List<PrijemnicaStavka> stavke = new ArrayList<PrijemnicaStavka>();
    private List<PrijemnicaStavka> stavkeZaUklanjanje = new ArrayList<PrijemnicaStavka>();
    private Label total;
    private double ukupnaVred = 0.0;
    private Boolean poPoslednjimCenama;
    private Boolean poPoslednjimCenamaKombo;
    private Text pretraga;
    private Combo artikal;
    private DoubleInput2 cenaKomad;
    private DoubleInput2 cenaKomad2;
    private Label preostalaKol2;
    private Combo pdvC;
    private DoubleInput2 kolicina;
    private DoubleInput2 nabVrednost;
    private DoubleInput2 rabat;
    private DoubleInput2 cenarabat;
    private DoubleInput2 nabVrednost2;
    private DoubleInput2 prodCena;
    private DoubleInput2 marza;
    private Text opis;
    private Text oznakaDokumenta;
    private Button uskaStampa;
    private Button stampaKalkulacije;
    private Button stampaKalkulacijeMaterijala;
    private Artikal artikalI;
    private Label kolicinaLabel;
    private int vrednostStope;
    private List<Artikal> artikliSvi;
    private Map<GrupaArtikala, Set<PodgrupaArtikala>> mapaGrupa;
    private Map<PodgrupaArtikala, Set<Artikal>> mapaPodgrupa;
    private Map<String, Artikal> artikliC = new HashMap<String, Artikal>();
    private boolean pregled;
    private int nextRB = 1;
    private Comparator<PrijemnicaStavka> psComp = new PrijemnicaStavkaRedniBrojComparator();
    private Boolean hasap;
    private TextInput2 hasVreme;
    private TextInput2 hasReg;
    private TextInput2 hasKontr;
    private TextInput2 hasLicenca;

    public UpravljanjePrijemnicom(Shell parent, Restoran r, Prijemnica inputTR, TipPrijemnice tip, List<Artikal> artikliSvi, boolean review, boolean hasap) {
        if (tip == null) {
            MessageBox mb = new MessageBox(parent, 40);
            mb.setText(String.format(this.barmasterText.getString("TEXT_BARMASTER"), new Object[0]));
            mb.setMessage(String.format(Konstante.getBundle().getString("PORUKA_NIJE_PREPOZNAT_TIP_PRIJEMNICE"), new Object[0]));
            mb.open();
            return;
        }
        this.pregled = review;
        this.hasap = hasap;
        this.input = inputTR;
        this.type = tip;
        this.restoran = r;
        this.server = this.restoran.getServer();
        this.shell = new Shell(parent.getDisplay(), 1264);
        this.shell.setBackgroundMode(1);
        this.shell.setText(tip.getInterName() + (this.input == null ? " - " + ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_UNOS") : " - " + ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_BROJ") + ": " + this.input.getBrPrijemnice()));
        this.magacin = this.server.returnMagacin();
        if (this.input != null) {
            try {
                this.restoran.getServer().getBase().refresh((Object)this.input);
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
        }
        this.artikliSvi = artikliSvi == null ? this.server.findAllArticlesNoComplexNoBlocked() : artikliSvi;
        if (!this.pregled) {
            this.fillInMap(this.artikliSvi);
        }
        this.dobavljaci = this.server.allDobavljaci();
        this.poPoslednjimCenama = this.server.getSetting(Option.PO_POSLEDNJIM_UNETIM_CENAMA).booleanValue();
        this.poPoslednjimCenamaKombo = this.server.getSetting(Option.PO_POSLEDNJIM_CENAMA_KOMBINOVANO).booleanValue();
        Composite grupa = new Composite((Composite)this.shell, 2048);
        SWTContainer grupaSWTC = new SWTContainer(grupa);
        GridData data = new GridData(768);
        data.horizontalSpan = 3;
        grupa.setLayoutData((Object)data);
        grupa.setLayout((Layout)new GridLayout(4, false));
        Label dat = new Label(grupa, 131072);
        dat.setText(String.format(this.barmasterText.getString("TEXT_DATUM_PRIJEMA"), new Object[0]) + ":");
        this.datum = new DateInput2(grupaSWTC, String.format(this.barmasterText.getString("TEXT_DATUM_PRIJEMA"), new Object[0]), new Date(this.server.getLastDateZD().getTime()), false, this.server);
        this.datum.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.datum, this.shell));
        this.datum.setEnabled(!this.pregled);
        Label dat2 = new Label(grupa, 131072);
        dat2.setText(String.format(this.barmasterText.getString("TEXT_DATUM_UNOSA"), new Object[0]) + ":");
        this.datum2 = new DateInput2(grupaSWTC, String.format(this.barmasterText.getString("TEXT_DATUM_UNOSA"), new Object[0]), new Date(this.server.getLastDateZD().getTime()), false, this.server);
        this.datum2.setEnabled(false);
        Label d = new Label(grupa, 131072);
        d.setText(String.format(this.barmasterText.getString("TEXT_DOBAVLJAC"), new Object[0]) + ":");
        Composite dob = new Composite(grupa, 0);
        GridLayout gl = new GridLayout(2, false);
        gl.marginTop = 0;
        gl.marginRight = 0;
        gl.marginLeft = 0;
        gl.marginBottom = 0;
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        dob.setLayout((Layout)gl);
        d.setVisible(true);
        this.dobavljac = new Combo(dob, 524);
        this.dobavljac.setEnabled(!this.pregled);
        data = new GridData(4, 0x1000000, true, true);
        this.dobavljac.setLayoutData((Object)data);
        if (this.pregled) {
            data.horizontalSpan = 2;
        } else {
            Button bNew = Dugmici.getPlusButton(dob);
            bNew.setText("");
            bNew.setVisible(!review);
            bNew.setEnabled(!review);
            bNew.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    Shell shells = new Shell(UpravljanjePrijemnicom.this.shell, 34912);
                    new Dobavljaci(SWTContainerClass.makeContainer(shells, UpravljanjePrijemnicom.this.barmasterText.getString("TEXT_ADMINISTRACIJA_DOBAVLJACA")), UpravljanjePrijemnicom.this.restoran);
                    SWTContainerClass.makeEnd(shells);
                    UpravljanjePrijemnicom.this.dobavljaci = UpravljanjePrijemnicom.this.server.allDobavljaci();
                    UpravljanjePrijemnicom.this.loadDobavljace();
                }
            });
            data = new GridData(0x1000000, 0x1000000, false, true);
            data.heightHint = 30;
            data.widthHint = 30;
            bNew.setLayoutData((Object)data);
        }
        Label c = new Label(grupa, 131072);
        c.setText(String.format(this.barmasterText.getString("TEXT_DODATNE_ZALIHE"), new Object[0]));
        this.crno = new Button(grupa, 32);
        this.crno.setEnabled(!this.pregled);
        Label odL = new Label(grupa, 131072);
        odL.setText(String.format(Konstante.getBundle().getString("TEXT_OZNAKA_DOKUMENTA"), new Object[0]) + ":");
        this.oznakaDokumenta = new Text(grupa, 2048);
        this.oznakaDokumenta.setEditable(!this.pregled);
        Label opisL = new Label(grupa, 131072);
        opisL.setText(String.format(this.barmasterText.getString("TEXT_OPIS"), new Object[0]) + ":");
        this.opis = new Text(grupa, 2562);
        this.opis.setEditable(!this.pregled);
        Label valuta = new Label(grupa, 131072);
        valuta.setText(String.format(this.barmasterText.getString("TEXT_VALUTA_PLACANJA_DATUM"), new Object[0]) + ":");
        this.valutaPlacanja = new DateInput2(grupa, String.format(this.barmasterText.getString("TEXT_DATUM_PRIJEMA"), new Object[0]), new Date(this.server.getLastDateZD().getTime()), false, this.server);
        this.valutaPlacanja.setValutaPlacanja(true);
        this.valutaPlacanja.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.valutaPlacanja, this.shell));
        this.valutaPlacanja.setEnabled(!this.pregled);
        Label lVreme = null;
        Label lReg = null;
        Label lKont = null;
        if (hasap) {
            Composite hasapGroup = new Composite((Composite)this.shell, 2048);
            GridData data1 = new GridData(768);
            data1.horizontalSpan = 4;
            hasapGroup.setLayoutData((Object)data1);
            hasapGroup.setLayout((Layout)new GridLayout(8, false));
            lVreme = new Label(hasapGroup, 131072);
            lVreme.setText(this.barmasterText.getString("TEXT_VREME_PRIJEMA") + ": ");
            this.hasVreme = new TextInput2(hasapGroup, this.barmasterText.getString("TEXT_VREME_PRIJEMA"));
            lReg = new Label(hasapGroup, 131072);
            lReg.setText(this.barmasterText.getString("TEXT_REGISTARSKA_TABLICA") + ": ");
            this.hasReg = new TextInput2(hasapGroup, this.barmasterText.getString("TEXT_REGISTARSKA_TABLICA"));
            lKont = new Label(hasapGroup, 131072);
            lKont.setText(this.barmasterText.getString("TEXT_KONTROLISAO") + ": ");
            this.hasKontr = new TextInput2(hasapGroup, this.barmasterText.getString("TEXT_KONTROLISAO"));
            this.hasLicenca = new TextInput2(hasapGroup, "");
            this.hasLicenca.setResult("HACCP licenca br: " + this.server.getSetting(Option.HACCP_LICENCE).stringValue());
            this.hasLicenca.setEditable(false);
        }
        Composite cTable = new Composite((Composite)this.shell, 2048);
        cTable.setLayout((Layout)new GridLayout());
        cTable.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        this.stavkeTV = new TableViewer(cTable, 68356);
        this.stavkeTable = this.stavkeTV.getTable();
        this.stavkeTable.setHeaderVisible(true);
        this.stavkeTable.setLinesVisible(true);
        this.stavkeTable.setFont(FontCache.getFont(this.fontName, 7, 0));
        TableColumn rbArtikla = new TableColumn(this.stavkeTable, 131072);
        rbArtikla.setText(String.format(this.barmasterText.getString("TEXT_REDNI_BROJ_SKR"), new Object[0]));
        rbArtikla.setWidth(40);
        TableViewerColumn tvcRB = new TableViewerColumn(this.stavkeTV, rbArtikla);
        tvcRB.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell vc) {
                String res = "";
                PrijemnicaStavka ts = (PrijemnicaStavka)vc.getElement();
                if (ts.getRedniBroj() == null) {
                    if (UpravljanjePrijemnicom.this.pregled) {
                        if (UpravljanjePrijemnicom.this.stavke.indexOf(ts) == 0) {
                            UpravljanjePrijemnicom.this.nextRB = 1;
                        }
                        res = "" + UpravljanjePrijemnicom.this.nextRB;
                        UpravljanjePrijemnicom.this.nextRB++;
                    }
                } else {
                    res = ts.getRedniBroj().toString();
                }
                vc.setText(res);
            }
        });
        TableColumn nazivArtikla = new TableColumn(this.stavkeTable, 16384);
        nazivArtikla.setText(String.format(this.barmasterText.getString("TEXT_NAZIV_ARTIKLA"), new Object[0]));
        nazivArtikla.setWidth(150);
        TableViewerColumn tvcNaziv = new TableViewerColumn(this.stavkeTV, nazivArtikla);
        tvcNaziv.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell vc) {
                PrijemnicaStavka ts = (PrijemnicaStavka)vc.getElement();
                vc.setText(ts.getArtikal().getName());
            }
        });
        TableColumn kolic = new TableColumn(this.stavkeTable, 131072);
        kolic.setText(String.format(this.barmasterText.getString("TEXT_KOLICINA"), new Object[0]));
        kolic.setWidth(80);
        TableViewerColumn tvcKolic = new TableViewerColumn(this.stavkeTV, kolic);
        tvcKolic.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell vc) {
                PrijemnicaStavka ts = (PrijemnicaStavka)vc.getElement();
                vc.setText(StatLogic.getNumber04(UpravljanjePrijemnicom.this.type.getTip() == TipTrebovanja.DokumentAtribut.IZLAZNI ? -ts.getKolicina().doubleValue() : ts.getKolicina()));
            }
        });
        TableColumn jmere = new TableColumn(this.stavkeTable, 16384);
        jmere.setText(String.format(this.barmasterText.getString("TEXT_JEDINICA_MERE_SKR"), new Object[0]));
        jmere.setWidth(50);
        TableViewerColumn tvcJM = new TableViewerColumn(this.stavkeTV, jmere);
        tvcJM.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell vc) {
                PrijemnicaStavka ts = (PrijemnicaStavka)vc.getElement();
                vc.setText(ts.getArtikal().getJedinicaMere());
            }
        });
        TableColumn cKomadBPDV = new TableColumn(this.stavkeTable, 131072);
        cKomadBPDV.setText(String.format(Konstante.getBundle().getString("TEXT_CENA_KOMAD_BEZ_PDV_SKR"), new Object[0]));
        cKomadBPDV.setWidth(80);
        TableViewerColumn tvcCenaBPDV = new TableViewerColumn(this.stavkeTV, cKomadBPDV);
        tvcCenaBPDV.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell vc) {
                PrijemnicaStavka ps = (PrijemnicaStavka)vc.getElement();
                vc.setText(StatLogic.getNumber04(ps.getKomad()));
            }
        });
        TableColumn cKomad = new TableColumn(this.stavkeTable, 131072);
        cKomad.setText(String.format(this.barmasterText.getString("TEXT_CENA_KOMAD_SKR"), new Object[0]));
        cKomad.setWidth(80);
        TableViewerColumn tvcCena = new TableViewerColumn(this.stavkeTV, cKomad);
        tvcCena.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell vc) {
                PrijemnicaStavka ps = (PrijemnicaStavka)vc.getElement();
                Double cspdv = ps.getKomadSPDV();
                Double pdv = ps.getPdvStopa();
                if (cspdv == null) {
                    if (pdv == null) {
                        try {
                            pdv = Konstante.getPGStopaProcenat(ps.getArtikal().getPoreskaGrupa());
                        }
                        catch (Exception ex) {
                            pdv = 0.0;
                            ex.printStackTrace(System.err);
                        }
                    }
                    pdv = 1.0 + pdv / 100.0;
                    cspdv = ps.getKomad() * pdv;
                    ps.setKomadSPDV(StatLogic.round(cspdv, 2));
                }
                vc.setText(StatLogic.getNumber02(ps.getKomadSPDV()));
            }
        });
        TableColumn nv = new TableColumn(this.stavkeTable, 131072);
        nv.setText(String.format(this.barmasterText.getString("TEXT_NABAVNA_CENA_SKR"), new Object[0]));
        nv.setWidth(80);
        TableViewerColumn tvcNV = new TableViewerColumn(this.stavkeTV, nv);
        tvcNV.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell vc) {
                PrijemnicaStavka ps = (PrijemnicaStavka)vc.getElement();
                Double pBPDV = ps.getKomad();
                Double vBPDV = ps.getVrednost();
                if (vBPDV == null) {
                    vBPDV = ps.getKolicina() * pBPDV;
                    ps.setVrednost(StatLogic.round(vBPDV, 2));
                }
                vc.setText(StatLogic.getNumber02(vBPDV));
            }
        });
        TableColumn nv2 = new TableColumn(this.stavkeTable, 131072);
        nv2.setText(String.format(this.barmasterText.getString("TEXT_NABAVNA_CENA_SA_PDV_SKR"), new Object[0]));
        nv2.setWidth(100);
        TableViewerColumn tvcNVPDV = new TableViewerColumn(this.stavkeTV, nv2);
        tvcNVPDV.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell vc) {
                PrijemnicaStavka ps = (PrijemnicaStavka)vc.getElement();
                Double vPDV = ps.getVrednostSPDV();
                Double pBPDV = ps.getKomad();
                Double vBPDV = ps.getVrednost();
                if (vPDV == null) {
                    if (vBPDV == null) {
                        vBPDV = ps.getKolicina() * pBPDV;
                    }
                    vPDV = StatLogic.round(vBPDV, 2) + StatLogic.round(vBPDV * (ps.getPdvStopa() / 100.0), 2);
                    ps.setVrednostSPDV(StatLogic.round(vPDV, 2));
                }
                vc.setText(StatLogic.getNumber02(ps.getVrednostSPDV()));
            }
        });
        TableColumn rbt = new TableColumn(this.stavkeTable, 131072);
        rbt.setText(String.format(this.barmasterText.getString("TEXT_RABAT"), new Object[0]));
        rbt.setWidth(80);
        TableViewerColumn tvcRBT = new TableViewerColumn(this.stavkeTV, rbt);
        tvcRBT.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell vc) {
                PrijemnicaStavka ps = (PrijemnicaStavka)vc.getElement();
                Double pRb = ps.getRabat();
                vc.setText(StatLogic.getNumber02(pRb != null ? pRb : 0.0));
            }
        });
        TableColumn vrbt = new TableColumn(this.stavkeTable, 131072);
        vrbt.setText(String.format(this.barmasterText.getString("TEXT_CENA_SA_RABATOM"), new Object[0]));
        vrbt.setWidth(80);
        TableViewerColumn tvccRBT = new TableViewerColumn(this.stavkeTV, vrbt);
        tvccRBT.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell vc) {
                PrijemnicaStavka ps = (PrijemnicaStavka)vc.getElement();
                Double csRb = ps.getKomBPDVsaRbt();
                vc.setText(StatLogic.getNumber02(csRb != null ? csRb : 0.0));
            }
        });
        if (!this.pregled) {
            Composite itemControls = new Composite(cTable, 0);
            itemControls.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
            itemControls.setLayout((Layout)new GridLayout(5, true));
            this.plus = Dugmici.getPlusButton(itemControls);
            this.plus.setVisible(!this.pregled);
            this.plus.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    UpravljanjePrijemnicom.this.unosStavkePrijemnice(UpravljanjePrijemnicom.this.shell, UpravljanjePrijemnicom.this.stavkeTable);
                }
            });
            this.minus = Dugmici.getMinusButton(itemControls);
            this.minus.setVisible(!this.pregled);
            this.minus.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    IStructuredSelection iss = (IStructuredSelection)UpravljanjePrijemnicom.this.stavkeTV.getSelection();
                    if (iss.isEmpty()) {
                        return;
                    }
                    PrijemnicaStavka stavka = (PrijemnicaStavka)iss.getFirstElement();
                    UpravljanjePrijemnicom.this.stavkeZaUklanjanje.add(stavka);
                    UpravljanjePrijemnicom.this.stavke.remove(stavka);
                    Collections.sort(UpravljanjePrijemnicom.this.stavke, UpravljanjePrijemnicom.this.psComp);
                    UpravljanjePrijemnicom.this.nextRB = 1;
                    for (PrijemnicaStavka ps : UpravljanjePrijemnicom.this.stavke) {
                        ps.setRedniBroj(UpravljanjePrijemnicom.this.nextRB);
                        UpravljanjePrijemnicom.this.nextRB++;
                    }
                    UpravljanjePrijemnicom.this.stavkeTV.refresh(true, true);
                    UpravljanjePrijemnicom.this.updateTotal();
                }
            });
            Button up = Dugmici.getPlusButton(itemControls);
            up.setVisible(!this.pregled);
            up.setText(String.format(Konstante.getBundle().getString("TEXT_GORE"), new Object[0]));
            up.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    IStructuredSelection iss = (IStructuredSelection)UpravljanjePrijemnicom.this.stavkeTV.getSelection();
                    if (iss.isEmpty() || !(iss.getFirstElement() instanceof PrijemnicaStavka)) {
                        return;
                    }
                    PrijemnicaStavka ps = (PrijemnicaStavka)iss.getFirstElement();
                    if (ps == null) {
                        return;
                    }
                    int idx = UpravljanjePrijemnicom.this.stavke.indexOf(ps);
                    if (idx == 0) {
                        return;
                    }
                    Collections.rotate(UpravljanjePrijemnicom.this.stavke.subList(idx - 1, idx + 1), 1);
                    UpravljanjePrijemnicom.this.nextRB = 1;
                    for (PrijemnicaStavka pss : UpravljanjePrijemnicom.this.stavke) {
                        pss.setRedniBroj(UpravljanjePrijemnicom.this.nextRB);
                        UpravljanjePrijemnicom.this.nextRB++;
                    }
                    Collections.sort(UpravljanjePrijemnicom.this.stavke, UpravljanjePrijemnicom.this.psComp);
                    UpravljanjePrijemnicom.this.stavkeTV.refresh();
                }
            });
            Button down = Dugmici.getMinusButton(itemControls);
            down.setVisible(!this.pregled);
            down.setText(String.format(Konstante.getBundle().getString("TEXT_DOLE"), new Object[0]));
            down.addListener(13, new Listener(){

                public void handleEvent(Event ev) {
                    IStructuredSelection iss = (IStructuredSelection)UpravljanjePrijemnicom.this.stavkeTV.getSelection();
                    if (iss.isEmpty() || !(iss.getFirstElement() instanceof PrijemnicaStavka)) {
                        return;
                    }
                    PrijemnicaStavka ps = (PrijemnicaStavka)iss.getFirstElement();
                    if (ps == null) {
                        return;
                    }
                    int idx = UpravljanjePrijemnicom.this.stavke.indexOf(ps);
                    if (idx == UpravljanjePrijemnicom.this.stavke.size() - 1) {
                        return;
                    }
                    Collections.rotate(UpravljanjePrijemnicom.this.stavke.subList(idx, idx + 2), 1);
                    UpravljanjePrijemnicom.this.nextRB = 1;
                    for (PrijemnicaStavka pss : UpravljanjePrijemnicom.this.stavke) {
                        pss.setRedniBroj(UpravljanjePrijemnicom.this.nextRB);
                        UpravljanjePrijemnicom.this.nextRB++;
                    }
                    Collections.sort(UpravljanjePrijemnicom.this.stavke, UpravljanjePrijemnicom.this.psComp);
                    UpravljanjePrijemnicom.this.stavkeTV.refresh();
                }
            });
            Button addArtikal = Dugmici.getPlusButton(itemControls);
            addArtikal.setVisible(!this.pregled);
            addArtikal.setText(" " + String.format(this.barmasterText.getString("TEXT_NOVI_ARTIKAL"), new Object[0]) + " ");
            addArtikal.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    super.widgetSelected(e);
                    try {
                        UpravljanjePrijemnicom.this.addArtikal();
                    }
                    catch (FiscalException ex) {
                        Logger.getLogger(UpravljanjePrijemnicom.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    catch (SerialIOException ex) {
                        Logger.getLogger(UpravljanjePrijemnicom.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            });
        }
        Composite cTotal = new Composite((Composite)this.shell, 2048);
        cTotal.setLayout((Layout)new GridLayout(2, false));
        cTotal.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        Label t = new Label(cTotal, 131072);
        t.setText(String.format(this.barmasterText.getString("TEXT_UKUPNA_VREDNOST"), new Object[0]) + ":");
        this.total = new Label(cTotal, 16384);
        this.total.setText("");
        this.loadData();
        this.stavkeTV.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.stavkeTV.setInput(this.stavke);
        Composite cPrint = new Composite((Composite)this.shell, 2048);
        cPrint.setLayout((Layout)new GridLayout(3, true));
        GridData pbData = new GridData(4, 0x1000000, true, true);
        pbData.heightHint = 30;
        this.uskaStampa = new Button(cPrint, (this.pregled ? 8 : 32) | 0x40);
        this.uskaStampa.setText(String.format(this.barmasterText.getString("TEXT_USKA_STAMPA"), new Object[0]));
        this.uskaStampa.setLayoutData((Object)pbData);
        this.stampaKalkulacije = new Button(cPrint, (this.pregled ? 8 : 32) | 0x40);
        this.stampaKalkulacije.setText(String.format(this.barmasterText.getString("TEXT_STAMPA_KALKULACIJE"), new Object[0]));
        this.stampaKalkulacije.setLayoutData((Object)pbData);
        this.stampaKalkulacijeMaterijala = new Button(cPrint, (this.pregled ? 8 : 32) | 0x40);
        this.stampaKalkulacijeMaterijala.setText(String.format("\u0160tampa kalkulacije materijala", new Object[0]));
        this.stampaKalkulacijeMaterijala.setLayoutData((Object)pbData);
        if (this.pregled) {
            this.uskaStampa.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    try {
                        new StampaPrijemniceUska(UpravljanjePrijemnicom.this.input, UpravljanjePrijemnicom.this.server.readIzvestajiStampacObject(), 1);
                    }
                    catch (Exception ex) {
                        Logger.getLogger(UpravljanjePrijemnicom.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            });
            this.stampaKalkulacije.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    PrintJob pj = UpravljanjePrijemnicom.this.pripremaStampe(false);
                    ReportPrintBuilder.printPreview(UpravljanjePrijemnicom.this.shell, pj);
                }
            });
            this.stampaKalkulacijeMaterijala.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    PrintJob pj = UpravljanjePrijemnicom.this.pripremaStampe(true);
                    ReportPrintBuilder.printPreview(UpravljanjePrijemnicom.this.shell, pj);
                }
            });
        }
        Composite cControl = new Composite((Composite)this.shell, 0);
        cControl.setLayout((Layout)new GridLayout(2, true));
        cControl.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        Button cancelButt = Dugmici.getCancelButton(cControl);
        cancelButt.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                UpravljanjePrijemnicom.this.shell.close();
            }
        });
        data = (GridData)cancelButt.getLayoutData();
        data.horizontalAlignment = 0x1000000;
        data.verticalAlignment = 0x1000000;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        Button okButt = Dugmici.getOkButton(cControl);
        data = (GridData)okButt.getLayoutData();
        data.horizontalAlignment = 0x1000000;
        data.verticalAlignment = 0x1000000;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        if (this.pregled) {
            cancelButt.setText(String.format(this.barmasterText.getString("TEXT_ZATVORI"), new Object[0]));
            okButt.setEnabled(false);
            okButt.setVisible(false);
        } else {
            okButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    Odeljenje odeljenje = UpravljanjePrijemnicom.this.server.getOdeljenje("MAGACIN");
                    try {
                        PopisProvera provera = new PopisProvera(UpravljanjePrijemnicom.this.server, UpravljanjePrijemnicom.this.shell, UpravljanjePrijemnicom.this.datum.getResult(), odeljenje, true);
                        if (provera.isPopis()) {
                            provera.setValidDate(UpravljanjePrijemnicom.this.datum);
                            return;
                        }
                    }
                    catch (InputException e1) {
                        e1.printStackTrace();
                    }
                    boolean ret = UpravljanjePrijemnicom.this.saveData();
                    if (ret) {
                        boolean stk;
                        boolean ust;
                        boolean bl = ust = UpravljanjePrijemnicom.this.uskaStampa != null && UpravljanjePrijemnicom.this.uskaStampa.getSelection();
                        if (ust) {
                            Runnable r = new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        new StampaPrijemniceUska(UpravljanjePrijemnicom.this.input, UpravljanjePrijemnicom.this.server.readIzvestajiStampacObject(), 1);
                                    }
                                    catch (Exception ex) {
                                        Logger.getLogger(UpravljanjePrijemnicom.class.getName()).log(Level.SEVERE, null, ex);
                                    }
                                }
                            };
                            Thread t = new Thread(r);
                            t.start();
                        }
                        boolean bl2 = stk = UpravljanjePrijemnicom.this.stampaKalkulacije != null && UpravljanjePrijemnicom.this.stampaKalkulacije.getSelection();
                        if (stk) {
                            Runnable r = new Runnable(){

                                @Override
                                public void run() {
                                    Display d = new Display();
                                    Shell shell2 = new Shell(d, 1264);
                                    PrintJob pj = UpravljanjePrijemnicom.this.pripremaStampe(false);
                                    ReportPrintBuilder.printPreview(shell2, pj);
                                    shell2.setActive();
                                    while (!shell2.isDisposed()) {
                                        if (d.readAndDispatch()) continue;
                                        d.sleep();
                                    }
                                    d.dispose();
                                }
                            };
                            Thread t = new Thread(r);
                            t.start();
                        }
                        UpravljanjePrijemnicom.this.shell.close();
                    }
                }
            });
        }
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.verticalSpacing = 2;
        layout.horizontalSpacing = 2;
        this.shell.setLayout((Layout)layout);
        data = new GridData(131072, 0x1000000, false, true);
        data.widthHint = 150;
        d.setLayoutData((Object)data);
        dat.setLayoutData((Object)data);
        if (hasap) {
            lVreme.setLayoutData((Object)data);
        }
        valuta.setLayoutData((Object)data);
        dat2.setLayoutData((Object)data);
        c.setLayoutData((Object)data);
        odL.setLayoutData((Object)data);
        opisL.setLayoutData((Object)data);
        t.setLayoutData((Object)data);
        data = new GridData(4, 0x1000000, true, true);
        data.heightHint = 25;
        dob.setLayoutData((Object)data);
        if (hasap) {
            this.hasVreme.getControl().setLayoutData((Object)data);
            this.hasReg.getControl().setLayoutData((Object)data);
            this.hasKontr.getControl().setLayoutData((Object)data);
            this.hasLicenca.getControl().setLayoutData((Object)data);
        }
        this.datum.getControl().setLayoutData((Object)data);
        this.datum2.getControl().setLayoutData((Object)data);
        this.crno.setLayoutData((Object)data);
        data = new GridData(4, 0x1000000, true, true);
        this.total.setLayoutData((Object)data);
        data = new GridData(4, 0x1000000, true, false, 3, 1);
        if (cPrint != null) {
            cPrint.setLayoutData((Object)data);
        }
        data = new GridData(4, 4, true, true, 3, 1);
        this.stavkeTable.setLayoutData((Object)data);
        data = new GridData(4, 0x1000000, true, true, 3, 1);
        this.oznakaDokumenta.setLayoutData((Object)data);
        data = new GridData(4, 0x1000000, true, true, 3, 1);
        data.heightHint = this.opis.getLineHeight() * 2;
        this.opis.setLayoutData((Object)data);
        SWTContainerClass.setDimension(this.shell);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
    }

    private PrintJob pripremaStampe(boolean materijal) {
        PagePrint p;
        String nazivObjekta = this.server.getSetting(Option.OBJEKAT_NAZIV).stringValue();
        String maticniBroj = this.server.getSetting(Option.OBJEKAT_MATICNI_BROJ).stringValue();
        String adresa = this.server.getSetting(Option.OBJEKAT_ADRESA).stringValue();
        String pib = this.server.getSetting(Option.OBJEKAT_PIB_PREFIX).stringValue() + this.server.getSetting(Option.OBJEKAT_PIB).stringValue();
        int orientation = 256;
        switch (this.restoran.getServer().getCurrentCountry()) {
            case BIH: {
                String nazivPredzeca = this.server.getSetting(Option.PREDUZECE_NAZIV).stringValue();
                String adresaPredzeca = this.server.getSetting(Option.PREDUZECE_ADRESA).stringValue();
                String mestoPredzeca = this.server.getSetting(Option.PREDUZECE_MESTO).stringValue();
                String mesto = this.server.getSetting(Option.OBJEKAT_MESTO).stringValue();
                p = new StampaKalkulacijeBA(this.input, this.type, nazivObjekta, maticniBroj, adresa, pib, mesto, nazivPredzeca, adresaPredzeca, mestoPredzeca, "", materijal);
                break;
            }
            case SRBIJA: {
                orientation = 256;
                String obveznik = this.server.getSetting(Option.DOK_OBVEZNIK).stringValue();
                String firmaRadnje = this.server.getSetting(Option.DOK_FIRMA_RADNJE).stringValue();
                String sediste = this.server.getSetting(Option.DOK_SEDISTE).stringValue();
                String sifraPoreskogObveznika = this.server.getSetting(Option.DOK_SIFRA_PORESKOG_OBVEZNIKA).stringValue();
                String logoPath = this.server.getSetting(Option.DOK_LOGO).stringValue();
                String sifraDelatnosti = this.server.getSetting(Option.SIFRA_DELATNOSTI).stringValue();
                Setting fup = this.server.getSetting(Option.U_SISTEMU_PDV);
                boolean firmaUPDV = fup != null && fup.booleanValue();
                EnumMap<StampaKalkulacijeNPC2.DataKey, String> data = new EnumMap<StampaKalkulacijeNPC2.DataKey, String>(StampaKalkulacijeNPC2.DataKey.class);
                data.put(StampaKalkulacijeNPC2.DataKey.FIRMA_RADNJE, firmaRadnje);
                data.put(StampaKalkulacijeNPC2.DataKey.OBVEZNIK, obveznik);
                data.put(StampaKalkulacijeNPC2.DataKey.SEDISTE, sediste);
                data.put(StampaKalkulacijeNPC2.DataKey.SIFRA_DELATNOSTI, sifraDelatnosti);
                data.put(StampaKalkulacijeNPC2.DataKey.SIFRA_PORESKOG_OBVEZNIKA, sifraPoreskogObveznika);
                data.put(StampaKalkulacijeNPC2.DataKey.LOGO_PATH, logoPath);
                data.put(StampaKalkulacijeNPC2.DataKey.PIB, pib);
                p = new StampaKalkulacijeNPC2(this.input, this.type, firmaUPDV, data, this.restoran);
                break;
            }
            default: {
                p = new StampaKalkulacijeNPC(this.input, this.type, nazivObjekta, maticniBroj, adresa, pib);
            }
        }
        PrintJob pj = new PrintJob(this.type.getInterName(), (Print)p);
        pj.setOrientation(orientation);
        return pj;
    }

    private boolean checkDobavljac() {
        if (this.dobavljac != null && this.dobavljac.getSelectionIndex() < 0) {
            Konstante.getPoruka(this.shell, String.format(this.barmasterText.getString("PORUKA_MORATE_IZABRATI_DOBAVLJACA"), new Object[0]));
            return false;
        }
        return true;
    }

    private boolean saveData() {
        if (!this.checkDobavljac()) {
            return false;
        }
        if (this.stavke.size() < 1) {
            Konstante.getPoruka(this.shell, String.format(this.barmasterText.getString("PORUKA_MORATE_UNETI_PODATKE_ZA_BAR_JEDAN_ARTIKAL"), new Object[0]));
            return false;
        }
        try {
            boolean oldBlack = this.crno.getSelection();
            String oldDocument = null;
            Date oldDate = this.datum.getResult();
            Date val = this.valutaPlacanja.getResult();
            LinkedList<PrijemnicaStavka> oldItems = new LinkedList<PrijemnicaStavka>(this.input.getStavke());
            if (this.input.getId() != null) {
                oldBlack = this.input.getCrno();
                String brTreb = this.input.getBrPrijemnice();
                if (this.input.getTip() == null || !brTreb.contains("-" + this.type.getDocMark())) {
                    brTreb = brTreb + " (p)";
                }
                oldDocument = brTreb;
                oldDate = this.input.getDatumPrijemnice();
                val = this.input.getDatumValute() != null ? this.input.getDatumValute() : oldDate;
            }
            Calendar dc = Calendar.getInstance();
            if (this.datum.getResult().after(new Date())) {
                Konstante.getPoruka(this.shell, String.format(this.barmasterText.getString("PORUKA_UNETI_DATUM_NIJE_VALIDAN"), new Object[0]));
                return false;
            }
            boolean upozorenje = false;
            Prijemnica t = this.input;
            if (this.input.getId() == null || this.input.getCrno().booleanValue() != this.crno.getSelection()) {
                String brPrijemnice = this.server.selectNextPrijemnicaNumber(this.crno.getSelection(), this.type, this.datum.getResult());
                t.setBrPrijemnice(brPrijemnice);
            }
            dc.setTime(this.datum.getResult());
            if (this.dobavljaci.size() < 1) {
                MessageDialog.openWarning((Shell)this.shell, (String)String.format(this.barmasterText.getString("TEXT_BARMASTER"), new Object[0]), (String)String.format(this.barmasterText.getString("PORUKA_ODABRANI_TIP_TREBOVANJA_PODRAZUMEVA_ODABIR_DOBAVLJACA"), new Object[0]));
                return false;
            }
            t.setDobavljac(this.getDobavljac());
            t.setDatumPrijemnice(this.datum.getResult());
            t.setDatumUnosa(this.datum2.getResult());
            t.setDatumValute(val);
            t.setUname("");
            if (this.hasap.booleanValue()) {
                t.setOpis(this.opis.getText());
                t.setHacapVreme(this.hasVreme.getResult());
                t.setRegOznaka(this.hasReg.getResult());
                t.setKontrolisao(this.hasKontr.getResult());
            }
            t.setTip(this.type);
            t.setOpis(this.opis.getText());
            t.setOznakaDokumenta(this.oznakaDokumenta.getText());
            t.setCrno(this.crno.getSelection());
            t.setStavke(this.stavke);
            double total = 0.0;
            for (PrijemnicaStavka ts : this.input.getStavke()) {
                ts.setPrijemnica(t);
                total += ts.getVrednostSPDV().doubleValue();
            }
            t.setTotal(total);
            try {
                if (this.input.getId() == null) {
                    this.server.addPrijemnica(t);
                } else {
                    this.server.updatePrijemnica(t);
                    this.input = this.server.updatePrijemnica(t);
                }
                if (upozorenje) {
                    MessageDialog.openInformation((Shell)this.shell, (String)String.format(this.barmasterText.getString("TEXT_BARMASTER"), new Object[0]), (String)String.format(this.barmasterText.getString("TEXT_NEMOGUCE_PRONACI_PRIJEMNICU_VEZANU_ZA_TREBOVANJE"), new Object[0]));
                }
                return true;
            }
            catch (Exception e) {
                Logger.getLogger(UpravljanjePrijemnicom.class.getName()).log(Level.WARNING, e.getMessage(), e);
                MessageDialog.openWarning((Shell)this.shell, (String)String.format(this.barmasterText.getString("TEXT_BARMASTER"), new Object[0]), (String)String.format(this.barmasterText.getString("PORUKA_DOSLO_JE_DO_GRESKE_PRILIKOM_PAMCENJA_DOKUMENTA"), new Object[0]));
            }
        }
        catch (InputException inputException) {
            // empty catch block
        }
        return false;
    }

    private void loadData() {
        if (this.input != null) {
            this.crno.setSelection(this.input.getCrno() != null && this.input.getCrno() != false);
            this.stavke = new LinkedList<PrijemnicaStavka>(this.input.getStavke());
            if (!this.pregled) {
                Collections.sort(this.stavke, this.psComp);
                boolean hasRBNull = false;
                for (PrijemnicaStavka ps : this.stavke) {
                    if (ps.getRedniBroj() == null) {
                        hasRBNull = true;
                        ps.setRedniBroj(Integer.MAX_VALUE);
                    }
                    if (hasRBNull) continue;
                    this.nextRB = ps.getRedniBroj() + 1;
                }
                if (hasRBNull) {
                    Collections.sort(this.stavke, this.psComp);
                    this.nextRB = 1;
                    for (PrijemnicaStavka ps : this.stavke) {
                        ps.setRedniBroj(this.nextRB);
                        ++this.nextRB;
                    }
                }
            } else {
                Collections.sort(this.stavke, this.psComp);
            }
            this.datum.setResult(this.input.getDatumPrijemnice());
            this.datum2.setResult(this.input.getDatumUnosa());
            this.valutaPlacanja.setResult(this.input.getDatumValute());
            this.opis.setText(this.input.getOpis() == null ? "" : this.input.getOpis());
            this.oznakaDokumenta.setText(this.input.getOznakaDokumenta() == null ? "" : this.input.getOznakaDokumenta());
            if (this.hasap.booleanValue()) {
                this.hasVreme.setResult(this.input.getHacapVreme() == null ? "" : this.input.getHacapVreme());
                this.hasReg.setResult(this.input.getRegOznaka() == null ? "" : this.input.getRegOznaka());
                this.hasKontr.setResult(this.input.getKontrolisao() == null ? "" : this.input.getKontrolisao());
            }
            this.updateTotal();
        } else {
            this.input = new Prijemnica();
        }
        this.loadDobavljace();
    }

    private void loadDobavljace() {
        if (this.dobavljac != null) {
            this.dobavljac.removeAll();
            int idxDob = -1;
            for (int i = 0; i < this.dobavljaci.size(); ++i) {
                StalniGost sg = this.dobavljaci.get(i);
                this.dobavljac.add(sg.getSkrNaziv());
                System.out.println("sg = " + sg);
                if (this.input == null || this.input.getDobavljac() == null || this.input.getDobavljac().getId() != sg.getId()) continue;
                idxDob = i;
            }
            if (idxDob >= 0) {
                this.dobavljac.select(idxDob);
            } else if (!this.dobavljaci.isEmpty()) {
                this.dobavljac.select(0);
            }
            this.dobavljac.update();
        }
    }

    private void updateTotal() {
        this.ukupnaVred = 0.0;
        for (PrijemnicaStavka ts : this.stavke) {
            if (ts.getVrednostSPDV() == null) {
                this.ukupnaVred += Math.abs(ts.getVrednost()) * (1.0 + Konstante.getPdvPoPG(ts.getArtikal().getPoreskaGrupa()));
                continue;
            }
            this.ukupnaVred += Math.abs(ts.getVrednostSPDV());
        }
        this.total.setText(StatLogic.getNumber02(this.ukupnaVred));
        this.total.update();
    }

    private void fillInMap(List<Artikal> artikli) {
        HashSet<BObject> set;
        this.mapaGrupa = new HashMap<GrupaArtikala, Set<PodgrupaArtikala>>();
        this.mapaPodgrupa = new HashMap<PodgrupaArtikala, Set<Artikal>>();
        for (Artikal a : artikli) {
            if (this.mapaPodgrupa.containsKey(a.getPodgrupa())) {
                this.mapaPodgrupa.get(a.getPodgrupa()).add(a);
                continue;
            }
            set = new HashSet<BObject>();
            set.add(a);
            this.mapaPodgrupa.put(a.getPodgrupa(), set);
        }
        for (PodgrupaArtikala pg : this.mapaPodgrupa.keySet()) {
            if (this.mapaGrupa.containsKey(pg.getGrupa())) {
                this.mapaGrupa.get(pg.getGrupa()).add(pg);
                continue;
            }
            set = new HashSet();
            set.add(pg);
            this.mapaGrupa.put(pg.getGrupa(), set);
        }
    }

    public void unosStavkePrijemnice(Shell shell, Table table) {
        if (!this.checkDobavljac()) {
            return;
        }
        UnosStavkePrijemnice ust = new UnosStavkePrijemnice(this.type.getTip() != TipTrebovanja.DokumentAtribut.ULAZNI ? null : this.getDobavljac().getPoreskiObveznik(), this.getDobavljac().getPoljoGazdinstvo());
        if (ust.getResult() != null) {
            PrijemnicaStavka ps = ust.getResult();
            if (this.type.getTip() == TipTrebovanja.DokumentAtribut.IZLAZNI) {
                ps.setKolicina(-ps.getKolicina().doubleValue());
                ps.setVrednost(-ps.getVrednost().doubleValue());
            }
            ps.setRedniBroj(this.nextRB);
            ++this.nextRB;
            this.stavke.add(ust.getResult());
            Collections.sort(this.stavke, this.psComp);
            this.stavkeTV.refresh();
            this.stavkeTV.setSelection((ISelection)new StructuredSelection((Object)ust.getResult()), true);
            this.updateTotal();
        }
    }

    private void addArtikal() throws FiscalException, SerialIOException {
        Odeljenje odeljenje = this.magacin;
        Shell shell2 = new Shell(this.shell);
        ArtikalDialog ad = new ArtikalDialog(SWTContainerClass.makeContainer(shell2, String.format(this.barmasterText.getString("TEXT_UNOS_NOVOG_ARTIKLA"), new Object[0])), this.restoran, null, odeljenje, true);
        if (ad.getResult() != null) {
            Artikal a = ad.getResult();
            try {
                a = this.server.addArtikal2JPAMerge(a);
            }
            catch (Exception e) {
                SWTOptionPane.showMessageDialog(SWTComponent.getSWTComponent((Control)this.shell), (Object)"Do\u0161lo je do gre\u0161ke prilikom kreiranja artikla ");
                return;
            }
            for (Odeljenje o : a.getOdeljenja()) {
                if (!o.containsArtikal(a)) {
                    o.getArtikli().add(a);
                }
                try {
                    this.server.updateOdeljenje(o);
                }
                catch (Exception e) {
                    SWTOptionPane.showMessageDialog(SWTComponent.getSWTComponent((Control)this.shell), (Object)"Do\u0161lo je do gre\u0161ke prilikom kreiranja artikla ");
                    return;
                }
            }
            if (ad.getResult2() != null) {
                for (Normativ norm : ad.getResult2()) {
                    norm.setArtikal(a);
                    try {
                        this.server.addNormativJPAPersist(norm);
                    }
                    catch (Exception e) {
                        SWTOptionPane.showMessageDialog(SWTComponent.getSWTComponent((Control)this.shell), (Object)"Do\u0161lo je do gre\u0161ke prilikom kreiranja artikla ");
                        return;
                    }
                }
            }
            odeljenje = this.server.getOdeljenjeJPA(odeljenje.getId());
            this.artikliSvi = this.server.findAllArticlesNoComplexNoBlocked();
            this.fillInMap(this.artikliSvi);
        }
    }

    private StalniGost getDobavljac() {
        if (this.dobavljac != null && this.dobavljaci != null && this.dobavljac.getSelectionIndex() > -1 && this.dobavljac.getSelectionIndex() < this.dobavljaci.size()) {
            return this.dobavljaci.get(this.dobavljac.getSelectionIndex());
        }
        return null;
    }

    private class UnosStavkePrijemnice {
        private PrijemnicaStavka result = null;
        boolean osam;
        private TextInput2 hasTemp;
        private Button hasUsagl;
        private Combo hasMagacini;
        private TextInput2 hasKorekt;
        private List<HacapMagacini> hMagacini;

        public UnosStavkePrijemnice(Boolean dobavljacUPDV, boolean osam) {
            this.osam = osam;
            final Shell shell2 = new Shell(UpravljanjePrijemnicom.this.shell, 34912);
            shell2.setBackgroundMode(1);
            shell2.setText(String.format(UpravljanjePrijemnicom.this.barmasterText.getString("TEXT_NOVA_STAVKA"), new Object[0]));
            shell2.setLayout((Layout)new GridLayout(UpravljanjePrijemnicom.this.hasap != false ? 3 : 2, false));
            Composite c1 = new Composite((Composite)shell2, 0);
            c1.setLayout((Layout)new FillLayout());
            GridData data = new GridData(1040);
            data.widthHint = 250;
            c1.setLayoutData((Object)data);
            Composite c2 = new Composite((Composite)shell2, 0);
            c2.setLayout((Layout)new GridLayout(2, false));
            data.widthHint = 360;
            c2.setLayoutData((Object)data);
            Composite c3 = null;
            if (UpravljanjePrijemnicom.this.hasap.booleanValue()) {
                c3 = new Composite((Composite)shell2, 2048);
                c3.setLayout((Layout)new GridLayout(1, false));
                data = new GridData(1040);
                data.widthHint = 180;
                c3.setLayoutData((Object)data);
                this.hMagacini = new ArrayList<HacapMagacini>();
                this.hMagacini = UpravljanjePrijemnicom.this.server.readHacapMagacine();
            }
            final Tree tree = new Tree(c1, 2562);
            tree.setFont(Konstante.getFont(UpravljanjePrijemnicom.this.shell.getDisplay(), 8, 0));
            for (GrupaArtikala ga : UpravljanjePrijemnicom.this.mapaGrupa.keySet()) {
                TreeItem item0 = new TreeItem(tree, 0);
                item0.setText(ga.getNaziv());
                for (PodgrupaArtikala pa : (Set)UpravljanjePrijemnicom.this.mapaGrupa.get(ga)) {
                    TreeItem item1 = new TreeItem(item0, 0);
                    item1.setText(pa.getNaziv());
                    for (Object a2 : (Set)UpravljanjePrijemnicom.this.mapaPodgrupa.get(pa)) {
                        TreeItem item2 = new TreeItem(item1, 0);
                        item2.setText(((Artikal)a2).getName());
                    }
                }
            }
            tree.setBounds(0, 0, 100, 100);
            tree.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    String string = "";
                    int index = -1;
                    TreeItem[] selection = tree.getSelection();
                    for (int i = 0; i < selection.length; ++i) {
                        string = string + selection[i].getText();
                        if (selection[i].getItems().length != 0) continue;
                        UpravljanjePrijemnicom.this.pretraga.setText("");
                        UpravljanjePrijemnicom.this.artikal.removeAll();
                        UpravljanjePrijemnicom.this.artikliC.clear();
                        for (Set set : UpravljanjePrijemnicom.this.mapaPodgrupa.values()) {
                            for (Artikal a : set) {
                                UpravljanjePrijemnicom.this.artikal.add(a.getName());
                                UpravljanjePrijemnicom.this.artikliC.put(a.getName(), a);
                                if (!a.getName().equalsIgnoreCase(string)) continue;
                                index = UpravljanjePrijemnicom.this.artikal.getItemCount() - 1;
                            }
                        }
                        break;
                    }
                    if (index > -1) {
                        UpravljanjePrijemnicom.this.artikal.select(index);
                        UpravljanjePrijemnicom.this.artikalI = (Artikal)UpravljanjePrijemnicom.this.artikliC.get(UpravljanjePrijemnicom.this.artikal.getItem(UpravljanjePrijemnicom.this.artikal.getSelectionIndex()));
                        UnosStavkePrijemnice.this.insertDataArtikal();
                    }
                }
            });
            final SWTContainer parent2 = new SWTContainer(c2);
            Font font = FontCache.getFont(UpravljanjePrijemnicom.this.fontName, 7, 0);
            Label pk2 = new Label(c2, 0);
            pk2.setText(String.format(UpravljanjePrijemnicom.this.barmasterText.getString("TEXT_STANJE"), new Object[0]) + " (" + UpravljanjePrijemnicom.this.magacin.getNaziv() + ")");
            UpravljanjePrijemnicom.this.preostalaKol2 = new Label(c2, 0);
            UpravljanjePrijemnicom.this.preostalaKol2.setText("");
            pk2.setFont(font);
            UpravljanjePrijemnicom.this.preostalaKol2.setFont(font);
            Label p = new Label(c2, 0);
            p.setText(String.format(UpravljanjePrijemnicom.this.barmasterText.getString("TEXT_PRETRAGA"), new Object[0]) + ":");
            p.setFont(font);
            UpravljanjePrijemnicom.this.pretraga = new Text(c2, 2048);
            UpravljanjePrijemnicom.this.pretraga.addListener(2, new Listener(){

                public void handleEvent(Event e) {
                    if (e.keyCode != 13 && e.keyCode != 0x1000050) {
                        return;
                    }
                    String str = UpravljanjePrijemnicom.this.pretraga.getText();
                    UpravljanjePrijemnicom.this.artikal.removeAll();
                    UpravljanjePrijemnicom.this.artikliC.clear();
                    for (Set set : UpravljanjePrijemnicom.this.mapaPodgrupa.values()) {
                        for (Artikal a : set) {
                            if ((a.getName() == null || !a.getName().toLowerCase().contains(str.toLowerCase())) && (a.getBarCode() == null || !a.getBarCode().toLowerCase().contains(str.toLowerCase()))) continue;
                            UpravljanjePrijemnicom.this.artikal.add(a.getName());
                            UpravljanjePrijemnicom.this.artikliC.put(a.getName(), a);
                        }
                    }
                    if (UpravljanjePrijemnicom.this.artikal.getItemCount() > 0) {
                        UpravljanjePrijemnicom.this.artikal.select(0);
                        UpravljanjePrijemnicom.this.artikalI = (Artikal)UpravljanjePrijemnicom.this.artikliC.get(UpravljanjePrijemnicom.this.artikal.getItem(UpravljanjePrijemnicom.this.artikal.getSelectionIndex()));
                        UnosStavkePrijemnice.this.insertDataArtikal();
                    }
                }
            });
            Label a = new Label(c2, 0);
            a.setText(String.format(UpravljanjePrijemnicom.this.barmasterText.getString("TEXT_ARTIKAL"), new Object[0]) + ":");
            a.setFont(font);
            UpravljanjePrijemnicom.this.artikal = new Combo(c2, 2572);
            for (Object set : UpravljanjePrijemnicom.this.mapaPodgrupa.values()) {
                Object a2;
                a2 = set.iterator();
                while (a2.hasNext()) {
                    Artikal art = (Artikal)a2.next();
                    UpravljanjePrijemnicom.this.artikal.add(art.getName());
                    UpravljanjePrijemnicom.this.artikliC.put(art.getName(), art);
                }
            }
            if (UpravljanjePrijemnicom.this.artikal.getItemCount() > 0) {
                UpravljanjePrijemnicom.this.artikal.select(0);
            }
            UpravljanjePrijemnicom.this.artikal.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    UpravljanjePrijemnicom.this.artikalI = (Artikal)UpravljanjePrijemnicom.this.artikliC.get(UpravljanjePrijemnicom.this.artikal.getItem(UpravljanjePrijemnicom.this.artikal.getSelectionIndex()));
                    UnosStavkePrijemnice.this.insertDataArtikal();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    UpravljanjePrijemnicom.this.artikalI = (Artikal)UpravljanjePrijemnicom.this.artikliC.get(UpravljanjePrijemnicom.this.artikal.getItem(UpravljanjePrijemnicom.this.artikal.getSelectionIndex()));
                    UnosStavkePrijemnice.this.insertDataArtikal();
                }
            });
            UpravljanjePrijemnicom.this.kolicinaLabel = new Label(c2, 0);
            UpravljanjePrijemnicom.this.kolicinaLabel.setText(String.format(UpravljanjePrijemnicom.this.barmasterText.getString("TEXT_KOLICINA"), new Object[0]) + ":");
            UpravljanjePrijemnicom.this.kolicinaLabel.setFont(font);
            Label pd = new Label(c2, 0);
            pd.setText(String.format(UpravljanjePrijemnicom.this.barmasterText.getString("TEXT_PORESKA_STOPA"), new Object[0]) + ":");
            pd.setFont(font);
            UpravljanjePrijemnicom.this.kolicina = new DoubleInput2(parent2, String.format(UpravljanjePrijemnicom.this.barmasterText.getString("TEXT_KOLICINA"), new Object[0]), false);
            UpravljanjePrijemnicom.this.kolicina.getControl().addListener(2, new Listener(){

                public void handleEvent(Event e) {
                    UnosStavkePrijemnice.this.insertDataKolicina();
                }
            });
            UpravljanjePrijemnicom.this.pdvC = new Combo(c2, 2572);
            if (!osam && dobavljacUPDV != null && !dobavljacUPDV.booleanValue()) {
                UpravljanjePrijemnicom.this.pdvC.add(PoreskeStope.getDefaultNonVatStopa().getStopa() + "%");
                UpravljanjePrijemnicom.this.pdvC.setEnabled(false);
            } else if (osam) {
                UpravljanjePrijemnicom.this.pdvC.add("8%");
                UpravljanjePrijemnicom.this.pdvC.setEnabled(false);
            } else {
                for (ObjectWrapper s : UpravljanjePrijemnicom.this.restoran.getStope()) {
                    UpravljanjePrijemnicom.this.pdvC.add(s.getPercent() + "%");
                }
            }
            UpravljanjePrijemnicom.this.pdvC.select(0);
            UpravljanjePrijemnicom.this.pdvC.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    UnosStavkePrijemnice.this.insertDataPDV();
                }
            });
            Label ck = new Label(c2, 0);
            ck.setText(String.format(UpravljanjePrijemnicom.this.barmasterText.getString("TEXT_CENA_BEZ_PDVA"), new Object[0]) + ":");
            ck.setFont(font);
            Label ck2 = new Label(c2, 0);
            ck2.setText(String.format(UpravljanjePrijemnicom.this.barmasterText.getString("TEXT_CENA_SA_PDVOM"), new Object[0]) + ":");
            ck2.setFont(font);
            UpravljanjePrijemnicom.this.cenaKomad = new DoubleInput2(parent2, String.format(UpravljanjePrijemnicom.this.barmasterText.getString("TEXT_CENA_BEZ_PDVA"), new Object[0]), false);
            UpravljanjePrijemnicom.this.cenaKomad.getControl().addListener(2, new Listener(){

                public void handleEvent(Event e) {
                    UnosStavkePrijemnice.this.insertDataCena1();
                }
            });
            UpravljanjePrijemnicom.this.cenaKomad2 = new DoubleInput2(parent2, String.format(UpravljanjePrijemnicom.this.barmasterText.getString("TEXT_CENA_SA_PDVOM"), new Object[0]), false);
            UpravljanjePrijemnicom.this.cenaKomad2.getControl().addListener(2, new Listener(){

                public void handleEvent(Event e) {
                    UnosStavkePrijemnice.this.insertDataCena2();
                }
            });
            Label rab = new Label(c2, 0);
            rab.setText(String.format(UpravljanjePrijemnicom.this.barmasterText.getString("TEXT_RABAT"), new Object[0]) + ":");
            rab.setFont(font);
            Label csr = new Label(c2, 0);
            csr.setText(String.format(UpravljanjePrijemnicom.this.barmasterText.getString("TEXT_CENA_SA_RABATOM"), new Object[0]) + ":");
            csr.setFont(font);
            UpravljanjePrijemnicom.this.rabat = new DoubleInput2(parent2, String.format(UpravljanjePrijemnicom.this.barmasterText.getString("TEXT_RABAT"), new Object[0]), (Double)0.0);
            UpravljanjePrijemnicom.this.rabat.getControl().addListener(2, new Listener(){

                public void handleEvent(Event e) {
                    Pattern p = Pattern.compile("[0-9\\.\b\\s]{1,1}");
                    if (!p.matcher("" + e.character).matches()) {
                        return;
                    }
                    UnosStavkePrijemnice.this.insertDataCena1();
                }
            });
            UpravljanjePrijemnicom.this.cenarabat = new DoubleInput2(parent2, String.format(UpravljanjePrijemnicom.this.barmasterText.getString("TEXT_CENA_SA_RABATOM"), new Object[0]), (Double)0.0);
            UpravljanjePrijemnicom.this.cenarabat.getControl().addListener(2, new Listener(){

                public void handleEvent(Event e) {
                    Pattern p = Pattern.compile("[0-9\\.\b\\s]{1,1}");
                    if (!p.matcher("" + e.character).matches()) {
                        return;
                    }
                    UnosStavkePrijemnice.this.insertDataCena1();
                }
            });
            Label nv = new Label(c2, 0);
            nv.setText(String.format(UpravljanjePrijemnicom.this.barmasterText.getString("TEXT_UKUPNO_BEZ_PDVA"), new Object[0]) + ":");
            nv.setFont(font);
            Label nv2 = new Label(c2, 0);
            nv2.setText(String.format(UpravljanjePrijemnicom.this.barmasterText.getString("TEXT_UKUPNO_SA_PDVOM"), new Object[0]) + ":");
            nv2.setFont(font);
            UpravljanjePrijemnicom.this.nabVrednost = new DoubleInput2(parent2, String.format(UpravljanjePrijemnicom.this.barmasterText.getString("TEXT_UKUPNO_BEZ_PDVA"), new Object[0]), false);
            UpravljanjePrijemnicom.this.nabVrednost.getControl().setForeground(shell2.getDisplay().getSystemColor(3));
            UpravljanjePrijemnicom.this.nabVrednost.getControl().setFont(Konstante.getFont(shell2.getDisplay(), 12, 1));
            UpravljanjePrijemnicom.this.nabVrednost.getControl().addListener(2, new Listener(){

                public void handleEvent(Event e) {
                    UnosStavkePrijemnice.this.insertDataSuma1();
                }
            });
            UpravljanjePrijemnicom.this.nabVrednost2 = new DoubleInput2(parent2, String.format(UpravljanjePrijemnicom.this.barmasterText.getString("TEXT_UKUPNO_SA_PDVOM"), new Object[0]), false);
            UpravljanjePrijemnicom.this.nabVrednost2.getControl().setForeground(shell2.getDisplay().getSystemColor(3));
            UpravljanjePrijemnicom.this.nabVrednost2.getControl().setFont(Konstante.getFont(shell2.getDisplay(), 12, 1));
            UpravljanjePrijemnicom.this.nabVrednost2.getControl().addListener(2, new Listener(){

                public void handleEvent(Event e) {
                    UnosStavkePrijemnice.this.insertDataSuma2();
                }
            });
            Label nca = new Label(c2, 0);
            nca.setText(String.format(UpravljanjePrijemnicom.this.barmasterText.getString("TEXT_PRODAJNA_CENA"), new Object[0]) + ":");
            nca.setFont(font);
            Label nma = new Label(c2, 0);
            nma.setText(String.format(UpravljanjePrijemnicom.this.barmasterText.getString("TEXT_MARZA"), new Object[0]) + ":");
            nma.setFont(font);
            UpravljanjePrijemnicom.this.prodCena = new DoubleInput2(parent2, String.format(UpravljanjePrijemnicom.this.barmasterText.getString("TEXT_PRODAJNA_CENA"), new Object[0]), false);
            UpravljanjePrijemnicom.this.prodCena.getControl().setForeground(shell2.getDisplay().getSystemColor(3));
            UpravljanjePrijemnicom.this.prodCena.getControl().setFont(Konstante.getFont(shell2.getDisplay(), 12, 1));
            UpravljanjePrijemnicom.this.prodCena.getControl().addListener(2, new Listener(){

                public void handleEvent(Event e) {
                    UnosStavkePrijemnice.this.insertPrice();
                }
            });
            UpravljanjePrijemnicom.this.marza = new DoubleInput2(parent2, String.format(UpravljanjePrijemnicom.this.barmasterText.getString("TEXT_MARZA"), new Object[0]), false);
            UpravljanjePrijemnicom.this.marza.getControl().setForeground(shell2.getDisplay().getSystemColor(3));
            UpravljanjePrijemnicom.this.marza.getControl().setFont(Konstante.getFont(shell2.getDisplay(), 12, 1));
            UpravljanjePrijemnicom.this.marza.getControl().addListener(2, new Listener(){

                public void handleEvent(Event e) {
                    UnosStavkePrijemnice.this.insertMargin();
                }
            });
            if (UpravljanjePrijemnicom.this.hasap.booleanValue()) {
                SWTContainer parent3 = new SWTContainer(c3);
                data = new GridData();
                data.widthHint = 130;
                data.heightHint = 20;
                data.horizontalAlignment = 16384;
                data.verticalIndent = 10;
                Label lTemp = new Label(c3, 0);
                lTemp.setText(UpravljanjePrijemnicom.this.barmasterText.getString("TEXT_TEMPERATURA_NA_PRIJEMU") + ":");
                lTemp.setLayoutData((Object)data);
                this.hasTemp = new TextInput2(parent3, UpravljanjePrijemnicom.this.barmasterText.getString("TEXT_TEMPERATURA_NA_PRIJEMU"));
                Label laznjak = new Label(c3, 0);
                laznjak.setLayoutData((Object)data);
                laznjak.setVisible(false);
                Label lUsagl = new Label(c3, 0);
                lUsagl.setText(UpravljanjePrijemnicom.this.barmasterText.getString("TEXT_USAGLASENO") + ":");
                lUsagl.setLayoutData((Object)data);
                this.hasUsagl = new Button(parent3.getComposite(), 32);
                this.hasUsagl.setSelection(true);
                Label lMag = new Label(c3, 0);
                lMag.setText(UpravljanjePrijemnicom.this.barmasterText.getString("TEXT_IZBOR_MAGACINA") + ":");
                lMag.setLayoutData((Object)data);
                this.hasMagacini = new Combo(parent3.getComposite(), 4);
                for (HacapMagacini hm : this.hMagacini) {
                    this.hasMagacini.add(hm.getNaziv());
                }
                this.hasMagacini.select(0);
                Label lKor = new Label(c3, 0);
                lKor.setText(UpravljanjePrijemnicom.this.barmasterText.getString("TEXT_KOREKTIVNA_MERA") + ":");
                lKor.setLayoutData((Object)data);
                this.hasKorekt = new TextInput2(parent3, UpravljanjePrijemnicom.this.barmasterText.getString("TEXT_KOREKTIVNA_MERA"));
            }
            Button cancelButt = Dugmici.getCancelButton(c2);
            cancelButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    parent2.getControl().getShell().close();
                }
            });
            Button okButt = Dugmici.getOkButton(c2);
            okButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    try {
                        Artikal art = (Artikal)UpravljanjePrijemnicom.this.artikliC.get(UpravljanjePrijemnicom.this.artikal.getItem(UpravljanjePrijemnicom.this.artikal.getSelectionIndex()));
                        PrijemnicaStavka ts = new PrijemnicaStavka();
                        if (art.getCena() != UpravljanjePrijemnicom.this.prodCena.getResult()) {
                            art.setCena(UpravljanjePrijemnicom.this.prodCena.getResult());
                            art = UpravljanjePrijemnicom.this.server.updateArtikal(art);
                            UpravljanjePrijemnicom.this.server.log("Azuriranje artikla, Artikal: " + art.getName() + ", kreirao/azurirao: " + UpravljanjePrijemnicom.this.server.getUser().getName());
                        }
                        ts.setArtikal(art);
                        ts.setKolicina(UpravljanjePrijemnicom.this.kolicina.getResult());
                        ts.setVrednost(UpravljanjePrijemnicom.this.nabVrednost.getResult());
                        ts.setVrednostSPDV(UpravljanjePrijemnicom.this.nabVrednost2.getResult());
                        ts.setPdvStopa(UnosStavkePrijemnice.this.getStopa());
                        ts.setKomad(UpravljanjePrijemnicom.this.cenaKomad.getResult());
                        ts.setRabat(UpravljanjePrijemnicom.this.rabat.getResult());
                        ts.setKomBPDVsaRbt(UpravljanjePrijemnicom.this.cenarabat.getResult());
                        if (UpravljanjePrijemnicom.this.hasap.booleanValue()) {
                            if (UnosStavkePrijemnice.this.hasMagacini.getSelectionIndex() < 0) {
                                Konstante.getPoruka(shell2, "Niste uneli ni jedan HACCP magacin!");
                                return;
                            }
                            ts.setHacapTemp(UnosStavkePrijemnice.this.hasTemp.getResult());
                            ts.setUsaglaseno(UnosStavkePrijemnice.this.hasUsagl.getSelection());
                            ts.setHacapMagacin((HacapMagacini)UnosStavkePrijemnice.this.hMagacini.get(UnosStavkePrijemnice.this.hasMagacini.getSelectionIndex()));
                            ts.setKorektivnaMera(UnosStavkePrijemnice.this.hasKorekt.getResult());
                        }
                        UnosStavkePrijemnice.this.result = ts;
                        shell2.close();
                    }
                    catch (InputException ex) {
                        Konstante.getPoruka(shell2, ex.getMessage());
                    }
                }
            });
            GridLayout layout = new GridLayout(UpravljanjePrijemnicom.this.hasap != false ? 3 : 2, false);
            layout.marginHeight = 10;
            layout.marginWidth = 10;
            layout.verticalSpacing = 10;
            layout.horizontalSpacing = 10;
            shell2.setLayout((Layout)layout);
            data = new GridData();
            data.widthHint = 120;
            data.heightHint = 20;
            data.horizontalAlignment = 16384;
            data.verticalIndent = 10;
            pk2.setLayoutData((Object)data);
            a.setLayoutData((Object)data);
            UpravljanjePrijemnicom.this.kolicinaLabel.setLayoutData((Object)data);
            rab.setLayoutData((Object)data);
            csr.setLayoutData((Object)data);
            nv.setLayoutData((Object)data);
            nca.setLayoutData((Object)data);
            nma.setLayoutData((Object)data);
            nv2.setLayoutData((Object)data);
            ck.setLayoutData((Object)data);
            ck2.setLayoutData((Object)data);
            p.setLayoutData((Object)data);
            pd.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 120;
            data.heightHint = 25;
            data.horizontalAlignment = 16384;
            data.verticalIndent = 0;
            UpravljanjePrijemnicom.this.kolicina.getControl().setLayoutData((Object)data);
            UpravljanjePrijemnicom.this.pretraga.setLayoutData((Object)data);
            UpravljanjePrijemnicom.this.nabVrednost.getControl().setLayoutData((Object)data);
            UpravljanjePrijemnicom.this.nabVrednost2.getControl().setLayoutData((Object)data);
            UpravljanjePrijemnicom.this.rabat.getControl().setLayoutData((Object)data);
            UpravljanjePrijemnicom.this.cenarabat.getControl().setLayoutData((Object)data);
            UpravljanjePrijemnicom.this.prodCena.getControl().setLayoutData((Object)data);
            UpravljanjePrijemnicom.this.marza.getControl().setLayoutData((Object)data);
            UpravljanjePrijemnicom.this.cenaKomad.getControl().setLayoutData((Object)data);
            UpravljanjePrijemnicom.this.cenaKomad2.getControl().setLayoutData((Object)data);
            UpravljanjePrijemnicom.this.artikal.setLayoutData((Object)data);
            UpravljanjePrijemnicom.this.preostalaKol2.setLayoutData((Object)data);
            UpravljanjePrijemnicom.this.pdvC.setLayoutData((Object)data);
            data.widthHint = 130;
            if (UpravljanjePrijemnicom.this.hasap.booleanValue()) {
                this.hasTemp.getControl().setLayoutData((Object)data);
            }
            if (UpravljanjePrijemnicom.this.hasap.booleanValue()) {
                this.hasUsagl.setLayoutData((Object)data);
            }
            if (UpravljanjePrijemnicom.this.hasap.booleanValue()) {
                this.hasMagacini.setLayoutData((Object)data);
            }
            if (UpravljanjePrijemnicom.this.hasap.booleanValue()) {
                this.hasKorekt.getControl().setLayoutData((Object)data);
            }
            data = new GridData();
            data.widthHint = 150;
            data.horizontalAlignment = 131072;
            okButt.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 150;
            data.horizontalAlignment = 16384;
            cancelButt.setLayoutData((Object)data);
            shell2.pack();
            UpravljanjePrijemnicom.this.pretraga.forceFocus();
            shell2.open();
            while (!shell2.isDisposed()) {
                if (shell2.getDisplay().readAndDispatch()) continue;
                shell2.getDisplay().sleep();
            }
        }

        public PrijemnicaStavka getResult() {
            return this.result;
        }

        public void insertDataArtikal() {
            try {
                Map<String, Double> nabavneCene = UpravljanjePrijemnicom.this.crno.getSelection() ? NabavneCene.getPosednjaNabavna(UpravljanjePrijemnicom.this.artikalI, new Date(), UpravljanjePrijemnicom.this.magacin, UpravljanjePrijemnicom.this.crno.getSelection(), 1, -1, UpravljanjePrijemnicom.this.server) : NabavneCene.getPosednjaNabavna(UpravljanjePrijemnicom.this.artikalI, new Date(), UpravljanjePrijemnicom.this.magacin, UpravljanjePrijemnicom.this.crno.getSelection(), 0, -1, UpravljanjePrijemnicom.this.server);
                double cenaBPDV = Konstante.round(nabavneCene.get("NCpoJMbezPDV"), 4);
                double cena = Konstante.round(nabavneCene.get("NCpoJMsaPDV"), 4);
                UpravljanjePrijemnicom.this.kolicinaLabel.setText(String.format(UpravljanjePrijemnicom.this.barmasterText.getString("TEXT_KOLICINA"), new Object[0]) + "( " + UpravljanjePrijemnicom.this.artikalI.getJedinicaMere() + " ):");
                UpravljanjePrijemnicom.this.vrednostStope = this.osam ? 0 : StavkeSumarno.getVrednostStope(UpravljanjePrijemnicom.this.artikalI.getPoreskaGrupa(), UpravljanjePrijemnicom.this.restoran);
                UpravljanjePrijemnicom.this.pdvC.select(UpravljanjePrijemnicom.this.pdvC.indexOf(UpravljanjePrijemnicom.this.vrednostStope + "%"));
                UpravljanjePrijemnicom.this.cenaKomad.setResult(cenaBPDV);
                UpravljanjePrijemnicom.this.cenaKomad2.setResult(cena);
                double preostalaKol = 0.0;
                preostalaKol = UpravljanjePrijemnicom.this.server.getLagerZaArtikal(UpravljanjePrijemnicom.this.artikalI, UpravljanjePrijemnicom.this.crno.getSelection(), UpravljanjePrijemnicom.this.magacin, UpravljanjePrijemnicom.this.datum.getResult());
                UpravljanjePrijemnicom.this.prodCena.setResult(Konstante.decimals2(UpravljanjePrijemnicom.this.artikalI.getCena()));
                UpravljanjePrijemnicom.this.marza.setResult(Konstante.decimals2((UpravljanjePrijemnicom.this.prodCena.getResult() / ((100.0 + this.getStopa()) / 100.0) / UpravljanjePrijemnicom.this.cenaKomad.getResult() - 1.0) * 100.0));
                UpravljanjePrijemnicom.this.preostalaKol2.setText(Konstante.getNumber4(preostalaKol));
                UpravljanjePrijemnicom.this.nabVrednost.setResult(Konstante.decimals2(UpravljanjePrijemnicom.this.kolicina.getResult() * UpravljanjePrijemnicom.this.cenaKomad.getResult()));
                UpravljanjePrijemnicom.this.nabVrednost2.setResult(Konstante.decimals2(UpravljanjePrijemnicom.this.kolicina.getResult() * UpravljanjePrijemnicom.this.cenaKomad2.getResult()));
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
        }

        public void insertDataKolicina() {
            try {
                UpravljanjePrijemnicom.this.nabVrednost.setResult(Konstante.decimals2(UpravljanjePrijemnicom.this.kolicina.getResult() * UpravljanjePrijemnicom.this.cenaKomad.getResult()));
                UpravljanjePrijemnicom.this.nabVrednost2.setResult(Konstante.decimals2(UpravljanjePrijemnicom.this.kolicina.getResult() * UpravljanjePrijemnicom.this.cenaKomad2.getResult()));
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
        }

        public void insertDataSuma1() {
            try {
                UpravljanjePrijemnicom.this.cenaKomad.setResult(Konstante.decimals2(UpravljanjePrijemnicom.this.nabVrednost.getResult() / UpravljanjePrijemnicom.this.kolicina.getResult()));
                UpravljanjePrijemnicom.this.cenaKomad2.setResult(Konstante.decimals2(UpravljanjePrijemnicom.this.cenaKomad.getResult() + UpravljanjePrijemnicom.this.cenaKomad.getResult() * this.getStopa() / 100.0));
                UpravljanjePrijemnicom.this.nabVrednost2.setResult(Konstante.decimals2(UpravljanjePrijemnicom.this.kolicina.getResult() * UpravljanjePrijemnicom.this.cenaKomad2.getResult()));
                UpravljanjePrijemnicom.this.marza.setResult(Konstante.decimals2((UpravljanjePrijemnicom.this.prodCena.getResult() / ((100.0 + this.getStopa()) / 100.0) / UpravljanjePrijemnicom.this.cenaKomad.getResult() - 1.0) * 100.0));
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
        }

        public void insertDataSuma2() {
            try {
                UpravljanjePrijemnicom.this.cenaKomad2.setResult(Konstante.decimals2(UpravljanjePrijemnicom.this.nabVrednost2.getResult() / UpravljanjePrijemnicom.this.kolicina.getResult()));
                UpravljanjePrijemnicom.this.cenaKomad.setResult(100.0 * UpravljanjePrijemnicom.this.cenaKomad2.getResult() / (100.0 + this.getStopa()));
                UpravljanjePrijemnicom.this.nabVrednost.setResult(UpravljanjePrijemnicom.this.kolicina.getResult() * UpravljanjePrijemnicom.this.cenaKomad.getResult());
                UpravljanjePrijemnicom.this.marza.setResult(Konstante.decimals2((UpravljanjePrijemnicom.this.prodCena.getResult() / ((100.0 + this.getStopa()) / 100.0) / UpravljanjePrijemnicom.this.cenaKomad.getResult() - 1.0) * 100.0));
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
        }

        public void insertDataPDV() {
            try {
                UpravljanjePrijemnicom.this.cenaKomad2.setResult(Konstante.decimals2(UpravljanjePrijemnicom.this.cenaKomad.getResult() * (1.0 + this.getStopa() / 100.0)));
                UpravljanjePrijemnicom.this.nabVrednost.setResult(Konstante.decimals2(UpravljanjePrijemnicom.this.kolicina.getResult() * UpravljanjePrijemnicom.this.cenaKomad.getResult()));
                UpravljanjePrijemnicom.this.nabVrednost2.setResult(Konstante.decimals2(UpravljanjePrijemnicom.this.kolicina.getResult() * UpravljanjePrijemnicom.this.cenaKomad2.getResult()));
                UpravljanjePrijemnicom.this.marza.setResult(Konstante.decimals2((UpravljanjePrijemnicom.this.prodCena.getResult() / ((100.0 + this.getStopa()) / 100.0) / UpravljanjePrijemnicom.this.cenaKomad.getResult() - 1.0) * 100.0));
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
        }

        public void insertDataCena1() {
            try {
                UpravljanjePrijemnicom.this.cenaKomad2.setResult(Konstante.decimals2(UpravljanjePrijemnicom.this.cenaKomad.getResult() * (1.0 + this.getStopa() / 100.0)));
                if (UpravljanjePrijemnicom.this.rabat.getResult() != 0.0) {
                    UpravljanjePrijemnicom.this.cenarabat.setResult(UpravljanjePrijemnicom.this.cenaKomad.getResult() - UpravljanjePrijemnicom.this.cenaKomad.getResult() * UpravljanjePrijemnicom.this.rabat.getResult() / 100.0);
                } else {
                    UpravljanjePrijemnicom.this.cenarabat.setResult(UpravljanjePrijemnicom.this.cenaKomad.getResult());
                }
                UpravljanjePrijemnicom.this.nabVrednost.setResult(Konstante.decimals2(UpravljanjePrijemnicom.this.kolicina.getResult() * UpravljanjePrijemnicom.this.cenarabat.getResult()));
                UpravljanjePrijemnicom.this.nabVrednost2.setResult(Konstante.decimals2(UpravljanjePrijemnicom.this.kolicina.getResult() * UpravljanjePrijemnicom.this.cenarabat.getResult() * (1.0 + this.getStopa() / 100.0)));
                UpravljanjePrijemnicom.this.marza.setResult(Konstante.decimals2((UpravljanjePrijemnicom.this.prodCena.getResult() / ((100.0 + this.getStopa()) / 100.0) / UpravljanjePrijemnicom.this.cenaKomad.getResult() - 1.0) * 100.0));
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
        }

        public void insertMargin() {
            try {
                UpravljanjePrijemnicom.this.prodCena.setResult(UpravljanjePrijemnicom.this.cenaKomad.getResult() * ((100.0 + UpravljanjePrijemnicom.this.marza.getResult()) / 100.0) * ((100.0 + this.getStopa()) / 100.0));
            }
            catch (InputException ex) {
                ex.printStackTrace(System.out);
            }
        }

        public void insertPrice() {
            try {
                UpravljanjePrijemnicom.this.marza.setResult(Konstante.decimals2((UpravljanjePrijemnicom.this.prodCena.getResult() / ((100.0 + this.getStopa()) / 100.0) / UpravljanjePrijemnicom.this.cenaKomad.getResult() - 1.0) * 100.0));
            }
            catch (InputException ex) {
                ex.printStackTrace(System.out);
            }
        }

        public void insertDataCena2() {
            try {
                UpravljanjePrijemnicom.this.cenaKomad.setResult(Konstante.decimals2(100.0 * UpravljanjePrijemnicom.this.cenaKomad2.getResult() / (100.0 + this.getStopa())));
                UpravljanjePrijemnicom.this.nabVrednost.setResult(Konstante.decimals2(UpravljanjePrijemnicom.this.kolicina.getResult() * UpravljanjePrijemnicom.this.cenaKomad.getResult()));
                UpravljanjePrijemnicom.this.nabVrednost2.setResult(Konstante.decimals2(UpravljanjePrijemnicom.this.kolicina.getResult() * UpravljanjePrijemnicom.this.cenaKomad2.getResult()));
                UpravljanjePrijemnicom.this.marza.setResult(Konstante.decimals2((1.0 - 100.0 * UpravljanjePrijemnicom.this.prodCena.getResult() / (100.0 + this.getStopa()) / UpravljanjePrijemnicom.this.cenaKomad.getResult()) * 100.0));
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
        }

        public double getStopa() {
            String s = UpravljanjePrijemnicom.this.pdvC.getItem(UpravljanjePrijemnicom.this.pdvC.getSelectionIndex());
            s = s.substring(0, s.length() - 1);
            return Double.valueOf(s);
        }
    }
}

