/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.sistem;

import com.dev63.fiscal.fp550.PoreskaGrupa;
import com.dev63.restoran.Dugmici;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.constants.StatLogic;
import com.dev63.restoran.sistem.PoreskaStopa;
import com.dev63.restoran.sistem.PoreskeStope;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class UpravljanjePoreskimStopama {
    private final ResourceBundle barmasterText = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale());
    private Shell shell;

    public UpravljanjePoreskimStopama(Shell parent) {
        this.shell = new Shell(parent, 34912);
        this.shell.setText(String.format(this.barmasterText.getString("TEXT_PORESKE_STOPE"), new Object[0]));
        GridLayout gl = new GridLayout(10, false);
        gl.marginWidth = 20;
        gl.marginHeight = 20;
        this.shell.setLayout((Layout)gl);
        PoreskaGrupa[] pga = PoreskaGrupa.values();
        final Button[] usedA = new Button[pga.length];
        final Button[] defaultNonVatA = new Button[pga.length];
        final Button[] defaultA = new Button[pga.length];
        final Text[] markA = new Text[pga.length];
        final Text[] nameA = new Text[pga.length];
        final Text[] percentA = new Text[pga.length];
        for (int i = 0; i < PoreskaGrupa.values().length; ++i) {
            GridData gd;
            PoreskaGrupa pg = PoreskaGrupa.values()[i];
            PoreskaStopa ps = PoreskeStope.getPoreskaStopa(pg);
            if (i == 0) {
                Label lInfo = new Label((Composite)this.shell, 0x1000000);
                lInfo.setText(String.format(this.barmasterText.getString("TEXT_EKRAN_ZA_UPRAVLJANJE_PORESKIM_STOPAMA"), new Object[0]) + "\n\n\n");
                lInfo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, gl.numColumns, 1));
                Label lSep = new Label((Composite)this.shell, 258);
                gd = new GridData(4, 0x1000000, true, false, gl.numColumns, 1);
                gd.heightHint = 8;
                lSep.setLayoutData((Object)gd);
                Label lWarning = new Label((Composite)this.shell, 16384);
                lWarning.setText(String.format(this.barmasterText.getString("TEXT_PRVA_STOPA_JE_PODRAZUMEVANA_UKOLIKO_JE_OBJEKAT_VAN_PDVA"), new Object[0]) + "\n\n");
                lWarning.setLayoutData((Object)new GridData(4, 0x1000000, true, false, gl.numColumns, 1));
                lSep = new Label((Composite)this.shell, 258);
                gd = new GridData(4, 0x1000000, true, false, gl.numColumns, 1);
                gd.heightHint = 8;
                lSep.setLayoutData((Object)gd);
            }
            Label lNum = new Label((Composite)this.shell, 0x1000008);
            lNum.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            lNum.setText(String.format(this.barmasterText.getString("TEXT_PORESKA_STOPA"), new Object[0]) + " " + (i + 1) + ": ");
            Button bUsed = new Button((Composite)this.shell, 32);
            bUsed.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
            bUsed.setText(String.format(this.barmasterText.getString("TEXT_U_UPOTREBI"), new Object[0]));
            usedA[i] = bUsed;
            Label lPercent = new Label((Composite)this.shell, 0x1000008);
            lPercent.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            lPercent.setText(String.format(this.barmasterText.getString("TEXT_STOPA"), new Object[0]));
            final Text tPercent = new Text((Composite)this.shell, 2048);
            gd = new GridData(4, 4, true, false);
            gd.heightHint = 30;
            tPercent.setLayoutData((Object)gd);
            tPercent.setText(StatLogic.getNumber02(ps.getStopa()));
            percentA[i] = tPercent;
            Label lMark = new Label((Composite)this.shell, 0x1000008);
            lMark.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            lMark.setText(String.format(this.barmasterText.getString("TEXT_OZNAKA"), new Object[0]));
            final Text tMark = new Text((Composite)this.shell, 2048);
            gd = new GridData(4, 4, false, false);
            gd.heightHint = 30;
            gd.widthHint = 30;
            tMark.setLayoutData((Object)gd);
            tMark.setTextLimit(1);
            tMark.setText("" + ps.getOznaka());
            markA[i] = tMark;
            Label lName = new Label((Composite)this.shell, 0x1000008);
            lName.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            lName.setText(String.format(this.barmasterText.getString("TEXT_NAZIV"), new Object[0]));
            final Text tName = new Text((Composite)this.shell, 2048);
            gd = new GridData(4, 4, true, false);
            gd.heightHint = 30;
            gd.widthHint = 150;
            tName.setLayoutData((Object)gd);
            tName.setText(ps.getNaziv());
            nameA[i] = tName;
            final Button bDefaultNonVat = new Button((Composite)this.shell, 32);
            bDefaultNonVat.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
            bDefaultNonVat.setText(String.format(this.barmasterText.getString("TEXT_PODRAZUMEVANA_VAN_PDV"), new Object[0]));
            defaultNonVatA[i] = bDefaultNonVat;
            bDefaultNonVat.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Button b = (Button)e.widget;
                    for (Button ba : defaultNonVatA) {
                        if (ba == null) continue;
                        ba.setSelection(false);
                    }
                    b.setSelection(true);
                }
            });
            bDefaultNonVat.setSelection(ps.isNonVatRate());
            final Button bDefault = new Button((Composite)this.shell, 32);
            bDefault.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
            bDefault.setText(String.format(this.barmasterText.getString("TEXT_PODRAZUMEVANA"), new Object[0]));
            defaultA[i] = bDefault;
            bDefault.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Button b = (Button)e.widget;
                    for (Button ba : defaultA) {
                        if (ba == null) continue;
                        ba.setSelection(false);
                    }
                    b.setSelection(true);
                }
            });
            bDefault.setSelection(ps.isMostUsedRate());
            Label lSep = new Label((Composite)this.shell, 258);
            gd = new GridData(4, 0x1000000, true, false, gl.numColumns, 1);
            gd.heightHint = 8;
            lSep.setLayoutData((Object)gd);
            bUsed.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Button source = (Button)e.widget;
                    tName.setEnabled(source.getSelection());
                    tMark.setEnabled(source.getSelection());
                    tPercent.setEnabled(source.getSelection());
                    bDefaultNonVat.setEnabled(source.getSelection());
                    bDefault.setEnabled(source.getSelection());
                }
            });
            bUsed.setSelection(ps.isUsed());
            bUsed.notifyListeners(13, new Event());
        }
        Composite control = new Composite((Composite)this.shell, 0);
        control.setLayout((Layout)new GridLayout(2, true));
        control.setLayoutData((Object)new GridData(4, 4, true, true, ((GridLayout)this.shell.getLayout()).numColumns, 1));
        Button bOk = Dugmici.getOkButton(control);
        bOk.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                for (int i = 0; i < PoreskaGrupa.values().length; ++i) {
                    PoreskaGrupa pg = PoreskaGrupa.values()[i];
                    Double perc = 0.0;
                    try {
                        NumberFormat nf;
                        Text t = percentA[i];
                        if (t.getText().contains(".")) {
                            try {
                                nf = NumberFormat.getInstance(Locale.UK);
                                nf.setGroupingUsed(false);
                                perc = nf.parse(t.getText()).doubleValue();
                            }
                            catch (Exception e) {
                                e.printStackTrace(System.out);
                            }
                        } else if (t.getText().contains(",")) {
                            try {
                                nf = NumberFormat.getInstance(Locale.GERMAN);
                                nf.setGroupingUsed(false);
                                perc = nf.parse(t.getText()).doubleValue();
                            }
                            catch (Exception e) {
                                e.printStackTrace(System.out);
                            }
                        } else {
                            try {
                                nf = NumberFormat.getIntegerInstance();
                                perc = nf.parse(t.getText()).doubleValue();
                            }
                            catch (Exception e) {
                                e.printStackTrace(System.out);
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.out);
                    }
                    PoreskaStopa ps = new PoreskaStopa(perc, markA[i].getText().charAt(0), nameA[i].getText(), pg, usedA[i].getSelection(), defaultNonVatA[i].getSelection(), defaultA[i].getSelection());
                    PoreskeStope.setStopa(ps);
                }
                UpravljanjePoreskimStopama.this.shell.close();
            }
        });
        GridData gd = (GridData)bOk.getLayoutData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        Button bCancel = Dugmici.getCancelButton(control);
        gd = (GridData)bCancel.getLayoutData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        bCancel.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                UpravljanjePoreskimStopama.this.shell.close();
            }
        });
        this.shell.pack();
        Konstante.centerShellOnDisplay(this.shell);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
    }
}

