/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.sistem;

import Stampa.core.GridPrinter;
import Stampa.test.PrintHandler;
import Stampa.test.TableWrapper;
import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.restoran.Dugmici;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.PopisProvera;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.SkidanjeNormativa;
import com.dev63.restoran.model.Artikal;
import com.dev63.restoran.model.DnevnoStanje;
import com.dev63.restoran.model.Kartica;
import com.dev63.restoran.model.Odeljenje;
import com.dev63.restoran.model.Option;
import com.dev63.restoran.model.Setting;
import com.dev63.restoran.model.TipArtikla;
import com.dev63.restoran.model.UtrosakDoc;
import com.dev63.restoran.model.UtrosakDocStavke;
import com.dev63.restoran.model.UtrosakDocUtrosak;
import com.dev63.restoran.parts.DateInput2;
import com.dev63.restoran.parts.DoubleInput2;
import com.dev63.restoran.parts.InputException;
import com.dev63.restoran.sistem.CalendarAdapter;
import com.dev63.restoran.sistem.IzracunajDnevniPromet2;
import com.dev63.restoran.sistem.PomocniUpit;
import com.dev63.restoran.swt.components.SWTMessage;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class UnosUtroskaDoc {
    private final ResourceBundle barmasterText = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale());
    RestoranServer server;
    SWTContainer parent;
    DateInput2 datum;
    final Table table;
    Button plus;
    Button minus;
    Odeljenje odeljenje;
    List<UtrosakDocStavke> stavke = new ArrayList<UtrosakDocStavke>();
    Shell shell;
    Text pretraga;
    Combo artikal;
    DoubleInput2 cenaKomad;
    Button crno;
    Restoran restoran;
    Map<Long, Artikal> artikli;
    List<Artikal> artikli2 = new ArrayList<Artikal>();
    Map<Long, Double> mapaPocetnoB;
    Map<Long, Double> mapaUlazB;
    Map<Long, Double> mapaIzlazB;
    Map<Long, Double> mapaPocetnoC;
    Map<Long, Double> mapaUlazC;
    Map<Long, Double> mapaIzlazC;
    boolean sifre;
    private boolean poPosUnetCenama = false;
    private boolean poPosCenamaKombo = false;
    List<DnevnoStanje> stanjaDanas = null;
    double totalNabBezPDV;
    double totalNab;
    double totalProd;
    TableItem total;
    boolean inspektor = false;
    boolean crn = false;
    Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
    int width = (int)this.screenSize.getWidth();
    int height = (int)this.screenSize.getHeight();

    public UnosUtroskaDoc(SWTContainer owner, Restoran r, Odeljenje o, final boolean inspektor) {
        this.restoran = r;
        this.server = this.restoran.getServer();
        this.parent = owner;
        this.shell = this.parent.getControl().getShell();
        this.odeljenje = o;
        this.inspektor = inspektor;
        try {
            this.sifre = this.restoran.getServer().getSetting(Option.STAMPA_SIFARA_DOKUMENTI).booleanValue();
            Setting poPNC = this.server.getSetting(Option.PO_POSLEDNJIM_UNETIM_CENAMA);
            Setting poPNCKombo = this.server.getSetting(Option.PO_POSLEDNJIM_CENAMA_KOMBINOVANO);
            this.poPosUnetCenama = poPNC == null ? false : poPNC.booleanValue();
            this.poPosCenamaKombo = poPNCKombo == null ? false : poPNCKombo.booleanValue();
        }
        catch (Exception e) {
            this.sifre = false;
        }
        Composite shell2 = new Composite((Composite)this.shell, 2048);
        SWTContainer parent2 = new SWTContainer(shell2);
        Label dat = new Label(shell2, 0);
        dat.setText("Datum unosa:");
        dat.setBackground(this.shell.getDisplay().getSystemColor(22));
        this.datum = new DateInput2(parent2, "Datum unosa", new Date(this.server.getLastDateZD().getTime()), false, this.server);
        this.datum.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.datum, this.shell));
        this.datum.setEnabled(true);
        Label cr = null;
        if (inspektor) {
            cr = new Label(shell2, 0);
            cr.setText("Unos utroska dodatnih:");
            cr.setBackground(this.shell.getDisplay().getSystemColor(22));
            this.crno = new Button(shell2, 32);
        }
        Label opisL = new Label(shell2, 0);
        opisL.setText("Opis:");
        opisL.setBackground(this.shell.getDisplay().getSystemColor(22));
        final Text opis = new Text(shell2, 2560);
        Label separator1 = new Label(shell2, 258);
        this.table = new Table(shell2, 68356);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        int widthColumn = this.parent.getWidth() * 4 / 5 / 8;
        TableColumn nazivArtikla = new TableColumn(this.table, 0x1000000);
        nazivArtikla.setText("Naziv artikla");
        nazivArtikla.setWidth(widthColumn);
        TableColumn kolicina = new TableColumn(this.table, 0x1000000);
        kolicina.setText("Kolicina");
        kolicina.setWidth(widthColumn / 2);
        TableColumn jmere = new TableColumn(this.table, 0x1000000);
        jmere.setText("J.M");
        jmere.setWidth(widthColumn / 2);
        TableColumn nabavnaCenaBezPDV = new TableColumn(this.table, 0x1000000);
        nabavnaCenaBezPDV.setText("Nab. cena bez PDV");
        nabavnaCenaBezPDV.setWidth(widthColumn);
        TableColumn nabavnaVrednostBezPDV = new TableColumn(this.table, 0x1000000);
        nabavnaVrednostBezPDV.setText("Nab. vrednost bez PDV");
        nabavnaVrednostBezPDV.setWidth(widthColumn);
        TableColumn nabavnaCena = new TableColumn(this.table, 0x1000000);
        nabavnaCena.setText("Nab. cena");
        nabavnaCena.setWidth(widthColumn);
        TableColumn nabavnaVrednost = new TableColumn(this.table, 0x1000000);
        nabavnaVrednost.setText("Nab. vrednost");
        nabavnaVrednost.setWidth(widthColumn);
        TableColumn prodajnaCena = new TableColumn(this.table, 0x1000000);
        prodajnaCena.setText("Prod. cena");
        prodajnaCena.setWidth(widthColumn);
        TableColumn prodajnaVrednost = new TableColumn(this.table, 0x1000000);
        prodajnaVrednost.setText("Prod. vrednost");
        prodajnaVrednost.setWidth(widthColumn);
        this.total = new TableItem(this.table, 0);
        this.total.setText(new String[]{"", "", "TOTAL:", "" + this.totalNabBezPDV, "" + this.totalNab, "" + this.totalProd});
        Label separator2 = new Label(shell2, 258);
        Button cancelButt = Dugmici.getCancelButton(shell2);
        cancelButt.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                UnosUtroskaDoc.this.parent.getControl().getShell().close();
            }
        });
        this.minus = Dugmici.getMinusButton(shell2);
        this.minus.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                int i = UnosUtroskaDoc.this.table.getSelectionIndex();
                if (i >= 0 && i != UnosUtroskaDoc.this.stavke.size()) {
                    UnosUtroskaDoc.this.totalNabBezPDV = Konstante.round(UnosUtroskaDoc.this.totalNabBezPDV - Double.parseDouble(UnosUtroskaDoc.this.table.getItem(i).getText(4)), 2);
                    UnosUtroskaDoc.this.totalNab = Konstante.round(UnosUtroskaDoc.this.totalNab - Double.parseDouble(UnosUtroskaDoc.this.table.getItem(i).getText(6)), 2);
                    UnosUtroskaDoc.this.totalProd = Konstante.round(UnosUtroskaDoc.this.totalProd - Double.parseDouble(UnosUtroskaDoc.this.table.getItem(i).getText(8)), 2);
                    UnosUtroskaDoc.this.table.remove(i);
                    UnosUtroskaDoc.this.stavke.remove(i);
                    UnosUtroskaDoc.this.total.setText(new String[]{"", "", "TOTAL:", "", String.valueOf(UnosUtroskaDoc.this.totalNabBezPDV), "", String.valueOf(UnosUtroskaDoc.this.totalNab), "", String.valueOf(UnosUtroskaDoc.this.totalProd)});
                }
            }
        });
        this.plus = Dugmici.getPlusButton(shell2);
        this.plus.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                UnosUtroskaDoc.this.unosUtrosakDocStavke(UnosUtroskaDoc.this.shell, UnosUtroskaDoc.this.table);
            }
        });
        Button okButt = Dugmici.getOkButton(shell2);
        okButt.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                try {
                    PopisProvera provera = new PopisProvera(UnosUtroskaDoc.this.server, UnosUtroskaDoc.this.shell, UnosUtroskaDoc.this.datum.getResult(), UnosUtroskaDoc.this.odeljenje, true);
                    if (provera.isPopis()) {
                        provera.setValidDate(UnosUtroskaDoc.this.datum);
                        return;
                    }
                }
                catch (InputException e1) {
                    e1.printStackTrace();
                }
                if (UnosUtroskaDoc.this.stavke.size() < 1) {
                    Konstante.getPoruka(UnosUtroskaDoc.this.shell, "Morate uneti podatke za bar jedan artikal !");
                    return;
                }
                if (inspektor) {
                    UnosUtroskaDoc.this.crn = UnosUtroskaDoc.this.crno.getSelection();
                }
                UtrosakDoc ot = new UtrosakDoc();
                try {
                    int broj;
                    Calendar dc = Calendar.getInstance();
                    if (UnosUtroskaDoc.this.datum.getResult().after(new Date())) {
                        Konstante.getPoruka(UnosUtroskaDoc.this.shell, "Uneti datum je neprihvatljiv!");
                        return;
                    }
                    dc.setTime(UnosUtroskaDoc.this.datum.getResult());
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(new Date());
                    cal.set(5, dc.get(5));
                    cal.set(2, dc.get(2));
                    cal.set(1, dc.get(1));
                    ot.setOdeljenje(UnosUtroskaDoc.this.odeljenje);
                    ot.setDatum(cal.getTime());
                    ot.setUname(UnosUtroskaDoc.this.server.getUser().getName());
                    ot.setOpis(opis.getText());
                    ot.setCrno(UnosUtroskaDoc.this.crn);
                    if (UnosUtroskaDoc.this.crn) {
                        broj = UnosUtroskaDoc.this.server.sledeciBrojUtrosakDoc2();
                        ot.setBroj(broj + "/2");
                    } else {
                        broj = UnosUtroskaDoc.this.server.sledeciBrojUtrosakDoc();
                        ot.setBroj(broj + "/" + dc.get(1));
                    }
                    UnosUtroskaDoc.this.server.saveUtrosakDoc(ot);
                    ot = (UtrosakDoc)UnosUtroskaDoc.this.server.getBase().find(UtrosakDoc.class, (Object)ot.getId());
                    if (UnosUtroskaDoc.this.crn) {
                        UnosUtroskaDoc.this.server.incrementBrojUtrosakDoc2(String.valueOf(broj + 1));
                    } else {
                        UnosUtroskaDoc.this.server.incrementBrojUtrosakDoc(String.valueOf(broj + 1));
                    }
                    for (UtrosakDocStavke os : UnosUtroskaDoc.this.stavke) {
                        os.setUtrosakDoc(ot);
                        UnosUtroskaDoc.this.sacuvajUtrosakDocStavku(os);
                    }
                    if (!UnosUtroskaDoc.this.unosUtrosakaDocUtrosak(ot, UnosUtroskaDoc.this.stavke)) {
                        SWTMessage.showMessageDialog(UnosUtroskaDoc.this.shell, "Neuspesan upis utrosaka u tabeli utrosakdocutrosak", String.format(UnosUtroskaDoc.this.barmasterText.getString("TEXT_UPOZORENJE"), new Object[0]), 2);
                        return;
                    }
                }
                catch (InputException dc) {
                    // empty catch block
                }
                Konstante.getPoruka3(UnosUtroskaDoc.this.shell, "UtrosakDoc uspesno zapamcen!");
                GridPrinter gp = new GridPrinter(new PrintHandler());
                gp.printTable(new TableWrapper(UnosUtroskaDoc.this.table), false, true, "UtrosakDoc " + ot.getBroj() + "\nDatum: " + Konstante.getDate(ot.getDatum()) + "\nNapomena:" + ot.getOpis(), UnosUtroskaDoc.this.shell, UnosUtroskaDoc.this.server);
                UnosUtroskaDoc.this.parent.getControl().getShell().close();
            }
        });
        GridLayout layout = new GridLayout(1, false);
        this.shell.setLayout((Layout)layout);
        this.shell.setMaximized(true);
        layout = new GridLayout(4, false);
        shell2.setLayout((Layout)layout);
        GridData gridData = new GridData();
        dat.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        this.datum.getControl().setLayoutData((Object)gridData);
        gridData = new GridData();
        cr.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        this.crno.setLayoutData((Object)gridData);
        gridData = new GridData(4, 1, true, false);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 4;
        opisL.setLayoutData((Object)gridData);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.heightHint = 100;
        gridData.horizontalSpan = 4;
        opis.setLayoutData((Object)gridData);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 4;
        separator1.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.widthHint = this.parent.getWidth() * 4 / 5;
        gridData.heightHint = this.parent.getHeight() / 2;
        gridData.horizontalAlignment = 16384;
        gridData.horizontalSpan = 4;
        this.table.setLayoutData((Object)gridData);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 4;
        separator2.setLayoutData((Object)gridData);
        gridData = new GridData(0, 4, true, true);
        gridData.horizontalAlignment = 16384;
        gridData.heightHint = 60;
        cancelButt.setLayoutData((Object)gridData);
        gridData = new GridData(0, 4, true, true);
        gridData.horizontalAlignment = 16384;
        gridData.heightHint = 60;
        this.plus.setLayoutData((Object)gridData);
        gridData = new GridData(0, 4, true, true);
        gridData.horizontalAlignment = 131072;
        gridData.heightHint = 60;
        this.minus.setLayoutData((Object)gridData);
        gridData = new GridData(0, 4, true, true);
        gridData.horizontalAlignment = 131072;
        gridData.heightHint = 60;
        okButt.setLayoutData((Object)gridData);
    }

    public void unosUtrosakDocStavke(final Shell shell, final Table table) {
        final Shell shell2 = new Shell(shell.getDisplay(), 67680);
        shell2.setBackground(shell.getDisplay().getSystemColor(22));
        Monitor primary = shell2.getDisplay().getPrimaryMonitor();
        Rectangle bounds = primary.getBounds();
        Rectangle rect = shell2.getBounds();
        int x = bounds.x + rect.width / 2;
        int y = bounds.y + rect.height / 2;
        shell2.setLocation(x, y);
        final SortedMap<String, Long> artikli3 = this.server.getArtikliZaUtrosak(this.odeljenje.getId());
        final SWTContainer parent2 = new SWTContainer((Composite)shell2);
        Label p = new Label((Composite)shell2, 0);
        p.setText("Pretraga:");
        p.setBackground(shell.getDisplay().getSystemColor(22));
        this.pretraga = new Text((Composite)shell2, 0);
        this.pretraga.addListener(2, new Listener(){

            public void handleEvent(Event e) {
                switch (e.keyCode) {
                    case 13: 
                    case 0x1000050: {
                        String str = UnosUtroskaDoc.this.pretraga.getText();
                        if (str.length() > 0) {
                            UnosUtroskaDoc.this.artikal.removeAll();
                        }
                        SortedMap<Object, Object> sMapa = new TreeMap();
                        if (str == null || str.length() <= 0) {
                            return;
                        }
                        sMapa = UnosUtroskaDoc.this.server.getArtikliByNameOrBarcode(UnosUtroskaDoc.this.odeljenje.getId(), str);
                        if (sMapa.isEmpty()) {
                            Konstante.getPoruka3(shell2, "Nije pronadjen artikal po pretrazi");
                            for (String string : artikli3.keySet()) {
                                UnosUtroskaDoc.this.artikal.add(string);
                            }
                            UnosUtroskaDoc.this.artikal.select(0);
                            break;
                        }
                        for (String string : sMapa.keySet()) {
                            UnosUtroskaDoc.this.artikal.add(string);
                        }
                        UnosUtroskaDoc.this.artikal.select(0);
                    }
                }
            }
        });
        Label a = new Label((Composite)shell2, 0);
        a.setText("Artikal:");
        a.setBackground(shell2.getDisplay().getSystemColor(22));
        this.artikal = new Combo((Composite)shell2, 2572);
        for (String s : artikli3.keySet()) {
            this.artikal.add(s);
        }
        this.artikal.select(0);
        Label k = new Label((Composite)shell2, 0);
        k.setText("Kolicina :");
        k.setBackground(shell2.getDisplay().getSystemColor(22));
        final DoubleInput2 kolicina = new DoubleInput2(parent2, "Kolicina", false);
        Label c = new Label((Composite)shell2, 0);
        c.setText("Cena :");
        c.setBackground(shell2.getDisplay().getSystemColor(22));
        final DoubleInput2 cena = new DoubleInput2(parent2, "Cena", false);
        this.artikal.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int i = UnosUtroskaDoc.this.artikal.getSelectionIndex();
                Artikal art = null;
                if (i > -1) {
                    art = UnosUtroskaDoc.this.server.getArtikal(UnosUtroskaDoc.this.artikal.getItem(i));
                    cena.setResult(art.getCena());
                }
            }
        });
        Button cancelButt = Dugmici.getCancelButton(shell2);
        cancelButt.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                parent2.getControl().getShell().close();
            }
        });
        Button okButt = Dugmici.getOkButton(shell2);
        okButt.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                try {
                    PopisProvera provera = new PopisProvera(UnosUtroskaDoc.this.server, shell, UnosUtroskaDoc.this.datum.getResult(), UnosUtroskaDoc.this.odeljenje, true);
                    if (provera.isPopis()) {
                        provera.setValidDate(UnosUtroskaDoc.this.datum);
                        return;
                    }
                }
                catch (InputException e1) {
                    e1.printStackTrace();
                }
                try {
                    int i = UnosUtroskaDoc.this.artikal.getSelectionIndex();
                    Artikal art = null;
                    if (i > -1) {
                        art = UnosUtroskaDoc.this.server.getArtikal(UnosUtroskaDoc.this.artikal.getItem(i));
                    }
                    if (art == null) {
                        Konstante.getPoruka3(shell2, "Nije izabran artikal");
                        return;
                    }
                    UtrosakDocStavke os = new UtrosakDocStavke();
                    os.setArtikal(art);
                    os.setKolicina(kolicina.getResult());
                    os.setCena(cena.getResult());
                    if (art.getTip() == TipArtikla.SIRO || art.getTip() == TipArtikla.POLU) {
                        os.setNcUtroska(Double.parseDouble(Konstante.getNumber2(UnosUtroskaDoc.this.getNabavnaCena(art, kolicina.getResult()) / kolicina.getResult())));
                        os.setNcUtroskaBezPDV(Double.parseDouble(Konstante.getNumber2(UnosUtroskaDoc.this.getNabavnaCenaBezPDV(art, kolicina.getResult()) / kolicina.getResult())));
                    } else if (art.getTip() == TipArtikla.SLOZ || art.getTip() == TipArtikla.DODA) {
                        art = (Artikal)UnosUtroskaDoc.this.server.getBase().find(Artikal.class, (Object)art.getId());
                        os.setNcUtroska(Double.parseDouble(Konstante.getNumber2(UnosUtroskaDoc.this.getNabavnaCena(art, kolicina.getResult()) / kolicina.getResult())));
                        os.setNcUtroskaBezPDV(Double.parseDouble(Konstante.getNumber2(UnosUtroskaDoc.this.getNabavnaCenaBezPDV(art, kolicina.getResult()) / kolicina.getResult())));
                    } else {
                        art = (Artikal)UnosUtroskaDoc.this.server.getBase().find(Artikal.class, (Object)art.getId());
                        os.setNcUtroska(Double.parseDouble(Konstante.getNumber2(UnosUtroskaDoc.this.getNabavnaCena(art, kolicina.getResult()) / kolicina.getResult())));
                        os.setNcUtroskaBezPDV(Double.parseDouble(Konstante.getNumber2(UnosUtroskaDoc.this.getNabavnaCenaBezPDV(art, kolicina.getResult()) / kolicina.getResult())));
                    }
                    UnosUtroskaDoc.this.stavke.add(os);
                    double nabavnaCena = 0.0;
                    double nabavnaCenaBezPDV = 0.0;
                    TableItem item = new TableItem(table, 0, UnosUtroskaDoc.this.stavke.size() - 1);
                    if (art.getTip() == TipArtikla.SIRO || art.getTip() == TipArtikla.POLU) {
                        nabavnaCena = UnosUtroskaDoc.this.getNabavnaCena(art, kolicina.getResult());
                        nabavnaCenaBezPDV = UnosUtroskaDoc.this.getNabavnaCenaBezPDV(art, kolicina.getResult());
                        art.setTrenutnaNV(Double.parseDouble(Konstante.getNumber2(nabavnaCena / kolicina.getResult())));
                        item.setText(new String[]{art.getName(), Konstante.getNumber2(kolicina.getResult()), art.getJedinicaMere(), Konstante.getNumber2(nabavnaCenaBezPDV / kolicina.getResult()), Konstante.getNumber2(nabavnaCenaBezPDV), Konstante.getNumber2(nabavnaCena / kolicina.getResult()), Konstante.getNumber2(nabavnaCena), "0.0", "0.0"});
                        UnosUtroskaDoc.this.totalNabBezPDV += Konstante.round(nabavnaCenaBezPDV, 2);
                        UnosUtroskaDoc.this.totalNab += Konstante.round(nabavnaCena, 2);
                        UnosUtroskaDoc.this.totalProd += 0.0;
                    } else if (art.getTip() == TipArtikla.SLOZ || art.getTip() == TipArtikla.DODA) {
                        art = (Artikal)UnosUtroskaDoc.this.server.getBase().find(Artikal.class, (Object)art.getId());
                        nabavnaCena = UnosUtroskaDoc.this.getNabavnaCena(art, kolicina.getResult());
                        nabavnaCenaBezPDV = UnosUtroskaDoc.this.getNabavnaCenaBezPDV(art, kolicina.getResult());
                        art.setTrenutnaNV(Double.parseDouble(Konstante.getNumber2(nabavnaCena / kolicina.getResult())));
                        item.setText(new String[]{art.getName(), Konstante.getNumber2(kolicina.getResult()), art.getJedinicaMere(), Konstante.getNumber2(nabavnaCenaBezPDV / kolicina.getResult()), Konstante.getNumber2(nabavnaCenaBezPDV), Konstante.getNumber2(nabavnaCena / kolicina.getResult()), Konstante.getNumber2(nabavnaCena), Konstante.getNumber2(cena.getResult()), Konstante.getNumber2(cena.getResult() * kolicina.getResult())});
                        UnosUtroskaDoc.this.totalNabBezPDV += Konstante.round(nabavnaCenaBezPDV, 2);
                        UnosUtroskaDoc.this.totalNab += Konstante.round(nabavnaCena, 2);
                        UnosUtroskaDoc.this.totalProd += cena.getResult() * kolicina.getResult();
                    } else {
                        nabavnaCena = UnosUtroskaDoc.this.getNabavnaCena(art, kolicina.getResult());
                        nabavnaCenaBezPDV = UnosUtroskaDoc.this.getNabavnaCenaBezPDV(art, kolicina.getResult());
                        art.setTrenutnaNV(Double.parseDouble(Konstante.getNumber2(nabavnaCena / kolicina.getResult())));
                        item.setText(new String[]{art.getName(), Konstante.getNumber2(kolicina.getResult()), art.getJedinicaMere(), Konstante.getNumber2(nabavnaCenaBezPDV / kolicina.getResult()), Konstante.getNumber2(nabavnaCenaBezPDV), Konstante.getNumber2(nabavnaCena / kolicina.getResult()), Konstante.getNumber2(nabavnaCena), Konstante.getNumber2(cena.getResult() / art.getMera()), Konstante.getNumber2(cena.getResult() / art.getMera() * kolicina.getResult())});
                        UnosUtroskaDoc.this.totalNabBezPDV += Konstante.round(nabavnaCenaBezPDV, 2);
                        UnosUtroskaDoc.this.totalNab += Konstante.round(nabavnaCena, 2);
                        UnosUtroskaDoc.this.totalProd += cena.getResult() / art.getMera() * kolicina.getResult();
                    }
                    shell2.close();
                }
                catch (InputException ex) {
                    Konstante.getPoruka(shell2, ex.getMessage());
                }
                UnosUtroskaDoc.this.total.setText(new String[]{"", "", "TOTAL:", "", Konstante.getNumber2(UnosUtroskaDoc.this.totalNabBezPDV), "", Konstante.getNumber2(UnosUtroskaDoc.this.totalNab), "", Konstante.getNumber2(UnosUtroskaDoc.this.totalProd)});
            }
        });
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.verticalSpacing = 10;
        layout.horizontalSpacing = 10;
        shell2.setLayout((Layout)layout);
        GridData data = new GridData();
        data.widthHint = 200;
        data.horizontalAlignment = 131072;
        this.artikal.setLayoutData((Object)data);
        data = new GridData();
        data.widthHint = 150;
        data.heightHint = 30;
        data.horizontalAlignment = 16384;
        a.setLayoutData((Object)data);
        k.setLayoutData((Object)data);
        c.setLayoutData((Object)data);
        this.pretraga.setLayoutData((Object)data);
        kolicina.getControl().setLayoutData((Object)data);
        cena.getControl().setLayoutData((Object)data);
        data = new GridData();
        data.widthHint = 150;
        data.horizontalAlignment = 131072;
        shell2.pack();
        shell2.open();
    }

    public void sacuvajUtrosakDocStavku(UtrosakDocStavke os) throws InputException {
        this.server.refresh();
        os.setVrednost(Double.parseDouble(Konstante.getNumber2(os.getNcUtroska() * os.getKolicina())));
        this.server.addUtrosakDocStavka(os);
    }

    public void izracunajBelo(Date day1, Date day2) {
        IzracunajDnevniPromet2 dp = new IzracunajDnevniPromet2(this.restoran, new Date(), true, false, this.odeljenje);
        this.stanjaDanas = dp.getDnevnaStanja();
        this.mapaPocetnoB = this.server.getDnevnoStanjeBelo(day1, this.odeljenje, PomocniUpit.artikliBezSlozenih(this.odeljenje));
        this.mapaIzlazB = this.server.getPeriodicnoStanjeBeloIzlaz(day1, day2, this.odeljenje, PomocniUpit.artikliBezSlozenih(this.odeljenje));
        this.mapaUlazB = this.server.getPeriodicnoStanjeBeloUlaz(day1, day2, this.odeljenje, PomocniUpit.artikliBezSlozenih(this.odeljenje));
    }

    public void izracunajCrno(Date day1, Date day2) {
        IzracunajDnevniPromet2 dp = new IzracunajDnevniPromet2(this.restoran, new Date(), false, true, this.odeljenje);
        this.stanjaDanas = dp.getDnevnaStanja();
        this.mapaPocetnoC = this.server.getDnevnoStanjeCrno(day1, this.odeljenje, PomocniUpit.artikliBezSlozenih(this.odeljenje));
        this.mapaIzlazC = this.server.getPeriodicnoStanjeCrnoIzlaz(day1, day2, this.odeljenje, PomocniUpit.artikliBezSlozenih(this.odeljenje));
        this.mapaUlazC = this.server.getPeriodicnoStanjeCrnoUlaz(day1, day2, this.odeljenje, PomocniUpit.artikliBezSlozenih(this.odeljenje));
    }

    public double izracunajPocetno(Artikal a, boolean belo) {
        double pocetno = 0.0;
        if (belo && this.mapaPocetnoB.get(a.getId()) != null) {
            pocetno += this.mapaPocetnoB.get(a.getId()).doubleValue();
        }
        if (!belo && this.mapaPocetnoC.get(a.getId()) != null) {
            pocetno += this.mapaPocetnoC.get(a.getId()).doubleValue();
        }
        return pocetno;
    }

    public double izracunajUlaz(Artikal a, boolean belo) {
        double ulaz = 0.0;
        if (belo) {
            if (this.mapaUlazB.get(a.getId()) != null) {
                ulaz += this.mapaUlazB.get(a.getId()).doubleValue();
            }
            if (this.getDS(a) != null) {
                ulaz += this.getDS(a).getBeloUlaz().doubleValue();
            }
        }
        if (!belo) {
            if (this.mapaUlazC.get(a.getId()) != null) {
                ulaz += this.mapaUlazC.get(a.getId()).doubleValue();
            }
            if (this.getDS(a) != null) {
                ulaz += this.getDS(a).getCrnoUlaz().doubleValue();
            }
        }
        return ulaz;
    }

    public double izracunajIzlaz(Artikal a, boolean belo) {
        double izlaz = 0.0;
        if (belo) {
            if (this.mapaIzlazB.get(a.getId()) != null) {
                izlaz += this.mapaIzlazB.get(a.getId()).doubleValue();
            }
            if (this.getDS(a) != null) {
                izlaz += this.getDS(a).getBeloIzlaz().doubleValue();
            }
        }
        if (!belo) {
            if (this.mapaIzlazC.get(a.getId()) != null) {
                izlaz += this.mapaIzlazC.get(a.getId()).doubleValue();
            }
            if (this.getDS(a) != null) {
                izlaz += this.getDS(a).getCrnoIzlaz().doubleValue();
            }
        }
        return izlaz;
    }

    public void sortiraj(List<Artikal> artikli) {
        Comparator<Artikal> SENIORITY_ORDER = null;
        SENIORITY_ORDER = new Comparator<Artikal>(){

            @Override
            public int compare(Artikal t1, Artikal t2) {
                return t1.getName().compareTo(t2.getName());
            }
        };
        Collections.sort(artikli, SENIORITY_ORDER);
    }

    public double getNabavnaCena(Artikal art, double kolicina) {
        double trNv = 0.0;
        if (art.getTip().equals((Object)TipArtikla.SLOZ) || art.getTip().equals((Object)TipArtikla.POLU) || art.getTip().equals((Object)TipArtikla.DODA)) {
            Map<Artikal, Double> mapa = SkidanjeNormativa.razloziSlozeni2(art, new HashMap<Artikal, Double>(), kolicina, this.server, null, null);
            for (Artikal a : mapa.keySet()) {
                trNv += (this.poPosUnetCenama ? (this.poPosCenamaKombo ? this.server.getLastNabavnaCenaKombo(a) : this.server.getLastNabavnaCenaBela(a, new Date())) : a.getTrenutnaNV()) / (1.0 + (this.poPosCenamaKombo || this.poPosUnetCenama ? 0.0 : Konstante.getPdvPoPG(a.getPoreskaGrupa()))) * mapa.get(a);
            }
        } else {
            trNv = (this.poPosUnetCenama ? (this.poPosCenamaKombo ? this.server.getLastNabavnaCenaKombo(art) : this.server.getLastNabavnaCenaBela(art, new Date())) : art.getTrenutnaNV()) / (1.0 + (this.poPosCenamaKombo || this.poPosUnetCenama ? 0.0 : Konstante.getPdvPoPG(art.getPoreskaGrupa()))) * kolicina;
        }
        return trNv;
    }

    public double getNabavnaCenaBezPDV(Artikal art, double kolicina) {
        double trNv = 0.0;
        if (art.getTip().equals((Object)TipArtikla.SLOZ) || art.getTip().equals((Object)TipArtikla.POLU) || art.getTip().equals((Object)TipArtikla.DODA)) {
            Map<Artikal, Double> mapa = SkidanjeNormativa.razloziSlozeni2(art, new HashMap<Artikal, Double>(), kolicina, this.server, null, null);
            for (Artikal a : mapa.keySet()) {
                trNv += (this.poPosUnetCenama ? (this.poPosCenamaKombo ? this.server.getLastNabavnaCenaKombo(a) : this.server.getLastNabavnaCenaBelaBezPDV(a, new Date())) : a.getTrenutnaNV()) / (1.0 + (this.poPosCenamaKombo || this.poPosUnetCenama ? 0.0 : Konstante.getPdvPoPG(a.getPoreskaGrupa()))) * mapa.get(a);
            }
        } else {
            trNv = (this.poPosUnetCenama ? (this.poPosCenamaKombo ? this.server.getLastNabavnaCenaKombo(art) : this.server.getLastNabavnaCenaBelaBezPDV(art, new Date())) : art.getTrenutnaNV()) / (1.0 + (this.poPosCenamaKombo || this.poPosUnetCenama ? 0.0 : Konstante.getPdvPoPG(art.getPoreskaGrupa()))) * kolicina;
        }
        return trNv;
    }

    DnevnoStanje getDS(Artikal a) {
        if (this.stanjaDanas == null) {
            return null;
        }
        for (DnevnoStanje ds : this.stanjaDanas) {
            if (!ds.getArtikalID().equals(a.getId())) continue;
            return ds;
        }
        return null;
    }

    protected synchronized boolean unosUtrosakaDocUtrosak(UtrosakDoc aktivanUtrosakDoc, List<UtrosakDocStavke> stavke) {
        System.out.println("Nesaaaa");
        System.out.println("ovde kreiram utroske otpisa");
        boolean upis = false;
        try {
            HashMap<Artikal, Double> artikal_kolicina = new HashMap<Artikal, Double>();
            HashMap<Artikal, Double> normativ_kolicina = new HashMap<Artikal, Double>();
            HashMap konacnaLista = new HashMap();
            boolean prolazi = false;
            for (UtrosakDocStavke os : stavke) {
                if (!artikal_kolicina.containsKey(os.getArtikal())) {
                    artikal_kolicina.put(os.getArtikal(), os.getKolicina());
                    continue;
                }
                artikal_kolicina.put(os.getArtikal(), (Double)artikal_kolicina.get(os.getArtikal()) + os.getKolicina());
            }
            ArrayList<Kartica> karticaList = new ArrayList<Kartica>();
            for (Artikal artikal : artikal_kolicina.keySet()) {
                karticaList.clear();
                normativ_kolicina.clear();
                if (artikal.getOdeljenje() == null) continue;
                for (Odeljenje o : artikal.getOdeljenja()) {
                    prolazi = this.odeljenje.equals(o);
                    if (prolazi && (artikal.getTip() == TipArtikla.SLOZ || artikal.getTip() == TipArtikla.DODA)) {
                        for (Kartica k : SkidanjeNormativa.napraviKarticeOdeljenjeRekPoOdeljenju(SkidanjeNormativa.razloziArtikalPoOdeljenju(artikal, (Double)artikal_kolicina.get(artikal), this.server, artikal.getOdeljenje(), aktivanUtrosakDoc.getDatum()), this.server, o, aktivanUtrosakDoc.getDatum())) {
                            boolean b = true;
                            for (Kartica k2 : karticaList) {
                                if (k.getArtikal().getId() != k2.getArtikal().getId() || k.getArtikal().getOdeljenje().getId() != k2.getArtikal().getOdeljenje().getId()) continue;
                                k2.setKolicina(BigDecimal.valueOf(k2.getKolicina() + k.getKolicina()).setScale(4, RoundingMode.HALF_EVEN).doubleValue());
                                b = false;
                            }
                            if (!b) continue;
                            k.setDokument("");
                            k.setCrno(false);
                            karticaList.add(k);
                        }
                    }
                    if (!prolazi) continue;
                    for (Kartica kartica : karticaList) {
                        if (kartica.getArtikal().getTip() == TipArtikla.SLOZ || kartica.getArtikal().getTip() == TipArtikla.DODA) continue;
                        normativ_kolicina.put(kartica.getArtikal(), kartica.getKolicina() * -1.0);
                    }
                    for (Artikal artikal1 : normativ_kolicina.keySet()) {
                        if (!konacnaLista.containsKey(artikal1)) {
                            konacnaLista.put(artikal1, normativ_kolicina.get(artikal1));
                            continue;
                        }
                        konacnaLista.put(artikal1, (Double)konacnaLista.get(artikal1) + (Double)normativ_kolicina.get(artikal1));
                    }
                    if (artikal.getTip() != TipArtikla.PROD && artikal.getTip() != TipArtikla.POLU && artikal.getTip() != TipArtikla.SIRO) continue;
                    if (!konacnaLista.containsKey(artikal)) {
                        konacnaLista.put(artikal, artikal_kolicina.get(artikal));
                        continue;
                    }
                    konacnaLista.put(artikal, (Double)konacnaLista.get(artikal) + (Double)artikal_kolicina.get(artikal));
                }
            }
            for (Artikal artikal1 : konacnaLista.keySet()) {
                UtrosakDocUtrosak utrosak = new UtrosakDocUtrosak();
                utrosak.setUtrosakDoc(aktivanUtrosakDoc);
                utrosak.setArtikal(artikal1);
                utrosak.setOdeljenje(artikal1.getOdeljenje());
                utrosak.setKolicina(BigDecimal.valueOf((Double)konacnaLista.get(artikal1)).setScale(4, RoundingMode.HALF_EVEN).doubleValue());
                utrosak.setNabavnaCena(artikal1.getTip() != TipArtikla.POLU ? this.server.getLastNabavnaCenaBelaBezPDV(artikal1, aktivanUtrosakDoc.getDatum()) : this.server.getNabavnaCenaPoluproizvodBezPDV(artikal1, 1.0));
                this.server.insertUDocUtrosak(utrosak);
            }
            upis = true;
        }
        catch (Exception e) {
            upis = false;
            e.printStackTrace();
        }
        return upis;
    }
}

