/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.sistem;

import Stampa.core.GridPrinter;
import Stampa.core.ImageCache;
import Stampa.test.PrintHandler;
import Stampa.test.TableWrapper;
import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.restoran.Dugmici;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.PopisProvera;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.SkidanjeNormativa;
import com.dev63.restoran.model.Artikal;
import com.dev63.restoran.model.Kartica;
import com.dev63.restoran.model.Odeljenje;
import com.dev63.restoran.model.Proizvodnja;
import com.dev63.restoran.model.ProizvodnjaStavka;
import com.dev63.restoran.model.ProizvodnjaUtrosak;
import com.dev63.restoran.model.TipArtikla;
import com.dev63.restoran.parts.DateInput2;
import com.dev63.restoran.parts.DoubleInput2;
import com.dev63.restoran.parts.InputException;
import com.dev63.restoran.sistem.CalendarAdapter;
import com.dev63.restoran.stampa.UskaStampa;
import com.dev63.restoran.swt.components.SWTMessage;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.SortedMap;
import javax.persistence.EntityManager;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class UnosProizvodnje {
    private final ResourceBundle barmasterText = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale());
    RestoranServer server;
    SWTContainer parent;
    DateInput2 datum;
    final Table table;
    Button plus;
    Button minus;
    Odeljenje u;
    List<ProizvodnjaStavka> stavke = new ArrayList<ProizvodnjaStavka>();
    Shell shell;
    String brTreb;
    Text pretraga;
    Combo artikal;
    DoubleInput2 cenaKomad;
    Button crno;
    boolean inspektor = false;
    boolean cr = false;
    Proizvodnja proizvodnja;

    public UnosProizvodnje(SWTContainer owner, final Restoran restoran, final Odeljenje odeljenjeU, boolean inspektor, Proizvodnja active) {
        this.server = restoran.getServer();
        this.parent = owner;
        this.proizvodnja = active;
        this.shell = this.parent.getControl().getShell();
        this.u = odeljenjeU;
        this.inspektor = inspektor;
        if (this.proizvodnja != null) {
            for (ProizvodnjaStavka ps : this.server.readStavkePregledaProizvodnje(this.proizvodnja)) {
                this.stavke.add(ps);
            }
        }
        Label pm = new Label((Composite)this.shell, 0);
        pm.setText(this.u.getNaziv());
        pm.setBackground(this.shell.getDisplay().getSystemColor(22));
        Label dat = new Label((Composite)this.shell, 0);
        dat.setText(String.format(this.barmasterText.getString("TEXT_DATUM_PROIZVODNJE"), new Object[0]) + ":");
        dat.setBackground(this.shell.getDisplay().getSystemColor(22));
        this.datum = new DateInput2(this.parent, String.format(this.barmasterText.getString("TEXT_DATUM_PROIZVODNJE"), new Object[0]), new Date(this.server.getLastDateZD().getTime()), false, this.server);
        this.datum.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.datum, this.shell));
        new Label((Composite)this.shell, 0).setText("Dodatno:");
        this.crno = new Button((Composite)this.shell, 32);
        Label separator1 = new Label((Composite)this.shell, 258);
        this.table = new Table((Composite)this.shell, 68356);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        TableColumn nazivArtikla = new TableColumn(this.table, 0x1000000);
        nazivArtikla.setText(String.format(this.barmasterText.getString("TEXT_NAZIV_ARTIKLA"), new Object[0]));
        nazivArtikla.setWidth(210);
        TableColumn kolicina = new TableColumn(this.table, 0x1000000);
        kolicina.setText(String.format(this.barmasterText.getString("TEXT_KOLICINA"), new Object[0]));
        kolicina.setWidth(110);
        TableColumn jmere = new TableColumn(this.table, 0x1000000);
        jmere.setText(String.format(this.barmasterText.getString("TEXT_JEDINICA_MERE_SKR"), new Object[0]));
        jmere.setWidth(140);
        if (!this.stavke.isEmpty()) {
            this.reloadTable(this.stavke);
        }
        this.plus = Dugmici.getPlusButton((Composite)this.shell);
        this.plus.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                UnosProizvodnje.this.unosStavkeProizvodnje(UnosProizvodnje.this.shell, UnosProizvodnje.this.table);
            }
        });
        this.minus = Dugmici.getMinusButton((Composite)this.shell);
        this.minus.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                int i = UnosProizvodnje.this.table.getSelectionIndex();
                if (i == -1) {
                    return;
                }
                UnosProizvodnje.this.table.remove(i);
                UnosProizvodnje.this.stavke.remove(i);
            }
        });
        if (this.proizvodnja != null) {
            Button printButt = new Button((Composite)this.shell, 8);
            try {
                printButt.setImage(ImageCache.getImage("print.gif"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            printButt.setText(String.format(this.barmasterText.getString("TEXT_STAMPA"), new Object[0]));
            printButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    GridPrinter gp = new GridPrinter(new PrintHandler());
                    gp.printTable(new TableWrapper(UnosProizvodnje.this.table), false, true, String.format(UnosProizvodnje.this.barmasterText.getString("TEXT_PROIZVODNJA"), new Object[0]) + UnosProizvodnje.this.proizvodnja.getId() + "\nDatum: " + Konstante.getDate(UnosProizvodnje.this.proizvodnja.getDatum()) + "\nNapomena:" + UnosProizvodnje.this.proizvodnja.getOdeljenje(), UnosProizvodnje.this.shell, UnosProizvodnje.this.server);
                }
            });
            Button uska = new Button((Composite)this.shell, 8);
            uska.setText(String.format(this.barmasterText.getString("TEXT_USKA_STAMPA"), new Object[0]));
            uska.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    new UskaStampa(UnosProizvodnje.this.proizvodnja, restoran);
                }
            });
        }
        Label separator2 = new Label((Composite)this.shell, 258);
        Button cancelButt = Dugmici.getCancelButton(this.shell);
        cancelButt.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                UnosProizvodnje.this.parent.getControl().getShell().close();
            }
        });
        Button helpButt = Dugmici.getHelpButton(this.shell);
        helpButt.addListener(13, new Listener(){

            public void handleEvent(Event e) {
            }
        });
        Button okButt = Dugmici.getOkButton(this.shell);
        okButt.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                try {
                    PopisProvera provera = new PopisProvera(UnosProizvodnje.this.server, UnosProizvodnje.this.shell, UnosProizvodnje.this.datum.getResult(), odeljenjeU, true);
                    if (provera.isPopis()) {
                        provera.setValidDate(UnosProizvodnje.this.datum);
                        return;
                    }
                }
                catch (InputException e1) {
                    e1.printStackTrace();
                }
                if (UnosProizvodnje.this.stavke.isEmpty()) {
                    Konstante.getPoruka(UnosProizvodnje.this.shell, String.format(UnosProizvodnje.this.barmasterText.getString("PORUKA_MORATE_UNETI_PODATKE_ZA_BAR_JEDAN_ARTIKAL"), new Object[0]));
                    return;
                }
                try {
                    if (UnosProizvodnje.this.datum.getResult().after(new Date())) {
                        Konstante.getPoruka(UnosProizvodnje.this.shell, String.format(UnosProizvodnje.this.barmasterText.getString("PORUKA_UNETI_DATUM_JE_NEPRIHVATLJIV"), new Object[0]));
                        return;
                    }
                    UnosProizvodnje.this.server.refresh();
                    if (UnosProizvodnje.this.proizvodnja == null) {
                        UnosProizvodnje.this.proizvodnja = new Proizvodnja();
                        UnosProizvodnje.this.proizvodnja.setDatum(UnosProizvodnje.this.datum.getResult());
                        UnosProizvodnje.this.proizvodnja.setDatumUnosa(new Date());
                        UnosProizvodnje.this.proizvodnja.setCrno(UnosProizvodnje.this.crno.getSelection());
                        UnosProizvodnje.this.proizvodnja.setOdeljenje(UnosProizvodnje.this.u);
                        UnosProizvodnje.this.server.addProizvodnja(UnosProizvodnje.this.proizvodnja);
                    } else {
                        for (ProizvodnjaStavka ts : UnosProizvodnje.this.server.readStavkePregledaProizvodnje(UnosProizvodnje.this.proizvodnja)) {
                            UnosProizvodnje.this.server.deleteProizvodnjaStavka(ts);
                        }
                        for (ProizvodnjaUtrosak pu : UnosProizvodnje.this.server.readProizvodnjaUtrosak(UnosProizvodnje.this.proizvodnja)) {
                            UnosProizvodnje.this.server.deleteProizvodnjaUtrosak(pu);
                        }
                    }
                    for (ProizvodnjaStavka ts : UnosProizvodnje.this.stavke) {
                        ts.setProizvodnja(UnosProizvodnje.this.proizvodnja);
                        ts.setId(null);
                        UnosProizvodnje.this.sacuvajStavkuProizvodnje(ts);
                    }
                    if (!UnosProizvodnje.this.unosUtrosakaProizvodnje(UnosProizvodnje.this.proizvodnja, UnosProizvodnje.this.stavke)) {
                        SWTMessage.showMessageDialog(UnosProizvodnje.this.shell, "Neuspesan upis utrosaka u tabeli proizvodnjautrosak", String.format(UnosProizvodnje.this.barmasterText.getString("TEXT_UPOZORENJE"), new Object[0]), 2);
                        return;
                    }
                    UnosProizvodnje.this.shell.close();
                }
                catch (InputException inputException) {
                    // empty catch block
                }
            }
        });
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.verticalSpacing = 10;
        layout.horizontalSpacing = 10;
        this.shell.setLayout((Layout)layout);
        GridData data = new GridData();
        data.widthHint = 150;
        data.horizontalAlignment = 16384;
        data.horizontalSpan = 3;
        pm.setLayoutData((Object)data);
        data = new GridData();
        data.widthHint = 150;
        data.horizontalAlignment = 16384;
        data.horizontalSpan = 2;
        dat.setLayoutData((Object)data);
        data = new GridData();
        data.widthHint = 150;
        data.horizontalAlignment = 16384;
        this.datum.getControl().setLayoutData((Object)data);
        this.crno.setLayoutData((Object)data);
        data = new GridData();
        data.horizontalSpan = 3;
        data = new GridData(768);
        data.horizontalSpan = 3;
        separator1.setLayoutData((Object)data);
        separator2.setLayoutData((Object)data);
        data = new GridData(768);
        data.horizontalSpan = 3;
        data.heightHint = 250;
        this.table.setLayoutData((Object)data);
        data = new GridData(768);
        data.horizontalSpan = 3;
        data.heightHint = 60;
        data = new GridData();
        data.widthHint = 250;
        data.horizontalAlignment = 16384;
        this.shell.open();
    }

    protected synchronized boolean unosUtrosakaProizvodnje(Proizvodnja p, List<ProizvodnjaStavka> stavke) {
        System.out.println("ovde kreiram utroske proizvodnje");
        EntityManager base = this.server.getBase();
        boolean upis = false;
        try {
            HashMap<Artikal, Double> artikal_kolicina = new HashMap<Artikal, Double>();
            HashMap normativ_kolicina = new HashMap();
            HashMap<Artikal, Double> konacnaLista = new HashMap<Artikal, Double>();
            boolean prolazi = false;
            for (ProizvodnjaStavka proizvodnjaStavka : stavke) {
                artikal_kolicina.put(proizvodnjaStavka.getArtikal(), proizvodnjaStavka.getKolicina());
            }
            ArrayList<Kartica> karticaList = new ArrayList<Kartica>();
            for (Artikal artikal : artikal_kolicina.keySet()) {
                if (artikal.getOdeljenje() == null) continue;
                for (Odeljenje o : artikal.getOdeljenja()) {
                    prolazi = this.u.equals(o);
                    if (!prolazi || artikal == null || artikal.getTip() != TipArtikla.POLU) continue;
                    for (Kartica k : SkidanjeNormativa.napraviKarticeOdeljenje22(SkidanjeNormativa.razloziArtikalPoluproizvodProizvodnja(artikal, (Double)artikal_kolicina.get(artikal), this.server, p.getDatum()), this.server, o, p.getDatum())) {
                        boolean b = true;
                        for (Kartica k2 : karticaList) {
                            if (!k.getArtikal().getId().equals(k2.getArtikal().getId()) || !k.getArtikal().getOdeljenje().getId().equals(k2.getArtikal().getOdeljenje().getId())) continue;
                            k2.setKolicina(BigDecimal.valueOf(k2.getKolicina() + k.getKolicina()).setScale(4, RoundingMode.HALF_EVEN).doubleValue());
                            b = false;
                        }
                        if (!b) continue;
                        k.setDokument("");
                        k.setCrno(false);
                        karticaList.add(k);
                    }
                }
            }
            if (prolazi) {
                for (Kartica kartica : karticaList) {
                    konacnaLista.put(kartica.getArtikal(), kartica.getKolicina() * -1.0);
                }
                for (Map.Entry entry : konacnaLista.entrySet()) {
                    ProizvodnjaUtrosak proizvodnjaUtrosak = new ProizvodnjaUtrosak();
                    proizvodnjaUtrosak.setProizvodnja(p);
                    proizvodnjaUtrosak.setArtikal((Artikal)entry.getKey());
                    proizvodnjaUtrosak.setOdeljenje(((Artikal)entry.getKey()).getOdeljenje());
                    proizvodnjaUtrosak.setKolicina(BigDecimal.valueOf((Double)entry.getValue()).setScale(4, RoundingMode.HALF_EVEN).doubleValue());
                    proizvodnjaUtrosak.setNabavnaCena(((Artikal)entry.getKey()).getTip() != TipArtikla.POLU ? this.server.getLastNabavnaCenaBelaBezPDV((Artikal)entry.getKey(), p.getDatum()) : this.server.getNabavnaCenaPoluproizvodBezPDV((Artikal)entry.getKey(), 1.0));
                    this.server.insertPU(proizvodnjaUtrosak);
                }
                upis = true;
            }
        }
        catch (Exception e) {
            upis = false;
        }
        return upis;
    }

    public void unosStavkeProizvodnje(Shell shell, Table table) {
        final Shell shell2 = new Shell(shell.getDisplay(), 67680);
        shell2.setBackground(shell.getDisplay().getSystemColor(22));
        Monitor primary = shell2.getDisplay().getPrimaryMonitor();
        Rectangle bounds = primary.getBounds();
        Rectangle rect = shell2.getBounds();
        int x = bounds.x + rect.width / 2;
        int y = bounds.y + rect.height / 2;
        shell2.setLocation(x, y);
        SortedMap<String, Long> artikli = this.server.getPoluproizvodi(this.u);
        final SWTContainer parent2 = new SWTContainer((Composite)shell2);
        Label pk2 = new Label((Composite)shell2, 0);
        pk2.setText(String.format(this.barmasterText.getString("TEXT_STANJE"), new Object[0]) + " (" + this.u.getNaziv().toLowerCase() + ")");
        pk2.setBackground(shell2.getDisplay().getSystemColor(22));
        final Label preostalaKol2 = new Label((Composite)shell2, 0);
        preostalaKol2.setText("");
        preostalaKol2.setBackground(shell2.getDisplay().getSystemColor(22));
        Label p = new Label((Composite)shell2, 0);
        p.setText(String.format(this.barmasterText.getString("TEXT_PRETRAGA"), new Object[0]) + ":");
        p.setBackground(shell.getDisplay().getSystemColor(22));
        this.pretraga = new Text((Composite)shell2, 0);
        this.pretraga.addListener(2, new Listener(){

            public void handleEvent(Event e) {
                if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    String str = UnosProizvodnje.this.pretraga.getText();
                    UnosProizvodnje.this.artikal.removeAll();
                    for (String s : UnosProizvodnje.this.server.getPoluproizvodiByNameBarCode(UnosProizvodnje.this.u.getId(), str).keySet()) {
                        UnosProizvodnje.this.artikal.add(s);
                    }
                    UnosProizvodnje.this.artikal.select(0);
                    if (UnosProizvodnje.this.artikal.getSelectionIndex() >= 0) {
                        double preostalo = 0.0;
                        try {
                            preostalo = UnosProizvodnje.this.server.getLagerZaArtikal(UnosProizvodnje.this.server.getArtikal(UnosProizvodnje.this.artikal.getItem(UnosProizvodnje.this.artikal.getSelectionIndex())), UnosProizvodnje.this.crno.getSelection(), UnosProizvodnje.this.u, UnosProizvodnje.this.datum.getResult());
                        }
                        catch (InputException e1) {
                            e1.printStackTrace();
                        }
                        preostalaKol2.setText(String.valueOf(preostalo));
                    }
                }
            }
        });
        Label a = new Label((Composite)shell2, 0);
        a.setText(String.format(this.barmasterText.getString("TEXT_ARTIKAL"), new Object[0]) + ":");
        a.setBackground(shell2.getDisplay().getSystemColor(22));
        this.artikal = new Combo((Composite)shell2, 2572);
        for (String s : artikli.keySet()) {
            this.artikal.add(s);
        }
        this.artikal.select(0);
        double preostalaKolicina = 0.0;
        try {
            preostalaKolicina = this.server.getLagerZaArtikal(this.server.getArtikal(this.artikal.getItem(this.artikal.getSelectionIndex())), this.crno.getSelection(), this.u, this.datum.getResult());
        }
        catch (InputException e1) {
            e1.printStackTrace();
        }
        if (this.artikal.getSelectionIndex() >= 0) {
            preostalaKol2.setText(String.valueOf(preostalaKolicina));
        }
        this.artikal.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Artikal art = UnosProizvodnje.this.server.getArtikal(UnosProizvodnje.this.artikal.getItem(UnosProizvodnje.this.artikal.getSelectionIndex()));
                double preostalaKolicina = 0.0;
                try {
                    preostalaKolicina = UnosProizvodnje.this.server.getLagerZaArtikal(art, UnosProizvodnje.this.crno.getSelection(), UnosProizvodnje.this.u, UnosProizvodnje.this.datum.getResult());
                }
                catch (InputException e1) {
                    e1.printStackTrace();
                }
                preostalaKol2.setText(String.valueOf(preostalaKolicina));
            }
        });
        Label k = new Label((Composite)shell2, 0);
        k.setText(String.format(this.barmasterText.getString("TEXT_KOLICINA"), new Object[0]) + ":");
        k.setBackground(shell2.getDisplay().getSystemColor(22));
        final DoubleInput2 kolicina = new DoubleInput2(parent2, String.format(this.barmasterText.getString("TEXT_KOLICINA"), new Object[0]), false);
        Button cancelButt = Dugmici.getCancelButton(shell2);
        cancelButt.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                parent2.getControl().getShell().close();
            }
        });
        Button okButt = Dugmici.getOkButton(shell2);
        okButt.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                try {
                    if (UnosProizvodnje.this.artikal.getSelectionIndex() == -1 || kolicina.getText().length() == 0) {
                        return;
                    }
                    Artikal art = UnosProizvodnje.this.server.getArtikal(UnosProizvodnje.this.artikal.getItem(UnosProizvodnje.this.artikal.getSelectionIndex()));
                    ProizvodnjaStavka ts = new ProizvodnjaStavka();
                    ts.setArtikal(art);
                    ts.setKolicina(kolicina.getResult());
                    UnosProizvodnje.this.stavke.add(ts);
                    UnosProizvodnje.this.reloadTable(UnosProizvodnje.this.stavke);
                    shell2.close();
                }
                catch (InputException ex) {
                    Konstante.getPoruka(shell2, ex.getMessage());
                }
            }
        });
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.verticalSpacing = 10;
        layout.horizontalSpacing = 10;
        shell2.setLayout((Layout)layout);
        GridData data = new GridData();
        data.widthHint = 200;
        data.horizontalAlignment = 131072;
        this.artikal.setLayoutData((Object)data);
        data = new GridData();
        data.widthHint = 150;
        data.heightHint = 30;
        data.horizontalAlignment = 16384;
        a.setLayoutData((Object)data);
        k.setLayoutData((Object)data);
        this.pretraga.setLayoutData((Object)data);
        preostalaKol2.setLayoutData((Object)data);
        kolicina.getControl().setLayoutData((Object)data);
        data = new GridData();
        data.widthHint = 150;
        data.horizontalAlignment = 131072;
        shell2.pack();
        shell2.open();
    }

    private void reloadTable(List<ProizvodnjaStavka> stavke) {
        this.table.removeAll();
        if (!stavke.isEmpty()) {
            for (ProizvodnjaStavka ps : stavke) {
                TableItem item = new TableItem(this.table, 0);
                String n = ps.getArtikal().getName();
                double nabavnaCena = ps.getArtikal().getTip() != TipArtikla.POLU ? this.server.getLastNabavnaCenaBelaBezPDV(ps.getArtikal(), this.proizvodnja.getDatum()) : this.server.getNabavnaCenaPoluproizvodBezPDV(ps.getArtikal(), 1.0);
                item.setText(new String[]{n, Konstante.getNumber4(ps.getKolicina()), ps.getArtikal().getJedinicaMere(), Konstante.getNumber2(nabavnaCena / ps.getKolicina()), Konstante.getNumber2(nabavnaCena)});
            }
        }
    }

    public void sacuvajStavkuProizvodnje(ProizvodnjaStavka ts) throws InputException {
        Artikal art = ts.getArtikal();
        if (art.getTip().equals((Object)TipArtikla.POLU)) {
            this.server.addProizvodnjaStavka(ts);
        }
    }
}

