/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.sistem;

import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.restoran.Dugmici;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.SWTContainerClass;
import com.dev63.restoran.model.Artikal;
import com.dev63.restoran.model.DnevnoStanje;
import com.dev63.restoran.model.Kartica;
import com.dev63.restoran.model.Odeljenje;
import com.dev63.restoran.model.Option;
import com.dev63.restoran.model.TipArtikla;
import com.dev63.restoran.model.Trebovanje;
import com.dev63.restoran.model.TrebovanjeStavka;
import com.dev63.restoran.parts.DateInput2;
import com.dev63.restoran.parts.DoubleInput2;
import com.dev63.restoran.parts.InputException;
import com.dev63.restoran.sistem.CalendarAdapter;
import com.dev63.restoran.sistem.PreostalaKolicina;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.SortedMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class UnosMedjutreb {
    RestoranServer server;
    SWTContainer parent;
    Combo dobavljac;
    DateInput2 datum;
    DateInput2 datum2;
    final Table table;
    Button plus;
    Button minus;
    Odeljenje iz;
    Odeljenje u;
    String brTreb;
    List<TrebovanjeStavka> stavke = new ArrayList<TrebovanjeStavka>();
    Shell shell;
    Label total;
    double ukupnaVred = 0.0;
    Boolean poPoslednjimCenama;
    Text pretraga;
    Combo artikal;
    Label tv2;
    DoubleInput2 cenaKomad;
    Button crno;

    public UnosMedjutreb(SWTContainer owner, Restoran restoran, final Odeljenje iz, final Odeljenje u) {
        this.server = restoran.getServer();
        this.parent = owner;
        this.shell = this.parent.getControl().getShell();
        this.iz = iz;
        this.u = u;
        this.poPoslednjimCenama = this.server.getSetting(Option.PO_POSLEDNJIM_UNETIM_CENAMA).booleanValue();
        Label pm = new Label((Composite)this.shell, 0);
        pm.setText(iz.getNaziv() + " --> " + u.getNaziv());
        pm.setBackground(this.shell.getDisplay().getSystemColor(22));
        Label dat = new Label((Composite)this.shell, 0);
        dat.setText("Datum prijema:");
        dat.setBackground(this.shell.getDisplay().getSystemColor(22));
        this.datum = new DateInput2(this.parent, "Datum prijema", new Date(this.server.getLastDateZD().getTime()), false, this.server);
        this.datum.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.datum, this.shell));
        Label dat2 = new Label((Composite)this.shell, 0);
        dat2.setText("Datum azuriranja:");
        dat2.setBackground(this.shell.getDisplay().getSystemColor(22));
        this.datum2 = new DateInput2(this.parent, "Datum azuriranja", new Date(this.server.getLastDateZD().getTime()), false, this.server);
        this.datum2.getControl().setEnabled(false);
        Label c = new Label((Composite)this.shell, 0);
        c.setText("Dodatne zalihe");
        c.setBackground(this.shell.getDisplay().getSystemColor(22));
        this.crno = new Button((Composite)this.shell, 32);
        Label opisL = new Label((Composite)this.shell, 0);
        opisL.setText("Opis:");
        opisL.setBackground(this.shell.getDisplay().getSystemColor(22));
        final Text opis = new Text((Composite)this.shell, 2560);
        Label separator1 = new Label((Composite)this.shell, 258);
        this.table = new Table((Composite)this.shell, 68356);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        TableColumn nazivArtikla = new TableColumn(this.table, 0x1000000);
        nazivArtikla.setText("Naziv artikla");
        nazivArtikla.setWidth(200);
        TableColumn kolicina = new TableColumn(this.table, 0x1000000);
        kolicina.setText("Kolicina");
        kolicina.setWidth(110);
        TableColumn jmere = new TableColumn(this.table, 0x1000000);
        jmere.setText("J.M");
        jmere.setWidth(110);
        TableColumn cKomad = new TableColumn(this.table, 0x1000000);
        cKomad.setText("Cena kom.");
        cKomad.setWidth(110);
        TableColumn nv = new TableColumn(this.table, 0x1000000);
        nv.setText("Ukup. vred.");
        nv.setWidth(130);
        this.plus = Dugmici.getPlusButton((Composite)this.shell);
        this.plus.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                UnosMedjutreb.this.unosStavkeTrebovanja(UnosMedjutreb.this.shell, UnosMedjutreb.this.table);
            }
        });
        this.minus = Dugmici.getMinusButton((Composite)this.shell);
        this.minus.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                int i = UnosMedjutreb.this.table.getSelectionIndex();
                Double d = Double.valueOf(UnosMedjutreb.this.table.getItem(i).getText(4).replace(',', '.'));
                UnosMedjutreb.this.table.remove(i);
                UnosMedjutreb.this.stavke.remove(i);
                UnosMedjutreb.this.ukupnaVred -= d.doubleValue();
                UnosMedjutreb.this.total.setText(Konstante.getNumber2(UnosMedjutreb.this.ukupnaVred) + " din");
            }
        });
        Label separator2 = new Label((Composite)this.shell, 258);
        Label t = new Label((Composite)this.shell, 0);
        t.setText("Ukupna vrednost trebovanja:");
        t.setBackground(this.shell.getDisplay().getSystemColor(22));
        this.total = new Label((Composite)this.shell, 0);
        this.total.setText("");
        this.total.setBackground(this.shell.getDisplay().getSystemColor(22));
        Label separator3 = new Label((Composite)this.shell, 258);
        Button cancelButt = Dugmici.getCancelButton(this.shell);
        cancelButt.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                UnosMedjutreb.this.parent.getControl().getShell().close();
            }
        });
        Button helpButt = Dugmici.getHelpButton(this.shell);
        helpButt.addListener(13, new Listener(){

            public void handleEvent(Event e) {
            }
        });
        Button okButt = Dugmici.getOkButton(this.shell);
        okButt.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (UnosMedjutreb.this.stavke.size() < 1) {
                    Konstante.getPoruka(UnosMedjutreb.this.shell, "Morate uneti podatke za bar jedan artikal !");
                    return;
                }
                Calendar dc = Calendar.getInstance();
                try {
                    if (UnosMedjutreb.this.datum.getResult().after(new Date())) {
                        Konstante.getPoruka(UnosMedjutreb.this.shell, "Uneti datum je neprihvatljiv!");
                        return;
                    }
                }
                catch (InputException ex) {
                    Logger.getLogger(UnosMedjutreb.class.getName()).log(Level.SEVERE, null, ex);
                }
                Trebovanje t = new Trebovanje();
                try {
                    int broj;
                    if (UnosMedjutreb.this.crno.getSelection()) {
                        broj = UnosMedjutreb.this.server.sledeciBrojTreb2();
                        UnosMedjutreb.this.brTreb = broj + "/2";
                    } else {
                        broj = UnosMedjutreb.this.server.sledeciBrojTreb();
                        UnosMedjutreb.this.brTreb = broj + "/" + dc.get(1);
                    }
                    dc.setTime(UnosMedjutreb.this.datum.getResult());
                    t.setBrTrebovanja(UnosMedjutreb.this.brTreb);
                    t.setIz(iz);
                    t.setU(u);
                    t.setDobavljac(null);
                    t.setDatumTrebovanja(UnosMedjutreb.this.datum.getResult());
                    t.setDatumUnosa(UnosMedjutreb.this.datum2.getResult());
                    t.setUname("");
                    t.setOpis(opis.getText());
                    t.setCrno(UnosMedjutreb.this.crno.getSelection());
                    t.setId(UnosMedjutreb.this.server.addTrebovanje(t));
                    for (TrebovanjeStavka ts : UnosMedjutreb.this.stavke) {
                        ts.setTrebovanje(t);
                        UnosMedjutreb.this.sacuvajStavkuTrebovanja(ts);
                    }
                    if (UnosMedjutreb.this.crno.getSelection()) {
                        UnosMedjutreb.this.server.incrementBrojTreb2(String.valueOf(broj + 1));
                    } else {
                        UnosMedjutreb.this.server.incrementBrojTreb(String.valueOf(broj + 1));
                    }
                    UnosMedjutreb.this.shell.close();
                }
                catch (InputException inputException) {
                    // empty catch block
                }
            }
        });
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.verticalSpacing = 10;
        layout.horizontalSpacing = 10;
        this.shell.setLayout((Layout)layout);
        GridData data = new GridData();
        data.widthHint = 250;
        data.horizontalAlignment = 16384;
        data.horizontalSpan = 3;
        pm.setLayoutData((Object)data);
        data = new GridData();
        data.widthHint = 150;
        data.horizontalAlignment = 16384;
        dat.setLayoutData((Object)data);
        dat2.setLayoutData((Object)data);
        c.setLayoutData((Object)data);
        data = new GridData();
        data.widthHint = 150;
        data.horizontalSpan = 2;
        data.horizontalAlignment = 131072;
        data.heightHint = 25;
        this.datum.getControl().setLayoutData((Object)data);
        this.datum2.getControl().setLayoutData((Object)data);
        this.crno.setLayoutData((Object)data);
        this.total.setLayoutData((Object)data);
        data = new GridData();
        data.horizontalSpan = 3;
        opisL.setLayoutData((Object)data);
        data = new GridData(768);
        data.horizontalSpan = 3;
        separator1.setLayoutData((Object)data);
        separator2.setLayoutData((Object)data);
        separator3.setLayoutData((Object)data);
        data = new GridData();
        data.horizontalSpan = 3;
        data.heightHint = 200;
        this.table.setLayoutData((Object)data);
        data = new GridData(768);
        data.horizontalSpan = 3;
        data.heightHint = 60;
        opis.setLayoutData((Object)data);
        SWTContainerClass.setDimension(this.shell);
        this.shell.open();
    }

    public void unosStavkeTrebovanja(Shell shell, final Table table) {
        final Shell shell2 = new Shell(shell.getDisplay());
        shell2.setBackground(shell.getDisplay().getSystemColor(22));
        Monitor primary = shell2.getDisplay().getPrimaryMonitor();
        Rectangle bounds = primary.getBounds();
        Rectangle rect = shell2.getBounds();
        int x = bounds.x + rect.width / 2;
        int y = bounds.y + rect.height / 2;
        shell2.setLocation(x, y);
        SortedMap<String, Long> artikli = this.server.getArtikliBezSloz(this.u.getId(), this.iz.getId());
        final SWTContainer parent2 = new SWTContainer((Composite)shell2);
        Label pk = new Label((Composite)shell2, 0);
        pk.setText("Stanje (" + this.iz.getNaziv().toLowerCase() + ")");
        pk.setBackground(shell2.getDisplay().getSystemColor(22));
        final Label preostalaKol = new Label((Composite)shell2, 0);
        preostalaKol.setText("");
        preostalaKol.setBackground(shell2.getDisplay().getSystemColor(22));
        Label pk2 = new Label((Composite)shell2, 0);
        pk2.setText("Stanje (" + this.u.getNaziv().toLowerCase() + ")");
        pk2.setBackground(shell2.getDisplay().getSystemColor(22));
        final Label preostalaKol2 = new Label((Composite)shell2, 0);
        preostalaKol2.setText("");
        preostalaKol2.setBackground(shell2.getDisplay().getSystemColor(22));
        Label p = new Label((Composite)shell2, 0);
        p.setText("Pretraga:");
        p.setBackground(shell.getDisplay().getSystemColor(22));
        this.pretraga = new Text((Composite)shell2, 0);
        this.pretraga.addListener(2, new Listener(){

            public void handleEvent(Event e) {
                String str = UnosMedjutreb.this.pretraga.getText();
                UnosMedjutreb.this.artikal.removeAll();
                for (String s : UnosMedjutreb.this.server.getArtikliByNameOrBarCode(UnosMedjutreb.this.iz.getId(), UnosMedjutreb.this.u.getId(), str).keySet()) {
                    UnosMedjutreb.this.artikal.add(s);
                }
                UnosMedjutreb.this.artikal.select(0);
            }
        });
        Label a = new Label((Composite)shell2, 0);
        a.setText("Artikal:");
        a.setBackground(shell2.getDisplay().getSystemColor(22));
        this.artikal = new Combo((Composite)shell2, 2572);
        for (String s : artikli.keySet()) {
            this.artikal.add(s);
        }
        this.artikal.select(0);
        this.artikal.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                UnosMedjutreb.this.tv2.setText(Konstante.getNumber2(UnosMedjutreb.this.server.getArtikal(UnosMedjutreb.this.artikal.getItem(UnosMedjutreb.this.artikal.getSelectionIndex())).getTrenutnaNV()));
            }
        });
        this.artikal.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Artikal art = UnosMedjutreb.this.server.getArtikal(UnosMedjutreb.this.artikal.getItem(UnosMedjutreb.this.artikal.getSelectionIndex()));
                Double zaliheIz = 0.0;
                Double zaliheU = 0.0;
                if (UnosMedjutreb.this.crno.getSelection()) {
                    zaliheIz = PreostalaKolicina.izracunajZaliheCrne(art, UnosMedjutreb.this.iz, UnosMedjutreb.this.server);
                    zaliheU = PreostalaKolicina.izracunajZaliheCrne(art, UnosMedjutreb.this.u, UnosMedjutreb.this.server);
                } else {
                    zaliheIz = PreostalaKolicina.izracunajZaliheBele(art, UnosMedjutreb.this.iz, UnosMedjutreb.this.server);
                    zaliheU = PreostalaKolicina.izracunajZaliheBele(art, UnosMedjutreb.this.u, UnosMedjutreb.this.server);
                }
                preostalaKol.setText(Konstante.getNumber4(zaliheIz));
                preostalaKol2.setText(Konstante.getNumber4(zaliheU));
            }
        });
        Label k = new Label((Composite)shell2, 0);
        k.setText("Kolicina :");
        k.setBackground(shell2.getDisplay().getSystemColor(22));
        final DoubleInput2 kolicina = new DoubleInput2(parent2, "Kolicina", false);
        Label tv = new Label((Composite)shell2, 0);
        tv.setText("Trenutna nab. vr.");
        tv.setBackground(shell2.getDisplay().getSystemColor(22));
        this.tv2 = new Label((Composite)shell2, 0);
        this.tv2.setBackground(shell2.getDisplay().getSystemColor(22));
        Button cancelButt = Dugmici.getCancelButton(shell2);
        cancelButt.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                parent2.getControl().getShell().close();
            }
        });
        Button okButt = Dugmici.getOkButton(shell2);
        okButt.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                try {
                    Artikal art = UnosMedjutreb.this.server.getArtikal(UnosMedjutreb.this.artikal.getItem(UnosMedjutreb.this.artikal.getSelectionIndex()));
                    TrebovanjeStavka ts = new TrebovanjeStavka();
                    ts.setArtikalId(art);
                    ts.setKolicina(kolicina.getResult());
                    ts.setKomad(art.getTrenutnaNV());
                    UnosMedjutreb.this.stavke.add(ts);
                    TableItem item = new TableItem(table, 0);
                    item.setText(new String[]{art.getName(), kolicina.getResult().toString(), art.getJedinicaMere(), art.getTrenutnaNV().toString(), Double.toString(art.getTrenutnaNV() * kolicina.getResult())});
                    UnosMedjutreb.this.ukupnaVred += art.getTrenutnaNV() * kolicina.getResult();
                    UnosMedjutreb.this.total.setText(Konstante.getNumber2(UnosMedjutreb.this.ukupnaVred) + " din");
                    shell2.close();
                }
                catch (InputException ex) {
                    int style = 65600;
                    MessageBox messageBox = new MessageBox(shell2, style);
                    messageBox.setText("Greska");
                    messageBox.setMessage(ex.getMessage());
                    messageBox.open();
                }
            }
        });
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.verticalSpacing = 10;
        layout.horizontalSpacing = 10;
        shell2.setLayout((Layout)layout);
        GridData data = new GridData();
        data.widthHint = 200;
        data.horizontalAlignment = 131072;
        this.artikal.setLayoutData((Object)data);
        data = new GridData();
        data.widthHint = 150;
        data.heightHint = 30;
        data.horizontalAlignment = 16384;
        a.setLayoutData((Object)data);
        k.setLayoutData((Object)data);
        pk.setLayoutData((Object)data);
        tv.setLayoutData((Object)data);
        this.tv2.setLayoutData((Object)data);
        preostalaKol.setLayoutData((Object)data);
        preostalaKol2.setLayoutData((Object)data);
        this.pretraga.setLayoutData((Object)data);
        kolicina.getControl().setLayoutData((Object)data);
        data = new GridData();
        data.widthHint = 150;
        data.horizontalAlignment = 131072;
        shell2.pack();
        shell2.open();
    }

    public void sacuvajStavkuTrebovanja(TrebovanjeStavka ts) {
        try {
            Calendar dc1 = Calendar.getInstance();
            Calendar dc2 = Calendar.getInstance();
            Artikal art = ts.getArtikal();
            Kartica kartica1 = new Kartica();
            kartica1.setArtikal(art);
            kartica1.setOdeljenje(this.iz);
            kartica1.setNabavnaCena(ts.getKomad());
            kartica1.setCrno(this.crno.getSelection());
            kartica1.setDatum(Konstante.getDatumKartica(this.datum.getResult(), this.server, 30));
            kartica1.setKolicina(-ts.getKolicina().doubleValue());
            if (art.getTip().equals((Object)TipArtikla.PROD)) {
                kartica1.setIzlazKOM((int)(ts.getKolicina() / art.getMera()));
            }
            if (this.iz.getNaziv().equals("MAGACIN")) {
                kartica1.setDokument(this.brTreb + " (tm)");
            } else {
                kartica1.setDokument(this.brTreb + " (mt)");
            }
            double trStanje1 = PreostalaKolicina.izracunajZalihe(art, this.iz, this.server);
            trStanje1 += ts.getKolicina().doubleValue();
            double vrednost1 = 0.0;
            List<Kartica> kartice = this.server.readKartice(art, this.iz);
            if (kartice.size() >= 1) {
                for (Kartica k : kartice) {
                    vrednost1 += k.getKolicina() * k.getNabavnaCena();
                }
            }
            if (trStanje1 != 0.0 && !this.poPoslednjimCenama.booleanValue()) {
                art.setTrenutnaNV(vrednost1 / trStanje1);
                this.server.updateArtikal(art);
            }
            this.server.addKartica(kartica1);
            Kartica kartica2 = new Kartica();
            kartica2.setArtikal(art);
            kartica2.setOdeljenje(this.u);
            kartica2.setNabavnaCena(ts.getKomad());
            kartica2.setCrno(this.crno.getSelection());
            kartica2.setDatum(Konstante.getDatumKartica(this.datum.getResult(), this.server, 10));
            kartica2.setKolicina(ts.getKolicina());
            if (this.iz.getNaziv().equals("MAGACIN")) {
                kartica2.setDokument(this.brTreb + " (tm)");
            } else {
                kartica2.setDokument(this.brTreb + " (mt)");
            }
            this.server.addKartica(kartica2);
            this.server.addTrebovanjeStavka(ts);
            if (this.datum.getResult().before(Konstante.getOnlyDate(new Date()))) {
                DnevnoStanje ds = new DnevnoStanje();
                ds.setDatum(this.datum.getResult());
                if (this.crno.getSelection()) {
                    ds.setCrnoIzlaz(ts.getKolicina());
                    ds.setBeloIzlaz(0.0);
                } else {
                    ds.setCrnoIzlaz(0.0);
                    ds.setBeloIzlaz(ts.getKolicina());
                }
                ds.setBeloUlaz(0.0);
                ds.setCrnoUlaz(0.0);
                ds.setOdeljenje(this.iz);
                ds.setArtikal(art.getName());
                ds.setArtikalID(art.getId());
                this.server.addDnevnoStanje(ds);
                ds = new DnevnoStanje();
                ds.setDatum(this.datum.getResult());
                if (this.crno.getSelection()) {
                    ds.setCrnoUlaz(ts.getKolicina());
                    ds.setBeloUlaz(0.0);
                } else {
                    ds.setCrnoUlaz(0.0);
                    ds.setBeloUlaz(ts.getKolicina());
                }
                ds.setBeloIzlaz(0.0);
                ds.setCrnoIzlaz(0.0);
                ds.setOdeljenje(this.u);
                ds.setArtikal(art.getName());
                ds.setArtikalID(art.getId());
                this.server.addDnevnoStanje(ds);
            }
        }
        catch (InputException ex) {
            int style = 65600;
            MessageBox messageBox = new MessageBox(this.shell, style);
            messageBox.setText("Greska");
            messageBox.setMessage(ex.getMessage());
            messageBox.open();
        }
    }
}

