/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.sistem;

import Stampa.core.GridPrinter;
import Stampa.core.ImageCache;
import Stampa.test.PrintHandler;
import Stampa.test.TableWrapper;
import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.hotel.swt.swing2swt.components.SWTOptionPane;
import com.dev63.restoran.Dugmici;
import com.dev63.restoran.ImagePath;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.Pregled.PrijemnicaPregled;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.SWTContainerClass;
import com.dev63.restoran.model.Knjizenje;
import com.dev63.restoran.model.Odeljenje;
import com.dev63.restoran.model.Option;
import com.dev63.restoran.model.Prijemnica;
import com.dev63.restoran.model.StalniGost;
import com.dev63.restoran.model.Trebovanje;
import com.dev63.restoran.parts.DateInput2;
import com.dev63.restoran.parts.InputException;
import com.dev63.restoran.sistem.CalendarAdapter;
import com.dev63.restoran.sistem.XLSExporter;
import java.io.IOException;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.EntityManager;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class UlzaneFakture {
    private Restoran restoran;
    private RestoranServer server;
    Table table;
    Shell shell;
    Composite composite;
    List<Prijemnica> prijemnice;
    List<Trebovanje> trebovanja;
    List<Odeljenje> odeljenja;
    StalniGost komitenti;
    Date day1;
    Date day2;
    boolean roba;
    boolean trosak;
    boolean magacin;
    boolean nerealizovano;

    public UlzaneFakture(Shell s, Restoran re, final Date d1, final Date d2, List<Odeljenje> o, StalniGost k, final boolean magacin, boolean n) {
        this.shell = s;
        this.restoran = re;
        this.server = this.restoran.getServer();
        this.day1 = Konstante.getPocetniDatum(d1, this.server);
        this.day2 = Konstante.getKrajnjiDatum(d2, this.server);
        this.odeljenja = o;
        this.komitenti = k;
        this.magacin = magacin;
        this.nerealizovano = n;
        this.shell.setBackground(this.shell.getDisplay().getSystemColor(1));
        this.shell.setLayout((Layout)new GridLayout(5, false));
        if (magacin) {
            this.prijemnice = this.server.readPrijemnicePoDatumima(this.day1, this.day2, k, n);
        } else {
            this.trebovanja = this.server.findTrebovanjaDatumOdeljenjeStalniGost(this.day1, this.day2, o, k, n);
            o.clear();
        }
        this.table = new Table((Composite)this.shell, 66306);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 200;
        data.horizontalSpan = 5;
        this.table.setLayoutData((Object)data);
        this.table.addListener(8, new Listener(){

            public void handleEvent(Event e) {
                if (UlzaneFakture.this.table.getSelectionIndex() > -1) {
                    try {
                        Prijemnica p = UlzaneFakture.this.prijemnice.get(UlzaneFakture.this.table.getSelectionIndex());
                        new PrijemnicaPregled.PrijemnicaDialog(SWTContainerClass.makeContainer(new Shell(UlzaneFakture.this.shell.getDisplay()), "Pregled prijemnice"), p, UlzaneFakture.this.restoran);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        this.makeHeaders();
        this.insertRows();
        data = new GridData();
        data.heightHint = 50;
        data.widthHint = 150;
        data.horizontalAlignment = 16384;
        Button printButton = new Button((Composite)this.shell, 8);
        try {
            printButton.setImage(ImageCache.getImage("print.gif"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        printButton.setText("Stampa A4");
        printButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                GridPrinter gp = new GridPrinter(new PrintHandler());
                gp.printTable(new TableWrapper(UlzaneFakture.this.table), false, true, "Promet po artiklima: " + Konstante.getDate(d1) + "-->" + Konstante.getDate(d2), UlzaneFakture.this.shell, UlzaneFakture.this.server);
            }
        });
        printButton.setLayoutData((Object)data);
        Button export = new Button((Composite)this.shell, 8);
        export.setLayoutData((Object)data);
        try {
            export.setImage(ImageCache.getImage("xls-icon.png"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        export.setText(String.format(Konstante.getBundle().getString("TEXT_EXCEL_IZVOZ"), new Object[0]));
        export.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                try {
                    XLSExporter.exportTable(UlzaneFakture.this.table, UlzaneFakture.this.shell);
                }
                catch (IOException ex) {
                    Logger.getLogger(UlzaneFakture.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        Button knjizi = new Button((Composite)this.shell, 8);
        knjizi.setLayoutData((Object)data);
        knjizi.setText(String.format(Konstante.getBundle().getString("TEXT_KNJIZI"), new Object[0]));
        knjizi.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                boolean tacno;
                EntityManager base = UlzaneFakture.this.server.getBase();
                Trebovanje t = null;
                Prijemnica p = null;
                if (magacin && UlzaneFakture.this.table.getSelectionIndex() > -1) {
                    p = UlzaneFakture.this.prijemnice.get(UlzaneFakture.this.table.getSelectionIndex());
                    if (p.getRealizovan()) {
                        return;
                    }
                } else if (!magacin && UlzaneFakture.this.table.getSelectionIndex() > -1) {
                    t = UlzaneFakture.this.trebovanja.get(UlzaneFakture.this.table.getSelectionIndex());
                    if (t.getRealizovan()) {
                        return;
                    }
                } else {
                    return;
                }
                if (tacno = Konstante.getPorukaDaNe(UlzaneFakture.this.shell, "Da li zelite da proknjizite iznos od " + (magacin ? Konstante.getNumber2(p.getTotal()) : Konstante.getNumber2(t.getTotal()))).isOdgovorPozitivan()) {
                    Knjizenje k = new Knjizenje();
                    try {
                        if (t != null) {
                            k.setDatumRealizacije(new Date());
                            k.setDatumUnosa(new Date());
                            k.setRealizovaniIznos(Double.parseDouble(Konstante.getNumber2(t.getTotal())));
                            k.setRealizovano(true);
                            k.setTrebovanje(t);
                            UlzaneFakture.this.server.CreateKnjizenje(k);
                            base.refresh((Object)t);
                        }
                        if (p != null) {
                            k.setDatumRealizacije(new Date());
                            k.setDatumUnosa(new Date());
                            k.setRealizovaniIznos(Double.parseDouble(Konstante.getNumber2(p.getTotal())));
                            k.setRealizovano(true);
                            k.setPrijemnica(p);
                            UlzaneFakture.this.server.CreateKnjizenje(k);
                            base.refresh((Object)p);
                        }
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
                UlzaneFakture.this.table.removeAll();
                UlzaneFakture.this.insertRows();
            }
        });
        data.horizontalAlignment = 131072;
        Button izlaz = new Button((Composite)this.shell, 8);
        izlaz.setText("Izlaz");
        izlaz.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                UlzaneFakture.this.shell.close();
            }
        });
        data = new GridData();
        data.heightHint = 50;
        data.widthHint = 150;
        data.horizontalAlignment = 131072;
        izlaz.setLayoutData((Object)data);
        this.table.pack();
        this.shell.setMaximized(true);
        this.shell.open();
    }

    public void makeHeaders() {
        TableColumn tc4 = new TableColumn(this.table, 131072);
        tc4.setText("Broj");
        tc4.setWidth(200);
        TableColumn tc1 = new TableColumn(this.table, 131072);
        tc1.setText("Datum prij.");
        tc1.setWidth(170);
        TableColumn tc2 = new TableColumn(this.table, 131072);
        tc2.setText("Datum azur.");
        tc2.setWidth(120);
        TableColumn tc3 = new TableColumn(this.table, 131072);
        tc3.setText("Dobavljac");
        tc3.setWidth(150);
        TableColumn tc9 = new TableColumn(this.table, 131072);
        tc9.setText("Nabavna vrednost");
        tc9.setWidth(100);
        TableColumn tc10 = new TableColumn(this.table, 131072);
        tc10.setText("Realizovan");
        tc10.setWidth(100);
    }

    public void insertRows() {
        double total = 0.0;
        if (!this.magacin) {
            for (Trebovanje t : this.trebovanja) {
                new TableItem(this.table, 0).setText(new String[]{t.getBrTrebovanja(), Konstante.getDate(t.getDatumTrebovanja()), Konstante.getDate(t.getDatumUnosa()), t.getDobavljac() == null ? "'IZ MAGACINA'" : t.getDobavljac().getNaziv(), Konstante.getNumber2(t.getTotal()), t.getRealizovan() ? "DA" : "NE"});
                total += t.getTotal().doubleValue();
            }
            new TableItem(this.table, 0).setText(new String[]{"", "", "", "Total: ", String.format("%.2f", total)});
        } else {
            for (Prijemnica p : this.prijemnice) {
                new TableItem(this.table, 0).setText(new String[]{p.getBrPrijemnice(), Konstante.getDate(p.getDatumPrijemnice()), Konstante.getDate(p.getDatumUnosa()), p.getDobavljac().getNaziv(), Konstante.getNumber2(p.getTotal()), p.getRealizovan() ? "DA" : "NE"});
                total += p.getTotal().doubleValue();
            }
            new TableItem(this.table, 0).setText(new String[]{"", "", "", "Total: ", String.format("%.2f", total)});
        }
    }

    public void reloadData() {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                UlzaneFakture.this.insertRows();
            }
        });
        t.start();
    }

    public static class UlazneFaktureInput {
        private DateInput2 odDatuma;
        private DateInput2 doDatuma;
        private Restoran restoran;
        private RestoranServer server;
        private Combo odeljenje;
        private Combo komitent;
        Date day1;
        Date day2;
        private Button roba;
        private Button trosak;
        private List<StalniGost> komitenti;
        Odeljenje o;
        List<Odeljenje> odeljenja;
        SWTContainer parent;
        List<Odeljenje> lista;
        List<Button> odelj;
        private Button mag;
        private Button nr;
        private boolean magacinVidljiv;

        public UlazneFaktureInput(SWTContainer owner, Restoran r) {
            this.parent = owner;
            this.restoran = r;
            this.server = this.restoran.getServer();
            ResourceBundle barmasterText = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale());
            this.magacinVidljiv = Boolean.parseBoolean(this.server.getSetting(Option.MAGACIN_VIDLJIV).getActual());
            this.lista = new LinkedList<Odeljenje>();
            this.odeljenja = this.server.readOdeljenjeBezMag();
            this.komitenti = this.server.readStalniGostiPreduzeca();
            Shell shell = this.parent.getControl().getShell();
            shell.setLayout((Layout)new GridLayout(1, false));
            Composite panel1 = new Composite((Composite)shell, 0);
            panel1.setLayout((Layout)new GridLayout(3, false));
            GridData data = new GridData();
            Composite panel2 = new Composite((Composite)shell, 0);
            panel2.setLayout((Layout)new GridLayout(1, false));
            data = new GridData();
            Label slika = new Label(panel1, 0);
            slika.setImage(new Image((Device)shell.getDisplay(), ImagePath.getPath() + "/prometV.gif"));
            slika.setLayoutData((Object)data);
            data = new GridData();
            data.heightHint = 80;
            data.widthHint = 440;
            Group grupaText = new Group(panel1, 0);
            grupaText.setText("Knjiga ulaznih faktura");
            grupaText.setLayout((Layout)new FillLayout());
            grupaText.setLayoutData((Object)data);
            Label text = new Label((Composite)grupaText, 64);
            text.setText("Ekran za unos, pregled i ispravku.\n Za vise informacija kliknite na ikonicu tehnickog uputstva ->");
            Button uputstvo = new Button(panel1, 8);
            uputstvo.setImage(new Image((Device)shell.getDisplay(), ImagePath.getPath() + "/uputstvoV.gif"));
            data = new GridData();
            data.widthHint = 115;
            data.heightHint = 100;
            uputstvo.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            Group grupa1 = new Group(panel2, 0x1000000);
            grupa1.setLayout((Layout)new GridLayout(2, false));
            grupa1.setText("Unos datuma");
            grupa1.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            data.heightHint = 110;
            Group grupa2 = new Group(panel2, 0);
            grupa2.setLayout((Layout)new GridLayout(2, false));
            grupa2.setText("Filter pregleda");
            grupa2.setLayoutData((Object)data);
            Group grupao = new Group(panel2, 0);
            grupao.setLayout((Layout)new GridLayout(8, false));
            grupao.setText("Filter odeljenja");
            grupao.setLayoutData((Object)data);
            this.odelj = new LinkedList<Button>();
            this.mag = new Button((Composite)grupao, 32);
            this.mag.setText("MAGACIN");
            this.mag.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    if (mag.getSelection()) {
                        for (Button b : odelj) {
                            b.setSelection(false);
                            b.setEnabled(false);
                        }
                    } else {
                        for (Button b : odelj) {
                            b.setSelection(true);
                            b.setEnabled(true);
                        }
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            for (Odeljenje odeljenje : this.odeljenja) {
                Button od = new Button((Composite)grupao, 32);
                od.setText(odeljenje.getNaziv());
                od.setSelection(true);
                this.odelj.add(od);
            }
            Label pa = new Label((Composite)grupa2, 0);
            pa.setText("Odaberi komitenta: ");
            this.komitent = new Combo((Composite)grupa2, 0);
            this.komitent.add(String.format(barmasterText.getString("TEXT_SVI_KOMITENTI"), new Object[0]));
            for (StalniGost sg : this.komitenti) {
                this.komitent.add(sg.getNaziv());
            }
            this.komitent.select(0);
            Label label = new Label((Composite)grupa2, 0);
            label.setText("Nerealizovano: ");
            this.nr = new Button((Composite)grupa2, 32);
            data = new GridData();
            data.widthHint = 670;
            data.heightHint = 70;
            data = new GridData();
            data.widthHint = 670;
            data.heightHint = 60;
            Group grupa3 = new Group(panel2, 0);
            grupa3.setLayout((Layout)new GridLayout(2, false));
            grupa3.setText("");
            grupa3.setLayoutData((Object)data);
            SWTContainer parent2 = new SWTContainer((Composite)grupa1);
            Label od = new Label((Composite)grupa1, 0);
            od.setText("Od datuma:");
            this.odDatuma = new DateInput2(parent2, "Od datuma", new Date(this.server.getLastDateZD().getTime()), false, this.server);
            this.odDatuma.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.odDatuma, shell));
            Label doD = new Label((Composite)grupa1, 0);
            doD.setText("Do datuma:");
            this.doDatuma = new DateInput2(parent2, "Do datuma", new Date(this.server.getLastDateZD().getTime()), false, this.server);
            this.doDatuma.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.doDatuma, shell));
            Button cancelButt = Dugmici.getCancelButton((Composite)grupa3);
            cancelButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.cancel();
                }
            });
            Button okButt = Dugmici.getOkButton((Composite)grupa3);
            okButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.ok();
                }
            });
            data = new GridData();
            data.horizontalAlignment = 16384;
            data.horizontalIndent = 10;
            data.widthHint = 150;
            data.heightHint = 30;
            od.setLayoutData((Object)data);
            doD.setLayoutData((Object)data);
            this.odDatuma.getControl().setLayoutData((Object)data);
            this.doDatuma.getControl().setLayoutData((Object)data);
            pa.setLayoutData((Object)data);
            label.setLayoutData((Object)data);
            this.komitent.setLayoutData((Object)data);
            this.nr.setLayoutData((Object)data);
            SWTContainerClass.setDimension(shell);
            shell.open();
        }

        private void cancel() {
            this.parent.getControl().getShell().close();
        }

        private void ok() {
            try {
                for (Button b : this.odelj) {
                    if (!b.getSelection()) continue;
                    for (Odeljenje od : this.odeljenja) {
                        if (!b.getText().equals(od.getNaziv())) continue;
                        this.lista.add(od);
                    }
                }
                this.day1 = this.odDatuma.getResult();
                this.day2 = this.doDatuma.getResult();
                StalniGost ss = this.komitent.getSelectionIndex() == 0 ? null : this.komitenti.get(this.komitent.getSelectionIndex() - 1);
                this.server.log("Pregled ulaznih faktura: od datuma->" + this.day1 + " do datuma ->" + this.day2);
                Shell shell2 = new Shell(this.parent.getControl().getShell().getDisplay());
                shell2.setText("Knjiga ulaznih faktura za period: " + Konstante.getDate(this.day1) + " -> " + Konstante.getDate(this.day2));
                new UlzaneFakture(shell2, this.restoran, this.day1, this.day2, this.lista, ss, this.mag.getSelection(), this.nr.getSelection());
            }
            catch (InputException ex) {
                SWTOptionPane.showMessageDialog(this.parent, (Object)ex.getMessage(), "Greska", 2);
            }
        }
    }
}

