/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.sistem;

import com.dev63.restoran.sistem.LayoutExample;
import java.util.Vector;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

abstract class Tab {
    Composite tabFolderPage;
    SashForm sash;
    Group layoutGroup;
    Group controlGroup;
    Group childGroup;
    Composite layoutComposite;
    String[] names;
    Control[] children;
    Button size;
    Button add;
    Button delete;
    Button clear;
    Button code;
    Table table;
    int index;
    TableItem newItem;
    TableItem lastSelected;
    Vector<Object> data = new Vector();
    final LayoutExample instance;
    SelectionListener selectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            Tab.this.resetEditors();
        }
    };
    TraverseListener traverseListener = new TraverseListener(){

        public void keyTraversed(TraverseEvent e) {
            if (e.detail == 4) {
                e.doit = false;
                Tab.this.resetEditors();
            }
        }
    };

    Tab(LayoutExample instance) {
        this.instance = instance;
    }

    void createChildGroup() {
        this.childGroup = new Group((Composite)this.controlGroup, 0);
        this.childGroup.setText(LayoutExample.getResourceString("Children"));
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        this.childGroup.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.horizontalSpan = 2;
        this.childGroup.setLayoutData((Object)data);
        this.createChildWidgets();
    }

    void createChildWidgets() {
        this.add = new Button((Composite)this.childGroup, 8);
        this.add.setText(LayoutExample.getResourceString("Add"));
        this.add.setLayoutData((Object)new GridData(768));
        this.delete = new Button((Composite)this.childGroup, 8);
        this.delete.setText(LayoutExample.getResourceString("Delete"));
        this.delete.setLayoutData((Object)new GridData(768));
        this.delete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Tab.this.resetEditors();
                int[] selected = Tab.this.table.getSelectionIndices();
                Tab.this.table.remove(selected);
                for (int i = 0; i < Tab.this.table.getItemCount(); ++i) {
                    Tab.this.table.getItem(i).setText(0, String.valueOf(i));
                }
                Tab.this.refreshLayoutComposite();
                Tab.this.layoutComposite.layout(true);
                Tab.this.layoutGroup.layout(true);
            }
        });
        this.clear = new Button((Composite)this.childGroup, 8);
        this.clear.setText(LayoutExample.getResourceString("Clear"));
        this.clear.setLayoutData((Object)new GridData(768));
        this.clear.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Tab.this.resetEditors();
                Tab.this.children = Tab.this.layoutComposite.getChildren();
                for (int i = 0; i < Tab.this.children.length; ++i) {
                    Tab.this.children[i].dispose();
                }
                Tab.this.table.removeAll();
                Tab.this.data.clear();
                Tab.this.children = new Control[0];
                Tab.this.layoutGroup.layout(true);
            }
        });
        this.table = new Table((Composite)this.childGroup, 101122);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 3;
        gridData.heightHint = 150;
        this.table.setLayoutData((Object)gridData);
        this.table.addTraverseListener(this.traverseListener);
        String[] columnHeaders = this.getLayoutDataFieldNames();
        for (int i = 0; i < columnHeaders.length; ++i) {
            TableColumn column = new TableColumn(this.table, 0);
            column.setText(columnHeaders[i]);
            if (i == 0) {
                column.setWidth(20);
                continue;
            }
            if (i == 1) {
                column.setWidth(80);
                continue;
            }
            column.pack();
        }
    }

    void createComboEditor(CCombo combo, TableEditor comboEditor) {
        combo.setItems(new String[]{"Button", "Canvas", "Combo", "Composite", "CoolBar", "Group", "Label", "List", "ProgressBar", "Scale", "Slider", "StyledText", "Table", "Text", "ToolBar", "Tree"});
        combo.setText(this.newItem.getText(1));
        comboEditor.horizontalAlignment = 16384;
        comboEditor.grabHorizontal = true;
        comboEditor.minimumWidth = 50;
        comboEditor.setEditor((Control)combo, this.newItem, 1);
        combo.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 16 || e.detail == 4) {
                    Tab.this.resetEditors();
                }
                if (e.detail == 2) {
                    Tab.this.disposeEditors();
                }
            }
        });
    }

    void createControlGroup() {
        this.controlGroup = new Group((Composite)this.sash, 0);
        this.controlGroup.setText(LayoutExample.getResourceString("Parameters"));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this.controlGroup.setLayout((Layout)layout);
        this.size = new Button((Composite)this.controlGroup, 32);
        this.size.setText(LayoutExample.getResourceString("Preferred_Size"));
        this.size.setSelection(false);
        this.size.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Tab.this.resetEditors();
                if (Tab.this.size.getSelection()) {
                    Tab.this.layoutComposite.setLayoutData((Object)new GridData());
                    Tab.this.layoutGroup.layout(true);
                } else {
                    Tab.this.layoutComposite.setLayoutData((Object)new GridData(1808));
                    Tab.this.layoutGroup.layout(true);
                }
            }
        });
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        this.size.setLayoutData((Object)data);
        this.createControlWidgets();
    }

    void createControlWidgets() {
        this.createChildGroup();
        this.code = new Button((Composite)this.controlGroup, 8);
        this.code.setText(LayoutExample.getResourceString("Code"));
        GridData gridData = new GridData(576);
        gridData.horizontalSpan = 2;
        this.code.setLayoutData((Object)gridData);
        this.code.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                final Shell shell = new Shell();
                shell.setText(LayoutExample.getResourceString("Generated_Code"));
                shell.setLayout((Layout)new FillLayout());
                final StyledText text = new StyledText((Composite)shell, 2818);
                String layoutCode = Tab.this.generateCode().toString();
                if (layoutCode.length() == 0) {
                    return;
                }
                text.setText(layoutCode);
                Menu bar = new Menu((Decorations)shell, 2);
                shell.setMenuBar(bar);
                MenuItem editItem = new MenuItem(bar, 64);
                editItem.setText(LayoutExample.getResourceString("Edit"));
                Menu menu = new Menu(bar);
                MenuItem select = new MenuItem(menu, 8);
                select.setText(LayoutExample.getResourceString("Select_All"));
                select.setAccelerator(SWT.MOD1 + 65);
                select.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        text.selectAll();
                    }
                });
                MenuItem copy = new MenuItem(menu, 8);
                copy.setText(LayoutExample.getResourceString("Copy"));
                copy.setAccelerator(SWT.MOD1 + 67);
                copy.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        text.copy();
                    }
                });
                MenuItem exit = new MenuItem(menu, 8);
                exit.setText(LayoutExample.getResourceString("Exit"));
                exit.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        shell.close();
                    }
                });
                editItem.setMenu(menu);
                shell.pack();
                shell.setSize(400, 500);
                shell.open();
                Display display = shell.getDisplay();
                while (!shell.isDisposed()) {
                    if (display.readAndDispatch()) continue;
                    display.sleep();
                }
            }
        });
    }

    void createLayout() {
    }

    void createLayoutComposite() {
        this.layoutComposite = new Composite((Composite)this.layoutGroup, 2048);
        this.layoutComposite.setLayoutData((Object)new GridData(1808));
        this.createLayout();
    }

    void createLayoutGroup() {
        this.layoutGroup = new Group((Composite)this.sash, 0);
        this.layoutGroup.setText(LayoutExample.getResourceString("Layout"));
        this.layoutGroup.setLayout((Layout)new GridLayout());
        this.createLayoutComposite();
    }

    Composite createTabFolderPage(TabFolder tabFolder) {
        this.tabFolderPage = new Composite((Composite)tabFolder, 0);
        this.tabFolderPage.setLayout((Layout)new FillLayout());
        this.sash = new SashForm(this.tabFolderPage, 256);
        this.createLayoutGroup();
        this.createControlGroup();
        return this.tabFolderPage;
    }

    void createTextEditor(Text text, TableEditor textEditor, int column) {
        text.setFont(this.table.getFont());
        text.selectAll();
        textEditor.horizontalAlignment = 16384;
        textEditor.grabHorizontal = true;
        textEditor.setEditor((Control)text, this.newItem, column);
        text.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 16) {
                    Tab.this.resetEditors(true);
                }
                if (e.detail == 2) {
                    Tab.this.disposeEditors();
                }
            }
        });
    }

    void disposeEditors() {
    }

    StringBuffer generateCode() {
        this.resetEditors();
        this.names = new String[this.children.length];
        for (int i = 0; i < this.children.length; ++i) {
            Control control = this.children[i];
            String controlClass = control.getClass().toString();
            String controlType = controlClass.substring(controlClass.lastIndexOf(46) + 1);
            this.names[i] = controlType.toLowerCase() + i;
        }
        StringBuffer code = new StringBuffer();
        code.append("import org.eclipse.swt.*;\n");
        code.append("import org.eclipse.swt.custom.*;\n");
        code.append("import org.eclipse.swt.graphics.*;\n");
        code.append("import org.eclipse.swt.layout.*;\n");
        code.append("import org.eclipse.swt.widgets.*;\n\n");
        code.append("public class MyLayout {\n");
        code.append("\tpublic static void main (String [] args) {\n");
        code.append("\t\tDisplay display = new Display ();\n");
        code.append("\t\tShell shell = new Shell (display);\n");
        code.append(this.generateLayoutCode());
        code.append("\n\t\tshell.pack ();\n\t\tshell.open ();\n\n");
        code.append("\t\twhile (!shell.isDisposed ()) {\n");
        code.append("\t\t\tif (!display.readAndDispatch ())\n");
        code.append("\t\t\t\tdisplay.sleep ();\n\t\t}\n\t\tdisplay.dispose ();\n\t}\n}");
        return code;
    }

    StringBuffer generateLayoutCode() {
        return new StringBuffer();
    }

    StringBuffer getChildCode(Control control, int i) {
        StringBuffer code = new StringBuffer();
        String controlClass = control.getClass().toString();
        String controlType = controlClass.substring(controlClass.lastIndexOf(46) + 1);
        String styleString = controlType.equals("Button") ? "SWT.PUSH" : (controlType.equals("Text") ? "SWT.BORDER" : (controlType.equals("StyledText") ? "SWT.MULTI | SWT.BORDER | SWT.V_SCROLL | SWT.H_SCROLL" : (controlType.equals("Canvas") || controlType.equals("Composite") || controlType.equals("Table") || controlType.equals("StyledText") || controlType.equals("ToolBar") || controlType.equals("Tree") || controlType.equals("List") ? "SWT.BORDER" : "SWT.NONE")));
        code.append("\n\t\t" + controlType + " " + this.names[i] + " = new " + controlType + " (shell, " + styleString + ");\n");
        if (controlType.equals("Combo") || controlType.equals("List")) {
            code.append("\t\t" + this.names[i] + ".setItems (new String [] {\"Item 1\", \"Item 2\", \"Item 2\"});\n");
        } else if (controlType.equals("Table")) {
            code.append("\t\t" + this.names[i] + ".setLinesVisible (true);\n");
            for (int j = 1; j < 3; ++j) {
                code.append("\t\tTableItem tableItem" + j + " = new TableItem (" + this.names[i] + ", SWT.NONE);\n");
                code.append("\t\ttableItem" + j + ".setText (\"Item" + j + "\");\n");
            }
        } else if (controlType.equals("Tree")) {
            for (int j = 1; j < 3; ++j) {
                code.append("\t\tTreeItem treeItem" + j + " = new TreeItem (" + this.names[i] + ", SWT.NONE);\n");
                code.append("\t\ttreeItem" + j + ".setText (\"Item" + j + "\");\n");
            }
        } else if (controlType.equals("ToolBar")) {
            for (int j = 1; j < 3; ++j) {
                code.append("\t\tToolItem toolItem" + j + " = new ToolItem (" + this.names[i] + ", SWT.NONE);\n");
                code.append("\t\ttoolItem" + j + ".setText (\"Item" + j + "\");\n");
            }
        } else if (controlType.equals("CoolBar")) {
            code.append("\t\tToolBar coolToolBar = new ToolBar (" + this.names[i] + ", SWT.BORDER);\n");
            code.append("\t\tToolItem coolToolItem = new ToolItem (coolToolBar, SWT.NONE);\n");
            code.append("\t\tcoolToolItem.setText (\"Item 1\");\n");
            code.append("\t\tcoolToolItem = new ToolItem (coolToolBar, SWT.NONE);\n");
            code.append("\t\tcoolToolItem.setText (\"Item 2\");\n");
            code.append("\t\tCoolItem coolItem1 = new CoolItem (" + this.names[i] + ", SWT.NONE);\n");
            code.append("\t\tcoolItem1.setControl (coolToolBar);\n");
            code.append("\t\tPoint size = coolToolBar.computeSize (SWT.DEFAULT, SWT.DEFAULT);\n");
            code.append("\t\tcoolItem1.setSize (coolItem1.computeSize (size.x, size.y));\n");
            code.append("\t\tcoolToolBar = new ToolBar (" + this.names[i] + ", SWT.BORDER);\n");
            code.append("\t\tcoolToolItem = new ToolItem (coolToolBar, SWT.NONE);\n");
            code.append("\t\tcoolToolItem.setText (\"Item 3\");\n");
            code.append("\t\tcoolToolItem = new ToolItem (coolToolBar, SWT.NONE);\n");
            code.append("\t\tcoolToolItem.setText (\"Item 4\");\n");
            code.append("\t\tCoolItem coolItem2 = new CoolItem (" + this.names[i] + ", SWT.NONE);\n");
            code.append("\t\tcoolItem2.setControl (coolToolBar);\n");
            code.append("\t\tsize = coolToolBar.computeSize (SWT.DEFAULT, SWT.DEFAULT);\n");
            code.append("\t\tcoolItem2.setSize (coolItem2.computeSize (size.x, size.y));\n");
            code.append("\t\t" + this.names[i] + ".setSize (" + this.names[i] + ".computeSize (SWT.DEFAULT, SWT.DEFAULT));\n");
        } else if (controlType.equals("ProgressBar")) {
            code.append("\t\t" + this.names[i] + ".setSelection (50);\n");
        }
        if (controlType.equals("Button") || controlType.equals("Combo") || controlType.equals("Group") || controlType.equals("Label") || controlType.equals("StyledText") || controlType.equals("Text")) {
            code.append("\t\t" + this.names[i] + ".setText (\"" + this.names[i] + "\");\n");
        }
        return code;
    }

    String[] getLayoutDataFieldNames() {
        return new String[0];
    }

    String getTabText() {
        return "";
    }

    void refreshLayoutComposite() {
        this.children = this.layoutComposite.getChildren();
        for (int i = 0; i < this.children.length; ++i) {
            this.children[i].dispose();
        }
        TableItem[] items = this.table.getItems();
        this.children = new Control[items.length];
        String[] itemValues = new String[]{LayoutExample.getResourceString("Item", new String[]{"1"}), LayoutExample.getResourceString("Item", new String[]{"2"}), LayoutExample.getResourceString("Item", new String[]{"3"})};
        for (int i = 0; i < items.length; ++i) {
            TableItem item2;
            TableItem item1;
            String control = items[i].getText(1);
            if (control.equals("Button")) {
                Button button = new Button(this.layoutComposite, 8);
                button.setText(LayoutExample.getResourceString("Button_Index", new String[]{new Integer(i).toString()}));
                this.children[i] = button;
                continue;
            }
            if (control.equals("Canvas")) {
                Canvas canvas = new Canvas(this.layoutComposite, 2048);
                this.children[i] = canvas;
                continue;
            }
            if (control.equals("Combo")) {
                Combo combo = new Combo(this.layoutComposite, 0);
                combo.setItems(itemValues);
                combo.setText(LayoutExample.getResourceString("Combo_Index", new String[]{new Integer(i).toString()}));
                this.children[i] = combo;
                continue;
            }
            if (control.equals("Composite")) {
                Composite composite = new Composite(this.layoutComposite, 2048);
                this.children[i] = composite;
                continue;
            }
            if (control.equals("CoolBar")) {
                CoolBar coolBar = new CoolBar(this.layoutComposite, 0);
                ToolBar toolBar = new ToolBar((Composite)coolBar, 2048);
                ToolItem item = new ToolItem(toolBar, 0);
                item.setText(LayoutExample.getResourceString("Item", new String[]{"1"}));
                item = new ToolItem(toolBar, 0);
                item.setText(LayoutExample.getResourceString("Item", new String[]{"2"}));
                CoolItem coolItem1 = new CoolItem(coolBar, 0);
                coolItem1.setControl((Control)toolBar);
                toolBar = new ToolBar((Composite)coolBar, 2048);
                item = new ToolItem(toolBar, 0);
                item.setText(LayoutExample.getResourceString("Item", new String[]{"3"}));
                item = new ToolItem(toolBar, 0);
                item.setText(LayoutExample.getResourceString("Item", new String[]{"4"}));
                CoolItem coolItem2 = new CoolItem(coolBar, 0);
                coolItem2.setControl((Control)toolBar);
                Point size = toolBar.computeSize(-1, -1);
                coolItem1.setSize(coolItem1.computeSize(size.x, size.y));
                coolItem2.setSize(coolItem2.computeSize(size.x, size.y));
                coolBar.setSize(coolBar.computeSize(-1, -1));
                this.children[i] = coolBar;
                continue;
            }
            if (control.equals("Group")) {
                Group group = new Group(this.layoutComposite, 0);
                group.setText(LayoutExample.getResourceString("Group_Index", new String[]{new Integer(i).toString()}));
                this.children[i] = group;
                continue;
            }
            if (control.equals("Label")) {
                Label label = new Label(this.layoutComposite, 0);
                label.setText(LayoutExample.getResourceString("Label_Index", new String[]{new Integer(i).toString()}));
                this.children[i] = label;
                continue;
            }
            if (control.equals("List")) {
                List list = new List(this.layoutComposite, 2048);
                list.setItems(itemValues);
                this.children[i] = list;
                continue;
            }
            if (control.equals("ProgressBar")) {
                ProgressBar progress = new ProgressBar(this.layoutComposite, 0);
                progress.setSelection(50);
                this.children[i] = progress;
                continue;
            }
            if (control.equals("Scale")) {
                Scale scale = new Scale(this.layoutComposite, 0);
                this.children[i] = scale;
                continue;
            }
            if (control.equals("Slider")) {
                Slider slider = new Slider(this.layoutComposite, 0);
                this.children[i] = slider;
                continue;
            }
            if (control.equals("StyledText")) {
                StyledText styledText = new StyledText(this.layoutComposite, 2818);
                styledText.setText(LayoutExample.getResourceString("StyledText_Index", new String[]{new Integer(i).toString()}));
                this.children[i] = styledText;
                continue;
            }
            if (control.equals("Table")) {
                Table table = new Table(this.layoutComposite, 2048);
                table.setLinesVisible(true);
                item1 = new TableItem(table, 0);
                item1.setText(LayoutExample.getResourceString("Item", new String[]{"1"}));
                item2 = new TableItem(table, 0);
                item2.setText(LayoutExample.getResourceString("Item", new String[]{"2"}));
                this.children[i] = table;
                continue;
            }
            if (control.equals("Text")) {
                Text text = new Text(this.layoutComposite, 2048);
                text.setText(LayoutExample.getResourceString("Text_Index", new String[]{new Integer(i).toString()}));
                this.children[i] = text;
                continue;
            }
            if (control.equals("ToolBar")) {
                ToolBar toolBar = new ToolBar(this.layoutComposite, 2048);
                item1 = new ToolItem(toolBar, 0);
                item1.setText(LayoutExample.getResourceString("Item", new String[]{"1"}));
                item2 = new ToolItem(toolBar, 0);
                item2.setText(LayoutExample.getResourceString("Item", new String[]{"2"}));
                this.children[i] = toolBar;
                continue;
            }
            Tree tree = new Tree(this.layoutComposite, 2048);
            item1 = new TreeItem(tree, 0);
            item1.setText(LayoutExample.getResourceString("Item", new String[]{"1"}));
            item2 = new TreeItem(tree, 0);
            item2.setText(LayoutExample.getResourceString("Item", new String[]{"2"}));
            this.children[i] = tree;
        }
    }

    void resetEditors() {
        this.resetEditors(false);
    }

    void resetEditors(boolean tab) {
    }

    void setLayoutData() {
    }

    void setLayoutState() {
    }
}

